/*
 * Decompiled with CFR 0.152.
 */
package beast.app.draw;

import beast.app.draw.BEASTObjectShape;
import beast.app.draw.Document;
import beast.app.draw.Shape;
import beast.core.BEASTInterface;
import beast.core.Input;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.io.PrintStream;
import java.util.List;
import javax.swing.JPanel;
import org.w3c.dom.Node;

public class InputShape
extends Shape {
    Input<?> m_input;
    static Font g_InputFont = new Font("arial", 0, 8);
    public BEASTObjectShape m_beastObjectShape = null;

    public InputShape(Input<?> input) {
        this.m_input = input;
    }

    public InputShape(Node node, Document document, boolean bl) {
        this.parse(node, document, bl);
    }

    BEASTObjectShape getPluginShape() {
        return this.m_beastObjectShape;
    }

    void setPluginShape(BEASTObjectShape bEASTObjectShape) {
        this.m_beastObjectShape = bEASTObjectShape;
    }

    BEASTInterface getBEASTObject() {
        return this.m_beastObjectShape.m_beastObject;
    }

    String getInputName() {
        String string = this.getLabel();
        if (string.indexOf(61) >= 0) {
            string = string.substring(0, string.indexOf(61));
        }
        return string;
    }

    @Override
    public void draw(Graphics2D graphics2D, JPanel jPanel) {
        if (this.m_beastObjectShape == null || this.m_beastObjectShape.m_bNeedsDrawing) {
            if (this.m_bFilled) {
                graphics2D.setColor(this.m_fillcolor);
                graphics2D.fillOval(this.m_x, this.m_y, this.m_w, this.m_h);
            }
            graphics2D.setStroke(new BasicStroke(this.m_nPenWidth));
            graphics2D.setColor(this.m_pencolor);
            graphics2D.setFont(g_InputFont);
            if (this.getLabel() != null) {
                FontMetrics fontMetrics = graphics2D.getFontMetrics(graphics2D.getFont());
                String string = this.getLabel();
                int n = 0;
                graphics2D.drawString(string, this.m_x + this.m_w / 2 - fontMetrics.stringWidth(string), this.m_y + this.m_h / 2 + n * fontMetrics.getHeight());
            }
        }
    }

    @Override
    void parse(Node node, Document document, boolean bl) {
        super.parse(node, document, bl);
    }

    @Override
    public String getXML() {
        return "<inputshape" + this.getAtts() + "/>";
    }

    @Override
    boolean intersects(int n, int n2) {
        return (this.m_x + this.m_w / 2 - n) * (this.m_x + this.m_w / 2 - n) + (this.m_y + this.m_h / 2 - n2) * (this.m_y + this.m_h / 2 - n2) < this.m_w * this.m_w / 4 + this.m_h * this.m_h / 4;
    }

    @Override
    String getLabel() {
        Object obj;
        if (this.m_input == null) {
            return "XXX";
        }
        String string = this.m_input.getName();
        if (this.m_input.get() != null && ((obj = this.m_input.get()) instanceof String || obj instanceof Integer || obj instanceof Double || obj instanceof Boolean)) {
            string = string + "=" + obj.toString();
        }
        return string;
    }

    String toString(Object object) {
        if (object instanceof String || object instanceof Integer || object instanceof Double || object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof BEASTInterface) {
            return ((BEASTInterface)object).getID();
        }
        return "";
    }

    String getLongLabel() {
        String string = this.m_input.getName();
        if (this.m_input.get() != null) {
            Object obj = this.m_input.get();
            if (obj instanceof String || obj instanceof Integer || obj instanceof Double || obj instanceof Boolean) {
                string = string + "=" + obj.toString();
            } else if (obj instanceof BEASTInterface) {
                string = string + "=" + ((BEASTInterface)obj).getID();
            } else if (obj instanceof List) {
                string = string + "=[";
                boolean bl = false;
                for (Object e : (List)obj) {
                    if (bl) {
                        string = string + ",";
                    }
                    string = string + this.toString(e);
                    bl = true;
                }
                string = string + "]";
            }
        }
        return string;
    }

    @Override
    String getID() {
        if (this.m_beastObjectShape != null) {
            return this.m_beastObjectShape.m_beastObject.getID() + "." + this.m_input.getName();
        }
        return this.m_sID;
    }

    @Override
    void toSVG(PrintStream printStream) {
        printStream.print("<circle cx='" + (this.m_x + this.m_w / 2) + "' cy='" + (this.m_y + this.m_h / 2) + "' r='" + this.m_w / 2 + "' ");
        printStream.println("fill='rgb(" + this.m_fillcolor.getRed() + "," + this.m_fillcolor.getGreen() + "," + this.m_fillcolor.getBlue() + ")'/>");
        this.drawSVGString(printStream, g_InputFont, this.m_pencolor, "end");
    }
}

