/*
 * Decompiled with CFR 0.152.
 */
package beast.app.draw;

import beast.app.draw.Document;
import beast.app.draw.InputShape;
import beast.app.draw.Shape;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.util.Randomizer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.w3c.dom.Node;

public class BEASTObjectShape
extends Shape {
    static Font g_PluginFont = new Font("arial", 0, UIManager.getFont("Label.font").getSize() * 11 / 12);
    public BEASTInterface m_beastObject;
    List<InputShape> m_inputs;

    public BEASTObjectShape() {
        this.m_fillcolor = new Color(Randomizer.nextInt(256), 128 + Randomizer.nextInt(128), Randomizer.nextInt(128));
    }

    public BEASTObjectShape(BEASTInterface bEASTInterface, Document document) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.m_beastObject = bEASTInterface;
        this.m_fillcolor = new Color(Randomizer.nextInt(256), 128 + Randomizer.nextInt(128), Randomizer.nextInt(128));
        this.init(bEASTInterface.getClass().getName(), document);
    }

    public BEASTObjectShape(Node node, Document document, boolean bl) {
        this.parse(node, document, bl);
    }

    public void init(String string, Document document) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Object object;
        this.m_doc = document;
        if (this.m_beastObject == null) {
            this.m_beastObject = (BEASTInterface)Class.forName(string).newInstance();
        }
        this.m_inputs = new ArrayList<InputShape>();
        if (this.m_beastObject.getID() == null) {
            object = this.m_beastObject.getClass().getName();
            object = ((String)object).substring(((String)object).lastIndexOf(46) + 1);
            this.m_beastObject.setID((String)object);
        }
        object = this.m_beastObject.listInputs();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Input input = (Input)iterator.next();
            String string2 = this.m_beastObject.getClass().getName() + "." + input.getName();
            if (!document.showAllInputs() && (document.tabulist.contains(string2) || input.get() == null || (!(input.get() instanceof List) || ((List)input.get()).size() <= 0) && input.get().equals(input.defaultValue))) continue;
            InputShape inputShape = new InputShape(input);
            inputShape.setPluginShape(this);
            inputShape.m_fillcolor = this.m_fillcolor;
            inputShape.m_w = 10;
            document.addNewShape(inputShape);
            this.m_inputs.add(inputShape);
        }
        this.m_h = Math.max(40, this.m_inputs.size() * 12);
        this.adjustInputs();
    }

    InputShape getInputShape(String string) {
        for (InputShape inputShape : this.m_inputs) {
            String string2 = inputShape.getLabel();
            if (string2 == null) continue;
            if (string2.contains("=")) {
                string2 = string2.substring(0, string2.indexOf(61));
            }
            if (!string2.equals(string)) continue;
            return inputShape;
        }
        return null;
    }

    void adjustInputs() {
        if (this.m_beastObject != null) {
            try {
                for (int i = 0; i < this.m_inputs.size(); ++i) {
                    InputShape inputShape = this.m_inputs.get(i);
                    int n = i * this.m_h / this.m_inputs.size() + this.m_h / (2 * this.m_inputs.size());
                    inputShape.m_x = this.m_x - inputShape.m_w;
                    inputShape.m_y = this.m_y + n;
                    inputShape.m_h = 10;
                    inputShape.m_fillcolor = this.m_fillcolor;
                    inputShape.m_nPenWidth = 0;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void draw(Graphics2D graphics2D, JPanel jPanel) {
        if (this.m_bFilled) {
            GradientPaint gradientPaint = new GradientPaint(new Point(this.m_x, this.m_y), Color.WHITE, new Point(this.m_x + this.m_w, this.m_y + this.m_h), this.m_fillcolor);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillOval(this.m_x, this.m_y, this.m_w, this.m_h);
            graphics2D.fillRect(this.m_x, this.m_y, this.m_w / 2, this.m_h);
        } else {
            graphics2D.setColor(this.m_fillcolor);
            graphics2D.drawLine(this.m_x, this.m_y, this.m_x, this.m_y + this.m_h);
            graphics2D.drawLine(this.m_x, this.m_y, this.m_x + this.m_w / 2, this.m_y);
            graphics2D.drawLine(this.m_x, this.m_y + this.m_h, this.m_x + this.m_w / 2, this.m_y + this.m_h);
            graphics2D.drawArc(this.m_x, this.m_y, this.m_w, this.m_h, 0, 90);
            graphics2D.drawArc(this.m_x, this.m_y, this.m_w, this.m_h, 0, -90);
        }
        graphics2D.setStroke(new BasicStroke(this.m_nPenWidth));
        graphics2D.setColor(this.m_pencolor);
        graphics2D.setFont(g_PluginFont);
        this.drawLabel(graphics2D);
        this.adjustInputs();
    }

    @Override
    void parse(Node node, Document document, boolean bl) {
        super.parse(node, document, bl);
        if (bl) {
            String string;
            if (node.getAttributes().getNamedItem("class") != null) {
                string = node.getAttributes().getNamedItem("class").getNodeValue();
                try {
                    this.m_beastObject = (BEASTInterface)Class.forName(string).newInstance();
                    this.m_beastObject.setID(this.m_sID);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (node.getAttributes().getNamedItem("inputids") != null) {
                string = node.getAttributes().getNamedItem("inputids").getNodeValue();
                String[] stringArray = string.split(" ");
                this.m_inputs = new ArrayList<InputShape>();
                try {
                    for (int i = 0; i < stringArray.length; ++i) {
                        InputShape inputShape = (InputShape)document.findObjectWithID(stringArray[i]);
                        this.m_inputs.add(inputShape);
                        inputShape.setPluginShape(this);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<pluginshape");
        stringBuffer.append(" class='");
        stringBuffer.append(this.m_beastObject.getClass().getName());
        stringBuffer.append("'");
        stringBuffer.append(" inputids='");
        for (int i = 0; i < this.m_inputs.size(); ++i) {
            stringBuffer.append(this.m_inputs.get(i).getID());
            stringBuffer.append(' ');
        }
        stringBuffer.append("'");
        stringBuffer.append(this.getAtts());
        stringBuffer.append(">\n");
        stringBuffer.append("</pluginshape>");
        return stringBuffer.toString();
    }

    @Override
    void assignFrom(Shape shape) {
        super.assignFrom(shape);
        this.m_beastObject.setID(shape.m_sID);
    }

    @Override
    boolean intersects(int n, int n2) {
        return super.intersects(n, n2);
    }

    @Override
    String getLabel() {
        return this.getID();
    }

    @Override
    String getID() {
        if (this.m_beastObject == null) {
            return null;
        }
        return this.m_beastObject.getID();
    }

    @Override
    void toSVG(PrintStream printStream) {
        printStream.println("<defs>");
        printStream.println("  <linearGradient id='grad" + this.getID() + "' x1='0%' y1='0%' x2='100%' y2='100%'>");
        printStream.println("    <stop offset='0%' style='stop-color:rgb(255,255,255);stop-opacity:1' />");
        printStream.println("    <stop offset='100%' style='stop-color:rgb(" + this.m_fillcolor.getRed() + "," + this.m_fillcolor.getGreen() + "," + this.m_fillcolor.getBlue() + ");stop-opacity:1' />");
        printStream.println("  </linearGradient>");
        printStream.println("</defs>");
        printStream.print("<path id='" + this.getID() + "' d='M " + this.m_x + " " + (this.m_y + this.m_h) + " l " + this.m_w / 2 + " 0 ");
        printStream.print(" a " + this.m_w / 2 + " " + -this.m_h / 2 + " 0 0,0 0," + -this.m_h + " l " + -this.m_w / 2 + " 0 z'");
        printStream.println(" fill='url(#grad" + this.getID() + ")' />");
        this.drawSVGString(printStream, g_PluginFont, this.m_pencolor, "middle");
    }
}

