/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.JPackageRepositoryDialog;
import beast.app.util.Utils;
import beast.core.Description;
import beast.util.AddOnManager;
import beast.util.Package;
import beast.util.PackageVersion;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

@Description(value="BEAUti package manager")
public class JPackageDialog
extends JPanel {
    private static final long serialVersionUID = 1L;
    JScrollPane scrollPane;
    JLabel jLabel;
    Box buttonBox;
    JFrame frame;
    PackageTable dataTable = null;
    boolean useLatestVersion = true;
    TreeMap<String, Package> packageMap = new TreeMap((string, string2) -> {
        if (string.equals("BEAST")) {
            if (string2.equals("BEAST")) {
                return 0;
            }
            return -1;
        }
        if (string2.equals("BEAST")) {
            return 1;
        }
        return string.compareToIgnoreCase((String)string2);
    });
    List<Package> packageList = null;
    boolean isRunning;
    Thread t;
    JDialog dlg = null;

    public JPackageDialog() {
        this.jLabel = new JLabel("List of available packages for BEAST v" + AddOnManager.beastVersion.getMajorVersion() + ".*");
        this.frame = (JFrame)SwingUtilities.getWindowAncestor(this);
        this.setLayout(new BorderLayout());
        this.createTable();
        this.isRunning = true;
        this.t = new Thread(){

            @Override
            public void run() {
                JPackageDialog.this.resetPackages();
                JPackageDialog.this.dataTable.updateWidths();
                JPackageDialog.this.isRunning = false;
            }
        };
        this.t.start();
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    2.sleep(30000L);
                    if (JPackageDialog.this.isRunning) {
                        JPackageDialog.this.t.interrupt();
                        JOptionPane.showMessageDialog(JPackageDialog.this.frame, "<html>Download of file https://raw.githubusercontent.com/CompEvol/CBAN/master/packages.xml timed out.<br>Perhaps this is due to lack of internet access</br>or some security settings not allowing internet access.</html>");
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.start();
        try {
            this.t.join();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.scrollPane = new JScrollPane(this.dataTable);
        this.add("Center", this.scrollPane);
        this.buttonBox = this.createButtonBox();
        this.add((Component)this.buttonBox, "South");
        this.scrollPane.setPreferredSize(new Dimension(660, 400));
        Dimension dimension = this.scrollPane.getPreferredSize();
        Dimension dimension2 = this.buttonBox.getPreferredSize();
        this.setSize(dimension.width + 30, dimension.height + dimension2.height + 30);
    }

    private void createTable() {
        final DataTableModel dataTableModel = new DataTableModel();
        this.dataTable = new PackageTable(dataTableModel);
        this.dataTable.setAutoResizeMode(3);
        this.dataTable.setSelectionMode(2);
        this.dataTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (JPackageDialog.this.dataTable.getSelectedColumn() == dataTableModel.linkColumn) {
                    URL uRL = JPackageDialog.this.getSelectedPackage(JPackageDialog.this.dataTable.getSelectedRow()).getProjectURL();
                    if (uRL != null) {
                        try {
                            Desktop.getDesktop().browse(uRL.toURI());
                        }
                        catch (IOException | URISyntaxException exception) {
                            exception.printStackTrace();
                        }
                    }
                } else if (mouseEvent.getClickCount() == 2) {
                    Package package_ = JPackageDialog.this.getSelectedPackage(JPackageDialog.this.dataTable.getSelectedRow());
                    JPackageDialog.this.showDetail(package_);
                }
            }
        });
        this.dataTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                super.mouseMoved(mouseEvent);
                int n = JPackageDialog.this.dataTable.rowAtPoint(mouseEvent.getPoint());
                int n2 = JPackageDialog.this.dataTable.columnAtPoint(mouseEvent.getPoint());
                int n3 = JPackageDialog.this.dataTable.getCursor().getType();
                if (n2 != dataTableModel.linkColumn) {
                    if (n3 == 12) {
                        JPackageDialog.this.dataTable.setCursor(Cursor.getDefaultCursor());
                    }
                    return;
                }
                Package package_ = JPackageDialog.this.getSelectedPackage(n);
                if (package_.getProjectURL() == null) {
                    if (n3 == 12) {
                        JPackageDialog.this.dataTable.setCursor(Cursor.getDefaultCursor());
                    }
                    return;
                }
                JPackageDialog.this.dataTable.setCursor(Cursor.getPredefinedCursor(12));
            }
        });
        int n = this.dataTable.getFont().getSize();
        this.dataTable.setRowHeight(20 * n / 13);
    }

    private void resetPackages() {
        this.packageMap.clear();
        try {
            AddOnManager.addAvailablePackages(this.packageMap);
            AddOnManager.addInstalledPackages(this.packageMap);
            this.packageList = new ArrayList<Package>();
            for (Package package_ : this.packageMap.values()) {
                if (package_.getName().equals("beast2")) continue;
                this.packageList.add(package_);
            }
        }
        catch (AddOnManager.PackageListRetrievalException packageListRetrievalException) {
            StringBuilder stringBuilder = new StringBuilder("<html>" + packageListRetrievalException.getMessage() + "<br>");
            if (packageListRetrievalException.getCause() instanceof IOException) {
                stringBuilder.append("Could not get an internet connection. The BEAST Package Manager needs internet access in order to list available packages and download them for installation. Possibly, some software (like security software, or a firewall) blocks the BEAST Package Manager.  If so, you need to reconfigure such software to allow access.".replaceAll("\\.", ".<br>"));
            }
            stringBuilder.append("</html>");
            try {
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(null, stringBuilder));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.dataTable.tableChanged(new TableModelEvent(this.dataTable.getModel()));
        if (this.dataTable.getRowCount() > 0) {
            this.dataTable.setRowSelectionInterval(0, 0);
        }
    }

    private Package getSelectedPackage(int n) {
        if (this.packageList.size() <= n) {
            throw new IllegalArgumentException("Incorrect row " + n + " is selected from package list, size = " + this.packageMap.size());
        }
        return this.packageList.get(n);
    }

    private void showDetail(Package package_) {
        JOptionPane.showMessageDialog(null, package_.toHTML(), package_.getName(), -1);
    }

    private Box createButtonBox() {
        Box box = Box.createHorizontalBox();
        JCheckBox jCheckBox = new JCheckBox("Latest");
        jCheckBox.setToolTipText("If selected, only the latest version is installed when hitting the Install/Upgrade button. Otherwise, you can select from a list of available versions.");
        box.add(jCheckBox);
        jCheckBox.addActionListener(actionEvent -> {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            this.useLatestVersion = jCheckBox.isSelected();
        });
        jCheckBox.setSelected(this.useLatestVersion);
        JButton jButton = new JButton("Install/Upgrade");
        jButton.addActionListener(actionEvent -> {
            int[] nArray = this.dataTable.getSelectedRows();
            String string = "";
            this.setCursor(new Cursor(3));
            HashMap<Package, PackageVersion> hashMap = new HashMap<Package, PackageVersion>();
            AddOnManager.useArchive(!this.useLatestVersion);
            for (int n : nArray) {
                Package package_ = this.getSelectedPackage(n);
                if (package_ == null) continue;
                if (this.useLatestVersion) {
                    hashMap.put(package_, package_.getLatestVersion());
                    continue;
                }
                PackageVersion packageVersion = (PackageVersion)JOptionPane.showInputDialog(null, "Select Version for " + package_.getName(), "Select version", 3, null, package_.getAvailableVersions().toArray(), package_.getAvailableVersions().toArray()[0]);
                if (packageVersion == null) {
                    return;
                }
                hashMap.put(package_, packageVersion);
            }
            try {
                AddOnManager.populatePackagesToInstall(this.packageMap, hashMap);
                AddOnManager.prepareForInstall(hashMap, false, null);
                if (AddOnManager.getToDeleteListFile().exists()) {
                    JOptionPane.showMessageDialog(this.frame, "<html><body><p style='width: 200px'>Upgrading packages on your machine requires BEAUti to restart. Shutting down now.</p></body></html>");
                    System.exit(0);
                }
                AddOnManager.installPackages(hashMap, false, null);
                AddOnManager.loadExternalJars();
                string = String.join((CharSequence)",", hashMap.keySet().stream().map(Package::toString).collect(Collectors.toList()));
                this.setCursor(new Cursor(0));
            }
            catch (AddOnManager.DependencyResolutionException | IOException exception) {
                JOptionPane.showMessageDialog(null, "Install failed because: " + exception.getMessage());
                this.setCursor(new Cursor(0));
            }
            this.resetPackages();
            this.dataTable.setRowSelectionInterval(nArray[0], nArray[0]);
            if (string.length() > 0) {
                JOptionPane.showMessageDialog(null, "Package(s) " + string + " installed. " + "Note that any changes to the BEAUti " + "interface will\n not appear until a " + "new document is created or BEAUti is " + "restarted.");
            }
        });
        box.add(jButton);
        JButton jButton2 = new JButton("Uninstall");
        jButton2.addActionListener(actionEvent -> {
            int[] nArray;
            StringBuilder stringBuilder = new StringBuilder();
            for (int n : nArray = this.dataTable.getSelectedRows()) {
                Package package_ = this.getSelectedPackage(n);
                if (package_ == null) continue;
                try {
                    if (package_.isInstalled()) {
                        this.setCursor(new Cursor(3));
                        List<String> list = AddOnManager.getInstalledDependencyNames(package_, this.packageMap);
                        if (list.isEmpty()) {
                            String string = AddOnManager.uninstallPackage(package_, package_.getInstalledVersion(), false, null);
                            if (string != null) {
                                if (stringBuilder.length() > 0) {
                                    stringBuilder.append(", ");
                                }
                                stringBuilder.append("'").append(package_.getName()).append(" v").append(package_.getInstalledVersion()).append("'");
                            }
                        } else {
                            throw new AddOnManager.DependencyResolutionException("package " + package_ + " is used by the following packages: " + String.join((CharSequence)", ", list) + "\n" + "Remove those packages first.");
                        }
                        this.setCursor(new Cursor(0));
                    }
                    this.resetPackages();
                    this.dataTable.setRowSelectionInterval(nArray[0], nArray[0]);
                }
                catch (AddOnManager.DependencyResolutionException | IOException exception) {
                    JOptionPane.showMessageDialog(null, "Uninstall failed because: " + exception.getMessage());
                    this.setCursor(new Cursor(0));
                }
            }
            if (AddOnManager.getToDeleteListFile().exists()) {
                JOptionPane.showMessageDialog(this.frame, "<html><body><p style='width: 200px'>Removing packages on your machine requires BEAUti to restart. Shutting down now.</p></body></html>");
                System.exit(0);
            }
            if (stringBuilder.length() > 0) {
                JOptionPane.showMessageDialog(null, "Package(s) " + stringBuilder.toString() + " removed. " + "Note that any changes to the BEAUti " + "interface will\n not appear until a " + "new document is created or BEAUti is " + "restarted.");
            }
        });
        box.add(jButton2);
        box.add(Box.createHorizontalGlue());
        JButton jButton3 = new JButton("Package repositories");
        jButton3.addActionListener(actionEvent -> {
            JPackageRepositoryDialog jPackageRepositoryDialog = new JPackageRepositoryDialog(this.frame);
            jPackageRepositoryDialog.setVisible(true);
            this.resetPackages();
        });
        box.add(jButton3);
        box.add(Box.createGlue());
        JButton jButton4 = new JButton("Close");
        jButton4.addActionListener(actionEvent -> {
            if (this.dlg != null) {
                this.dlg.setVisible(false);
            } else {
                this.setVisible(false);
            }
        });
        box.add(jButton4);
        JButton jButton5 = new JButton("?");
        jButton5.setToolTipText(AddOnManager.getPackageUserDir() + " " + AddOnManager.getPackageSystemDir());
        jButton5.addActionListener(actionEvent -> JOptionPane.showMessageDialog(this.scrollPane, "<html>By default, packages are installed in <br><br><em>" + AddOnManager.getPackageUserDir() + "</em><br><br>and are available only to you.<br>" + "<br>Packages can also be moved manually to <br><br><em>" + AddOnManager.getPackageSystemDir() + "</em><br><br>which makes them available to all users<br>" + "on your system.</html>"));
        box.add(jButton5);
        return box;
    }

    public JDialog asDialog(JFrame jFrame) {
        if (jFrame == null) {
            jFrame = (JFrame)SwingUtilities.getWindowAncestor(this);
        }
        this.frame = jFrame;
        this.dlg = new JDialog(jFrame, "BEAST 2 Package Manager", true);
        this.dlg.getContentPane().add((Component)this.scrollPane, "Center");
        this.dlg.getContentPane().add((Component)this.jLabel, "North");
        this.dlg.getContentPane().add((Component)this.buttonBox, "South");
        this.dlg.pack();
        Point point = jFrame.getLocation();
        Dimension dimension = jFrame.getSize();
        Dimension dimension2 = this.getPreferredSize();
        int n = UIManager.getFont("Label.font").getSize();
        this.dlg.setSize(690 * n / 13, 430 * n / 13);
        this.dlg.setLocation(point.x + dimension.width / 2 - dimension2.width / 2, point.y + dimension.height / 2 - dimension2.height / 2);
        jFrame.setCursor(new Cursor(0));
        return this.dlg;
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (this.dlg != null) {
            this.dlg.setCursor(cursor);
        } else {
            super.setCursor(cursor);
        }
    }

    class PackageTable
    extends JTable {
        private static final long serialVersionUID = 1L;
        Map<Package, PackageVersion> packagesToInstall;

        public PackageTable(TableModel tableModel) {
            super(tableModel);
            this.packagesToInstall = new HashMap<Package, PackageVersion>();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n != ((DataTableModel)this.getModel()).linkColumn) {
                return String.class;
            }
            return ImageIcon.class;
        }

        @Override
        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Component component = super.prepareRenderer(tableCellRenderer, n, n2);
            Font font = component.getFont();
            font.getFamily();
            Font font2 = new Font(font.getName(), 3, font.getSize());
            Package package_ = JPackageDialog.this.packageList.get(n);
            if (!this.isRowSelected(n)) {
                if (package_.newVersionAvailable()) {
                    if (package_.isInstalled()) {
                        component.setFont(font2);
                    }
                    if (n2 == 2) {
                        this.packagesToInstall.clear();
                        this.packagesToInstall.put(package_, package_.getLatestVersion());
                        try {
                            AddOnManager.populatePackagesToInstall(JPackageDialog.this.packageMap, this.packagesToInstall);
                            component.setForeground(new Color(0, 150, 0));
                        }
                        catch (AddOnManager.DependencyResolutionException dependencyResolutionException) {
                            component.setForeground(new Color(150, 0, 0));
                        }
                    } else {
                        component.setForeground(Color.BLACK);
                    }
                } else {
                    component.setForeground(Color.BLACK);
                }
            }
            return component;
        }

        private int getColumnDataWidth(int n) {
            int n2 = 0;
            int n3 = this.getColumnModel().getColumn(n).getMaxWidth();
            for (int i = 0; i < this.getRowCount() && (n2 = Math.max(n2, this.getCellDataWidth(i, n))) < n3; ++i) {
            }
            n2 = Math.max(n2, this.getHeaderWidth(n));
            return n2;
        }

        private int getCellDataWidth(int n, int n2) {
            TableCellRenderer tableCellRenderer = this.getCellRenderer(n, n2);
            Component component = this.prepareRenderer(tableCellRenderer, n, n2);
            return component.getPreferredSize().width + 2 * this.getIntercellSpacing().width;
        }

        private int getHeaderWidth(int n) {
            TableColumn tableColumn = this.getColumnModel().getColumn(n);
            TableCellRenderer tableCellRenderer = this.getDefaultRenderer(String.class);
            Component component = tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, -1, n);
            return component.getPreferredSize().width + 2 * this.getIntercellSpacing().width;
        }

        void updateWidths() {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                int n = this.getColumnDataWidth(i);
                TableColumn tableColumn = this.getColumnModel().getColumn(i);
                this.getTableHeader().setResizingColumn(tableColumn);
                tableColumn.setWidth(n);
            }
        }
    }

    class DataTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        String[] columnNames = new String[]{"Name", "Installed", "Latest", "Dependencies", "Link", "Detail"};
        public final int linkColumn = 4;
        ImageIcon linkIcon = Utils.getIcon("beast/app/beauti/link.png");

        DataTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return JPackageDialog.this.packageList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Package package_ = JPackageDialog.this.packageList.get(n);
            switch (n2) {
                case 0: {
                    return package_.getName();
                }
                case 1: {
                    return package_.getInstalledVersion();
                }
                case 2: {
                    return package_.getLatestVersion();
                }
                case 3: {
                    return package_.getDependenciesString();
                }
                case 4: {
                    return package_.getProjectURL() != null ? this.linkIcon : null;
                }
                case 5: {
                    return package_.getDescription();
                }
            }
            throw new IllegalArgumentException("unknown column, " + n2);
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public String toString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getColumnName(0));
            for (n = 1; n < this.getColumnCount(); ++n) {
                stringBuffer.append("\t");
                stringBuffer.append(this.getColumnName(n));
            }
            stringBuffer.append("\n");
            for (n = 0; n < this.getRowCount(); ++n) {
                stringBuffer.append(this.getValueAt(n, 0));
                for (int i = 1; i < this.getColumnCount(); ++i) {
                    stringBuffer.append("\t");
                    stringBuffer.append(this.getValueAt(n, i));
                }
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
    }
}

