/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.Beauti;
import beast.app.beauti.BeautiAlignmentProvider;
import beast.app.beauti.BeautiConfig;
import beast.app.beauti.BeautiConnector;
import beast.app.beauti.BeautiDocListener;
import beast.app.beauti.BeautiPanelConfig;
import beast.app.beauti.BeautiSubTemplate;
import beast.app.beauti.PartitionContext;
import beast.app.beauti.SiteModelInputEditor;
import beast.app.draw.BEASTObjectPanel;
import beast.app.draw.InputEditor;
import beast.app.draw.InputEditorFactory;
import beast.app.util.Utils;
import beast.core.BEASTInterface;
import beast.core.BEASTObject;
import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.Distribution;
import beast.core.Input;
import beast.core.MCMC;
import beast.core.Runnable;
import beast.core.StateNode;
import beast.core.parameter.Parameter;
import beast.core.parameter.RealParameter;
import beast.core.util.CompoundDistribution;
import beast.core.util.Log;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.FilteredAlignment;
import beast.evolution.alignment.Taxon;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.branchratemodel.BranchRateModel;
import beast.evolution.branchratemodel.StrictClockModel;
import beast.evolution.likelihood.GenericTreeLikelihood;
import beast.evolution.operators.TipDatesRandomWalker;
import beast.evolution.substitutionmodel.SubstitutionModel;
import beast.evolution.tree.TraitSet;
import beast.evolution.tree.Tree;
import beast.math.distributions.MRCAPrior;
import beast.math.distributions.Normal;
import beast.math.distributions.ParametricDistribution;
import beast.math.distributions.Prior;
import beast.util.JSONProducer;
import beast.util.NexusParser;
import beast.util.XMLParser;
import beast.util.XMLParserException;
import beast.util.XMLProducer;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Description(value="Beauti document in doc-view pattern, not useful in models")
public class BeautiDoc
extends BEASTObject
implements XMLParser.RequiredInputProvider {
    static final String STANDARD_TEMPLATE = "templates/Standard.xml";
    static final int ALIGNMENT_PARTITION = 3;
    static final int SITEMODEL_PARTITION = 0;
    static final int CLOCKMODEL_PARTITION = 1;
    static final int TREEMODEL_PARTITION = 2;
    public List<Alignment> alignments = new ArrayList<Alignment>();
    public final Input<Runnable> mcmc = new Input("runnable", "main entry of analysis", Input.Validate.REQUIRED);
    protected List<BranchRateModel> clockModels;
    public boolean autoSetClockRate = true;
    public boolean autoUpdateFixMeanSubstRate = true;
    public boolean allowLinking = false;
    public boolean hasLinkedAtLeastOnce = false;
    List<BEASTInterface>[] pPartitionByAlignments;
    List<BEASTInterface>[] pPartition;
    private List<Integer>[] currentPartitions;
    List<PartitionContext> partitionNames = new ArrayList<PartitionContext>();
    Set<PartitionContext> possibleContexts = new HashSet<PartitionContext>();
    public BeautiConfig beautiConfig;
    Beauti beauti;
    private String templateName = null;
    private String templateFileName = "templates/Standard.xml";
    Map<String, String> tipTextMap = new HashMap<String, String>();
    public HashMap<String, BEASTInterface> pluginmap = null;
    private Map<BEASTInterface, String> reversePluginmap;
    List<BEASTInterface> posteriorPredecessors = null;
    List<BEASTInterface> likelihoodPredecessors = null;
    public Map<String, Taxon> taxaset = null;
    private boolean isExpertMode = false;
    public Set<InputEditor> currentInputEditors = new HashSet<InputEditor>();
    private String fileName = "";
    public Set<Input<?>> linked;
    InputEditorFactory inputEditorFactory;
    static ByteArrayOutputStream baos = null;
    private Set<BeautiDocListener> listeners = new HashSet<BeautiDocListener>();

    public InputEditorFactory getInputEditorFactory() {
        return this.inputEditorFactory;
    }

    public BeautiDoc() {
        this.setID("BeautiDoc");
        this.clear();
        this.inputEditorFactory = new InputEditorFactory(this);
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public ActionOnExit parseArgs(String[] stringArray) throws XMLParserException, SAXException, IOException, ParserConfigurationException {
        ActionOnExit actionOnExit = ActionOnExit.UNKNOWN;
        String string = "beast.xml";
        String string2 = null;
        String string3 = null;
        TraitSet traitSet = null;
        int n = 0;
        try {
            while (n < stringArray.length) {
                Object object;
                String string4;
                int n2 = n;
                if (stringArray[n].equals("")) {
                    ++n;
                } else if (stringArray[n].equals("-capture")) {
                    ++n;
                } else if (stringArray[n].equals("-xml")) {
                    string4 = stringArray[n + 1];
                    string2 = BeautiDoc.load(string4);
                    this.fileName = this.nameFromFile(string4);
                    n += 2;
                } else if (stringArray[n].equals("-template")) {
                    string4 = stringArray[n + 1];
                    string3 = this.processTemplate(string4);
                    this.templateFileName = string4;
                    this.templateName = this.nameFromFile(string4);
                    n += 2;
                } else if (stringArray[n].equals("-nex")) {
                    string4 = stringArray[n + 1];
                    object = new NexusParser();
                    ((NexusParser)object).parseFile(new File(string4));
                    if (((NexusParser)object).filteredAlignments.size() > 0) {
                        for (Alignment alignment : ((NexusParser)object).filteredAlignments) {
                            this.alignments.add(alignment);
                        }
                    } else {
                        this.alignments.add(((NexusParser)object).m_alignment);
                    }
                    n += 2;
                    traitSet = ((NexusParser)object).traitSet;
                } else if (stringArray[n].equals("-xmldata")) {
                    string4 = stringArray[n + 1];
                    object = (Alignment)BeautiAlignmentProvider.getXMLData(new File(string4));
                    this.alignments.add((Alignment)object);
                    n += 2;
                } else if (stringArray[n].equals("-exitaction")) {
                    if (stringArray[n + 1].equals("writexml")) {
                        actionOnExit = ActionOnExit.WRITE_XML;
                    } else if (stringArray[n + 1].equals("usetemplate")) {
                        actionOnExit = ActionOnExit.SHOW_DETAILS_USE_TEMPLATE;
                    } else if (stringArray[n + 1].equals("usexml")) {
                        actionOnExit = ActionOnExit.SHOW_DETAILS_USE_XML_SPEC;
                    } else if (stringArray[n + 1].equals("merge")) {
                        actionOnExit = ActionOnExit.MERGE_AND_WRITE_XML;
                    } else {
                        throw new IllegalArgumentException("Expected one of 'writexml','usetemplate' or 'usexml', not " + stringArray[n + 1]);
                    }
                    n += 2;
                } else if (stringArray[n].equals("-out")) {
                    string = stringArray[n + 1];
                    n += 2;
                } else if (stringArray[n].equals("-noerr")) {
                    System.setErr(new PrintStream(new OutputStream(){

                        @Override
                        public void write(int n) {
                        }
                    }));
                    ++n;
                }
                if (n != n2) continue;
                throw new IllegalArgumentException("Wrong argument: " + stringArray[n]);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
        this.initialize(actionOnExit, string2, string3, string);
        this.addTraitSet(traitSet);
        return actionOnExit;
    }

    String nameFromFile(String string) {
        if (string.contains("/")) {
            return string.substring(string.lastIndexOf("/") + 1, string.length() - 4);
        }
        if (string.contains("\\")) {
            return string.substring(string.lastIndexOf("\\") + 1, string.length() - 4);
        }
        return string.substring(0, string.length() - 4);
    }

    public void addBeautiDocListener(BeautiDocListener beautiDocListener) {
        this.listeners.add(beautiDocListener);
    }

    void clear() {
        this.clockModels = new ArrayList<BranchRateModel>();
        this.alignments = new ArrayList<Alignment>();
        this.pPartitionByAlignments = new List[3];
        this.pPartition = new List[3];
        this.currentPartitions = new List[3];
        this.partitionNames = new ArrayList<PartitionContext>();
        for (int i = 0; i < 3; ++i) {
            this.pPartitionByAlignments[i] = new ArrayList<BEASTInterface>();
            this.pPartition[i] = new ArrayList<BEASTInterface>();
            this.currentPartitions[i] = new ArrayList<Integer>();
        }
        this.tipTextMap = new HashMap<String, String>();
        this.pluginmap = new HashMap();
        this.reversePluginmap = new HashMap<BEASTInterface, String>();
        this.taxaset = new HashMap<String, Taxon>();
        this.fileName = "";
        this.linked = new HashSet();
    }

    public void registerPlugin(BEASTInterface bEASTInterface) {
        this.unregisterPlugin(bEASTInterface);
        this.pluginmap.put(bEASTInterface.getID(), bEASTInterface);
        this.reversePluginmap.put(bEASTInterface, bEASTInterface.getID());
        if (bEASTInterface instanceof Taxon) {
            Taxon taxon = (Taxon)bEASTInterface;
            this.taxaset.put(taxon.getID(), taxon);
        }
    }

    public void unregisterPlugin(BEASTInterface bEASTInterface) {
        this.taxaset.remove(bEASTInterface.getID());
        String string = this.reversePluginmap.get(bEASTInterface);
        if (string != null && this.pluginmap.containsKey(string)) {
            this.pluginmap.remove(string);
        }
    }

    public void newAnalysis() {
        try {
            this.clear();
            BEASTObjectPanel.init();
            this.beautiConfig.clear();
            String string = this.processTemplate(this.templateFileName);
            this.loadTemplate(string);
            for (BeautiDocListener beautiDocListener : this.listeners) {
                beautiDocListener.docHasChanged();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void loadXML(File file) throws IOException, XMLParserException, SAXException, ParserConfigurationException {
        String string = BeautiDoc.load(file);
        this.extractSequences(string);
        this.scrubAll(true, false);
        this.fireDocHasChanged();
    }

    public void loadNewTemplate(String string) {
        this.templateFileName = string;
        this.newAnalysis();
    }

    public void importNexus(File file) throws IOException {
        NexusParser nexusParser = new NexusParser();
        nexusParser.parseFile(file);
        if (nexusParser.filteredAlignments.size() > 0) {
            for (Alignment alignment : nexusParser.filteredAlignments) {
                this.addAlignmentWithSubnet(alignment, this.beautiConfig.partitionTemplate.get());
            }
        } else {
            this.addAlignmentWithSubnet(nexusParser.m_alignment, this.beautiConfig.partitionTemplate.get());
        }
        this.addTraitSet(nexusParser.traitSet);
    }

    public void importXMLAlignment(File file) {
        Alignment alignment = (Alignment)BeautiAlignmentProvider.getXMLData(file);
        alignment.initAndValidate();
        this.addAlignmentWithSubnet(alignment, this.beautiConfig.partitionTemplate.get());
    }

    void fireDocHasChanged() {
        for (BeautiDocListener beautiDocListener : this.listeners) {
            try {
                beautiDocListener.docHasChanged();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void initialize(ActionOnExit actionOnExit, String string, String string2, String string3) throws XMLParserException, SAXException, IOException, ParserConfigurationException {
        switch (actionOnExit) {
            case UNKNOWN: 
            case SHOW_DETAILS_USE_TEMPLATE: {
                this.mergeSequences(string2);
                this.connectModel();
                break;
            }
            case SHOW_DETAILS_USE_XML_SPEC: {
                if (string2 == null) {
                    string2 = this.processTemplate(STANDARD_TEMPLATE);
                }
                this.loadTemplate(string2);
                this.extractSequences(string);
                this.connectModel();
                break;
            }
            case WRITE_XML: {
                this.mergeSequences(string2);
                this.connectModel();
                this.save(string3);
                break;
            }
            case MERGE_AND_WRITE_XML: {
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public String processTemplate(String string) throws IOException {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        String string2 = System.getProperty("path.separator");
        String string3 = System.getProperty("java.class.path");
        String string4 = System.getProperty("file.separator");
        if (string4.equals("\\")) {
            string4 = "\\\\";
        }
        hashSet.add(".");
        for (String string5 : string3.split(string2)) {
            void object22;
            void var10_15;
            String string6 = string5.replaceAll(string4, "/");
            if (string6.endsWith(".jar")) {
                String string7 = string6.substring(0, string6.lastIndexOf("/"));
            }
            if (var10_15.indexOf("/") >= 0) {
                String string8 = var10_15.substring(0, var10_15.lastIndexOf("/"));
            }
            if (hashSet.contains(object22)) continue;
            hashSet.add(object22);
        }
        Object object3 = new File(string);
        for (String string5 : hashSet) {
            if (!((File)object3).exists()) {
                object3 = new File(string5 + string4 + string);
            }
            if (((File)object3).exists()) continue;
            object3 = new File(string5 + string4 + "templates" + string4 + string);
        }
        Log.warning.println("Loading template " + ((File)object3).getAbsolutePath());
        Object object4 = BeautiDoc.load(((File)object3).getAbsolutePath());
        int n = 0;
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        while (n >= 0) {
            if ((n = ((String)object4).indexOf("<mergepoint", n + 1)) <= 0) continue;
            int n2 = ((String)object4).indexOf(62, n);
            Object object2 = ((String)object4).substring(n, n2);
            object2 = ((String)object2).replaceAll(".*id=", "");
            char c = ((String)object2).charAt(0);
            object2 = ((String)object2).replaceAll(c + "[^" + c + "]*$", "");
            object2 = ((String)object2).substring(1);
            hashMap.put(object2, "");
        }
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String string9 : hashSet) {
            Log.info.println("Investigating " + string9);
            File file = new File(string9 + string4 + "templates");
            object = file.listFiles();
            if (object == null) continue;
            for (File file2 : object) {
                if (file2.getAbsolutePath().equals(((File)object3).getAbsolutePath()) || !file2.getName().toLowerCase().endsWith(".xml")) continue;
                if (!hashSet2.contains(file2.getName())) {
                    Log.warning.println("Processing " + file2.getAbsolutePath());
                    Utils.logToSplashScreen("Processing " + file2.getName());
                    hashSet2.add(file2.getName());
                    String string10 = BeautiDoc.load(file2.getAbsolutePath());
                    if (string10.contains("<mergepoint ")) continue;
                    try {
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        Document document = documentBuilderFactory.newDocumentBuilder().parse(file2);
                        document.normalize();
                        this.processBeautiConfig(document);
                        NodeList nodeList = document.getElementsByTagName("mergewith");
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            Node node = nodeList.item(i);
                            String string11 = node.getAttributes().getNamedItem("point").getNodeValue();
                            if (!hashMap.containsKey(string11)) {
                                Log.warning.println("Cannot find merge point named " + string11 + " from " + file2.getName() + " in template. MergeWith ignored.");
                                continue;
                            }
                            String string12 = "";
                            NodeList nodeList2 = node.getChildNodes();
                            for (int j = 0; j < nodeList2.getLength(); ++j) {
                                string12 = string12 + this.nodeToString(nodeList2.item(j));
                            }
                            String string13 = (String)hashMap.get(string11);
                            string13 = string13 + string12;
                            hashMap.put(string11, string13);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        if (exception.getMessage().contains("beast.app.beauti.InputConstraint")) continue;
                        Log.warning.println(exception.getMessage());
                        continue;
                    }
                }
                Log.warning.println("Skipping " + file2.getAbsolutePath() + " since " + file2.getName() + " is already processed");
            }
        }
        n = 0;
        while (n >= 0) {
            if ((n = ((String)object4).indexOf("<mergepoint", n + 1)) <= 0) continue;
            int n3 = ((String)object4).indexOf(62, n);
            String string14 = ((String)object4).substring(n, n3);
            string14 = string14.replaceAll(".*id=", "");
            char c = string14.charAt(0);
            string14 = string14.replaceAll(c + "[^" + c + "]*$", "");
            string14 = string14.substring(1);
            object = (String)hashMap.get(string14);
            object4 = ((String)object4).substring(0, n) + (String)object + ((String)object4).substring(n3 + 1);
        }
        this.templateName = this.nameFromFile(string);
        if (Boolean.valueOf(System.getProperty("beast.debug")).booleanValue()) {
            try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream("/tmp/beast.xml"));){
                outputStreamWriter.write((String)object4);
            }
        }
        return object4;
    }

    void processBeautiConfig(Document document) throws XMLParserException, TransformerException {
        NodeList nodeList = document.getElementsByTagName("beauticonfig");
        Node node = document.getElementsByTagName("*").item(0);
        String string = XMLParser.getAttribute(node, "namespace");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string2 = this.nodeToString(node2);
            XMLParser xMLParser = new XMLParser();
            xMLParser.setNameSpace(string);
            xMLParser.parseBareFragment(string2, true);
            node2.getParentNode().removeChild(node2);
        }
    }

    String nodeToString(Node node) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        StringWriter stringWriter = new StringWriter();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.transform(new DOMSource(node), new StreamResult(stringWriter));
        return stringWriter.toString();
    }

    public static String load(String string) throws IOException {
        return BeautiDoc.load(new File(string));
    }

    public static String load(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        while (bufferedReader.ready()) {
            string = bufferedReader.readLine();
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    Alignment getPartition(BEASTInterface bEASTInterface) {
        String string = bEASTInterface.getID();
        string = BeautiDoc.parsePartition(string);
        for (Alignment alignment : this.alignments) {
            if (!alignment.getID().equals(string)) continue;
            return alignment;
        }
        return null;
    }

    public DOC_STATUS validateModel() {
        if (this.mcmc == null || this.mcmc.get().hasPartitions() && this.partitionNames.size() == 0) {
            return DOC_STATUS.NO_DOCUMENT;
        }
        try {
            String string;
            String string2;
            if (this.fileName != null && this.fileName.length() > 0 && (string2 = BeautiDoc.load(this.fileName)).equals(string = this.toXML())) {
                return DOC_STATUS.SAVED;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return DOC_STATUS.DIRTY;
    }

    public void save(String string) throws IOException {
        this.save(new File(string));
    }

    public void save(File file) throws IOException {
        this.determinePartitions();
        this.scrubAll(false, false);
        String string = null;
        string = file.getPath().toLowerCase().endsWith(".json") ? this.toJSON() : this.toXML();
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        fileWriter.close();
    }

    private String toJSON() {
        HashSet<BEASTInterface> hashSet = new HashSet<BEASTInterface>();
        String string = new JSONProducer().toJSON(this.mcmc.get(), hashSet);
        string = string.replaceFirst("\\{", "{ beautitemplate:\"" + this.templateName + "\", beautistatus:\"" + this.getBeautiStatus() + "\", ");
        return string + "\n";
    }

    public String toXML() {
        HashSet<BEASTInterface> hashSet = new HashSet<BEASTInterface>();
        String string = new XMLProducer().toXML(this.mcmc.get(), hashSet);
        string = string.replaceFirst("<beast ", "<beast beautitemplate='" + this.templateName + "' beautistatus='" + this.getBeautiStatus() + "' ");
        return string + "\n";
    }

    String getBeautiStatus() {
        String string = "";
        if (!this.autoSetClockRate) {
            string = "noAutoSetClockRate";
        }
        if (this.allowLinking) {
            string = string + (string.length() > 0 ? "|" : "") + "allowLinking";
        }
        if (!this.autoUpdateFixMeanSubstRate) {
            string = string + (string.length() > 0 ? "|" : "") + "noAutoUpdateFixMeanSubstRate";
        }
        return string;
    }

    void extractSequences(String string) throws XMLParserException, SAXException, IOException, ParserConfigurationException {
        Object object;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Document document = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(new StringReader(string)));
        document.normalize();
        NodeList nodeList = document.getElementsByTagName("*");
        Node node = nodeList.item(0);
        String string2 = XMLParser.getAttribute(node, "beautitemplate");
        if (string2 == null) {
            int n = JOptionPane.showConfirmDialog(this.getFrame(), "This file does not appear to be generated by BEAUti. If you load it, unexpected behaviour may follow");
            if (n != 0) {
                return;
            }
            if (this.beautiConfig == null) {
                object = this.processTemplate(STANDARD_TEMPLATE);
                this.loadTemplate((String)object);
            }
        } else {
            String string3 = this.processTemplate(string2 + ".xml");
            this.loadTemplate(string3);
        }
        String string4 = XMLParser.getAttribute(node, "beautistatus");
        if (string4 == null) {
            string4 = "";
        }
        this.autoSetClockRate = !string4.contains("noAutoSetClockRate");
        this.beauti.autoSetClockRate.setSelected(this.autoSetClockRate);
        this.allowLinking = string4.contains("allowLinking");
        this.beauti.allowLinking.setSelected(this.allowLinking);
        this.autoUpdateFixMeanSubstRate = !string4.contains("noAutoUpdateFixMeanSubstRate");
        this.beauti.autoUpdateFixMeanSubstRate.setSelected(this.autoUpdateFixMeanSubstRate);
        object = new XMLParser();
        BEASTInterface bEASTInterface = ((XMLParser)object).parseFragment(string, true);
        this.mcmc.setValue(bEASTInterface, this);
        BEASTObjectPanel.addPluginToMap(bEASTInterface, this);
        try {
            CompoundDistribution compoundDistribution = (CompoundDistribution)((MCMC)this.mcmc.get()).posteriorInput.get();
            for (Distribution distribution : compoundDistribution.pDistributions.get()) {
                if (!distribution.getID().equals("likelihood")) continue;
                for (Distribution distribution2 : ((CompoundDistribution)distribution).pDistributions.get()) {
                    if (!(distribution2 instanceof GenericTreeLikelihood)) continue;
                    GenericTreeLikelihood genericTreeLikelihood = (GenericTreeLikelihood)distribution2;
                    PartitionContext partitionContext = new PartitionContext(genericTreeLikelihood);
                    try {
                        this.beautiConfig.partitionTemplate.get().createSubNet(partitionContext, false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (BeautiSubTemplate beautiSubTemplate : this.beautiConfig.subTemplates) {
                        try {
                            beautiSubTemplate.createSubNet(partitionContext, false);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.determinePartitions();
    }

    void mergeSequences(String string) throws XMLParserException, SAXException, IOException, ParserConfigurationException {
        if (string == null) {
            string = this.processTemplate(STANDARD_TEMPLATE);
        }
        this.loadTemplate(string);
        if (this.beautiConfig != null) {
            for (Alignment alignment : this.alignments) {
                this.beautiConfig.partitionTemplate.get().createSubNet(alignment, this, true);
            }
        } else {
            for (BEASTInterface bEASTInterface : this.pluginmap.values()) {
                if (!(bEASTInterface instanceof Alignment)) continue;
                for (Object object : bEASTInterface.getOutputs().toArray()) {
                    this.replaceInputs((BEASTInterface)object, bEASTInterface, this.alignments.get(0));
                }
            }
            return;
        }
        this.determinePartitions();
    }

    private void replaceInputs(BEASTInterface bEASTInterface, BEASTInterface bEASTInterface2, BEASTInterface bEASTInterface3) {
        try {
            for (Input<?> input : bEASTInterface.listInputs()) {
                if (input.get() == null) continue;
                if (input.get() instanceof List) {
                    List list = (List)input.get();
                    if (!list.contains(bEASTInterface2)) continue;
                    list.remove(bEASTInterface2);
                    list.add(bEASTInterface3);
                    continue;
                }
                if (!input.get().equals(bEASTInterface2)) continue;
                input.setValue(bEASTInterface3, bEASTInterface);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void loadTemplate(String string) throws XMLParserException, SAXException, IOException, ParserConfigurationException {
        XMLParser xMLParser = new XMLParser();
        BEASTObjectPanel.init();
        List<BEASTInterface> list = xMLParser.parseTemplate(string, new HashMap<String, BEASTInterface>(), true);
        for (BEASTInterface bEASTInterface : list) {
            if (bEASTInterface instanceof Runnable) {
                this.mcmc.setValue(bEASTInterface, this);
            } else if (bEASTInterface instanceof BeautiConfig) {
                this.beautiConfig = (BeautiConfig)bEASTInterface;
                this.beautiConfig.setDoc(this);
            } else {
                Log.warning.println("template item " + bEASTInterface.getID() + " is ignored");
            }
            BEASTObjectPanel.addPluginToMap(bEASTInterface, this);
        }
    }

    void addTraitSet(TraitSet traitSet) {
        if (traitSet != null) {
            CompoundDistribution compoundDistribution = (CompoundDistribution)this.pluginmap.get("likelihood");
            for (Distribution distribution : compoundDistribution.pDistributions.get()) {
                if (!(distribution instanceof GenericTreeLikelihood)) continue;
                try {
                    Tree tree = (Tree)((GenericTreeLikelihood)distribution).treeInput.get();
                    tree.m_traitList.setValue(traitSet, tree);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.scrubAll(true, false);
                return;
            }
        }
    }

    void connectModel() {
        this.scrubAll(true, true);
    }

    private void collectClockModels() {
        CompoundDistribution compoundDistribution = (CompoundDistribution)this.pluginmap.get("likelihood");
        while (this.clockModels.size() < this.partitionNames.size()) {
            try {
                GenericTreeLikelihood genericTreeLikelihood = new GenericTreeLikelihood();
                genericTreeLikelihood.branchRateModelInput.setValue(new StrictClockModel(), genericTreeLikelihood);
                List<BeautiSubTemplate> list = this.inputEditorFactory.getAvailableTemplates(genericTreeLikelihood.branchRateModelInput, genericTreeLikelihood, null, this);
                BEASTInterface bEASTInterface = ((BeautiSubTemplate)list.get(0)).createSubNet(this.partitionNames.get(this.clockModels.size()), true);
                this.clockModels.add((BranchRateModel.Base)bEASTInterface);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        int n = 0;
        for (Distribution distribution : compoundDistribution.pDistributions.get()) {
            String string;
            BranchRateModel branchRateModel = ((GenericTreeLikelihood)distribution).branchRateModelInput.get();
            Tree tree = null;
            try {
                for (Input input : ((BEASTInterface)((Object)branchRateModel)).listInputs()) {
                    if (!input.getName().equals("tree")) continue;
                    tree = (Tree)input.get();
                }
                if (tree != null && tree != ((GenericTreeLikelihood)distribution).treeInput.get()) {
                    branchRateModel = this.clockModels.get(n);
                    Log.warning.println("WARNING: unlinking clock model for " + distribution.getID());
                    ((GenericTreeLikelihood)distribution).branchRateModelInput.setValue(branchRateModel, distribution);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (branchRateModel == null) continue;
            Object object = ((BEASTInterface)((Object)branchRateModel)).getID();
            if (((String)(object = BeautiDoc.parsePartition((String)object))).equals(string = this.alignments.get(n).getID())) {
                this.clockModels.set(n, branchRateModel);
            }
            ++n;
        }
    }

    BranchRateModel getClockModel(String string) {
        int n = 0;
        for (Alignment alignment : this.alignments) {
            if (alignment.getID().equals(string)) {
                return this.clockModels.get(n);
            }
            ++n;
        }
        return null;
    }

    public synchronized void scrubAll(boolean bl, boolean bl2) {
        try {
            ArrayList<BeautiSubTemplate> arrayList;
            Object object2;
            if (this.autoSetClockRate) {
                this.setClockRate();
            }
            if (this.autoUpdateFixMeanSubstRate) {
                SiteModelInputEditor.customConnector(this);
            }
            if (this.pluginmap.containsKey("Tree.t:Species")) {
                Tree tree = (Tree)this.pluginmap.get("Tree.t:Species");
                tree.isEstimatedInput.setValue(true, tree);
            }
            boolean bl3 = true;
            block2: while (bl3) {
                this.warning("============================ start scrubbing ===========================");
                bl3 = false;
                this.setUpActivePlugins();
                for (String string : this.pluginmap.keySet()) {
                    BEASTInterface bEASTInterface;
                    if (string == null || !string.endsWith(".prior") || !((bEASTInterface = this.pluginmap.get(string)) instanceof MRCAPrior)) continue;
                    object2 = (MRCAPrior)bEASTInterface;
                    if (!((Boolean)((MRCAPrior)object2).treeInput.get().isEstimatedInput.get()).booleanValue()) {
                        this.disconnect(bEASTInterface, "prior", "distribution");
                        continue;
                    }
                    this.connect(bEASTInterface, "prior", "distribution");
                }
                arrayList = new ArrayList<BeautiSubTemplate>();
                arrayList.add(this.beautiConfig.partitionTemplate.get());
                arrayList.addAll(this.beautiConfig.subTemplates);
                for (PartitionContext partitionContext : this.possibleContexts) {
                    this.applyBeautiRules(arrayList, bl2, partitionContext);
                }
                this.applyBeautiRules(arrayList, bl2, new PartitionContext("Species"));
                ArrayList<BEASTInterface> object32 = new ArrayList<BEASTInterface>();
                BeautiDoc.collectPredecessors(((MCMC)this.mcmc.get()).posteriorInput.get(), object32);
                if (this.posteriorPredecessors.size() != object32.size()) {
                    bl3 = true;
                    continue;
                }
                for (Object object2 : object32) {
                    if (this.posteriorPredecessors.contains(object2)) continue;
                    bl3 = true;
                    continue block2;
                }
            }
            arrayList = new ArrayList<BeautiSubTemplate>();
            arrayList.add(this.beautiConfig.hyperPriorTemplate);
            for (BEASTInterface bEASTInterface : this.pluginmap.values()) {
                if (!(bEASTInterface instanceof RealParameter) || bEASTInterface.getID() == null || !bEASTInterface.getID().startsWith("parameter.")) continue;
                object2 = new PartitionContext(bEASTInterface.getID().substring("parameter.".length()));
                this.applyBeautiRules(arrayList, bl2, (PartitionContext)object2);
            }
            this.collectClockModels();
            Log.warning.println("PARTITIONS:\n");
            Log.warning.println(Arrays.toString(this.currentPartitions));
            this.determineLinks();
        }
        catch (Exception exception) {
            Log.err.println(exception.getMessage());
        }
    }

    protected void setUpActivePlugins() {
        this.posteriorPredecessors = new ArrayList<BEASTInterface>();
        BeautiDoc.collectPredecessors(((MCMC)this.mcmc.get()).posteriorInput.get(), this.posteriorPredecessors);
        this.likelihoodPredecessors = new ArrayList<BEASTInterface>();
        if (this.pluginmap.containsKey("likelihood")) {
            BeautiDoc.collectPredecessors(this.pluginmap.get("likelihood"), this.likelihoodPredecessors);
        }
        Log.trace.print("InPosterior=");
        for (BEASTInterface bEASTInterface : this.posteriorPredecessors) {
            this.pluginmap.put(bEASTInterface.getID(), bEASTInterface);
            Log.trace.print(bEASTInterface.getID() + " ");
        }
        Log.trace.println();
    }

    public static String translatePartitionNames(String string, PartitionContext partitionContext) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '.' && i < n - 6) {
                if (string.charAt(i + 2) == ':' && string.charAt(i + 3) == '$' && string.charAt(i + 4) == '(' && string.charAt(i + 5) == 'n' && string.charAt(i + 6) == ')') {
                    switch (string.charAt(i + 1)) {
                        case 's': {
                            stringBuilder.append(".s:").append(partitionContext.siteModel);
                            i += 6;
                            break;
                        }
                        case 'c': {
                            stringBuilder.append(".c:").append(partitionContext.clockModel);
                            i += 6;
                            break;
                        }
                        case 't': {
                            stringBuilder.append(".t:").append(partitionContext.tree);
                            i += 6;
                            break;
                        }
                        default: {
                            stringBuilder.append('.');
                            break;
                        }
                    }
                    continue;
                }
                stringBuilder.append('.');
                continue;
            }
            if (c == '$' && i < n - 3) {
                if (string.charAt(i + 1) == '(' && string.charAt(i + 2) == 'n' && string.charAt(i + 3) == ')') {
                    stringBuilder.append(partitionContext.partition);
                    i += 3;
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    void applyBeautiRules(List<BeautiSubTemplate> list, boolean bl, PartitionContext partitionContext) {
        for (BeautiSubTemplate beautiSubTemplate : list) {
            String string = BeautiDoc.translatePartitionNames(beautiSubTemplate.getMainID(), partitionContext);
            BEASTInterface bEASTInterface = this.pluginmap.get(string);
            if (bEASTInterface == null) continue;
            for (BeautiConnector beautiConnector : beautiSubTemplate.connectors) {
                if (beautiConnector.atInitialisationOnly()) {
                    if (!bl) continue;
                    this.warning("connect: " + beautiConnector.toString(partitionContext) + "\n");
                    this.connect(beautiConnector, partitionContext);
                    continue;
                }
                if (beautiConnector.isActivated(partitionContext, this.posteriorPredecessors, this.likelihoodPredecessors, this)) {
                    this.warning("connect: " + beautiConnector.toString(partitionContext) + "\n");
                    try {
                        this.connect(beautiConnector, partitionContext);
                    }
                    catch (Exception exception) {
                        this.warning(exception.getMessage());
                    }
                    continue;
                }
                this.warning("DISconnect: " + beautiConnector.toString(partitionContext) + "\n");
                try {
                    this.disconnect(beautiConnector, partitionContext);
                }
                catch (Exception exception) {
                    this.warning(exception.getMessage() + "\n");
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void setClockRate() {
        BEASTInterface bEASTInterface;
        boolean bl = false;
        if (this.pluginmap.containsKey("Tree.t:Species")) {
            bEASTInterface = (Tree)this.pluginmap.get("Tree.t:Species");
            for (BEASTInterface object : ((BEASTObject)bEASTInterface).getOutputs()) {
                if (!(object instanceof MRCAPrior)) continue;
                MRCAPrior mRCAPrior = (MRCAPrior)object;
                if (mRCAPrior.distInput.get() == null) continue;
                bl = true;
            }
        }
        if ((bEASTInterface = this.pluginmap.get("likelihood")) instanceof CompoundDistribution) {
            int n = 0;
            Object var4_6 = null;
            for (Distribution distribution : ((CompoundDistribution)bEASTInterface).pDistributions.get()) {
                void var4_7;
                CalculationNode calculationNode;
                if (!(distribution instanceof GenericTreeLikelihood)) continue;
                GenericTreeLikelihood genericTreeLikelihood = (GenericTreeLikelihood)distribution;
                boolean bl2 = bl;
                if (n > 0) {
                    calculationNode = genericTreeLikelihood.branchRateModelInput.get();
                    bl2 = ((BranchRateModel.Base)calculationNode).meanRateInput.get() != var4_7 || (Boolean)var4_7.isEstimatedInput.get() != false;
                } else {
                    calculationNode = (Tree)genericTreeLikelihood.treeInput.get();
                    if (((Tree)calculationNode).hasDateTrait()) {
                        bl2 = true;
                    }
                    for (BEASTInterface bEASTInterface2 : calculationNode.getOutputs()) {
                        if (!(bEASTInterface2 instanceof MRCAPrior)) continue;
                        MRCAPrior mRCAPrior = (MRCAPrior)bEASTInterface2;
                        if (mRCAPrior.distInput.get() == null) continue;
                        bl2 = true;
                    }
                }
                calculationNode = genericTreeLikelihood.branchRateModelInput.get();
                if (calculationNode != null) {
                    RealParameter realParameter = ((BranchRateModel.Base)calculationNode).meanRateInput.get();
                    realParameter.isEstimatedInput.setValue(bl2, realParameter);
                    if (var4_7 == null) {
                        Object object = realParameter;
                    }
                }
                ++n;
            }
        }
    }

    public void addPlugin(BEASTInterface bEASTInterface) {
        BEASTObjectPanel.addPluginToMap(bEASTInterface, this);
        try {
            for (Input<?> input : bEASTInterface.listInputs()) {
                if (input.get() == null) continue;
                if (input.get() instanceof BEASTInterface) {
                    BEASTObjectPanel.addPluginToMap((BEASTInterface)input.get(), this);
                }
                if (!(input.get() instanceof List)) continue;
                for (Object e : (List)input.get()) {
                    if (!(e instanceof BEASTInterface)) continue;
                    BEASTObjectPanel.addPluginToMap((BEASTInterface)e, this);
                }
            }
        }
        catch (Exception exception) {
            Log.warning.println(exception.getClass().getName() + " " + exception.getMessage());
        }
    }

    public void connect(BeautiConnector beautiConnector, PartitionContext partitionContext) {
        if (!beautiConnector.isRegularConnector) {
            return;
        }
        String string = BeautiDoc.translatePartitionNames(beautiConnector.sourceID, partitionContext);
        BEASTInterface bEASTInterface = this.pluginmap.get(string);
        if (bEASTInterface == null) {
            throw new IllegalArgumentException("Could not find beastObject with id " + string + ". Typo in template perhaps?\n");
        }
        String string2 = BeautiDoc.translatePartitionNames(beautiConnector.targetID, partitionContext);
        this.connect(bEASTInterface, string2, beautiConnector.targetInput);
    }

    public void connect(BEASTInterface bEASTInterface, String string, String string2) {
        try {
            BEASTInterface bEASTInterface2 = this.pluginmap.get(string);
            if (bEASTInterface2 == null) {
                Log.trace.println("BeautiDoc: Could not find object " + string);
                return;
            }
            Object object = bEASTInterface2.getInputValue(string2);
            if (object instanceof List && ((List)object).contains(bEASTInterface)) {
                this.warning("   " + string + "/" + string2 + " already contains " + (bEASTInterface == null ? "nulls" : bEASTInterface.getID()) + "\n");
                return;
            }
            bEASTInterface2.setInputValue(string2, bEASTInterface);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void disconnect(BeautiConnector beautiConnector, PartitionContext partitionContext) {
        if (!beautiConnector.isRegularConnector) {
            return;
        }
        BEASTInterface bEASTInterface = this.pluginmap.get(BeautiDoc.translatePartitionNames(beautiConnector.sourceID, partitionContext));
        String string = BeautiDoc.translatePartitionNames(beautiConnector.targetID, partitionContext);
        this.disconnect(bEASTInterface, string, beautiConnector.targetInput);
    }

    public void disconnect(BEASTInterface bEASTInterface, String string, String string2) {
        try {
            BEASTInterface bEASTInterface2 = this.pluginmap.get(string);
            if (bEASTInterface2 == null) {
                return;
            }
            Input<?> input = bEASTInterface2.getInput(string2);
            Object obj = input.get();
            if (obj instanceof List) {
                List list = (List)obj;
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) != bEASTInterface) continue;
                    this.warning("  DEL " + string + "/" + string2 + " contains " + (bEASTInterface == null ? "null" : bEASTInterface.getID()) + "\n");
                    list.remove(i);
                }
                if (bEASTInterface != null && bEASTInterface.getOutputs() != null) {
                    bEASTInterface.getOutputs().remove(bEASTInterface2);
                }
            } else if (input.get() != null && input.get() instanceof BEASTInterface && input.get() == bEASTInterface) {
                input.setValue(null, bEASTInterface2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addAlignmentWithSubnet(Alignment alignment, BeautiSubTemplate beautiSubTemplate) {
        this.alignments.add(alignment);
        beautiSubTemplate.createSubNet(alignment, this, true);
        this.determinePartitions();
    }

    public BEASTInterface addAlignmentWithSubnet(PartitionContext partitionContext, BeautiSubTemplate beautiSubTemplate) {
        BEASTInterface bEASTInterface = beautiSubTemplate.createSubNet(partitionContext, true);
        this.alignments.add((Alignment)bEASTInterface);
        this.determinePartitions();
        return bEASTInterface;
    }

    public void delAlignmentWithSubnet(Alignment alignment) {
        this.alignments.remove(alignment);
        try {
            PartitionContext partitionContext = null;
            for (PartitionContext partitionContextArray2 : this.partitionNames) {
                if (!partitionContextArray2.partition.equals(alignment.getID())) continue;
                partitionContext = partitionContextArray2;
                break;
            }
            BeautiSubTemplate beautiSubTemplate = this.beautiConfig.partitionTemplate.get();
            beautiSubTemplate.removeSubNet(beautiSubTemplate, partitionContext);
            for (BeautiSubTemplate beautiSubTemplate2 : this.beautiConfig.subTemplates) {
                beautiSubTemplate2.removeSubNet(beautiSubTemplate2, partitionContext);
            }
            PartitionContext[] partitionContextArray = this.possibleContexts.toArray(new PartitionContext[0]);
            this.determinePartitions();
            this.scrubAll(true, false);
            for (PartitionContext partitionContext2 : partitionContextArray) {
                if (!partitionContext2.equals(partitionContext)) continue;
                this.possibleContexts.remove(partitionContext2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.determinePartitions();
        this.scrubAll(true, false);
    }

    /*
     * WARNING - void declaration
     */
    public void determinePartitions() {
        void var4_15;
        Object object;
        CompoundDistribution compoundDistribution = (CompoundDistribution)this.pluginmap.get("likelihood");
        if (compoundDistribution == null) {
            return;
        }
        this.partitionNames.clear();
        this.possibleContexts.clear();
        for (Distribution object2 : compoundDistribution.pDistributions.get()) {
            if (!(object2 instanceof GenericTreeLikelihood)) continue;
            GenericTreeLikelihood genericTreeLikelihood = (GenericTreeLikelihood)object2;
            this.alignments.add(genericTreeLikelihood.dataInput.get());
            object = new PartitionContext(genericTreeLikelihood);
            this.partitionNames.add((PartitionContext)object);
            boolean bl = false;
            for (PartitionContext partitionContext : this.possibleContexts) {
                if (!((PartitionContext)object).equals(partitionContext)) continue;
                bl = true;
            }
            if (bl) continue;
            this.possibleContexts.add((PartitionContext)object);
        }
        this.alignments.clear();
        for (int i = 0; i < 3; ++i) {
            this.pPartitionByAlignments[i].clear();
            this.pPartition[i].clear();
            this.currentPartitions[i].clear();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Distribution distribution : compoundDistribution.pDistributions.get()) {
            if (!(distribution instanceof GenericTreeLikelihood)) continue;
            object = (GenericTreeLikelihood)distribution;
            this.alignments.add(((GenericTreeLikelihood)object).dataInput.get());
            arrayList.add(object);
        }
        for (Distribution distribution : compoundDistribution.pDistributions.get()) {
            if (!(distribution instanceof GenericTreeLikelihood)) continue;
            object = (GenericTreeLikelihood)distribution;
            try {
                int n = this.getPartitionNr((BEASTInterface)((Object)((GenericTreeLikelihood)object).siteModelInput.get()));
                Object object2 = (GenericTreeLikelihood)arrayList.get(n);
                ((GenericTreeLikelihood)object).siteModelInput.setValue(((GenericTreeLikelihood)object2).siteModelInput.get(), (BEASTInterface)object);
                this.currentPartitions[0].add(n);
                BranchRateModel branchRateModel = ((GenericTreeLikelihood)object).branchRateModelInput.get();
                if (branchRateModel != null) {
                    n = this.getPartitionNr((BEASTInterface)((Object)branchRateModel));
                    object2 = (GenericTreeLikelihood)arrayList.get(n);
                    ((GenericTreeLikelihood)object).branchRateModelInput.setValue(((GenericTreeLikelihood)object2).branchRateModelInput.get(), (BEASTInterface)object);
                    this.currentPartitions[1].add(n);
                } else {
                    this.currentPartitions[1].add(0);
                }
                n = this.getPartitionNr((BEASTInterface)((Object)((GenericTreeLikelihood)object).treeInput.get()));
                object2 = (GenericTreeLikelihood)arrayList.get(n);
                ((GenericTreeLikelihood)object).treeInput.setValue(((GenericTreeLikelihood)object2).treeInput.get(), (BEASTInterface)object);
                this.currentPartitions[2].add(n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.pPartitionByAlignments[0].add((BEASTInterface)object);
            this.pPartitionByAlignments[1].add((BEASTInterface)object);
            this.pPartitionByAlignments[2].add((BEASTInterface)object);
        }
        int n = this.partitionNames.size();
        boolean bl = false;
        while (var4_15 < 3) {
            int n2;
            object = new boolean[n];
            for (n2 = 0; n2 < n; ++n2) {
                int n3 = this.currentPartitions[var4_15].get(n2);
                object[n3] = true;
            }
            for (n2 = 0; n2 < n; ++n2) {
                if (object[n2] == false) continue;
                this.pPartition[var4_15].add(this.pPartitionByAlignments[var4_15].get(n2));
            }
            ++var4_15;
        }
        Log.warning.println("PARTITIONS0:\n");
        Log.warning.println(Arrays.toString(this.currentPartitions));
    }

    int getPartitionNr(String string, int n) {
        block6: for (int i = 0; i < this.partitionNames.size(); ++i) {
            PartitionContext partitionContext = this.partitionNames.get(i);
            switch (n) {
                case 3: {
                    if (!partitionContext.partition.equals(string)) continue block6;
                    return i;
                }
                case 0: {
                    if (!partitionContext.siteModel.equals(string)) continue block6;
                    return i;
                }
                case 1: {
                    if (!partitionContext.clockModel.equals(string)) continue block6;
                    return i;
                }
                case 2: {
                    if (!partitionContext.tree.equals(string)) continue block6;
                    return i;
                }
            }
        }
        return -1;
    }

    int getPartitionNr(BEASTInterface bEASTInterface) {
        String string;
        String string2 = string = bEASTInterface.getID();
        if (string.indexOf(46) >= 0) {
            string2 = string.substring(string.indexOf(46) + 1);
        }
        int n = 3;
        if (string.indexOf(58) >= 0) {
            char c = string.charAt(string.length() - string2.length());
            switch (c) {
                case 's': {
                    n = 0;
                    break;
                }
                case 'c': {
                    n = 1;
                    break;
                }
                case 't': {
                    n = 2;
                }
            }
            string2 = string2.substring(string2.indexOf(58) + 1);
        }
        return this.getPartitionNr(string2, n);
    }

    public List<BEASTInterface> getPartitions(String string) {
        if (string == null) {
            return this.pPartition[2];
        }
        if (string.contains("Partitions")) {
            ArrayList<BEASTInterface> arrayList = new ArrayList<BEASTInterface>();
            arrayList.addAll(this.alignments);
            return arrayList;
        }
        if (string.contains("SiteModel")) {
            return this.pPartition[0];
        }
        if (string.contains("ClockModel")) {
            return this.pPartition[1];
        }
        return this.pPartition[2];
    }

    public void setCurrentPartition(int n, int n2, String string) {
        int n3 = this.getPartitionNr(string, n);
        this.currentPartitions[n].set(n2, n3);
    }

    @Override
    public Object createInput(BEASTInterface bEASTInterface, Input<?> input, PartitionContext partitionContext) {
        for (BeautiSubTemplate beautiSubTemplate : this.beautiConfig.subTemplates) {
            try {
                if (!input.canSetValue(beautiSubTemplate.instance, bEASTInterface)) continue;
                String string = bEASTInterface.getID();
                string = BeautiDoc.parsePartition(string);
                BEASTInterface bEASTInterface2 = beautiSubTemplate.createSubNet(partitionContext, bEASTInterface, input, true);
                return bEASTInterface2;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private void warning(String string) {
        if (Boolean.valueOf(System.getProperty("beast.debug")).booleanValue()) {
            Log.warning.print(string);
        }
    }

    public boolean isExpertMode() {
        return this.isExpertMode;
    }

    public void setExpertMode(boolean bl) {
        this.isExpertMode = bl;
    }

    public static String parsePartition(String string) {
        String string2 = string.substring(string.indexOf(46) + 1);
        if (string2.indexOf(58) >= 0) {
            string2 = string2.substring(string2.indexOf(58) + 1);
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public static BEASTInterface deepCopyPlugin(BEASTInterface bEASTInterface, BEASTInterface bEASTInterface2, MCMC mCMC, PartitionContext partitionContext, PartitionContext partitionContext2, BeautiDoc beautiDoc, List<BEASTInterface> list) {
        Iterator<Object> iterator2;
        Object object;
        Object object22;
        Object object32;
        Object object4;
        HashSet<BEASTInterface> hashSet = new HashSet<BEASTInterface>();
        hashSet.add(bEASTInterface2);
        hashSet.add(mCMC.startStateInput.get());
        if (mCMC.posteriorInput.get() instanceof CompoundDistribution) {
            for (Distribution object62 : ((CompoundDistribution)mCMC.posteriorInput.get()).pDistributions.get()) {
                if (!(object62 instanceof CompoundDistribution)) continue;
                hashSet.add(object62);
            }
        }
        hashSet.add(mCMC.posteriorInput.get());
        hashSet.add(mCMC);
        hashSet.addAll((Collection)mCMC.loggersInput.get());
        if (beautiDoc.pluginmap.containsKey("SpeciesTreeLoggerX")) {
            hashSet.add(beautiDoc.pluginmap.get("SpeciesTreeLoggerX"));
        }
        for (StateNode stateNode : mCMC.startStateInput.get().stateNodeInput.get()) {
            if (!(stateNode instanceof Tree)) continue;
            hashSet.add(stateNode);
        }
        for (String string : beautiDoc.pluginmap.keySet()) {
            object4 = beautiDoc.pluginmap.get(string);
            if (!(object4 instanceof MRCAPrior)) continue;
            hashSet.add((BEASTInterface)object4);
        }
        if (list != null) {
            hashSet.addAll(list);
        }
        ArrayList arrayList = new ArrayList();
        BeautiDoc.collectPredecessors(bEASTInterface, arrayList);
        HashSet<BEASTInterface> hashSet2 = new HashSet<BEASTInterface>();
        BeautiDoc.collectAncestors(bEASTInterface, hashSet2, hashSet);
        Log.info.print(Arrays.toString(hashSet2.toArray()));
        object4 = arrayList.iterator();
        while (object4.hasNext()) {
            object32 = (BEASTInterface)object4.next();
            if (object32 instanceof StateNode) {
                object22 = new HashSet<BEASTInterface>();
                BeautiDoc.collectAncestors((BEASTInterface)object32, object22, hashSet);
                hashSet2.addAll((Collection<BEASTInterface>)object22);
                continue;
            }
            if (!(object32 instanceof Alignment) && !(object32 instanceof FilteredAlignment)) continue;
            for (Object e : object32.getOutputs()) {
                if (hashSet.contains(e)) continue;
                object = new HashSet<BEASTInterface>();
                BeautiDoc.collectAncestors((BEASTInterface)e, object, hashSet);
                hashSet2.addAll((Collection<BEASTInterface>)object);
            }
        }
        arrayList.addAll(hashSet2);
        object4 = arrayList.iterator();
        while (object4.hasNext()) {
            object32 = (BEASTInterface)object4.next();
            if (!(object32 instanceof Prior)) continue;
            object22 = new ArrayList<BEASTInterface>();
            BeautiDoc.collectPredecessors((BEASTInterface)object32, object22);
            hashSet2.addAll((Collection<BEASTInterface>)object22);
        }
        Log.info.print(Arrays.toString(arrayList.toArray()));
        for (Object object32 : hashSet2) {
            Log.info.print("(");
            try {
                for (BEASTInterface bEASTInterface3 : object32.listActiveBEASTObjects()) {
                    if (!hashSet2.contains(bEASTInterface3)) continue;
                    Log.info.print(bEASTInterface3.getID() + " ");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            Log.info.print(") ");
            Log.info.println(object32.getID());
        }
        object4 = new HashMap();
        for (Object object22 : hashSet2) {
            void var13_26;
            String string = object22.getID();
            if (string == null) {
                String string2 = bEASTInterface.getClass().getName().replaceAll(".*\\.", "");
                int n = 0;
                while (beautiDoc.pluginmap.containsKey(string2 + "." + n)) {
                    ++n;
                }
                String string3 = string2 + "." + n;
                object22.setID(string3);
            }
            if (!var13_26.equals(object = BeautiDoc.renameId((String)var13_26, partitionContext, partitionContext2))) {
                if (beautiDoc.pluginmap.containsKey(object)) {
                    iterator2 = beautiDoc.pluginmap.get(object);
                    object4.put(var13_26, iterator2);
                } else {
                    try {
                        iterator2 = (BEASTInterface)object22.getClass().newInstance();
                        iterator2.setID((String)object);
                        object4.put(var13_26, iterator2);
                    }
                    catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                        reflectiveOperationException.printStackTrace();
                        throw new RuntimeException("Programmer error: every object in the model should have a default constructor that is publicly accessible");
                    }
                }
            }
            Log.warning.println("Copy: " + (String)var13_26 + " -> " + (String)object);
        }
        for (Object object22 : hashSet2) {
            Object object5;
            Object object6;
            String string = object22.getID();
            object = (BEASTInterface)object4.get(string);
            if (object == null) continue;
            Log.warning.println("Processing: " + string + " -> " + object.getID());
            for (Input<?> input : object22.listInputs()) {
                if (input.get() == null) continue;
                if (input.get() instanceof List) {
                    for (BEASTInterface bEASTInterface4 : (List)input.get()) {
                        Input<?> input2;
                        if (bEASTInterface4 instanceof BEASTInterface) {
                            input2 = BeautiDoc.getCopyValue(bEASTInterface4, (Map<String, BEASTInterface>)object4, partitionContext, partitionContext2, beautiDoc);
                            object6 = object.getInput(input.getName()).get();
                            boolean bl = false;
                            if (object6 instanceof List) {
                                List list2 = (List)object6;
                                for (Object e : list2) {
                                    if (e != input2) continue;
                                    bl = true;
                                    break;
                                }
                            }
                            if (bl) continue;
                            object.setInputValue(input.getName(), input2);
                            continue;
                        }
                        if (object instanceof Parameter.Base && input.getName().equals("value")) {
                            input2 = (Parameter.Base)object;
                            ((Parameter.Base)((Object)input2)).valuesInput.get().clear();
                        }
                        object.setInputValue(input.getName(), input.get());
                    }
                    continue;
                }
                if (input.get() instanceof BEASTInterface) {
                    object5 = BeautiDoc.getCopyValue((BEASTInterface)input.get(), (Map<String, BEASTInterface>)object4, partitionContext, partitionContext2, beautiDoc);
                    object.setInputValue(input.getName(), object5);
                    continue;
                }
                if (input.get() instanceof String) {
                    object5 = (String)input.get();
                    object5 = ((String)object5).replaceAll("\\.c:[a-zA-Z0-9_]*", ".c:" + partitionContext2.clockModel);
                    object5 = ((String)object5).replaceAll("\\.s:[a-zA-Z0-9_]*", ".s:" + partitionContext2.siteModel);
                    object5 = ((String)object5).replaceAll("\\.t:[a-zA-Z0-9_]*", ".t:" + partitionContext2.tree);
                    object.setInputValue(input.getName(), object5);
                    continue;
                }
                object.setInputValue(input.getName(), input.get());
            }
            for (Object object7 : object22.getOutputs()) {
                if (!hashSet.contains(object7) || object7 == bEASTInterface2) continue;
                object5 = BeautiDoc.getCopyValue((BEASTInterface)object7, (Map<String, BEASTInterface>)object4, partitionContext, partitionContext2, beautiDoc);
                for (Input<?> input2 : ((BEASTInterface)object7).listInputs()) {
                    List list3;
                    if (!(input2.get() instanceof List) || hashSet.contains(object5) && input2.getName().equals("init") || !(object6 = (List)input2.get()).contains(object22) || (list3 = (List)object5.getInput(input2.getName()).get()).contains(object)) continue;
                    object5.setInputValue(input2.getName(), object);
                }
            }
            object4.put(string, object);
        }
        object32 = (BEASTInterface)object4.get(bEASTInterface.getID());
        object22 = new ArrayList();
        Collection collection = object4.values();
        while (collection.size() > 0) {
            for (Iterator<Object> iterator2 : collection) {
                boolean bl = false;
                for (BEASTInterface bEASTInterface5 : iterator2.listActiveBEASTObjects()) {
                    if (!collection.contains(bEASTInterface5)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                object22.add(iterator2);
            }
            collection.remove(object22.get(object22.size() - 1));
        }
        object = new HashSet();
        iterator2 = object22.iterator();
        while (iterator2.hasNext()) {
            BEASTInterface bEASTInterface6 = (BEASTInterface)iterator2.next();
            try {
                if (!object.contains(bEASTInterface6)) {
                    bEASTInterface6.initAndValidate();
                    object.add(bEASTInterface6);
                }
            }
            catch (Exception exception) {
                Log.warning.print(exception.getMessage());
            }
            if (beautiDoc == null) continue;
            beautiDoc.addPlugin(bEASTInterface6);
        }
        beautiDoc.scrubAll(true, false);
        return object32;
    }

    private static BEASTInterface getCopyValue(BEASTInterface bEASTInterface, Map<String, BEASTInterface> map, PartitionContext partitionContext, PartitionContext partitionContext2, BeautiDoc beautiDoc) {
        if (map.containsKey(bEASTInterface.getID())) {
            bEASTInterface = map.get(bEASTInterface.getID());
            return bEASTInterface;
        }
        String string = bEASTInterface.getID();
        if (string == null) {
            return bEASTInterface;
        }
        if (string.indexOf(46) >= 0) {
            String string2 = BeautiDoc.renameId(string, partitionContext, partitionContext2);
            if (beautiDoc.pluginmap.containsKey(string2)) {
                bEASTInterface = beautiDoc.pluginmap.get(string2);
            }
        } else if (beautiDoc.pluginmap.get(string) instanceof Alignment || beautiDoc.pluginmap.get(string) instanceof FilteredAlignment) {
            return beautiDoc.pluginmap.get(partitionContext2.partition);
        }
        return bEASTInterface;
    }

    public static String renameId(String string, PartitionContext partitionContext, PartitionContext partitionContext2) {
        String string2 = string.substring(string.indexOf(46) + 1);
        String string3 = null;
        if (string2.indexOf(58) >= 0) {
            char c = string2.charAt(0);
            switch (c) {
                case 's': {
                    string3 = partitionContext2.siteModel;
                    string2 = partitionContext.siteModel;
                    break;
                }
                case 'c': {
                    string3 = partitionContext2.clockModel;
                    string2 = partitionContext.clockModel;
                    break;
                }
                case 't': {
                    string3 = partitionContext2.tree;
                    string2 = partitionContext.tree;
                }
            }
        } else {
            string3 = partitionContext2.partition;
            string2 = partitionContext.partition;
        }
        if (string.indexOf(46) < 0 || !string.endsWith(string2)) {
            if (string.indexOf(58) > 0) {
                return string;
            }
            return string + "." + string3;
        }
        string = string.substring(0, string.length() - string2.length()) + string3;
        return string;
    }

    public static void collectPredecessors(BEASTInterface bEASTInterface, List<BEASTInterface> list) {
        list.add(bEASTInterface);
        if (bEASTInterface instanceof Alignment || bEASTInterface instanceof FilteredAlignment) {
            return;
        }
        try {
            for (BEASTInterface bEASTInterface2 : bEASTInterface.listActiveBEASTObjects()) {
                if (list.contains(bEASTInterface2)) continue;
                BeautiDoc.collectPredecessors(bEASTInterface2, list);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
    }

    public static void collectAncestors(BEASTInterface bEASTInterface, Set<BEASTInterface> set, Set<BEASTInterface> set2) {
        if (bEASTInterface instanceof GenericTreeLikelihood || bEASTInterface instanceof BeautiPanelConfig) {
            return;
        }
        set.add(bEASTInterface);
        try {
            for (BEASTInterface bEASTInterface2 : bEASTInterface.getOutputs()) {
                if (set.contains(bEASTInterface2) || set2.contains(bEASTInterface2)) continue;
                BeautiDoc.collectAncestors(bEASTInterface2, set, set2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
    }

    public void renamePartition(int n, String string, String string2) {
        String[] stringArray;
        Object object;
        String[] stringArray2;
        Log.warning.println("renamePartition: " + n + " " + string + " " + string2);
        String string3 = null;
        switch (n) {
            case 3: {
                string3 = "." + string2;
                break;
            }
            case 0: {
                string3 = ".s:" + string2;
                break;
            }
            case 1: {
                string3 = ".c:" + string2;
                break;
            }
            case 2: {
                string3 = ".t:" + string2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        for (BEASTInterface object22 : this.pluginmap.values()) {
            if (!object22.getID().endsWith(string3)) continue;
            throw new IllegalArgumentException("Name " + string2 + " is already in use");
        }
        Object object3 = null;
        switch (n) {
            case 3: {
                object3 = "." + string;
                break;
            }
            case 0: {
                object3 = ".s:" + string;
                break;
            }
            case 1: {
                object3 = ".c:" + string;
                break;
            }
            case 2: {
                object3 = ".t:" + string;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        for (BEASTInterface bEASTInterface : this.pluginmap.values()) {
            if (!bEASTInterface.getID().endsWith((String)object3)) continue;
            String string4 = bEASTInterface.getID();
            string4 = string4.substring(0, string4.indexOf((String)object3)) + string3;
            bEASTInterface.setID(string4);
        }
        if (n == 3) {
            for (BEASTInterface bEASTInterface : this.pluginmap.values()) {
                if (!bEASTInterface.getID().equals(string)) continue;
                bEASTInterface.setID(string2);
            }
        }
        for (String string5 : stringArray2 = this.pluginmap.keySet().toArray(new String[0])) {
            if (!string5.endsWith((String)object3)) continue;
            object = this.pluginmap.remove(string5);
            String string6 = string5.substring(0, string5.indexOf((String)object3)) + string3;
            this.pluginmap.put(string6, (BEASTInterface)object);
        }
        for (String string7 : stringArray = this.tipTextMap.keySet().toArray(new String[0])) {
            if (!string7.endsWith((String)object3)) continue;
            object = this.tipTextMap.remove(string7);
            String string8 = string7.substring(0, string7.indexOf((String)object3)) + string3;
            object = ((String)object).replaceAll((String)object3, string3);
            this.tipTextMap.put(string8, (String)object);
        }
        this.determinePartitions();
    }

    public PartitionContext getContextFor(BEASTInterface bEASTInterface) {
        String string = bEASTInterface.getID();
        String string2 = string.substring(string.indexOf(46) + 1);
        int n = 3;
        if (string2.indexOf(58) >= 0) {
            char c = string2.charAt(0);
            switch (c) {
                case 's': {
                    n = 0;
                    break;
                }
                case 'c': {
                    n = 1;
                    break;
                }
                case 't': {
                    n = 2;
                }
            }
            string2 = BeautiDoc.parsePartition(string);
        }
        block11: for (PartitionContext partitionContext : this.partitionNames) {
            switch (n) {
                case 3: {
                    if (!partitionContext.partition.equals(string2)) continue block11;
                    return partitionContext;
                }
                case 0: {
                    if (!partitionContext.siteModel.equals(string2)) continue block11;
                    return partitionContext;
                }
                case 1: {
                    if (!partitionContext.clockModel.equals(string2)) continue block11;
                    return partitionContext;
                }
                case 2: {
                    if (!partitionContext.tree.equals(string2)) continue block11;
                    return partitionContext;
                }
            }
            return null;
        }
        return new PartitionContext(string2);
    }

    void determineLinks() {
        if (!this.allowLinking) {
            return;
        }
        this.linked.clear();
        for (BEASTInterface object : this.posteriorPredecessors) {
            String string;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (BEASTInterface bEASTInterface : object.getOutputs()) {
                if (!this.posteriorPredecessors.contains(bEASTInterface) || (string = bEASTInterface.getID()).indexOf(46) < 0) continue;
                if (hashMap.containsKey(string = string.substring(0, string.indexOf(46)))) {
                    hashMap.put(string, (Integer)hashMap.get(string) + 1);
                    continue;
                }
                hashMap.put(string, 1);
            }
            for (BEASTInterface bEASTInterface : object.getOutputs()) {
                if (!this.posteriorPredecessors.contains(bEASTInterface) || (string = bEASTInterface.getID()).indexOf(46) < 0 || (Integer)hashMap.get(string = string.substring(0, string.indexOf(46))) <= 1) continue;
                this.addLink(object, bEASTInterface);
            }
            if (!(object instanceof Parameter)) continue;
            for (BEASTInterface bEASTInterface : object.getOutputs()) {
                if (!this.posteriorPredecessors.contains(bEASTInterface) || !(bEASTInterface instanceof SubstitutionModel)) continue;
                int n = 0;
                try {
                    for (Input<?> input : bEASTInterface.listInputs()) {
                        if (input.get() == null || !input.get().equals(object)) continue;
                        ++n;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n <= true) continue;
                this.addLink(object, bEASTInterface);
            }
        }
        this.hasLinkedAtLeastOnce = false;
        for (Input input : this.linked) {
            if (!input.getType().isAssignableFrom(RealParameter.class)) continue;
            this.hasLinkedAtLeastOnce = true;
            break;
        }
    }

    void addLink(BEASTInterface bEASTInterface, BEASTInterface bEASTInterface2) {
        try {
            for (Input<?> input : bEASTInterface2.listInputs()) {
                if (!(input.get() instanceof BEASTInterface) || input.get() != bEASTInterface) continue;
                this.linked.add(input);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addLink(Input<?> input) {
        this.linked.add(input);
        this.hasLinkedAtLeastOnce = true;
    }

    public void deLink(Input<?> input) {
        this.linked.remove(input);
    }

    public boolean isLinked(Input<?> input) {
        return this.linked.contains(input);
    }

    public List<BEASTInterface> suggestedLinks(BEASTInterface bEASTInterface) {
        String string = bEASTInterface.getID();
        ArrayList<BEASTInterface> arrayList = new ArrayList<BEASTInterface>();
        String string2 = null;
        if (string.indexOf(46) < 0) {
            return arrayList;
        }
        string2 = string.substring(string.indexOf(46) + 1);
        string = string.substring(0, string.indexOf(46));
        for (BEASTInterface bEASTInterface2 : this.posteriorPredecessors) {
            String string3 = bEASTInterface2.getID();
            if (string3.indexOf(46) < 0) continue;
            String string4 = string3.substring(string3.indexOf(46) + 1);
            if ((string3 = string3.substring(0, string3.indexOf(46))).equals(string)) {
                arrayList.add(bEASTInterface2);
            }
            if (!(bEASTInterface instanceof Parameter) || !string4.equals(string2) || !bEASTInterface2.getClass().equals(bEASTInterface.getClass())) continue;
            boolean bl = true;
            if (((Parameter)((Object)bEASTInterface)).getDimension() != ((Parameter)((Object)bEASTInterface2)).getDimension()) {
                bl = false;
            }
            boolean bl2 = false;
            block1: for (BEASTInterface bEASTInterface3 : bEASTInterface.getOutputs()) {
                for (BEASTInterface bEASTInterface4 : bEASTInterface2.getOutputs()) {
                    if (bEASTInterface3 != bEASTInterface4 || !(bEASTInterface3 instanceof SubstitutionModel)) continue;
                    bl2 = true;
                    continue block1;
                }
            }
            if (!bl || !bl2) continue;
            arrayList.add(bEASTInterface2);
        }
        arrayList.remove(bEASTInterface);
        return arrayList;
    }

    public BEASTInterface getUnlinkCandidate(Input<?> input, BEASTInterface bEASTInterface) {
        PartitionContext partitionContext = this.getContextFor((BEASTInterface)input.get());
        PartitionContext partitionContext2 = this.getContextFor(bEASTInterface);
        BEASTInterface bEASTInterface2 = BeautiDoc.deepCopyPlugin((BEASTInterface)input.get(), bEASTInterface, (MCMC)this.mcmc.get(), partitionContext, partitionContext2, this, null);
        return bEASTInterface2;
    }

    public void setBeauti(Beauti beauti) {
        this.beauti = beauti;
    }

    public JFrame getFrame() {
        return this.beauti.frame;
    }

    @Override
    public void initAndValidate() {
    }

    static void createTaxonSet(Alignment alignment, BeautiDoc beautiDoc) {
        List<String> list = alignment.getTaxaNames();
        TaxonSet taxonSet = new TaxonSet();
        for (String string : list) {
            taxonSet.taxonsetInput.get().add(beautiDoc.getTaxon(string));
        }
        taxonSet.setID("TaxonSet0." + alignment.getID());
        try {
            taxonSet.initAndValidate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        beautiDoc.registerPlugin(taxonSet);
    }

    public Taxon getTaxon(String string) {
        if (this.taxaset.keySet().contains(string)) {
            return this.taxaset.get(string);
        }
        try {
            Taxon taxon = new Taxon(string);
            this.registerPlugin(taxon);
            return taxon;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void addMRCAPrior(MRCAPrior mRCAPrior) {
        int n;
        Object object;
        Tree tree = (Tree)this.pluginmap.get("Tree.t:" + this.alignments.get(0).getID());
        if (tree == null) {
            for (String object22 : this.pluginmap.keySet()) {
                if (!object22.startsWith("Tree.t:")) continue;
                tree = (Tree)this.pluginmap.get(object22);
                break;
            }
        }
        if (this.alignments.size() > 1) {
            object = mRCAPrior.taxonsetInput.get().toString().split("\n")[1].trim();
            int n2 = -1;
            int d = 0;
            while (n2 < 0 && d++ < this.alignments.size()) {
                tree = (Tree)this.pluginmap.get("Tree.t:" + this.alignments.get(d - 1).getID());
                String[] stringArray = tree.getTaxaNames();
                for (n = 0; n < stringArray.length && n2 < 0; ++n) {
                    if (!((String)object).equals(stringArray[n])) continue;
                    n2 = n;
                }
            }
        }
        object = (CompoundDistribution)this.pluginmap.get("prior");
        mRCAPrior.treeInput.setValue(tree, mRCAPrior);
        ParametricDistribution parametricDistribution = mRCAPrior.distInput.get();
        TaxonSet taxonSet = mRCAPrior.taxonsetInput.get();
        if (this.taxaset.keySet().contains(taxonSet.getID())) {
            Log.warning.println("taxonset " + taxonSet.getID() + " already exists: MRCAPrior " + mRCAPrior.getID() + " can not be added");
        } else {
            this.taxaset.put(taxonSet.getID(), taxonSet);
            List<Taxon> list = taxonSet.taxonsetInput.get();
            for (n = 0; n < list.size(); ++n) {
                if (this.taxaset.containsKey(list.get(n).getID())) {
                    list.set(n, this.taxaset.get(list.get(n).getID()));
                    continue;
                }
                this.taxaset.put(list.get(n).getID(), list.get(n));
            }
            if (!(parametricDistribution instanceof Normal) || !Double.isInfinite(((Normal)parametricDistribution).sigmaInput.get().getValue())) {
                ((CompoundDistribution)object).pDistributions.setValue(mRCAPrior, (BEASTInterface)object);
                this.connect(mRCAPrior, "tracelog", "log");
            }
        }
        if (taxonSet.taxonsetInput.get().size() == 1 && parametricDistribution != null) {
            if (!(parametricDistribution instanceof Normal) || !Double.isInfinite(((Normal)parametricDistribution).sigmaInput.get().getValue())) {
                TipDatesRandomWalker tipDatesRandomWalker = new TipDatesRandomWalker();
                taxonSet.initAndValidate();
                tipDatesRandomWalker.initByName("taxonset", taxonSet, "weight", 1.0, "tree", tree, "windowSize", 1.0);
                tipDatesRandomWalker.setID("TipDatesRandomWalker." + taxonSet.getID());
                MCMC mCMC = (MCMC)this.mcmc.get();
                mCMC.operatorsInput.setValue(tipDatesRandomWalker, mCMC);
            }
            double d = parametricDistribution.getMean();
            TraitSet traitSet = null;
            for (TraitSet traitSet2 : tree.m_traitList.get()) {
                if (!traitSet2.isDateTrait()) continue;
                traitSet = traitSet2;
            }
            if (traitSet == null) {
                traitSet = new TraitSet();
                traitSet.setID("traitsetDate");
                this.registerPlugin(traitSet);
                traitSet.initByName("traitname", "date-backward", "taxa", tree.getTaxonset(), "value", taxonSet.taxonsetInput.get().get(0).getID() + "=" + d);
                tree.m_traitList.setValue(traitSet, tree);
                tree.initAndValidate();
            } else {
                traitSet.traitsInput.setValue(traitSet.traitsInput.get() + ",\n" + taxonSet.taxonsetInput.get().get(0).getID() + "=" + d, traitSet);
            }
            mRCAPrior.onlyUseTipsInput.setValue(true, mRCAPrior);
        }
    }

    public static enum DOC_STATUS {
        NO_DOCUMENT,
        SAVED,
        DIRTY;

    }

    public static enum ActionOnExit {
        UNKNOWN,
        SHOW_DETAILS_USE_TEMPLATE,
        SHOW_DETAILS_USE_XML_SPEC,
        WRITE_XML,
        MERGE_AND_WRITE_XML;

    }
}

