/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiAlignmentProvider;
import beast.app.beauti.BeautiDoc;
import beast.app.beauti.BeautiSubTemplate;
import beast.app.beauti.MRCAPriorInputEditor;
import beast.app.beauti.PartitionContext;
import beast.app.draw.InputEditor;
import beast.app.draw.ListInputEditor;
import beast.app.draw.SmallButton;
import beast.app.util.FileDrop;
import beast.core.BEASTInterface;
import beast.core.BEASTObject;
import beast.core.Input;
import beast.core.MCMC;
import beast.core.State;
import beast.core.StateNode;
import beast.core.util.CompoundDistribution;
import beast.core.util.Log;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.FilteredAlignment;
import beast.evolution.alignment.Taxon;
import beast.evolution.branchratemodel.BranchRateModel;
import beast.evolution.likelihood.GenericTreeLikelihood;
import beast.evolution.sitemodel.SiteModel;
import beast.evolution.sitemodel.SiteModelInterface;
import beast.evolution.tree.TreeInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class AlignmentListInputEditor
extends ListInputEditor {
    private static final long serialVersionUID = 1L;
    static final int NAME_COLUMN = 0;
    static final int FILE_COLUMN = 1;
    static final int TAXA_COLUMN = 2;
    static final int SITES_COLUMN = 3;
    static final int TYPE_COLUMN = 4;
    static final int SITEMODEL_COLUMN = 5;
    static final int CLOCKMODEL_COLUMN = 6;
    static final int TREE_COLUMN = 7;
    static final int USE_AMBIGUITIES_COLUMN = 8;
    static final int NR_OF_COLUMNS = 9;
    static final int STRUT_SIZE = 5;
    List<Alignment> alignments;
    int partitionCount;
    GenericTreeLikelihood[] likelihoods;
    Object[][] tableData;
    JTable table;
    JTextField nameEditor;
    List<JButton> linkButtons;
    List<JButton> unlinkButtons;
    JButton splitButton;
    JButton delButton;
    protected SmallButton replaceButton;
    private JScrollPane scrollPane;

    public AlignmentListInputEditor(BeautiDoc beautiDoc) {
        super(beautiDoc);
    }

    @Override
    public Class<?> type() {
        return List.class;
    }

    @Override
    public Class<?> baseType() {
        return Alignment.class;
    }

    @Override
    public Class<?>[] types() {
        Class[] classArray = new Class[]{List.class, Alignment.class};
        return classArray;
    }

    @Override
    public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
        this.itemNr = n;
        if (input.get() instanceof List) {
            this.alignments = (List)input.get();
        } else {
            this.alignments = new ArrayList<Alignment>();
            this.alignments.add((Alignment)input.get());
        }
        this.linkButtons = new ArrayList<JButton>();
        this.unlinkButtons = new ArrayList<JButton>();
        this.partitionCount = this.alignments.size();
        this.setLayout(new BorderLayout());
        this.add((Component)this.createLinkButtons(), "North");
        this.add(this.createListBox(), "Center");
        Color color = UIManager.getColor("Focus.color");
        MatteBorder matteBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, color);
        new FileDrop(null, (Component)this.scrollPane, matteBorder, new FileDrop.Listener(){

            @Override
            public void filesDropped(final File[] fileArray) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AlignmentListInputEditor.this.addItem(fileArray);
                    }
                });
            }
        });
        this.add((Component)this.createAddRemoveSplitButtons(), "South");
        this.updateStatus();
    }

    private JComponent createLinkButtons() {
        Box box = Box.createHorizontalBox();
        this.addLinkUnlinkPair(box, "Site Models");
        box.add(Box.createHorizontalStrut(5));
        this.addLinkUnlinkPair(box, "Clock Models");
        box.add(Box.createHorizontalStrut(5));
        this.addLinkUnlinkPair(box, "Trees");
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private JComponent createAddRemoveSplitButtons() {
        Box box = Box.createHorizontalBox();
        this.addButton = new SmallButton("+", true, SmallButton.ButtonType.square);
        this.addButton.setName("+");
        this.addButton.setToolTipText("Add item to the list");
        this.addButton.addActionListener(actionEvent -> this.addItem());
        box.add(Box.createHorizontalStrut(5));
        box.add(this.addButton);
        box.add(Box.createHorizontalStrut(5));
        this.delButton = new SmallButton("-", true, SmallButton.ButtonType.square);
        this.delButton.setName("-");
        this.delButton.setToolTipText("Delete selected items from the list");
        this.delButton.addActionListener(actionEvent -> {
            if (this.doc.hasLinkedAtLeastOnce) {
                JOptionPane.showMessageDialog(null, "Cannot delete partition while parameters are linked");
                return;
            }
            this.delItem();
        });
        box.add(this.delButton);
        box.add(Box.createHorizontalStrut(5));
        this.replaceButton = new SmallButton("r", true, SmallButton.ButtonType.square);
        this.replaceButton.setName("r");
        this.replaceButton.setToolTipText("Replace alignment by one loaded from file");
        this.replaceButton.addActionListener(actionEvent -> this.replaceItem());
        box.add(Box.createHorizontalStrut(5));
        box.add(this.replaceButton);
        box.add(Box.createHorizontalStrut(5));
        this.splitButton = new JButton("Split");
        this.splitButton.setName("Split");
        this.splitButton.setToolTipText("Split alignment into partitions, for example, codon positions");
        this.splitButton.addActionListener(actionEvent -> this.splitItem());
        box.add(this.splitButton);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private void addLinkUnlinkPair(Box box, String string) {
        JButton jButton = new JButton("Link " + string);
        jButton.setName("Link " + string);
        jButton.addActionListener(actionEvent -> {
            JButton jButton = (JButton)actionEvent.getSource();
            this.link(this.columnLabelToNr(jButton.getText()));
            this.table.repaint();
        });
        box.add(jButton);
        jButton.setEnabled(!this.getDoc().hasLinkedAtLeastOnce);
        JButton jButton2 = new JButton("Unlink " + string);
        jButton2.setName("Unlink " + string);
        jButton2.addActionListener(actionEvent -> {
            JButton jButton = (JButton)actionEvent.getSource();
            this.unlink(this.columnLabelToNr(jButton.getText()));
            this.table.repaint();
        });
        box.add(jButton2);
        jButton2.setEnabled(!this.getDoc().hasLinkedAtLeastOnce);
        this.linkButtons.add(jButton);
        this.unlinkButtons.add(jButton2);
    }

    private int columnLabelToNr(String string) {
        int n = string.contains("Tree") ? 7 : (string.contains("Clock") ? 6 : 5);
        return n;
    }

    private void link(int n) {
        int[] nArray = this.getTableRowSelection();
        for (int i = 1; i < nArray.length; ++i) {
            int n2 = nArray[i];
            this.link(n, n2, nArray[0]);
        }
    }

    private void link(int n, int n2, int n3) {
        Object object = this.tableData[n2][n];
        this.tableData[n2][n] = this.tableData[n3][n];
        try {
            this.updateModel(n, n2);
        }
        catch (Exception exception) {
            Log.warning.println(exception.getMessage());
            this.tableData[n2][n] = object;
            try {
                this.updateModel(n, n2);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        MRCAPriorInputEditor.customConnector(this.doc);
    }

    private void unlink(int n) {
        int[] nArray = this.getTableRowSelection();
        for (int i = 1; i < nArray.length; ++i) {
            int n2 = nArray[i];
            this.tableData[n2][n] = this.getDoc().partitionNames.get((int)n2).partition;
            try {
                this.updateModel(n, n2);
                continue;
            }
            catch (Exception exception) {
                Log.err.println(exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    int[] getTableRowSelection() {
        return this.table.getSelectedRows();
    }

    void updateModel(int n, int n2) {
        Object object;
        Log.warning.println("updateModel: " + n2 + " " + n + " " + this.table.getSelectedRow() + " " + this.table.getSelectedColumn());
        for (int i = 0; i < this.partitionCount; ++i) {
            Log.warning.println(i + " " + this.tableData[i][0] + " " + this.tableData[i][5] + " " + this.tableData[i][6] + " " + this.tableData[i][7]);
        }
        this.getDoc();
        String string = (String)this.tableData[n2][n];
        String string2 = null;
        boolean bl = false;
        try {
            switch (n) {
                case 5: {
                    if (this.doc.pluginmap.containsKey("SiteModel.s:" + string)) break;
                    String string3 = ((BEASTInterface)((Object)this.likelihoods[n2].siteModelInput.get())).getID();
                    string2 = BeautiDoc.parsePartition(string3);
                    this.doc.renamePartition(0, string2, string);
                    bl = true;
                    break;
                }
                case 6: {
                    String string3 = this.likelihoods[n2].branchRateModelInput.get().getID();
                    String string4 = string3.substring(0, string3.indexOf(46)) + ".c:" + string;
                    if (!this.doc.pluginmap.containsKey(string4)) {
                        string2 = BeautiDoc.parsePartition(string3);
                        this.doc.renamePartition(1, string2, string);
                        bl = true;
                    }
                    break;
                }
                case 7: {
                    if (this.doc.pluginmap.containsKey("Tree.t:" + string)) break;
                    String string3 = this.likelihoods[n2].treeInput.get().getID();
                    string2 = BeautiDoc.parsePartition(string3);
                    this.doc.renamePartition(2, string2, string);
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Cannot rename item: " + exception.getMessage());
            this.tableData[n2][n] = string2;
            return;
        }
        if (bl) {
            this.doc.determinePartitions();
            this.initTableData();
            this.setUpComboBoxes();
            this.table.repaint();
            return;
        }
        int n3 = 3;
        switch (n) {
            case 5: {
                n3 = 0;
                break;
            }
            case 6: {
                n3 = 1;
                break;
            }
            case 7: {
                n3 = 2;
            }
        }
        int n4 = this.doc.getPartitionNr(string, n3);
        GenericTreeLikelihood genericTreeLikelihood = null;
        if (n4 >= 0) {
            genericTreeLikelihood = this.likelihoods[n4];
        }
        boolean bl2 = false;
        PartitionContext partitionContext = new PartitionContext(this.likelihoods[n2]);
        switch (n) {
            case 5: {
                Object object2;
                object = null;
                if (genericTreeLikelihood != null) {
                    object = genericTreeLikelihood.siteModelInput.get();
                } else {
                    object = (SiteModel)this.doc.pluginmap.get("SiteModel.s:" + string);
                    if (object != this.likelihoods[n2].siteModelInput.get()) {
                        object2 = this.getPartitionContext(n2);
                        try {
                            object = (SiteModelInterface.Base)BeautiDoc.deepCopyPlugin((BEASTInterface)((Object)this.likelihoods[n2].siteModelInput.get()), this.likelihoods[n2], (MCMC)this.doc.mcmc.get(), partitionContext, (PartitionContext)object2, this.doc, null);
                        }
                        catch (RuntimeException runtimeException) {
                            JOptionPane.showMessageDialog(this, "Could not clone site model: " + runtimeException.getMessage());
                            return;
                        }
                    }
                }
                object2 = this.likelihoods[n2].siteModelInput.get();
                if (object2 instanceof SiteModelInterface.Base && object instanceof SiteModelInterface.Base) {
                    if (!((SiteModelInterface.Base)object2).substModelInput.canSetValue(((SiteModelInterface.Base)object).substModelInput.get(), (SiteModelInterface.Base)object2)) {
                        throw new IllegalArgumentException("Cannot link site model: substitution models are incompatible");
                    }
                } else {
                    throw new IllegalArgumentException("Don't know how to link this site model");
                }
                bl2 = this.likelihoods[n2].siteModelInput.get() != object;
                this.likelihoods[n2].siteModelInput.setValue(object, this.likelihoods[n2]);
                string = ((BEASTInterface)((Object)this.likelihoods[n2].siteModelInput.get())).getID();
                string = BeautiDoc.parsePartition(string);
                this.getDoc().setCurrentPartition(0, n2, string);
                break;
            }
            case 6: {
                Object object2;
                object = null;
                if (genericTreeLikelihood != null) {
                    object = genericTreeLikelihood.branchRateModelInput.get();
                } else {
                    object = this.getDoc().getClockModel(string);
                    if (object != this.likelihoods[n2].branchRateModelInput.get()) {
                        object2 = this.getPartitionContext(n2);
                        try {
                            object = (BranchRateModel)((Object)BeautiDoc.deepCopyPlugin(this.likelihoods[n2].branchRateModelInput.get(), this.likelihoods[n2], (MCMC)this.doc.mcmc.get(), partitionContext, (PartitionContext)object2, this.doc, null));
                        }
                        catch (RuntimeException runtimeException) {
                            JOptionPane.showMessageDialog(this, "Could not clone clock model: " + runtimeException.getMessage());
                            return;
                        }
                    }
                }
                object2 = null;
                for (Input<?> object3 : ((BEASTInterface)object).listInputs()) {
                    if (!object3.getName().equals("tree")) continue;
                    object2 = (TreeInterface)object3.get();
                }
                if (object2 != null && object2 != this.likelihoods[n2].treeInput.get()) {
                    JOptionPane.showMessageDialog(this, "Cannot link clock model with different trees");
                    throw new IllegalArgumentException("Cannot link clock model with different trees");
                }
                bl2 = this.likelihoods[n2].branchRateModelInput.get() != object;
                this.likelihoods[n2].branchRateModelInput.setValue(object, this.likelihoods[n2]);
                string = this.likelihoods[n2].branchRateModelInput.get().getID();
                string = BeautiDoc.parsePartition(string);
                this.getDoc().setCurrentPartition(1, n2, string);
                break;
            }
            case 7: {
                ArrayList<TreeInterface> arrayList;
                Object object2;
                object = null;
                if (genericTreeLikelihood != null) {
                    object = genericTreeLikelihood.treeInput.get();
                } else {
                    object = (TreeInterface)((Object)this.doc.pluginmap.get("Tree.t:" + string));
                    if (object != this.likelihoods[n2].treeInput.get()) {
                        object2 = this.getPartitionContext(n2);
                        try {
                            object = (TreeInterface)((Object)BeautiDoc.deepCopyPlugin((BEASTInterface)((Object)this.likelihoods[n2].treeInput.get()), this.likelihoods[n2], (MCMC)this.doc.mcmc.get(), partitionContext, (PartitionContext)object2, this.doc, null));
                        }
                        catch (RuntimeException runtimeException) {
                            JOptionPane.showMessageDialog(this, "Could not clone tree model: " + runtimeException.getMessage());
                            return;
                        }
                        arrayList = ((MCMC)this.doc.mcmc.get()).startStateInput.get();
                        ArrayList arrayList2 = new ArrayList();
                        arrayList2.addAll(((State)((Object)arrayList)).stateNodeInput.get());
                        for (StateNode stateNode : arrayList2) {
                            if (!stateNode.getID().endsWith(".t:" + partitionContext.tree) || stateNode instanceof TreeInterface) continue;
                            try {
                                StateNode stateNode2 = (StateNode)BeautiDoc.deepCopyPlugin(stateNode, this.likelihoods[n2], (MCMC)this.doc.mcmc.get(), partitionContext, (PartitionContext)object2, this.doc, null);
                            }
                            catch (RuntimeException runtimeException) {
                                JOptionPane.showMessageDialog(this, "Could not clone tree model: " + runtimeException.getMessage());
                                return;
                            }
                        }
                    }
                }
                Taxon.assertSameTaxa(object.getID(), object.getTaxonset().getTaxaNames(), this.likelihoods[n2].dataInput.get().getID(), this.likelihoods[n2].dataInput.get().getTaxaNames());
                bl2 = this.likelihoods[n2].treeInput.get() != object;
                Log.warning.println("needsRePartition = " + bl2);
                if (bl2) {
                    object2 = this.likelihoods[n2].treeInput.get();
                    arrayList = new ArrayList<TreeInterface>();
                    for (GenericTreeLikelihood genericTreeLikelihood2 : this.likelihoods) {
                        if (genericTreeLikelihood2.treeInput.get() != object2) continue;
                        arrayList.add(genericTreeLikelihood2.treeInput.get());
                    }
                    if (arrayList.size() == 1) {
                        ((BEASTInterface)object2).setInputValue("estimate", false);
                        for (Object object3 : BEASTInterface.getOutputs(object2).toArray()) {
                            for (Input<?> input : ((BEASTInterface)object3).listInputs()) {
                                try {
                                    List list;
                                    if (input.get() == object2) {
                                        if (input.getRule() == Input.Validate.REQUIRED) continue;
                                        input.setValue(object, (BEASTInterface)object3);
                                        continue;
                                    }
                                    if (!(input.get() instanceof List) || !(list = (List)input.get()).contains(object2)) continue;
                                    list.remove(object2);
                                    if (list.contains(object)) continue;
                                    list.add(object);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                    }
                }
                this.likelihoods[n2].treeInput.setValue(object, this.likelihoods[n2]);
                string = this.likelihoods[n2].treeInput.get().getID();
                string = BeautiDoc.parsePartition(string);
                this.getDoc().setCurrentPartition(2, n2, string);
            }
        }
        this.tableData[n2][n] = string;
        if (bl2) {
            int n5;
            object = new ArrayList<BeautiSubTemplate>();
            object.add(this.doc.beautiConfig.partitionTemplate.get());
            object.addAll(this.doc.beautiConfig.subTemplates);
            this.doc.setUpActivePlugins();
            do {
                n5 = this.doc.posteriorPredecessors.size();
                this.doc.applyBeautiRules((List<BeautiSubTemplate>)object, false, partitionContext);
                this.doc.setUpActivePlugins();
            } while (n5 != this.doc.posteriorPredecessors.size());
            this.doc.determinePartitions();
        }
        if (genericTreeLikelihood == null) {
            this.initTableData();
            this.setUpComboBoxes();
        }
        this.updateStatus();
    }

    private PartitionContext getPartitionContext(int n) {
        PartitionContext partitionContext = new PartitionContext(this.tableData[n][0].toString(), this.tableData[n][5].toString(), this.tableData[n][6].toString(), this.tableData[n][7].toString());
        return partitionContext;
    }

    @Override
    protected void addInputLabel() {
    }

    void initTableData() {
        this.likelihoods = new GenericTreeLikelihood[this.partitionCount];
        if (this.tableData == null) {
            this.tableData = new Object[this.partitionCount][9];
        }
        CompoundDistribution compoundDistribution = (CompoundDistribution)this.doc.pluginmap.get("likelihood");
        for (int i = 0; i < this.partitionCount; ++i) {
            Alignment alignment = this.alignments.get(i);
            this.tableData[i][0] = alignment;
            this.tableData[i][1] = alignment instanceof FilteredAlignment ? ((FilteredAlignment)alignment).alignmentInput.get() : alignment;
            this.tableData[i][2] = alignment.getTaxonCount();
            this.tableData[i][3] = alignment.getSiteCount();
            this.tableData[i][4] = alignment.getDataType();
            GenericTreeLikelihood genericTreeLikelihood = (GenericTreeLikelihood)compoundDistribution.pDistributions.get().get(i);
            assert (genericTreeLikelihood != null);
            this.likelihoods[i] = genericTreeLikelihood;
            this.tableData[i][5] = this.getPartition(genericTreeLikelihood.siteModelInput);
            this.tableData[i][6] = this.getPartition(genericTreeLikelihood.branchRateModelInput);
            this.tableData[i][7] = this.getPartition(genericTreeLikelihood.treeInput);
            this.tableData[i][8] = null;
            try {
                if (!this.hasUseAmbiguitiesInput(i)) continue;
                this.tableData[i][8] = genericTreeLikelihood.getInputValue("useAmbiguities");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean hasUseAmbiguitiesInput(int n) {
        try {
            for (Input<?> input : this.likelihoods[n].listInputs()) {
                if (!input.getName().equals("useAmbiguities")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private String getPartition(Input<?> input) {
        BEASTInterface bEASTInterface = (BEASTInterface)input.get();
        String string = bEASTInterface.getID();
        String string2 = BeautiDoc.parsePartition(string);
        return string2;
    }

    protected Component createListBox() {
        Object[] objectArray = new String[]{"Name", "File", "Taxa", "Sites", "Data Type", "Site Model", "Clock Model", "Tree", "Ambiguities"};
        this.initTableData();
        this.table = new JTable(this.tableData, objectArray){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (this.isCellSelected(n, n2)) {
                    component.setBackground(Color.gray);
                } else if (n % 2 == 0 && !this.isCellSelected(n, n2)) {
                    component.setBackground(new Color(237, 243, 255));
                } else {
                    component.setBackground(Color.white);
                }
                JComponent jComponent = (JComponent)component;
                switch (n2) {
                    case 0: 
                    case 5: 
                    case 6: 
                    case 7: {
                        jComponent.setToolTipText("Set " + AlignmentListInputEditor.this.table.getColumnName(n2).toLowerCase() + " for this partition");
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        jComponent.setToolTipText("Report " + AlignmentListInputEditor.this.table.getColumnName(n2).toLowerCase() + " for this partition");
                        break;
                    }
                    case 8: {
                        jComponent.setToolTipText("<html>Flag whether to use ambiguities.<br>If not set, the treelikelihood will treat ambiguities in the<br>data as unknowns<br>If set, the treelikelihood will use ambiguities as equally<br>likely values for the tips.<br>This will make the computation twice as slow.</html>");
                        break;
                    }
                    default: {
                        jComponent.setToolTipText(null);
                    }
                }
                AlignmentListInputEditor.this.updateStatus();
                return component;
            }
        };
        int n = this.table.getFont().getSize();
        this.table.setRowHeight(25 * n / 13);
        this.table.setSelectionMode(2);
        this.table.setColumnSelectionAllowed(false);
        this.table.setRowSelectionAllowed(true);
        this.table.setName("alignmenttable");
        this.setUpComboBoxes();
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        this.nameEditor = new JTextField();
        this.nameEditor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AlignmentListInputEditor.this.processPartitionName();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AlignmentListInputEditor.this.processPartitionName();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AlignmentListInputEditor.this.processPartitionName();
            }
        });
        tableColumn.setCellEditor(new DefaultCellEditor(this.nameEditor));
        this.table.setDefaultEditor(Object.class, new TableCellEditor(){
            JTextField m_textField = new JTextField();
            int m_iRow;
            int m_iCol;

            @Override
            public boolean stopCellEditing() {
                AlignmentListInputEditor.this.table.removeEditor();
                String string = this.m_textField.getText();
                try {
                    Double.parseDouble(string);
                }
                catch (Exception exception) {
                    return false;
                }
                AlignmentListInputEditor.this.tableData[this.m_iRow][this.m_iCol] = string;
                return true;
            }

            @Override
            public boolean isCellEditable(EventObject eventObject) {
                return AlignmentListInputEditor.this.table.getSelectedColumn() == 0;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                return null;
            }

            @Override
            public boolean shouldSelectCell(EventObject eventObject) {
                return false;
            }

            @Override
            public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            }

            @Override
            public Object getCellEditorValue() {
                return null;
            }

            @Override
            public void cancelCellEditing() {
            }

            @Override
            public void addCellEditorListener(CellEditorListener cellEditorListener) {
            }
        });
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    try {
                        int n = AlignmentListInputEditor.this.table.rowAtPoint(mouseEvent.getPoint());
                        Alignment alignment = AlignmentListInputEditor.this.alignments.get(n);
                        int n2 = 0;
                        BeautiAlignmentProvider beautiAlignmentProvider = null;
                        for (BeautiAlignmentProvider beautiAlignmentProvider2 : ((AlignmentListInputEditor)AlignmentListInputEditor.this).doc.beautiConfig.alignmentProvider) {
                            int n3 = beautiAlignmentProvider2.matches(alignment);
                            if (n3 <= n2) continue;
                            n2 = n3;
                            beautiAlignmentProvider = beautiAlignmentProvider2;
                        }
                        beautiAlignmentProvider.editAlignment(alignment, AlignmentListInputEditor.this.doc);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    AlignmentListInputEditor.this.updateStatus();
                } else if (mouseEvent.getButton() == 3) {
                    int n = AlignmentListInputEditor.this.table.rowAtPoint(mouseEvent.getPoint());
                    Alignment alignment = AlignmentListInputEditor.this.alignments.get(n);
                    int n4 = JOptionPane.showConfirmDialog(null, "Do you want to replace alignment " + alignment.getID());
                    if (n4 == 0) {
                        AlignmentListInputEditor.this.replaceItem(alignment);
                    }
                }
            }
        });
        this.scrollPane = new JScrollPane(this.table);
        int n2 = 3;
        Dimension dimension = this.table.getPreferredSize();
        this.scrollPane.setPreferredSize(new Dimension(dimension.width, this.table.getRowHeight() * n2 + this.table.getTableHeader().getHeight()));
        return this.scrollPane;
    }

    void setUpComboBoxes() {
        int n;
        int n2;
        HashSet[] hashSetArray = new HashSet[3];
        for (n2 = 0; n2 < 3; ++n2) {
            hashSetArray[n2] = new HashSet();
        }
        for (n2 = 0; n2 < this.partitionCount; ++n2) {
            hashSetArray[0].add(((BEASTInterface)((Object)this.likelihoods[n2].siteModelInput.get())).getID());
            hashSetArray[1].add(this.likelihoods[n2].branchRateModelInput.get().getID());
            hashSetArray[2].add(this.likelihoods[n2].treeInput.get().getID());
        }
        String[][] stringArrayArray = new String[3][];
        for (n = 0; n < 3; ++n) {
            stringArrayArray[n] = hashSetArray[n].toArray(new String[0]);
        }
        for (n = 0; n < 3; ++n) {
            for (int i = 0; i < stringArrayArray[n].length; ++i) {
                stringArrayArray[n][i] = BeautiDoc.parsePartition(stringArrayArray[n][i]);
            }
        }
        TableColumn tableColumn = this.table.getColumnModel().getColumn(5);
        JComboBox<String> jComboBox = new JComboBox<String>(stringArrayArray[0]);
        jComboBox.setEditable(true);
        jComboBox.addActionListener(new ComboActionListener(5));
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        tableColumn.setCellRenderer(new MyComboBoxRenderer(stringArrayArray[0]));
        tableColumn = this.table.getColumnModel().getColumn(6);
        JComboBox<String> jComboBox2 = new JComboBox<String>(stringArrayArray[1]);
        jComboBox2.setEditable(true);
        jComboBox2.addActionListener(new ComboActionListener(6));
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox2));
        tableColumn.setCellRenderer(new MyComboBoxRenderer(stringArrayArray[1]));
        tableColumn = this.table.getColumnModel().getColumn(7);
        JComboBox<String> jComboBox3 = new JComboBox<String>(stringArrayArray[2]);
        jComboBox3.setEditable(true);
        jComboBox3.addActionListener(new ComboActionListener(7));
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox3));
        tableColumn.setCellRenderer(new MyComboBoxRenderer(stringArrayArray[2]));
        tableColumn = this.table.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(30);
        tableColumn = this.table.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(30);
        tableColumn = this.table.getColumnModel().getColumn(8);
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.addActionListener(actionEvent -> {
            if (this.table.getSelectedRow() >= 0 && this.table.getSelectedColumn() >= 0) {
                Log.warning.println(" " + this.table.getValueAt(this.table.getSelectedRow(), this.table.getSelectedColumn()));
            }
            try {
                int n = this.table.getSelectedRow();
                if (this.hasUseAmbiguitiesInput(n)) {
                    this.likelihoods[n].setInputValue("useAmbiguities", jCheckBox.isSelected());
                    this.tableData[n][8] = jCheckBox.isSelected();
                } else if (jCheckBox.isSelected()) {
                    jCheckBox.setSelected(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        tableColumn.setCellEditor(new DefaultCellEditor(jCheckBox));
        tableColumn.setCellRenderer(new MyCheckBoxRenderer());
        tableColumn.setPreferredWidth(20);
        tableColumn.setMaxWidth(20);
    }

    void processPartitionName() {
        Log.warning.println("processPartitionName");
        Log.warning.println(this.table.getSelectedColumn() + " " + this.table.getSelectedRow());
        String string = this.tableData[this.table.getSelectedRow()][this.table.getSelectedColumn()].toString();
        String string2 = this.nameEditor.getText();
        if (!string.equals(string2) && string2.indexOf(".") >= 0) {
            string2 = string2.replaceAll("\\.", "");
            this.table.setValueAt(string2, this.table.getSelectedRow(), this.table.getSelectedColumn());
            this.table.repaint();
        }
        if (!string.equals(string2)) {
            try {
                int n = -2;
                switch (this.table.getSelectedColumn()) {
                    case 0: {
                        n = 3;
                        break;
                    }
                    case 5: {
                        n = 0;
                        break;
                    }
                    case 6: {
                        n = 1;
                        break;
                    }
                    case 7: {
                        n = 2;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Cannot rename item in column");
                    }
                }
                this.getDoc().renamePartition(n, string, string2);
                this.table.setValueAt(string2, this.table.getSelectedRow(), this.table.getSelectedColumn());
                this.setUpComboBoxes();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Renaming failed: " + exception.getMessage());
            }
        }
    }

    @Override
    protected void addSingleItem(BEASTInterface bEASTInterface) {
        this.initTableData();
        this.repaint();
    }

    @Override
    protected void addItem() {
        this.addItem(null);
    }

    private void addItem(File[] fileArray) {
        List<BEASTInterface> list = this.doc.beautiConfig.selectAlignments(this.doc, this, fileArray);
        if (list != null) {
            this.refreshPanel();
        }
    }

    void delItem() {
        int[] nArray = this.getTableRowSelection();
        if (nArray.length == 0) {
            JOptionPane.showMessageDialog(this, "Select partitions to delete, before hitting the delete button");
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            BranchRateModel.Base base = this.likelihoods[n].branchRateModelInput.get();
            SiteModelInterface siteModelInterface = this.likelihoods[n].siteModelInput.get();
            TreeInterface treeInterface = this.likelihoods[n].treeInput.get();
            ArrayList<GenericTreeLikelihood> arrayList = new ArrayList<GenericTreeLikelihood>();
            ArrayList<GenericTreeLikelihood> arrayList2 = new ArrayList<GenericTreeLikelihood>();
            ArrayList<GenericTreeLikelihood> arrayList3 = new ArrayList<GenericTreeLikelihood>();
            for (GenericTreeLikelihood genericTreeLikelihood : this.likelihoods) {
                if (genericTreeLikelihood == this.likelihoods[n]) continue;
                if (genericTreeLikelihood.branchRateModelInput.get() == base) {
                    arrayList.add(genericTreeLikelihood);
                }
                if (genericTreeLikelihood.siteModelInput.get() == siteModelInterface) {
                    arrayList2.add(genericTreeLikelihood);
                }
                if (genericTreeLikelihood.treeInput.get() != treeInterface) continue;
                arrayList3.add(genericTreeLikelihood);
            }
            try {
                if (arrayList.size() > 0) {
                    if (this.doc.getPartitionNr(base) != n) {
                        this.tableData[n][6] = this.getDoc().partitionNames.get((int)n).partition;
                    } else {
                        int n2 = this.doc.getPartitionNr((BEASTInterface)arrayList.get(0));
                        this.tableData[n][6] = this.getDoc().partitionNames.get((int)n2).partition;
                    }
                    this.updateModel(6, n);
                }
                if (arrayList2.size() > 0) {
                    if (this.doc.getPartitionNr((BEASTInterface)((Object)siteModelInterface)) != n) {
                        this.tableData[n][5] = this.getDoc().partitionNames.get((int)n).partition;
                    } else {
                        int n3 = this.doc.getPartitionNr((BEASTInterface)arrayList2.get(0));
                        this.tableData[n][5] = this.getDoc().partitionNames.get((int)n3).partition;
                    }
                    this.updateModel(5, n);
                }
                if (arrayList3.size() > 0) {
                    if (this.doc.getPartitionNr((BEASTInterface)((Object)treeInterface)) != n) {
                        this.tableData[n][7] = this.getDoc().partitionNames.get((int)n).partition;
                    } else {
                        int n4 = this.doc.getPartitionNr((BEASTInterface)arrayList3.get(0));
                        this.tableData[n][7] = this.getDoc().partitionNames.get((int)n4).partition;
                    }
                    this.updateModel(7, n);
                }
                this.getDoc().delAlignmentWithSubnet(this.alignments.get(n));
                this.alignments.remove(n);
                GenericTreeLikelihood[] genericTreeLikelihoodArray = new GenericTreeLikelihood[this.likelihoods.length - 1];
                int n5 = 0;
                for (int j = 0; j < this.likelihoods.length; ++j) {
                    if (j == n) continue;
                    genericTreeLikelihoodArray[n5] = this.likelihoods[j];
                    ++n5;
                }
                this.likelihoods = genericTreeLikelihoodArray;
                --this.partitionCount;
                continue;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(null, "Deletion failed: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
        MRCAPriorInputEditor.customConnector(this.doc);
        this.refreshPanel();
    }

    void replaceItem() {
        int[] nArray = this.getTableRowSelection();
        if (nArray.length != 1) {
            return;
        }
        Alignment alignment = this.alignments.get(nArray[0]);
        this.replaceItem(alignment);
    }

    private void replaceItem(Alignment alignment) {
        BeautiAlignmentProvider beautiAlignmentProvider = new BeautiAlignmentProvider();
        List<BEASTInterface> list = beautiAlignmentProvider.getAlignments(this.doc);
        ArrayList<Alignment> arrayList = new ArrayList<Alignment>();
        for (BEASTInterface object2 : list) {
            if (!(object2 instanceof Alignment)) continue;
            arrayList.add((Alignment)object2);
        }
        Object object3 = null;
        if (arrayList.size() > 1) {
            JComboBox<Alignment> jComboBox = new JComboBox<Alignment>(arrayList.toArray(new Alignment[0]));
            JOptionPane.showMessageDialog(null, jComboBox, "Select a replacement alignment", 3);
            object3 = (Alignment)jComboBox.getSelectedItem();
        } else if (arrayList.size() == 1) {
            object3 = (Alignment)arrayList.get(0);
        }
        if (object3 != null) {
            if (!((Alignment)object3).getDataType().getClass().getName().equals(alignment.getDataType().getClass().getName())) {
                JOptionPane.showMessageDialog(null, "Data types do not match, so alignment cannot be replaced: " + ((BEASTObject)object3).getID() + " " + ((Alignment)object3).getDataType().getClass().getName() + " != " + alignment.getID() + " " + alignment.getDataType().getClass().getName());
                return;
            }
            LinkedHashSet<BEASTInterface> linkedHashSet = new LinkedHashSet<BEASTInterface>();
            linkedHashSet.addAll(alignment.getOutputs());
            for (BEASTInterface bEASTInterface : linkedHashSet) {
                for (Input<?> input : bEASTInterface.listInputs()) {
                    List list2;
                    int n;
                    if (input.get() == alignment) {
                        input.setValue(object3, bEASTInterface);
                        ((BEASTObject)object3).getOutputs().add(bEASTInterface);
                        continue;
                    }
                    if (!(input.get() instanceof List) || (n = (list2 = (List)input.get()).indexOf(alignment)) < 0) continue;
                    list2.set(n, object3);
                    ((BEASTObject)object3).getOutputs().add(bEASTInterface);
                }
            }
            int n = this.doc.alignments.indexOf(alignment);
            this.doc.alignments.set(n, (Alignment)object3);
            this.refreshPanel();
        }
    }

    void splitItem() {
        int[] nArray = this.getTableRowSelection();
        if (nArray.length == 0) {
            JOptionPane.showMessageDialog(this, "Select partitions to split, before hitting the split button");
            return;
        }
        Object[] objectArray = new String[]{"{1,2} + 3", "{1,2} + 3 frame 2", "{1,2} + 3 frame 3", "1 + 2 + 3", "1 + 2 + 3 frame 2", "1 + 2 + 3 frame 3"};
        String string = (String)JOptionPane.showInputDialog(null, "Split selected alignments into partitions", "Option", 2, null, objectArray, "1 + 2 + 3");
        if (string == null) {
            return;
        }
        String[] stringArray = null;
        String[] stringArray2 = null;
        if (string.equals(objectArray[0])) {
            stringArray = new String[]{"1::3,2::3", "3::3"};
            stringArray2 = new String[]{"_1,2", "_3"};
        } else if (string.equals(objectArray[1])) {
            stringArray = new String[]{"1::3,3::3", "2::3"};
            stringArray2 = new String[]{"_1,2", "_3"};
        } else if (string.equals(objectArray[2])) {
            stringArray = new String[]{"2::3,3::3", "1::3"};
            stringArray2 = new String[]{"_1,2", "_3"};
        } else if (string.equals(objectArray[3])) {
            stringArray = new String[]{"1::3", "2::3", "3::3"};
            stringArray2 = new String[]{"_1", "_2", "_3"};
        } else if (string.equals(objectArray[4])) {
            stringArray = new String[]{"2::3", "3::3", "1::3"};
            stringArray2 = new String[]{"_1", "_2", "_3"};
        } else if (string.equals(objectArray[5])) {
            stringArray = new String[]{"3::3", "1::3", "2::3"};
            stringArray2 = new String[]{"_1", "_2", "_3"};
        } else {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            Alignment alignment = this.alignments.remove(n);
            this.getDoc().delAlignmentWithSubnet(alignment);
            try {
                ArrayList<FilteredAlignment> arrayList = new ArrayList<FilteredAlignment>();
                for (int j = 0; j < stringArray.length; ++j) {
                    FilteredAlignment filteredAlignment = new FilteredAlignment();
                    filteredAlignment.initByName("data", alignment, "filter", stringArray[j], "dataType", alignment.dataTypeInput.get());
                    filteredAlignment.setID(alignment.getID() + stringArray2[j]);
                    this.getDoc().addAlignmentWithSubnet(filteredAlignment, this.getDoc().beautiConfig.partitionTemplate.get());
                    arrayList.add(filteredAlignment);
                }
                this.alignments.addAll(arrayList);
                this.partitionCount = this.alignments.size();
                this.tableData = null;
                this.initTableData();
                if (arrayList.size() == 2) {
                    this.link(7, this.alignments.size() - 1, this.alignments.size() - 2);
                    continue;
                }
                this.link(7, this.alignments.size() - 2, this.alignments.size() - 3);
                this.tableData = null;
                this.initTableData();
                this.link(7, this.alignments.size() - 1, this.alignments.size() - 2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.refreshPanel();
    }

    void updateStatus() {
        boolean bl;
        boolean bl2 = bl = this.alignments.size() > 1;
        if (this.alignments.size() >= 2 && this.getTableRowSelection().length == 0) {
            bl = false;
        }
        for (JButton jButton : this.linkButtons) {
            jButton.setEnabled(bl);
        }
        for (JButton jButton : this.unlinkButtons) {
            jButton.setEnabled(bl);
        }
        bl = this.getTableRowSelection().length > 0;
        this.splitButton.setEnabled(bl);
        this.delButton.setEnabled(bl);
        this.replaceButton.setEnabled(this.getTableRowSelection().length == 1);
    }

    public class MyCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public MyCheckBoxRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (AlignmentListInputEditor.this.hasUseAmbiguitiesInput(n)) {
                if (bl) {
                    super.setBackground(jTable.getSelectionBackground());
                } else {
                    this.setForeground(jTable.getForeground());
                    this.setBackground(jTable.getBackground());
                }
                this.setEnabled(true);
                this.setSelected((Boolean)object);
            } else {
                this.setEnabled(false);
            }
            return this;
        }
    }

    public class MyComboBoxRenderer
    extends JComboBox<String>
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public MyComboBoxRenderer(String[] stringArray) {
            super(stringArray);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                super.setBackground(jTable.getSelectionBackground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelectedItem(object);
            return this;
        }
    }

    class ComboActionListener
    implements ActionListener {
        int m_nColumn;

        public ComboActionListener(int n) {
            this.m_nColumn = n;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Log.warning.println("actionPerformed ");
            Log.warning.println(AlignmentListInputEditor.this.table.getSelectedRow() + " " + AlignmentListInputEditor.this.table.getSelectedColumn());
            if (AlignmentListInputEditor.this.table.getSelectedRow() >= 0 && AlignmentListInputEditor.this.table.getSelectedColumn() >= 0) {
                Log.warning.println(" " + AlignmentListInputEditor.this.table.getValueAt(AlignmentListInputEditor.this.table.getSelectedRow(), AlignmentListInputEditor.this.table.getSelectedColumn()));
            }
            for (int i = 0; i < AlignmentListInputEditor.this.partitionCount; ++i) {
                try {
                    AlignmentListInputEditor.this.updateModel(this.m_nColumn, i);
                    continue;
                }
                catch (Exception exception) {
                    Log.warning.println(exception.getMessage());
                }
            }
        }
    }
}

