/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.List;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.api.Indentable;
import com.itextpdf.text.api.Spaceable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paragraph
extends Phrase
implements Indentable,
Spaceable {
    private static final long serialVersionUID = 7852314969733375514L;
    protected int alignment = -1;
    protected float multipliedLeading = 0.0f;
    protected float indentationLeft;
    protected float indentationRight;
    private float firstLineIndent = 0.0f;
    protected float spacingBefore;
    protected float spacingAfter;
    private float extraParagraphSpace = 0.0f;
    protected boolean keeptogether = false;

    public Paragraph() {
    }

    public Paragraph(float leading) {
        super(leading);
    }

    public Paragraph(Chunk chunk) {
        super(chunk);
    }

    public Paragraph(float leading, Chunk chunk) {
        super(leading, chunk);
    }

    public Paragraph(String string) {
        super(string);
    }

    public Paragraph(String string, Font font) {
        super(string, font);
    }

    public Paragraph(float leading, String string) {
        super(leading, string);
    }

    public Paragraph(float leading, String string, Font font) {
        super(leading, string, font);
    }

    public Paragraph(Phrase phrase) {
        super(phrase);
        if (phrase instanceof Paragraph) {
            Paragraph p = (Paragraph)phrase;
            this.setAlignment(p.alignment);
            this.setLeading(phrase.getLeading(), p.multipliedLeading);
            this.setIndentationLeft(p.getIndentationLeft());
            this.setIndentationRight(p.getIndentationRight());
            this.setFirstLineIndent(p.getFirstLineIndent());
            this.setSpacingAfter(p.getSpacingAfter());
            this.setSpacingBefore(p.getSpacingBefore());
            this.setExtraParagraphSpace(p.getExtraParagraphSpace());
        }
    }

    public Paragraph cloneShallow(boolean spacingBefore) {
        Paragraph copy = new Paragraph();
        copy.setFont(this.getFont());
        copy.setAlignment(this.getAlignment());
        copy.setLeading(this.getLeading(), this.multipliedLeading);
        copy.setIndentationLeft(this.getIndentationLeft());
        copy.setIndentationRight(this.getIndentationRight());
        copy.setFirstLineIndent(this.getFirstLineIndent());
        copy.setSpacingAfter(this.getSpacingAfter());
        if (spacingBefore) {
            copy.setSpacingBefore(this.getSpacingBefore());
        }
        copy.setExtraParagraphSpace(this.getExtraParagraphSpace());
        return copy;
    }

    public java.util.List<Element> breakUp() {
        ArrayList<Element> list = new ArrayList<Element>();
        Paragraph tmp = this.cloneShallow(true);
        for (Element e : this) {
            if (e.type() == 14 || e.type() == 23 || e.type() == 12) {
                if (tmp.size() > 0) {
                    tmp.setSpacingAfter(0.0f);
                    list.add(tmp);
                    tmp = this.cloneShallow(false);
                }
                list.add(e);
                continue;
            }
            tmp.add(e);
        }
        if (tmp.size() > 0) {
            list.add(tmp);
        }
        return list;
    }

    @Override
    public int type() {
        return 12;
    }

    @Override
    public boolean add(Element o) {
        if (o instanceof List) {
            List list = (List)o;
            list.setIndentationLeft(list.getIndentationLeft() + this.indentationLeft);
            list.setIndentationRight(this.indentationRight);
            return super.add(list);
        }
        if (o instanceof Image) {
            super.addSpecial(o);
            return true;
        }
        if (o instanceof Paragraph) {
            super.addSpecial(o);
            return true;
        }
        return super.add(o);
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    @Override
    public void setLeading(float fixedLeading) {
        this.leading = fixedLeading;
        this.multipliedLeading = 0.0f;
    }

    public void setMultipliedLeading(float multipliedLeading) {
        this.leading = 0.0f;
        this.multipliedLeading = multipliedLeading;
    }

    public void setLeading(float fixedLeading, float multipliedLeading) {
        this.leading = fixedLeading;
        this.multipliedLeading = multipliedLeading;
    }

    @Override
    public void setIndentationLeft(float indentation) {
        this.indentationLeft = indentation;
    }

    @Override
    public void setIndentationRight(float indentation) {
        this.indentationRight = indentation;
    }

    public void setFirstLineIndent(float firstLineIndent) {
        this.firstLineIndent = firstLineIndent;
    }

    @Override
    public void setSpacingBefore(float spacing) {
        this.spacingBefore = spacing;
    }

    @Override
    public void setSpacingAfter(float spacing) {
        this.spacingAfter = spacing;
    }

    public void setKeepTogether(boolean keeptogether) {
        this.keeptogether = keeptogether;
    }

    public boolean getKeepTogether() {
        return this.keeptogether;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public float getMultipliedLeading() {
        return this.multipliedLeading;
    }

    public float getTotalLeading() {
        float m;
        float f = m = this.font == null ? 12.0f * this.multipliedLeading : this.font.getCalculatedLeading(this.multipliedLeading);
        if (m > 0.0f && !this.hasLeading()) {
            return m;
        }
        return this.getLeading() + m;
    }

    @Override
    public float getIndentationLeft() {
        return this.indentationLeft;
    }

    @Override
    public float getIndentationRight() {
        return this.indentationRight;
    }

    public float getFirstLineIndent() {
        return this.firstLineIndent;
    }

    @Override
    public float getSpacingBefore() {
        return this.spacingBefore;
    }

    @Override
    public float getSpacingAfter() {
        return this.spacingAfter;
    }

    public float getExtraParagraphSpace() {
        return this.extraParagraphSpace;
    }

    public void setExtraParagraphSpace(float extraParagraphSpace) {
        this.extraParagraphSpace = extraParagraphSpace;
    }

    @Deprecated
    public float spacingBefore() {
        return this.getSpacingBefore();
    }

    @Deprecated
    public float spacingAfter() {
        return this.spacingAfter;
    }
}

