/* === This file is part of Calamares - <http://github.com/calamares> ===
 *
 *   Copyright 2014, Teo Mrnjavac <teo@kde.org> (original dummypython code)
 *   Copyright 2016, Kevin Kofler <kevin.kofler@chello.at>
 *
 *   Calamares is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Calamares is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Calamares. If not, see <http://www.gnu.org/licenses/>.
 */

#include <QProcess>

#include "pacstrap-gui.h"


/* PacstrapGuiJob private class constants */

const QString PacstrapGuiJob::GET_XKBMAP_CMD        = "grep 'XKBMAP=' ~/.codecheck 2> /dev/null | cut -d '=' -f 2" ;
const QString PacstrapGuiJob::SET_EDITOR_FMT        = "echo 'export EDITOR=nano'         >> %1/etc/skel/.bashrc" ;
const QString PacstrapGuiJob::SET_LANG_FMT          = "echo 'export LANG=%1'             >> %2/etc/skel/.bashrc" ;
const QString PacstrapGuiJob::SET_XKBMAP_FMT        = "echo 'setxkbmap %1'               >> %2/etc/skel/.bashrc" ;
const QString PacstrapGuiJob::DM_DESKTOP_FMT        = "sed -i 's|^Session=.*|Session=%1|'   %2/etc/skel/.dmrc" ;
const QString PacstrapGuiJob::DM_LANG_FMT           = "sed -i 's|^Language=.*|Language=%1|' %2/etc/skel/.dmrc" ;
const QString PacstrapGuiJob::WELCOME_TITLE_FMT     = "sed -i 's|_EDITION_TITLE_|Parabola GNU/Linux-libre News|' %1/usr/bin/autostart.sh" ;
const QString PacstrapGuiJob::WELCOME_TEXT_FMT      = "sed 's|_DEFAULT_DESKTOP_|%1|' /usr/share/calamares/welcome > %2/usr/share/parabola-laf/news/news-0" ;
const QString PacstrapGuiJob::OCTOPI_FMT            = "rm -f %1/etc/xdg/autostart/octopi-notifier.desktop" ; // FIXME: issue #1850
const QString PacstrapGuiJob::GRUB_THEME_FMT        = "sed -i 's|^#GRUB_THEME=.*|GRUB_THEME=/boot/grub/themes/parabola-laf/theme.txt|' %1/etc/default/grub" ; // TODO:: delegate this to parabola-laf
const QString PacstrapGuiJob::GRUB_CONFIG_FMT       = "grub-mkconfig -o %1/boot/grub/grub.cfg" ; // TODO:: delegate this to parabola-laf
const QString PacstrapGuiJob::GRUB_THEME_ERROR_MSG  = "The grub theme command has failed." ; // TODO:: delegate this to parabola-laf
const QString PacstrapGuiJob::GRUB_CONFIG_ERROR_MSG = "The grub-mkconfig command has failed." ; // TODO:: delegate this to parabola-laf


/* PacstrapGuiJob public instance methods */

PacstrapGuiJob::PacstrapGuiJob(QObject* parent) : PacstrapCppJob(GUI_JOB_NAME   ,
                                                                 GUI_STATUS_MSG ,
                                                                 GUI_JOB_WEIGHT ,
                                                                 parent         ) {}


/* PacstrapGuiJob protected getters/setters */

QString PacstrapGuiJob::getPackageList()
{
  QString init_key    = this->globalStorage->value(GS::INITSYSTEM_KEY).toString() ;
  QString desktop_key = this->globalStorage->value(GS::DESKTOP_KEY   ).toString() ;
  QString locale      = this->globalStorage->value(GS::LOCALE_KEY    ).toMap()
                                            .value(GS::LANG_KEY      ).toString() ;

DEBUG_TRACE_DESKTOPPACKAGES

  return (this->localStorage.value (APPLICATIONS_PACKAGES_KEY).toStringList() +
          this->localStorage.value (MULTIMEDIA_PACKAGES_KEY  ).toStringList() +
          this->localStorage.value (NETWORK_PACKAGES_KEY     ).toStringList() +
          this->localStorage.value (LOOKANDFEEL_PACKAGES_KEY ).toStringList() +
          this->localStorage.value (UTILITIES_PACKAGES_KEY   ).toStringList() +
          this->localStorage.value (XSERVER_PACKAGES_KEY     ).toStringList() +
          this->localStorage.value (init_key                 ).toStringList() +
          this->localStorage.value (desktop_key              ).toStringList() +
          LANGUAGE_PACKS    .values(locale                   )                ).join(' ') ;
}


/* PacstrapGuiJob protected instance methods */

QString PacstrapGuiJob::chrootExecPreInstall() { return QString("") ; }

QString PacstrapGuiJob::chrootExecPostInstall()
{
  QString default_desktop   = this->globalStorage->value(GS::DESKTOP_KEY).toString() ;
  QString locale            = this->globalStorage->value(GS::LOCALE_KEY).toMap().value(GS::LANG_KEY).toString() ;
  QString xkbmap            = execOutput(GET_XKBMAP_CMD) ; if (xkbmap.isEmpty()) xkbmap = "us" ;
  QString set_editor_cmd    = SET_EDITOR_FMT   .arg(                  this->mountPoint) ;
  QString set_lang_cmd      = SET_LANG_FMT     .arg(locale          , this->mountPoint) ;
  QString set_xkbmap_cmd    = SET_XKBMAP_FMT   .arg(xkbmap          , this->mountPoint) ;
  QString dm_desktop_cmd    = DM_DESKTOP_FMT   .arg(default_desktop , this->mountPoint) ;
  QString dm_lang_cmd       = DM_LANG_FMT      .arg(locale          , this->mountPoint) ;
  QString welcome_title_cmd = WELCOME_TITLE_FMT.arg(                  this->mountPoint) ;
  QString welcome_text_cmd  = WELCOME_TEXT_FMT .arg(default_desktop , this->mountPoint) ;
  QString octopi_cmd        = OCTOPI_FMT       .arg(                  this->mountPoint) ;
  QString grub_config_cmd   = GRUB_CONFIG_FMT  .arg(this->mountPoint) ; // TODO:: delegate this to parabola-laf

  if (!!execStatus(grub_config_cmd)) return GRUB_CONFIG_ERROR_MSG ; // TODO:: delegate this to parabola-laf

  if (!!execStatus(set_editor_cmd          )) return "SET_EDITOR_FMT ERROR_MSG" ;
  if (!!execStatus(set_lang_cmd            )) return "SET_LANG_FMT ERROR_MSG" ;
  if (!!execStatus(set_xkbmap_cmd          )) return "SET_XKBMAP_FMT ERROR_MSG" ;
  if (!!execStatus(dm_desktop_cmd          )) return "DM_DESKTOP_FMT ERROR_MSG" ;
  if (!!execStatus(dm_lang_cmd             )) return "DM_LANG_FMT ERROR_MSG" ;
  if (!!execStatus(welcome_title_cmd       )) return "WELCOME_TITLE_FMT ERROR_MSG" ;
  if (!!execStatus(welcome_text_cmd        )) return "WELCOME_TEXT_FMT ERROR_MSG" ;
  if (default_desktop == LXDE_PACKAGES_KEY &&
      !!execStatus(octopi_cmd              )) return "OCTOPI_FMT ERROR_MSG" ;

  return QString("") ;
}


CALAMARES_PLUGIN_FACTORY_DEFINITION(PacstrapGuiJobFactory , registerPlugin<PacstrapGuiJob>() ;)
