/*

    This file was generated with glesw_gen.cmake, part of glXXw
    (hosted at https://github.com/paroj/glXXw-cmake)

    This is free and unencumbered software released into the public domain.

    Anyone is free to copy, modify, publish, use, compile, sell, or
    distribute this software, either in source code form or as a compiled
    binary, for any purpose, commercial or non-commercial, and by any
    means.

    In jurisdictions that recognize copyright laws, the author or authors
    of this software dedicate any and all copyright interest in the
    software to the public domain. We make this dedication for the benefit
    of the public at large and to the detriment of our heirs and
    successors. We intend this dedication to be an overt act of
    relinquishment in perpetuity of all present and future rights to this
    software under copyright law.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
    IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
    ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

*/

#include <GLES3/glesw.h>

#ifdef _WIN32
#define WIN32_LEAN_AND_MEAN 1
#include <windows.h>
#include <EGL/egl.h>

static HMODULE libgl;

static void open_libgl(void)
{
    libgl = LoadLibraryA("libGLESv2.dll");
}

static void close_libgl(void)
{
    FreeLibrary(libgl);
}

static GLESWglProc get_proc(const char *proc)
{
    GLESWglProc res;

    res = (GLESWglProc)eglGetProcAddress(proc);
    if (!res)
        res = (GLESWglProc)GetProcAddress(libgl, proc);
    return res;
}
#elif defined(__APPLE__) || defined(__APPLE_CC__)
#import <CoreFoundation/CoreFoundation.h>
#import <UIKit/UIDevice.h>

CFBundleRef bundle;
CFURLRef bundleURL;

static void open_libgl(void)
{
    bundle = CFBundleGetBundleWithIdentifier(CFSTR("com.apple.opengles")); // we are always linked to OpenGLES.framework statically, so it is already loaded and could be found by id
    assert(bundle != NULL);
    
    CFRetain(bundle);
    bundleURL = CFBundleCopyBundleURL(bundle);
}

static void close_libgl(void)
{
    CFRelease(bundle);
    CFRelease(bundleURL);
}

static GLESWglProc get_proc(const char *proc)
{
    GLESWglProc res;

    CFStringRef procname = CFStringCreateWithCString(kCFAllocatorDefault, proc,
                                                     kCFStringEncodingASCII);
    *(void **)(&res) = CFBundleGetFunctionPointerForName(bundle, procname);
    CFRelease(procname);
    return res;
}
#elif defined(__EMSCRIPTEN__)
#include <EGL/egl.h>
static void open_libgl() {}
static void close_libgl() {}
static GLESWglProc get_proc(const char *proc)
{
    return (GLESWglProc)eglGetProcAddress(proc);
}
#else
#include <dlfcn.h>

static void *libgl;

static void open_libgl(void)
{
    libgl = dlopen("libGLESv2.so", RTLD_LAZY | RTLD_GLOBAL);
}

static void close_libgl(void)
{
    dlclose(libgl);
}

static GLESWglProc get_proc(const char *proc)
{
    return dlsym(libgl, proc);
}
#endif

static struct {
	int major, minor;
} version;

static int parse_version(void)
{
    version.major = 2;
    version.minor = 0;

	if(glGetIntegerv)
	{
	    glGetIntegerv(GL_MAJOR_VERSION, &version.major);
	    glGetIntegerv(GL_MINOR_VERSION, &version.minor);
	}

	if(version.major < 2)
	    return -1;

	return 0;
}

static void load_procs(GLESWGetProcAddressProc proc);

int gleswInit(void)
{
	open_libgl();
	load_procs(get_proc);
	close_libgl();
	return parse_version();
}

int gleswInit2(GLESWGetProcAddressProc proc)
{
	load_procs(proc);
	return parse_version();
}

int gleswIsSupported(int major, int minor)
{
	if (major < 2)
		return 0;
	if (version.major == major)
		return version.minor >= minor;
	return version.major >= major;
}

GLESWglProc gleswGetProcAddress(const char *proc)
{
	return get_proc(proc);
}

PFNGLACTIVESHADERPROGRAMEXTPROC                         gleswActiveShaderProgramEXT;
PFNGLACTIVETEXTUREPROC                                  gleswActiveTexture;
PFNGLALPHAFUNCQCOMPROC                                  gleswAlphaFuncQCOM;
PFNGLAPPLYFRAMEBUFFERATTACHMENTCMAAINTELPROC            gleswApplyFramebufferAttachmentCMAAINTEL;
PFNGLATTACHSHADERPROC                                   gleswAttachShader;
PFNGLBEGINCONDITIONALRENDERNVPROC                       gleswBeginConditionalRenderNV;
PFNGLBEGINPERFMONITORAMDPROC                            gleswBeginPerfMonitorAMD;
PFNGLBEGINPERFQUERYINTELPROC                            gleswBeginPerfQueryINTEL;
PFNGLBEGINQUERYPROC                                     gleswBeginQuery;
PFNGLBEGINQUERYEXTPROC                                  gleswBeginQueryEXT;
PFNGLBEGINTRANSFORMFEEDBACKPROC                         gleswBeginTransformFeedback;
PFNGLBINDATTRIBLOCATIONPROC                             gleswBindAttribLocation;
PFNGLBINDBUFFERPROC                                     gleswBindBuffer;
PFNGLBINDBUFFERBASEPROC                                 gleswBindBufferBase;
PFNGLBINDBUFFERRANGEPROC                                gleswBindBufferRange;
PFNGLBINDFRAGDATALOCATIONEXTPROC                        gleswBindFragDataLocationEXT;
PFNGLBINDFRAGDATALOCATIONINDEXEDEXTPROC                 gleswBindFragDataLocationIndexedEXT;
PFNGLBINDFRAMEBUFFERPROC                                gleswBindFramebuffer;
PFNGLBINDPROGRAMPIPELINEEXTPROC                         gleswBindProgramPipelineEXT;
PFNGLBINDRENDERBUFFERPROC                               gleswBindRenderbuffer;
PFNGLBINDSAMPLERPROC                                    gleswBindSampler;
PFNGLBINDTEXTUREPROC                                    gleswBindTexture;
PFNGLBINDTRANSFORMFEEDBACKPROC                          gleswBindTransformFeedback;
PFNGLBINDVERTEXARRAYPROC                                gleswBindVertexArray;
PFNGLBINDVERTEXARRAYOESPROC                             gleswBindVertexArrayOES;
PFNGLBLENDBARRIERKHRPROC                                gleswBlendBarrierKHR;
PFNGLBLENDBARRIERNVPROC                                 gleswBlendBarrierNV;
PFNGLBLENDCOLORPROC                                     gleswBlendColor;
PFNGLBLENDEQUATIONPROC                                  gleswBlendEquation;
PFNGLBLENDEQUATIONSEPARATEPROC                          gleswBlendEquationSeparate;
PFNGLBLENDEQUATIONSEPARATEIEXTPROC                      gleswBlendEquationSeparateiEXT;
PFNGLBLENDEQUATIONSEPARATEIOESPROC                      gleswBlendEquationSeparateiOES;
PFNGLBLENDEQUATIONIEXTPROC                              gleswBlendEquationiEXT;
PFNGLBLENDEQUATIONIOESPROC                              gleswBlendEquationiOES;
PFNGLBLENDFUNCPROC                                      gleswBlendFunc;
PFNGLBLENDFUNCSEPARATEPROC                              gleswBlendFuncSeparate;
PFNGLBLENDFUNCSEPARATEIEXTPROC                          gleswBlendFuncSeparateiEXT;
PFNGLBLENDFUNCSEPARATEIOESPROC                          gleswBlendFuncSeparateiOES;
PFNGLBLENDFUNCIEXTPROC                                  gleswBlendFunciEXT;
PFNGLBLENDFUNCIOESPROC                                  gleswBlendFunciOES;
PFNGLBLENDPARAMETERINVPROC                              gleswBlendParameteriNV;
PFNGLBLITFRAMEBUFFERPROC                                gleswBlitFramebuffer;
PFNGLBLITFRAMEBUFFERANGLEPROC                           gleswBlitFramebufferANGLE;
PFNGLBLITFRAMEBUFFERNVPROC                              gleswBlitFramebufferNV;
PFNGLBUFFERDATAPROC                                     gleswBufferData;
PFNGLBUFFERSTORAGEEXTPROC                               gleswBufferStorageEXT;
PFNGLBUFFERSUBDATAPROC                                  gleswBufferSubData;
PFNGLCHECKFRAMEBUFFERSTATUSPROC                         gleswCheckFramebufferStatus;
PFNGLCLEARPROC                                          gleswClear;
PFNGLCLEARBUFFERFIPROC                                  gleswClearBufferfi;
PFNGLCLEARBUFFERFVPROC                                  gleswClearBufferfv;
PFNGLCLEARBUFFERIVPROC                                  gleswClearBufferiv;
PFNGLCLEARBUFFERUIVPROC                                 gleswClearBufferuiv;
PFNGLCLEARCOLORPROC                                     gleswClearColor;
PFNGLCLEARDEPTHFPROC                                    gleswClearDepthf;
PFNGLCLEARPIXELLOCALSTORAGEUIEXTPROC                    gleswClearPixelLocalStorageuiEXT;
PFNGLCLEARSTENCILPROC                                   gleswClearStencil;
PFNGLCLIENTWAITSYNCPROC                                 gleswClientWaitSync;
PFNGLCLIENTWAITSYNCAPPLEPROC                            gleswClientWaitSyncAPPLE;
PFNGLCOLORMASKPROC                                      gleswColorMask;
PFNGLCOLORMASKIEXTPROC                                  gleswColorMaskiEXT;
PFNGLCOLORMASKIOESPROC                                  gleswColorMaskiOES;
PFNGLCOMPILESHADERPROC                                  gleswCompileShader;
PFNGLCOMPRESSEDTEXIMAGE2DPROC                           gleswCompressedTexImage2D;
PFNGLCOMPRESSEDTEXIMAGE3DPROC                           gleswCompressedTexImage3D;
PFNGLCOMPRESSEDTEXIMAGE3DOESPROC                        gleswCompressedTexImage3DOES;
PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC                        gleswCompressedTexSubImage2D;
PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC                        gleswCompressedTexSubImage3D;
PFNGLCOMPRESSEDTEXSUBIMAGE3DOESPROC                     gleswCompressedTexSubImage3DOES;
PFNGLCOPYBUFFERSUBDATAPROC                              gleswCopyBufferSubData;
PFNGLCOPYBUFFERSUBDATANVPROC                            gleswCopyBufferSubDataNV;
PFNGLCOPYIMAGESUBDATAEXTPROC                            gleswCopyImageSubDataEXT;
PFNGLCOPYIMAGESUBDATAOESPROC                            gleswCopyImageSubDataOES;
PFNGLCOPYPATHNVPROC                                     gleswCopyPathNV;
PFNGLCOPYTEXIMAGE2DPROC                                 gleswCopyTexImage2D;
PFNGLCOPYTEXSUBIMAGE2DPROC                              gleswCopyTexSubImage2D;
PFNGLCOPYTEXSUBIMAGE3DPROC                              gleswCopyTexSubImage3D;
PFNGLCOPYTEXSUBIMAGE3DOESPROC                           gleswCopyTexSubImage3DOES;
PFNGLCOPYTEXTURELEVELSAPPLEPROC                         gleswCopyTextureLevelsAPPLE;
PFNGLCOVERFILLPATHINSTANCEDNVPROC                       gleswCoverFillPathInstancedNV;
PFNGLCOVERFILLPATHNVPROC                                gleswCoverFillPathNV;
PFNGLCOVERSTROKEPATHINSTANCEDNVPROC                     gleswCoverStrokePathInstancedNV;
PFNGLCOVERSTROKEPATHNVPROC                              gleswCoverStrokePathNV;
PFNGLCOVERAGEMASKNVPROC                                 gleswCoverageMaskNV;
PFNGLCOVERAGEMODULATIONNVPROC                           gleswCoverageModulationNV;
PFNGLCOVERAGEMODULATIONTABLENVPROC                      gleswCoverageModulationTableNV;
PFNGLCOVERAGEOPERATIONNVPROC                            gleswCoverageOperationNV;
PFNGLCREATEPERFQUERYINTELPROC                           gleswCreatePerfQueryINTEL;
PFNGLCREATEPROGRAMPROC                                  gleswCreateProgram;
PFNGLCREATESHADERPROC                                   gleswCreateShader;
PFNGLCREATESHADERPROGRAMVEXTPROC                        gleswCreateShaderProgramvEXT;
PFNGLCULLFACEPROC                                       gleswCullFace;
PFNGLDEBUGMESSAGECALLBACKKHRPROC                        gleswDebugMessageCallbackKHR;
PFNGLDEBUGMESSAGECONTROLKHRPROC                         gleswDebugMessageControlKHR;
PFNGLDEBUGMESSAGEINSERTKHRPROC                          gleswDebugMessageInsertKHR;
PFNGLDELETEBUFFERSPROC                                  gleswDeleteBuffers;
PFNGLDELETEFENCESNVPROC                                 gleswDeleteFencesNV;
PFNGLDELETEFRAMEBUFFERSPROC                             gleswDeleteFramebuffers;
PFNGLDELETEPATHSNVPROC                                  gleswDeletePathsNV;
PFNGLDELETEPERFMONITORSAMDPROC                          gleswDeletePerfMonitorsAMD;
PFNGLDELETEPERFQUERYINTELPROC                           gleswDeletePerfQueryINTEL;
PFNGLDELETEPROGRAMPROC                                  gleswDeleteProgram;
PFNGLDELETEPROGRAMPIPELINESEXTPROC                      gleswDeleteProgramPipelinesEXT;
PFNGLDELETEQUERIESPROC                                  gleswDeleteQueries;
PFNGLDELETEQUERIESEXTPROC                               gleswDeleteQueriesEXT;
PFNGLDELETERENDERBUFFERSPROC                            gleswDeleteRenderbuffers;
PFNGLDELETESAMPLERSPROC                                 gleswDeleteSamplers;
PFNGLDELETESHADERPROC                                   gleswDeleteShader;
PFNGLDELETESYNCPROC                                     gleswDeleteSync;
PFNGLDELETESYNCAPPLEPROC                                gleswDeleteSyncAPPLE;
PFNGLDELETETEXTURESPROC                                 gleswDeleteTextures;
PFNGLDELETETRANSFORMFEEDBACKSPROC                       gleswDeleteTransformFeedbacks;
PFNGLDELETEVERTEXARRAYSPROC                             gleswDeleteVertexArrays;
PFNGLDELETEVERTEXARRAYSOESPROC                          gleswDeleteVertexArraysOES;
PFNGLDEPTHFUNCPROC                                      gleswDepthFunc;
PFNGLDEPTHMASKPROC                                      gleswDepthMask;
PFNGLDEPTHRANGEARRAYFVNVPROC                            gleswDepthRangeArrayfvNV;
PFNGLDEPTHRANGEINDEXEDFNVPROC                           gleswDepthRangeIndexedfNV;
PFNGLDEPTHRANGEFPROC                                    gleswDepthRangef;
PFNGLDETACHSHADERPROC                                   gleswDetachShader;
PFNGLDISABLEPROC                                        gleswDisable;
PFNGLDISABLEDRIVERCONTROLQCOMPROC                       gleswDisableDriverControlQCOM;
PFNGLDISABLEVERTEXATTRIBARRAYPROC                       gleswDisableVertexAttribArray;
PFNGLDISABLEIEXTPROC                                    gleswDisableiEXT;
PFNGLDISABLEINVPROC                                     gleswDisableiNV;
PFNGLDISABLEIOESPROC                                    gleswDisableiOES;
PFNGLDISCARDFRAMEBUFFEREXTPROC                          gleswDiscardFramebufferEXT;
PFNGLDRAWARRAYSPROC                                     gleswDrawArrays;
PFNGLDRAWARRAYSINSTANCEDPROC                            gleswDrawArraysInstanced;
PFNGLDRAWARRAYSINSTANCEDANGLEPROC                       gleswDrawArraysInstancedANGLE;
PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEEXTPROC             gleswDrawArraysInstancedBaseInstanceEXT;
PFNGLDRAWARRAYSINSTANCEDEXTPROC                         gleswDrawArraysInstancedEXT;
PFNGLDRAWARRAYSINSTANCEDNVPROC                          gleswDrawArraysInstancedNV;
PFNGLDRAWBUFFERSPROC                                    gleswDrawBuffers;
PFNGLDRAWBUFFERSEXTPROC                                 gleswDrawBuffersEXT;
PFNGLDRAWBUFFERSINDEXEDEXTPROC                          gleswDrawBuffersIndexedEXT;
PFNGLDRAWBUFFERSNVPROC                                  gleswDrawBuffersNV;
PFNGLDRAWELEMENTSPROC                                   gleswDrawElements;
PFNGLDRAWELEMENTSBASEVERTEXEXTPROC                      gleswDrawElementsBaseVertexEXT;
PFNGLDRAWELEMENTSBASEVERTEXOESPROC                      gleswDrawElementsBaseVertexOES;
PFNGLDRAWELEMENTSINSTANCEDPROC                          gleswDrawElementsInstanced;
PFNGLDRAWELEMENTSINSTANCEDANGLEPROC                     gleswDrawElementsInstancedANGLE;
PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEEXTPROC           gleswDrawElementsInstancedBaseInstanceEXT;
PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEEXTPROC gleswDrawElementsInstancedBaseVertexBaseInstanceEXT;
PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXEXTPROC             gleswDrawElementsInstancedBaseVertexEXT;
PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXOESPROC             gleswDrawElementsInstancedBaseVertexOES;
PFNGLDRAWELEMENTSINSTANCEDEXTPROC                       gleswDrawElementsInstancedEXT;
PFNGLDRAWELEMENTSINSTANCEDNVPROC                        gleswDrawElementsInstancedNV;
PFNGLDRAWRANGEELEMENTSPROC                              gleswDrawRangeElements;
PFNGLDRAWRANGEELEMENTSBASEVERTEXEXTPROC                 gleswDrawRangeElementsBaseVertexEXT;
PFNGLDRAWRANGEELEMENTSBASEVERTEXOESPROC                 gleswDrawRangeElementsBaseVertexOES;
PFNGLEGLIMAGETARGETRENDERBUFFERSTORAGEOESPROC           gleswEGLImageTargetRenderbufferStorageOES;
PFNGLEGLIMAGETARGETTEXTURE2DOESPROC                     gleswEGLImageTargetTexture2DOES;
PFNGLENABLEPROC                                         gleswEnable;
PFNGLENABLEDRIVERCONTROLQCOMPROC                        gleswEnableDriverControlQCOM;
PFNGLENABLEVERTEXATTRIBARRAYPROC                        gleswEnableVertexAttribArray;
PFNGLENABLEIEXTPROC                                     gleswEnableiEXT;
PFNGLENABLEINVPROC                                      gleswEnableiNV;
PFNGLENABLEIOESPROC                                     gleswEnableiOES;
PFNGLENDCONDITIONALRENDERNVPROC                         gleswEndConditionalRenderNV;
PFNGLENDPERFMONITORAMDPROC                              gleswEndPerfMonitorAMD;
PFNGLENDPERFQUERYINTELPROC                              gleswEndPerfQueryINTEL;
PFNGLENDQUERYPROC                                       gleswEndQuery;
PFNGLENDQUERYEXTPROC                                    gleswEndQueryEXT;
PFNGLENDTILINGQCOMPROC                                  gleswEndTilingQCOM;
PFNGLENDTRANSFORMFEEDBACKPROC                           gleswEndTransformFeedback;
PFNGLEXTGETBUFFERPOINTERVQCOMPROC                       gleswExtGetBufferPointervQCOM;
PFNGLEXTGETBUFFERSQCOMPROC                              gleswExtGetBuffersQCOM;
PFNGLEXTGETFRAMEBUFFERSQCOMPROC                         gleswExtGetFramebuffersQCOM;
PFNGLEXTGETPROGRAMBINARYSOURCEQCOMPROC                  gleswExtGetProgramBinarySourceQCOM;
PFNGLEXTGETPROGRAMSQCOMPROC                             gleswExtGetProgramsQCOM;
PFNGLEXTGETRENDERBUFFERSQCOMPROC                        gleswExtGetRenderbuffersQCOM;
PFNGLEXTGETSHADERSQCOMPROC                              gleswExtGetShadersQCOM;
PFNGLEXTGETTEXLEVELPARAMETERIVQCOMPROC                  gleswExtGetTexLevelParameterivQCOM;
PFNGLEXTGETTEXSUBIMAGEQCOMPROC                          gleswExtGetTexSubImageQCOM;
PFNGLEXTGETTEXTURESQCOMPROC                             gleswExtGetTexturesQCOM;
PFNGLEXTISPROGRAMBINARYQCOMPROC                         gleswExtIsProgramBinaryQCOM;
PFNGLEXTTEXOBJECTSTATEOVERRIDEIQCOMPROC                 gleswExtTexObjectStateOverrideiQCOM;
PFNGLFENCESYNCPROC                                      gleswFenceSync;
PFNGLFENCESYNCAPPLEPROC                                 gleswFenceSyncAPPLE;
PFNGLFINISHPROC                                         gleswFinish;
PFNGLFINISHFENCENVPROC                                  gleswFinishFenceNV;
PFNGLFLUSHPROC                                          gleswFlush;
PFNGLFLUSHMAPPEDBUFFERRANGEPROC                         gleswFlushMappedBufferRange;
PFNGLFLUSHMAPPEDBUFFERRANGEEXTPROC                      gleswFlushMappedBufferRangeEXT;
PFNGLFRAGMENTCOVERAGECOLORNVPROC                        gleswFragmentCoverageColorNV;
PFNGLFRAMEBUFFERPIXELLOCALSTORAGESIZEEXTPROC            gleswFramebufferPixelLocalStorageSizeEXT;
PFNGLFRAMEBUFFERRENDERBUFFERPROC                        gleswFramebufferRenderbuffer;
PFNGLFRAMEBUFFERSAMPLELOCATIONSFVNVPROC                 gleswFramebufferSampleLocationsfvNV;
PFNGLFRAMEBUFFERTEXTURE2DPROC                           gleswFramebufferTexture2D;
PFNGLFRAMEBUFFERTEXTURE2DDOWNSAMPLEIMGPROC              gleswFramebufferTexture2DDownsampleIMG;
PFNGLFRAMEBUFFERTEXTURE2DMULTISAMPLEEXTPROC             gleswFramebufferTexture2DMultisampleEXT;
PFNGLFRAMEBUFFERTEXTURE2DMULTISAMPLEIMGPROC             gleswFramebufferTexture2DMultisampleIMG;
PFNGLFRAMEBUFFERTEXTURE3DOESPROC                        gleswFramebufferTexture3DOES;
PFNGLFRAMEBUFFERTEXTUREEXTPROC                          gleswFramebufferTextureEXT;
PFNGLFRAMEBUFFERTEXTURELAYERPROC                        gleswFramebufferTextureLayer;
PFNGLFRAMEBUFFERTEXTURELAYERDOWNSAMPLEIMGPROC           gleswFramebufferTextureLayerDownsampleIMG;
PFNGLFRAMEBUFFERTEXTUREMULTISAMPLEMULTIVIEWOVRPROC      gleswFramebufferTextureMultisampleMultiviewOVR;
PFNGLFRAMEBUFFERTEXTUREMULTIVIEWOVRPROC                 gleswFramebufferTextureMultiviewOVR;
PFNGLFRAMEBUFFERTEXTUREOESPROC                          gleswFramebufferTextureOES;
PFNGLFRONTFACEPROC                                      gleswFrontFace;
PFNGLGENBUFFERSPROC                                     gleswGenBuffers;
PFNGLGENFENCESNVPROC                                    gleswGenFencesNV;
PFNGLGENFRAMEBUFFERSPROC                                gleswGenFramebuffers;
PFNGLGENPATHSNVPROC                                     gleswGenPathsNV;
PFNGLGENPERFMONITORSAMDPROC                             gleswGenPerfMonitorsAMD;
PFNGLGENPROGRAMPIPELINESEXTPROC                         gleswGenProgramPipelinesEXT;
PFNGLGENQUERIESPROC                                     gleswGenQueries;
PFNGLGENQUERIESEXTPROC                                  gleswGenQueriesEXT;
PFNGLGENRENDERBUFFERSPROC                               gleswGenRenderbuffers;
PFNGLGENSAMPLERSPROC                                    gleswGenSamplers;
PFNGLGENTEXTURESPROC                                    gleswGenTextures;
PFNGLGENTRANSFORMFEEDBACKSPROC                          gleswGenTransformFeedbacks;
PFNGLGENVERTEXARRAYSPROC                                gleswGenVertexArrays;
PFNGLGENVERTEXARRAYSOESPROC                             gleswGenVertexArraysOES;
PFNGLGENERATEMIPMAPPROC                                 gleswGenerateMipmap;
PFNGLGETACTIVEATTRIBPROC                                gleswGetActiveAttrib;
PFNGLGETACTIVEUNIFORMPROC                               gleswGetActiveUniform;
PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC                      gleswGetActiveUniformBlockName;
PFNGLGETACTIVEUNIFORMBLOCKIVPROC                        gleswGetActiveUniformBlockiv;
PFNGLGETACTIVEUNIFORMSIVPROC                            gleswGetActiveUniformsiv;
PFNGLGETATTACHEDSHADERSPROC                             gleswGetAttachedShaders;
PFNGLGETATTRIBLOCATIONPROC                              gleswGetAttribLocation;
PFNGLGETBOOLEANVPROC                                    gleswGetBooleanv;
PFNGLGETBUFFERPARAMETERI64VPROC                         gleswGetBufferParameteri64v;
PFNGLGETBUFFERPARAMETERIVPROC                           gleswGetBufferParameteriv;
PFNGLGETBUFFERPOINTERVPROC                              gleswGetBufferPointerv;
PFNGLGETBUFFERPOINTERVOESPROC                           gleswGetBufferPointervOES;
PFNGLGETCOVERAGEMODULATIONTABLENVPROC                   gleswGetCoverageModulationTableNV;
PFNGLGETDEBUGMESSAGELOGKHRPROC                          gleswGetDebugMessageLogKHR;
PFNGLGETDRIVERCONTROLSTRINGQCOMPROC                     gleswGetDriverControlStringQCOM;
PFNGLGETDRIVERCONTROLSQCOMPROC                          gleswGetDriverControlsQCOM;
PFNGLGETERRORPROC                                       gleswGetError;
PFNGLGETFENCEIVNVPROC                                   gleswGetFenceivNV;
PFNGLGETFIRSTPERFQUERYIDINTELPROC                       gleswGetFirstPerfQueryIdINTEL;
PFNGLGETFLOATI_VNVPROC                                  gleswGetFloati_vNV;
PFNGLGETFLOATVPROC                                      gleswGetFloatv;
PFNGLGETFRAGDATAINDEXEXTPROC                            gleswGetFragDataIndexEXT;
PFNGLGETFRAGDATALOCATIONPROC                            gleswGetFragDataLocation;
PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC            gleswGetFramebufferAttachmentParameteriv;
PFNGLGETFRAMEBUFFERPIXELLOCALSTORAGESIZEEXTPROC         gleswGetFramebufferPixelLocalStorageSizeEXT;
PFNGLGETGRAPHICSRESETSTATUSEXTPROC                      gleswGetGraphicsResetStatusEXT;
PFNGLGETGRAPHICSRESETSTATUSKHRPROC                      gleswGetGraphicsResetStatusKHR;
PFNGLGETIMAGEHANDLENVPROC                               gleswGetImageHandleNV;
PFNGLGETINTEGER64I_VPROC                                gleswGetInteger64i_v;
PFNGLGETINTEGER64VPROC                                  gleswGetInteger64v;
PFNGLGETINTEGER64VAPPLEPROC                             gleswGetInteger64vAPPLE;
PFNGLGETINTEGERI_VPROC                                  gleswGetIntegeri_v;
PFNGLGETINTEGERI_VEXTPROC                               gleswGetIntegeri_vEXT;
PFNGLGETINTEGERVPROC                                    gleswGetIntegerv;
PFNGLGETINTERNALFORMATSAMPLEIVNVPROC                    gleswGetInternalformatSampleivNV;
PFNGLGETINTERNALFORMATIVPROC                            gleswGetInternalformativ;
PFNGLGETNEXTPERFQUERYIDINTELPROC                        gleswGetNextPerfQueryIdINTEL;
PFNGLGETOBJECTLABELEXTPROC                              gleswGetObjectLabelEXT;
PFNGLGETOBJECTLABELKHRPROC                              gleswGetObjectLabelKHR;
PFNGLGETOBJECTPTRLABELKHRPROC                           gleswGetObjectPtrLabelKHR;
PFNGLGETPATHCOMMANDSNVPROC                              gleswGetPathCommandsNV;
PFNGLGETPATHCOORDSNVPROC                                gleswGetPathCoordsNV;
PFNGLGETPATHDASHARRAYNVPROC                             gleswGetPathDashArrayNV;
PFNGLGETPATHLENGTHNVPROC                                gleswGetPathLengthNV;
PFNGLGETPATHMETRICRANGENVPROC                           gleswGetPathMetricRangeNV;
PFNGLGETPATHMETRICSNVPROC                               gleswGetPathMetricsNV;
PFNGLGETPATHPARAMETERFVNVPROC                           gleswGetPathParameterfvNV;
PFNGLGETPATHPARAMETERIVNVPROC                           gleswGetPathParameterivNV;
PFNGLGETPATHSPACINGNVPROC                               gleswGetPathSpacingNV;
PFNGLGETPERFCOUNTERINFOINTELPROC                        gleswGetPerfCounterInfoINTEL;
PFNGLGETPERFMONITORCOUNTERDATAAMDPROC                   gleswGetPerfMonitorCounterDataAMD;
PFNGLGETPERFMONITORCOUNTERINFOAMDPROC                   gleswGetPerfMonitorCounterInfoAMD;
PFNGLGETPERFMONITORCOUNTERSTRINGAMDPROC                 gleswGetPerfMonitorCounterStringAMD;
PFNGLGETPERFMONITORCOUNTERSAMDPROC                      gleswGetPerfMonitorCountersAMD;
PFNGLGETPERFMONITORGROUPSTRINGAMDPROC                   gleswGetPerfMonitorGroupStringAMD;
PFNGLGETPERFMONITORGROUPSAMDPROC                        gleswGetPerfMonitorGroupsAMD;
PFNGLGETPERFQUERYDATAINTELPROC                          gleswGetPerfQueryDataINTEL;
PFNGLGETPERFQUERYIDBYNAMEINTELPROC                      gleswGetPerfQueryIdByNameINTEL;
PFNGLGETPERFQUERYINFOINTELPROC                          gleswGetPerfQueryInfoINTEL;
PFNGLGETPOINTERVKHRPROC                                 gleswGetPointervKHR;
PFNGLGETPROGRAMBINARYPROC                               gleswGetProgramBinary;
PFNGLGETPROGRAMBINARYOESPROC                            gleswGetProgramBinaryOES;
PFNGLGETPROGRAMINFOLOGPROC                              gleswGetProgramInfoLog;
PFNGLGETPROGRAMPIPELINEINFOLOGEXTPROC                   gleswGetProgramPipelineInfoLogEXT;
PFNGLGETPROGRAMPIPELINEIVEXTPROC                        gleswGetProgramPipelineivEXT;
PFNGLGETPROGRAMRESOURCELOCATIONINDEXEXTPROC             gleswGetProgramResourceLocationIndexEXT;
PFNGLGETPROGRAMRESOURCEFVNVPROC                         gleswGetProgramResourcefvNV;
PFNGLGETPROGRAMIVPROC                                   gleswGetProgramiv;
PFNGLGETQUERYOBJECTI64VEXTPROC                          gleswGetQueryObjecti64vEXT;
PFNGLGETQUERYOBJECTIVEXTPROC                            gleswGetQueryObjectivEXT;
PFNGLGETQUERYOBJECTUI64VEXTPROC                         gleswGetQueryObjectui64vEXT;
PFNGLGETQUERYOBJECTUIVPROC                              gleswGetQueryObjectuiv;
PFNGLGETQUERYOBJECTUIVEXTPROC                           gleswGetQueryObjectuivEXT;
PFNGLGETQUERYIVPROC                                     gleswGetQueryiv;
PFNGLGETQUERYIVEXTPROC                                  gleswGetQueryivEXT;
PFNGLGETRENDERBUFFERPARAMETERIVPROC                     gleswGetRenderbufferParameteriv;
PFNGLGETSAMPLERPARAMETERIIVEXTPROC                      gleswGetSamplerParameterIivEXT;
PFNGLGETSAMPLERPARAMETERIIVOESPROC                      gleswGetSamplerParameterIivOES;
PFNGLGETSAMPLERPARAMETERIUIVEXTPROC                     gleswGetSamplerParameterIuivEXT;
PFNGLGETSAMPLERPARAMETERIUIVOESPROC                     gleswGetSamplerParameterIuivOES;
PFNGLGETSAMPLERPARAMETERFVPROC                          gleswGetSamplerParameterfv;
PFNGLGETSAMPLERPARAMETERIVPROC                          gleswGetSamplerParameteriv;
PFNGLGETSHADERINFOLOGPROC                               gleswGetShaderInfoLog;
PFNGLGETSHADERPRECISIONFORMATPROC                       gleswGetShaderPrecisionFormat;
PFNGLGETSHADERSOURCEPROC                                gleswGetShaderSource;
PFNGLGETSHADERIVPROC                                    gleswGetShaderiv;
PFNGLGETSTRINGPROC                                      gleswGetString;
PFNGLGETSTRINGIPROC                                     gleswGetStringi;
PFNGLGETSYNCIVPROC                                      gleswGetSynciv;
PFNGLGETSYNCIVAPPLEPROC                                 gleswGetSyncivAPPLE;
PFNGLGETTEXPARAMETERIIVEXTPROC                          gleswGetTexParameterIivEXT;
PFNGLGETTEXPARAMETERIIVOESPROC                          gleswGetTexParameterIivOES;
PFNGLGETTEXPARAMETERIUIVEXTPROC                         gleswGetTexParameterIuivEXT;
PFNGLGETTEXPARAMETERIUIVOESPROC                         gleswGetTexParameterIuivOES;
PFNGLGETTEXPARAMETERFVPROC                              gleswGetTexParameterfv;
PFNGLGETTEXPARAMETERIVPROC                              gleswGetTexParameteriv;
PFNGLGETTEXTUREHANDLENVPROC                             gleswGetTextureHandleNV;
PFNGLGETTEXTURESAMPLERHANDLENVPROC                      gleswGetTextureSamplerHandleNV;
PFNGLGETTRANSFORMFEEDBACKVARYINGPROC                    gleswGetTransformFeedbackVarying;
PFNGLGETTRANSLATEDSHADERSOURCEANGLEPROC                 gleswGetTranslatedShaderSourceANGLE;
PFNGLGETUNIFORMBLOCKINDEXPROC                           gleswGetUniformBlockIndex;
PFNGLGETUNIFORMINDICESPROC                              gleswGetUniformIndices;
PFNGLGETUNIFORMLOCATIONPROC                             gleswGetUniformLocation;
PFNGLGETUNIFORMFVPROC                                   gleswGetUniformfv;
PFNGLGETUNIFORMIVPROC                                   gleswGetUniformiv;
PFNGLGETUNIFORMUIVPROC                                  gleswGetUniformuiv;
PFNGLGETVERTEXATTRIBIIVPROC                             gleswGetVertexAttribIiv;
PFNGLGETVERTEXATTRIBIUIVPROC                            gleswGetVertexAttribIuiv;
PFNGLGETVERTEXATTRIBPOINTERVPROC                        gleswGetVertexAttribPointerv;
PFNGLGETVERTEXATTRIBFVPROC                              gleswGetVertexAttribfv;
PFNGLGETVERTEXATTRIBIVPROC                              gleswGetVertexAttribiv;
PFNGLGETNUNIFORMFVEXTPROC                               gleswGetnUniformfvEXT;
PFNGLGETNUNIFORMFVKHRPROC                               gleswGetnUniformfvKHR;
PFNGLGETNUNIFORMIVEXTPROC                               gleswGetnUniformivEXT;
PFNGLGETNUNIFORMIVKHRPROC                               gleswGetnUniformivKHR;
PFNGLGETNUNIFORMUIVKHRPROC                              gleswGetnUniformuivKHR;
PFNGLHINTPROC                                           gleswHint;
PFNGLINSERTEVENTMARKEREXTPROC                           gleswInsertEventMarkerEXT;
PFNGLINTERPOLATEPATHSNVPROC                             gleswInterpolatePathsNV;
PFNGLINVALIDATEFRAMEBUFFERPROC                          gleswInvalidateFramebuffer;
PFNGLINVALIDATESUBFRAMEBUFFERPROC                       gleswInvalidateSubFramebuffer;
PFNGLISBUFFERPROC                                       gleswIsBuffer;
PFNGLISENABLEDPROC                                      gleswIsEnabled;
PFNGLISENABLEDIEXTPROC                                  gleswIsEnablediEXT;
PFNGLISENABLEDINVPROC                                   gleswIsEnablediNV;
PFNGLISENABLEDIOESPROC                                  gleswIsEnablediOES;
PFNGLISFENCENVPROC                                      gleswIsFenceNV;
PFNGLISFRAMEBUFFERPROC                                  gleswIsFramebuffer;
PFNGLISIMAGEHANDLERESIDENTNVPROC                        gleswIsImageHandleResidentNV;
PFNGLISPATHNVPROC                                       gleswIsPathNV;
PFNGLISPOINTINFILLPATHNVPROC                            gleswIsPointInFillPathNV;
PFNGLISPOINTINSTROKEPATHNVPROC                          gleswIsPointInStrokePathNV;
PFNGLISPROGRAMPROC                                      gleswIsProgram;
PFNGLISPROGRAMPIPELINEEXTPROC                           gleswIsProgramPipelineEXT;
PFNGLISQUERYPROC                                        gleswIsQuery;
PFNGLISQUERYEXTPROC                                     gleswIsQueryEXT;
PFNGLISRENDERBUFFERPROC                                 gleswIsRenderbuffer;
PFNGLISSAMPLERPROC                                      gleswIsSampler;
PFNGLISSHADERPROC                                       gleswIsShader;
PFNGLISSYNCPROC                                         gleswIsSync;
PFNGLISSYNCAPPLEPROC                                    gleswIsSyncAPPLE;
PFNGLISTEXTUREPROC                                      gleswIsTexture;
PFNGLISTEXTUREHANDLERESIDENTNVPROC                      gleswIsTextureHandleResidentNV;
PFNGLISTRANSFORMFEEDBACKPROC                            gleswIsTransformFeedback;
PFNGLISVERTEXARRAYPROC                                  gleswIsVertexArray;
PFNGLISVERTEXARRAYOESPROC                               gleswIsVertexArrayOES;
PFNGLLABELOBJECTEXTPROC                                 gleswLabelObjectEXT;
PFNGLLINEWIDTHPROC                                      gleswLineWidth;
PFNGLLINKPROGRAMPROC                                    gleswLinkProgram;
PFNGLMAKEIMAGEHANDLENONRESIDENTNVPROC                   gleswMakeImageHandleNonResidentNV;
PFNGLMAKEIMAGEHANDLERESIDENTNVPROC                      gleswMakeImageHandleResidentNV;
PFNGLMAKETEXTUREHANDLENONRESIDENTNVPROC                 gleswMakeTextureHandleNonResidentNV;
PFNGLMAKETEXTUREHANDLERESIDENTNVPROC                    gleswMakeTextureHandleResidentNV;
PFNGLMAPBUFFEROESPROC                                   gleswMapBufferOES;
PFNGLMAPBUFFERRANGEPROC                                 gleswMapBufferRange;
PFNGLMAPBUFFERRANGEEXTPROC                              gleswMapBufferRangeEXT;
PFNGLMATRIXLOAD3X2FNVPROC                               gleswMatrixLoad3x2fNV;
PFNGLMATRIXLOAD3X3FNVPROC                               gleswMatrixLoad3x3fNV;
PFNGLMATRIXLOADTRANSPOSE3X3FNVPROC                      gleswMatrixLoadTranspose3x3fNV;
PFNGLMATRIXMULT3X2FNVPROC                               gleswMatrixMult3x2fNV;
PFNGLMATRIXMULT3X3FNVPROC                               gleswMatrixMult3x3fNV;
PFNGLMATRIXMULTTRANSPOSE3X3FNVPROC                      gleswMatrixMultTranspose3x3fNV;
PFNGLMINSAMPLESHADINGOESPROC                            gleswMinSampleShadingOES;
PFNGLMULTIDRAWARRAYSEXTPROC                             gleswMultiDrawArraysEXT;
PFNGLMULTIDRAWARRAYSINDIRECTEXTPROC                     gleswMultiDrawArraysIndirectEXT;
PFNGLMULTIDRAWELEMENTSBASEVERTEXEXTPROC                 gleswMultiDrawElementsBaseVertexEXT;
PFNGLMULTIDRAWELEMENTSBASEVERTEXOESPROC                 gleswMultiDrawElementsBaseVertexOES;
PFNGLMULTIDRAWELEMENTSEXTPROC                           gleswMultiDrawElementsEXT;
PFNGLMULTIDRAWELEMENTSINDIRECTEXTPROC                   gleswMultiDrawElementsIndirectEXT;
PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVNVPROC            gleswNamedFramebufferSampleLocationsfvNV;
PFNGLOBJECTLABELKHRPROC                                 gleswObjectLabelKHR;
PFNGLOBJECTPTRLABELKHRPROC                              gleswObjectPtrLabelKHR;
PFNGLPATCHPARAMETERIEXTPROC                             gleswPatchParameteriEXT;
PFNGLPATCHPARAMETERIOESPROC                             gleswPatchParameteriOES;
PFNGLPATHCOMMANDSNVPROC                                 gleswPathCommandsNV;
PFNGLPATHCOORDSNVPROC                                   gleswPathCoordsNV;
PFNGLPATHCOVERDEPTHFUNCNVPROC                           gleswPathCoverDepthFuncNV;
PFNGLPATHDASHARRAYNVPROC                                gleswPathDashArrayNV;
PFNGLPATHGLYPHINDEXARRAYNVPROC                          gleswPathGlyphIndexArrayNV;
PFNGLPATHGLYPHINDEXRANGENVPROC                          gleswPathGlyphIndexRangeNV;
PFNGLPATHGLYPHRANGENVPROC                               gleswPathGlyphRangeNV;
PFNGLPATHGLYPHSNVPROC                                   gleswPathGlyphsNV;
PFNGLPATHMEMORYGLYPHINDEXARRAYNVPROC                    gleswPathMemoryGlyphIndexArrayNV;
PFNGLPATHPARAMETERFNVPROC                               gleswPathParameterfNV;
PFNGLPATHPARAMETERFVNVPROC                              gleswPathParameterfvNV;
PFNGLPATHPARAMETERINVPROC                               gleswPathParameteriNV;
PFNGLPATHPARAMETERIVNVPROC                              gleswPathParameterivNV;
PFNGLPATHSTENCILDEPTHOFFSETNVPROC                       gleswPathStencilDepthOffsetNV;
PFNGLPATHSTENCILFUNCNVPROC                              gleswPathStencilFuncNV;
PFNGLPATHSTRINGNVPROC                                   gleswPathStringNV;
PFNGLPATHSUBCOMMANDSNVPROC                              gleswPathSubCommandsNV;
PFNGLPATHSUBCOORDSNVPROC                                gleswPathSubCoordsNV;
PFNGLPAUSETRANSFORMFEEDBACKPROC                         gleswPauseTransformFeedback;
PFNGLPIXELSTOREIPROC                                    gleswPixelStorei;
PFNGLPOINTALONGPATHNVPROC                               gleswPointAlongPathNV;
PFNGLPOLYGONMODENVPROC                                  gleswPolygonModeNV;
PFNGLPOLYGONOFFSETPROC                                  gleswPolygonOffset;
PFNGLPOLYGONOFFSETCLAMPEXTPROC                          gleswPolygonOffsetClampEXT;
PFNGLPOPDEBUGGROUPKHRPROC                               gleswPopDebugGroupKHR;
PFNGLPOPGROUPMARKEREXTPROC                              gleswPopGroupMarkerEXT;
PFNGLPRIMITIVEBOUNDINGBOXEXTPROC                        gleswPrimitiveBoundingBoxEXT;
PFNGLPRIMITIVEBOUNDINGBOXOESPROC                        gleswPrimitiveBoundingBoxOES;
PFNGLPROGRAMBINARYPROC                                  gleswProgramBinary;
PFNGLPROGRAMBINARYOESPROC                               gleswProgramBinaryOES;
PFNGLPROGRAMPARAMETERIPROC                              gleswProgramParameteri;
PFNGLPROGRAMPARAMETERIEXTPROC                           gleswProgramParameteriEXT;
PFNGLPROGRAMPATHFRAGMENTINPUTGENNVPROC                  gleswProgramPathFragmentInputGenNV;
PFNGLPROGRAMUNIFORM1FEXTPROC                            gleswProgramUniform1fEXT;
PFNGLPROGRAMUNIFORM1FVEXTPROC                           gleswProgramUniform1fvEXT;
PFNGLPROGRAMUNIFORM1IEXTPROC                            gleswProgramUniform1iEXT;
PFNGLPROGRAMUNIFORM1IVEXTPROC                           gleswProgramUniform1ivEXT;
PFNGLPROGRAMUNIFORM1UIEXTPROC                           gleswProgramUniform1uiEXT;
PFNGLPROGRAMUNIFORM1UIVEXTPROC                          gleswProgramUniform1uivEXT;
PFNGLPROGRAMUNIFORM2FEXTPROC                            gleswProgramUniform2fEXT;
PFNGLPROGRAMUNIFORM2FVEXTPROC                           gleswProgramUniform2fvEXT;
PFNGLPROGRAMUNIFORM2IEXTPROC                            gleswProgramUniform2iEXT;
PFNGLPROGRAMUNIFORM2IVEXTPROC                           gleswProgramUniform2ivEXT;
PFNGLPROGRAMUNIFORM2UIEXTPROC                           gleswProgramUniform2uiEXT;
PFNGLPROGRAMUNIFORM2UIVEXTPROC                          gleswProgramUniform2uivEXT;
PFNGLPROGRAMUNIFORM3FEXTPROC                            gleswProgramUniform3fEXT;
PFNGLPROGRAMUNIFORM3FVEXTPROC                           gleswProgramUniform3fvEXT;
PFNGLPROGRAMUNIFORM3IEXTPROC                            gleswProgramUniform3iEXT;
PFNGLPROGRAMUNIFORM3IVEXTPROC                           gleswProgramUniform3ivEXT;
PFNGLPROGRAMUNIFORM3UIEXTPROC                           gleswProgramUniform3uiEXT;
PFNGLPROGRAMUNIFORM3UIVEXTPROC                          gleswProgramUniform3uivEXT;
PFNGLPROGRAMUNIFORM4FEXTPROC                            gleswProgramUniform4fEXT;
PFNGLPROGRAMUNIFORM4FVEXTPROC                           gleswProgramUniform4fvEXT;
PFNGLPROGRAMUNIFORM4IEXTPROC                            gleswProgramUniform4iEXT;
PFNGLPROGRAMUNIFORM4IVEXTPROC                           gleswProgramUniform4ivEXT;
PFNGLPROGRAMUNIFORM4UIEXTPROC                           gleswProgramUniform4uiEXT;
PFNGLPROGRAMUNIFORM4UIVEXTPROC                          gleswProgramUniform4uivEXT;
PFNGLPROGRAMUNIFORMHANDLEUI64NVPROC                     gleswProgramUniformHandleui64NV;
PFNGLPROGRAMUNIFORMHANDLEUI64VNVPROC                    gleswProgramUniformHandleui64vNV;
PFNGLPROGRAMUNIFORMMATRIX2FVEXTPROC                     gleswProgramUniformMatrix2fvEXT;
PFNGLPROGRAMUNIFORMMATRIX2X3FVEXTPROC                   gleswProgramUniformMatrix2x3fvEXT;
PFNGLPROGRAMUNIFORMMATRIX2X4FVEXTPROC                   gleswProgramUniformMatrix2x4fvEXT;
PFNGLPROGRAMUNIFORMMATRIX3FVEXTPROC                     gleswProgramUniformMatrix3fvEXT;
PFNGLPROGRAMUNIFORMMATRIX3X2FVEXTPROC                   gleswProgramUniformMatrix3x2fvEXT;
PFNGLPROGRAMUNIFORMMATRIX3X4FVEXTPROC                   gleswProgramUniformMatrix3x4fvEXT;
PFNGLPROGRAMUNIFORMMATRIX4FVEXTPROC                     gleswProgramUniformMatrix4fvEXT;
PFNGLPROGRAMUNIFORMMATRIX4X2FVEXTPROC                   gleswProgramUniformMatrix4x2fvEXT;
PFNGLPROGRAMUNIFORMMATRIX4X3FVEXTPROC                   gleswProgramUniformMatrix4x3fvEXT;
PFNGLPUSHDEBUGGROUPKHRPROC                              gleswPushDebugGroupKHR;
PFNGLPUSHGROUPMARKEREXTPROC                             gleswPushGroupMarkerEXT;
PFNGLQUERYCOUNTEREXTPROC                                gleswQueryCounterEXT;
PFNGLRASTERSAMPLESEXTPROC                               gleswRasterSamplesEXT;
PFNGLREADBUFFERPROC                                     gleswReadBuffer;
PFNGLREADBUFFERINDEXEDEXTPROC                           gleswReadBufferIndexedEXT;
PFNGLREADBUFFERNVPROC                                   gleswReadBufferNV;
PFNGLREADPIXELSPROC                                     gleswReadPixels;
PFNGLREADNPIXELSEXTPROC                                 gleswReadnPixelsEXT;
PFNGLREADNPIXELSKHRPROC                                 gleswReadnPixelsKHR;
PFNGLRELEASESHADERCOMPILERPROC                          gleswReleaseShaderCompiler;
PFNGLRENDERBUFFERSTORAGEPROC                            gleswRenderbufferStorage;
PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC                 gleswRenderbufferStorageMultisample;
PFNGLRENDERBUFFERSTORAGEMULTISAMPLEANGLEPROC            gleswRenderbufferStorageMultisampleANGLE;
PFNGLRENDERBUFFERSTORAGEMULTISAMPLEAPPLEPROC            gleswRenderbufferStorageMultisampleAPPLE;
PFNGLRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC              gleswRenderbufferStorageMultisampleEXT;
PFNGLRENDERBUFFERSTORAGEMULTISAMPLEIMGPROC              gleswRenderbufferStorageMultisampleIMG;
PFNGLRENDERBUFFERSTORAGEMULTISAMPLENVPROC               gleswRenderbufferStorageMultisampleNV;
PFNGLRESOLVEDEPTHVALUESNVPROC                           gleswResolveDepthValuesNV;
PFNGLRESOLVEMULTISAMPLEFRAMEBUFFERAPPLEPROC             gleswResolveMultisampleFramebufferAPPLE;
PFNGLRESUMETRANSFORMFEEDBACKPROC                        gleswResumeTransformFeedback;
PFNGLSAMPLECOVERAGEPROC                                 gleswSampleCoverage;
PFNGLSAMPLERPARAMETERIIVEXTPROC                         gleswSamplerParameterIivEXT;
PFNGLSAMPLERPARAMETERIIVOESPROC                         gleswSamplerParameterIivOES;
PFNGLSAMPLERPARAMETERIUIVEXTPROC                        gleswSamplerParameterIuivEXT;
PFNGLSAMPLERPARAMETERIUIVOESPROC                        gleswSamplerParameterIuivOES;
PFNGLSAMPLERPARAMETERFPROC                              gleswSamplerParameterf;
PFNGLSAMPLERPARAMETERFVPROC                             gleswSamplerParameterfv;
PFNGLSAMPLERPARAMETERIPROC                              gleswSamplerParameteri;
PFNGLSAMPLERPARAMETERIVPROC                             gleswSamplerParameteriv;
PFNGLSCISSORPROC                                        gleswScissor;
PFNGLSCISSORARRAYVNVPROC                                gleswScissorArrayvNV;
PFNGLSCISSORINDEXEDNVPROC                               gleswScissorIndexedNV;
PFNGLSCISSORINDEXEDVNVPROC                              gleswScissorIndexedvNV;
PFNGLSELECTPERFMONITORCOUNTERSAMDPROC                   gleswSelectPerfMonitorCountersAMD;
PFNGLSETFENCENVPROC                                     gleswSetFenceNV;
PFNGLSHADERBINARYPROC                                   gleswShaderBinary;
PFNGLSHADERSOURCEPROC                                   gleswShaderSource;
PFNGLSTARTTILINGQCOMPROC                                gleswStartTilingQCOM;
PFNGLSTENCILFILLPATHINSTANCEDNVPROC                     gleswStencilFillPathInstancedNV;
PFNGLSTENCILFILLPATHNVPROC                              gleswStencilFillPathNV;
PFNGLSTENCILFUNCPROC                                    gleswStencilFunc;
PFNGLSTENCILFUNCSEPARATEPROC                            gleswStencilFuncSeparate;
PFNGLSTENCILMASKPROC                                    gleswStencilMask;
PFNGLSTENCILMASKSEPARATEPROC                            gleswStencilMaskSeparate;
PFNGLSTENCILOPPROC                                      gleswStencilOp;
PFNGLSTENCILOPSEPARATEPROC                              gleswStencilOpSeparate;
PFNGLSTENCILSTROKEPATHINSTANCEDNVPROC                   gleswStencilStrokePathInstancedNV;
PFNGLSTENCILSTROKEPATHNVPROC                            gleswStencilStrokePathNV;
PFNGLSTENCILTHENCOVERFILLPATHINSTANCEDNVPROC            gleswStencilThenCoverFillPathInstancedNV;
PFNGLSTENCILTHENCOVERFILLPATHNVPROC                     gleswStencilThenCoverFillPathNV;
PFNGLSTENCILTHENCOVERSTROKEPATHINSTANCEDNVPROC          gleswStencilThenCoverStrokePathInstancedNV;
PFNGLSTENCILTHENCOVERSTROKEPATHNVPROC                   gleswStencilThenCoverStrokePathNV;
PFNGLSUBPIXELPRECISIONBIASNVPROC                        gleswSubpixelPrecisionBiasNV;
PFNGLTESTFENCENVPROC                                    gleswTestFenceNV;
PFNGLTEXBUFFEREXTPROC                                   gleswTexBufferEXT;
PFNGLTEXBUFFEROESPROC                                   gleswTexBufferOES;
PFNGLTEXBUFFERRANGEEXTPROC                              gleswTexBufferRangeEXT;
PFNGLTEXBUFFERRANGEOESPROC                              gleswTexBufferRangeOES;
PFNGLTEXIMAGE2DPROC                                     gleswTexImage2D;
PFNGLTEXIMAGE3DPROC                                     gleswTexImage3D;
PFNGLTEXIMAGE3DOESPROC                                  gleswTexImage3DOES;
PFNGLTEXPAGECOMMITMENTEXTPROC                           gleswTexPageCommitmentEXT;
PFNGLTEXPARAMETERIIVEXTPROC                             gleswTexParameterIivEXT;
PFNGLTEXPARAMETERIIVOESPROC                             gleswTexParameterIivOES;
PFNGLTEXPARAMETERIUIVEXTPROC                            gleswTexParameterIuivEXT;
PFNGLTEXPARAMETERIUIVOESPROC                            gleswTexParameterIuivOES;
PFNGLTEXPARAMETERFPROC                                  gleswTexParameterf;
PFNGLTEXPARAMETERFVPROC                                 gleswTexParameterfv;
PFNGLTEXPARAMETERIPROC                                  gleswTexParameteri;
PFNGLTEXPARAMETERIVPROC                                 gleswTexParameteriv;
PFNGLTEXSTORAGE1DEXTPROC                                gleswTexStorage1DEXT;
PFNGLTEXSTORAGE2DPROC                                   gleswTexStorage2D;
PFNGLTEXSTORAGE2DEXTPROC                                gleswTexStorage2DEXT;
PFNGLTEXSTORAGE3DPROC                                   gleswTexStorage3D;
PFNGLTEXSTORAGE3DEXTPROC                                gleswTexStorage3DEXT;
PFNGLTEXSTORAGE3DMULTISAMPLEOESPROC                     gleswTexStorage3DMultisampleOES;
PFNGLTEXSUBIMAGE2DPROC                                  gleswTexSubImage2D;
PFNGLTEXSUBIMAGE3DPROC                                  gleswTexSubImage3D;
PFNGLTEXSUBIMAGE3DOESPROC                               gleswTexSubImage3DOES;
PFNGLTEXTURESTORAGE1DEXTPROC                            gleswTextureStorage1DEXT;
PFNGLTEXTURESTORAGE2DEXTPROC                            gleswTextureStorage2DEXT;
PFNGLTEXTURESTORAGE3DEXTPROC                            gleswTextureStorage3DEXT;
PFNGLTEXTUREVIEWEXTPROC                                 gleswTextureViewEXT;
PFNGLTEXTUREVIEWOESPROC                                 gleswTextureViewOES;
PFNGLTRANSFORMFEEDBACKVARYINGSPROC                      gleswTransformFeedbackVaryings;
PFNGLTRANSFORMPATHNVPROC                                gleswTransformPathNV;
PFNGLUNIFORM1FPROC                                      gleswUniform1f;
PFNGLUNIFORM1FVPROC                                     gleswUniform1fv;
PFNGLUNIFORM1IPROC                                      gleswUniform1i;
PFNGLUNIFORM1IVPROC                                     gleswUniform1iv;
PFNGLUNIFORM1UIPROC                                     gleswUniform1ui;
PFNGLUNIFORM1UIVPROC                                    gleswUniform1uiv;
PFNGLUNIFORM2FPROC                                      gleswUniform2f;
PFNGLUNIFORM2FVPROC                                     gleswUniform2fv;
PFNGLUNIFORM2IPROC                                      gleswUniform2i;
PFNGLUNIFORM2IVPROC                                     gleswUniform2iv;
PFNGLUNIFORM2UIPROC                                     gleswUniform2ui;
PFNGLUNIFORM2UIVPROC                                    gleswUniform2uiv;
PFNGLUNIFORM3FPROC                                      gleswUniform3f;
PFNGLUNIFORM3FVPROC                                     gleswUniform3fv;
PFNGLUNIFORM3IPROC                                      gleswUniform3i;
PFNGLUNIFORM3IVPROC                                     gleswUniform3iv;
PFNGLUNIFORM3UIPROC                                     gleswUniform3ui;
PFNGLUNIFORM3UIVPROC                                    gleswUniform3uiv;
PFNGLUNIFORM4FPROC                                      gleswUniform4f;
PFNGLUNIFORM4FVPROC                                     gleswUniform4fv;
PFNGLUNIFORM4IPROC                                      gleswUniform4i;
PFNGLUNIFORM4IVPROC                                     gleswUniform4iv;
PFNGLUNIFORM4UIPROC                                     gleswUniform4ui;
PFNGLUNIFORM4UIVPROC                                    gleswUniform4uiv;
PFNGLUNIFORMBLOCKBINDINGPROC                            gleswUniformBlockBinding;
PFNGLUNIFORMHANDLEUI64NVPROC                            gleswUniformHandleui64NV;
PFNGLUNIFORMHANDLEUI64VNVPROC                           gleswUniformHandleui64vNV;
PFNGLUNIFORMMATRIX2FVPROC                               gleswUniformMatrix2fv;
PFNGLUNIFORMMATRIX2X3FVPROC                             gleswUniformMatrix2x3fv;
PFNGLUNIFORMMATRIX2X3FVNVPROC                           gleswUniformMatrix2x3fvNV;
PFNGLUNIFORMMATRIX2X4FVPROC                             gleswUniformMatrix2x4fv;
PFNGLUNIFORMMATRIX2X4FVNVPROC                           gleswUniformMatrix2x4fvNV;
PFNGLUNIFORMMATRIX3FVPROC                               gleswUniformMatrix3fv;
PFNGLUNIFORMMATRIX3X2FVPROC                             gleswUniformMatrix3x2fv;
PFNGLUNIFORMMATRIX3X2FVNVPROC                           gleswUniformMatrix3x2fvNV;
PFNGLUNIFORMMATRIX3X4FVPROC                             gleswUniformMatrix3x4fv;
PFNGLUNIFORMMATRIX3X4FVNVPROC                           gleswUniformMatrix3x4fvNV;
PFNGLUNIFORMMATRIX4FVPROC                               gleswUniformMatrix4fv;
PFNGLUNIFORMMATRIX4X2FVPROC                             gleswUniformMatrix4x2fv;
PFNGLUNIFORMMATRIX4X2FVNVPROC                           gleswUniformMatrix4x2fvNV;
PFNGLUNIFORMMATRIX4X3FVPROC                             gleswUniformMatrix4x3fv;
PFNGLUNIFORMMATRIX4X3FVNVPROC                           gleswUniformMatrix4x3fvNV;
PFNGLUNMAPBUFFERPROC                                    gleswUnmapBuffer;
PFNGLUNMAPBUFFEROESPROC                                 gleswUnmapBufferOES;
PFNGLUSEPROGRAMPROC                                     gleswUseProgram;
PFNGLUSEPROGRAMSTAGESEXTPROC                            gleswUseProgramStagesEXT;
PFNGLVALIDATEPROGRAMPROC                                gleswValidateProgram;
PFNGLVALIDATEPROGRAMPIPELINEEXTPROC                     gleswValidateProgramPipelineEXT;
PFNGLVERTEXATTRIB1FPROC                                 gleswVertexAttrib1f;
PFNGLVERTEXATTRIB1FVPROC                                gleswVertexAttrib1fv;
PFNGLVERTEXATTRIB2FPROC                                 gleswVertexAttrib2f;
PFNGLVERTEXATTRIB2FVPROC                                gleswVertexAttrib2fv;
PFNGLVERTEXATTRIB3FPROC                                 gleswVertexAttrib3f;
PFNGLVERTEXATTRIB3FVPROC                                gleswVertexAttrib3fv;
PFNGLVERTEXATTRIB4FPROC                                 gleswVertexAttrib4f;
PFNGLVERTEXATTRIB4FVPROC                                gleswVertexAttrib4fv;
PFNGLVERTEXATTRIBDIVISORPROC                            gleswVertexAttribDivisor;
PFNGLVERTEXATTRIBDIVISORANGLEPROC                       gleswVertexAttribDivisorANGLE;
PFNGLVERTEXATTRIBDIVISOREXTPROC                         gleswVertexAttribDivisorEXT;
PFNGLVERTEXATTRIBDIVISORNVPROC                          gleswVertexAttribDivisorNV;
PFNGLVERTEXATTRIBI4IPROC                                gleswVertexAttribI4i;
PFNGLVERTEXATTRIBI4IVPROC                               gleswVertexAttribI4iv;
PFNGLVERTEXATTRIBI4UIPROC                               gleswVertexAttribI4ui;
PFNGLVERTEXATTRIBI4UIVPROC                              gleswVertexAttribI4uiv;
PFNGLVERTEXATTRIBIPOINTERPROC                           gleswVertexAttribIPointer;
PFNGLVERTEXATTRIBPOINTERPROC                            gleswVertexAttribPointer;
PFNGLVIEWPORTPROC                                       gleswViewport;
PFNGLVIEWPORTARRAYVNVPROC                               gleswViewportArrayvNV;
PFNGLVIEWPORTINDEXEDFNVPROC                             gleswViewportIndexedfNV;
PFNGLVIEWPORTINDEXEDFVNVPROC                            gleswViewportIndexedfvNV;
PFNGLWAITSYNCPROC                                       gleswWaitSync;
PFNGLWAITSYNCAPPLEPROC                                  gleswWaitSyncAPPLE;
PFNGLWEIGHTPATHSNVPROC                                  gleswWeightPathsNV;

static void load_procs(GLESWGetProcAddressProc proc)
{
	gleswActiveShaderProgramEXT = (PFNGLACTIVESHADERPROGRAMEXTPROC)proc("glActiveShaderProgramEXT");
	gleswActiveTexture = (PFNGLACTIVETEXTUREPROC)proc("glActiveTexture");
	gleswAlphaFuncQCOM = (PFNGLALPHAFUNCQCOMPROC)proc("glAlphaFuncQCOM");
	gleswApplyFramebufferAttachmentCMAAINTEL = (PFNGLAPPLYFRAMEBUFFERATTACHMENTCMAAINTELPROC)proc("glApplyFramebufferAttachmentCMAAINTEL");
	gleswAttachShader = (PFNGLATTACHSHADERPROC)proc("glAttachShader");
	gleswBeginConditionalRenderNV = (PFNGLBEGINCONDITIONALRENDERNVPROC)proc("glBeginConditionalRenderNV");
	gleswBeginPerfMonitorAMD = (PFNGLBEGINPERFMONITORAMDPROC)proc("glBeginPerfMonitorAMD");
	gleswBeginPerfQueryINTEL = (PFNGLBEGINPERFQUERYINTELPROC)proc("glBeginPerfQueryINTEL");
	gleswBeginQuery = (PFNGLBEGINQUERYPROC)proc("glBeginQuery");
	gleswBeginQueryEXT = (PFNGLBEGINQUERYEXTPROC)proc("glBeginQueryEXT");
	gleswBeginTransformFeedback = (PFNGLBEGINTRANSFORMFEEDBACKPROC)proc("glBeginTransformFeedback");
	gleswBindAttribLocation = (PFNGLBINDATTRIBLOCATIONPROC)proc("glBindAttribLocation");
	gleswBindBuffer = (PFNGLBINDBUFFERPROC)proc("glBindBuffer");
	gleswBindBufferBase = (PFNGLBINDBUFFERBASEPROC)proc("glBindBufferBase");
	gleswBindBufferRange = (PFNGLBINDBUFFERRANGEPROC)proc("glBindBufferRange");
	gleswBindFragDataLocationEXT = (PFNGLBINDFRAGDATALOCATIONEXTPROC)proc("glBindFragDataLocationEXT");
	gleswBindFragDataLocationIndexedEXT = (PFNGLBINDFRAGDATALOCATIONINDEXEDEXTPROC)proc("glBindFragDataLocationIndexedEXT");
	gleswBindFramebuffer = (PFNGLBINDFRAMEBUFFERPROC)proc("glBindFramebuffer");
	gleswBindProgramPipelineEXT = (PFNGLBINDPROGRAMPIPELINEEXTPROC)proc("glBindProgramPipelineEXT");
	gleswBindRenderbuffer = (PFNGLBINDRENDERBUFFERPROC)proc("glBindRenderbuffer");
	gleswBindSampler = (PFNGLBINDSAMPLERPROC)proc("glBindSampler");
	gleswBindTexture = (PFNGLBINDTEXTUREPROC)proc("glBindTexture");
	gleswBindTransformFeedback = (PFNGLBINDTRANSFORMFEEDBACKPROC)proc("glBindTransformFeedback");
	gleswBindVertexArray = (PFNGLBINDVERTEXARRAYPROC)proc("glBindVertexArray");
	gleswBindVertexArrayOES = (PFNGLBINDVERTEXARRAYOESPROC)proc("glBindVertexArrayOES");
	gleswBlendBarrierKHR = (PFNGLBLENDBARRIERKHRPROC)proc("glBlendBarrierKHR");
	gleswBlendBarrierNV = (PFNGLBLENDBARRIERNVPROC)proc("glBlendBarrierNV");
	gleswBlendColor = (PFNGLBLENDCOLORPROC)proc("glBlendColor");
	gleswBlendEquation = (PFNGLBLENDEQUATIONPROC)proc("glBlendEquation");
	gleswBlendEquationSeparate = (PFNGLBLENDEQUATIONSEPARATEPROC)proc("glBlendEquationSeparate");
	gleswBlendEquationSeparateiEXT = (PFNGLBLENDEQUATIONSEPARATEIEXTPROC)proc("glBlendEquationSeparateiEXT");
	gleswBlendEquationSeparateiOES = (PFNGLBLENDEQUATIONSEPARATEIOESPROC)proc("glBlendEquationSeparateiOES");
	gleswBlendEquationiEXT = (PFNGLBLENDEQUATIONIEXTPROC)proc("glBlendEquationiEXT");
	gleswBlendEquationiOES = (PFNGLBLENDEQUATIONIOESPROC)proc("glBlendEquationiOES");
	gleswBlendFunc = (PFNGLBLENDFUNCPROC)proc("glBlendFunc");
	gleswBlendFuncSeparate = (PFNGLBLENDFUNCSEPARATEPROC)proc("glBlendFuncSeparate");
	gleswBlendFuncSeparateiEXT = (PFNGLBLENDFUNCSEPARATEIEXTPROC)proc("glBlendFuncSeparateiEXT");
	gleswBlendFuncSeparateiOES = (PFNGLBLENDFUNCSEPARATEIOESPROC)proc("glBlendFuncSeparateiOES");
	gleswBlendFunciEXT = (PFNGLBLENDFUNCIEXTPROC)proc("glBlendFunciEXT");
	gleswBlendFunciOES = (PFNGLBLENDFUNCIOESPROC)proc("glBlendFunciOES");
	gleswBlendParameteriNV = (PFNGLBLENDPARAMETERINVPROC)proc("glBlendParameteriNV");
	gleswBlitFramebuffer = (PFNGLBLITFRAMEBUFFERPROC)proc("glBlitFramebuffer");
	gleswBlitFramebufferANGLE = (PFNGLBLITFRAMEBUFFERANGLEPROC)proc("glBlitFramebufferANGLE");
	gleswBlitFramebufferNV = (PFNGLBLITFRAMEBUFFERNVPROC)proc("glBlitFramebufferNV");
	gleswBufferData = (PFNGLBUFFERDATAPROC)proc("glBufferData");
	gleswBufferStorageEXT = (PFNGLBUFFERSTORAGEEXTPROC)proc("glBufferStorageEXT");
	gleswBufferSubData = (PFNGLBUFFERSUBDATAPROC)proc("glBufferSubData");
	gleswCheckFramebufferStatus = (PFNGLCHECKFRAMEBUFFERSTATUSPROC)proc("glCheckFramebufferStatus");
	gleswClear = (PFNGLCLEARPROC)proc("glClear");
	gleswClearBufferfi = (PFNGLCLEARBUFFERFIPROC)proc("glClearBufferfi");
	gleswClearBufferfv = (PFNGLCLEARBUFFERFVPROC)proc("glClearBufferfv");
	gleswClearBufferiv = (PFNGLCLEARBUFFERIVPROC)proc("glClearBufferiv");
	gleswClearBufferuiv = (PFNGLCLEARBUFFERUIVPROC)proc("glClearBufferuiv");
	gleswClearColor = (PFNGLCLEARCOLORPROC)proc("glClearColor");
	gleswClearDepthf = (PFNGLCLEARDEPTHFPROC)proc("glClearDepthf");
	gleswClearPixelLocalStorageuiEXT = (PFNGLCLEARPIXELLOCALSTORAGEUIEXTPROC)proc("glClearPixelLocalStorageuiEXT");
	gleswClearStencil = (PFNGLCLEARSTENCILPROC)proc("glClearStencil");
	gleswClientWaitSync = (PFNGLCLIENTWAITSYNCPROC)proc("glClientWaitSync");
	gleswClientWaitSyncAPPLE = (PFNGLCLIENTWAITSYNCAPPLEPROC)proc("glClientWaitSyncAPPLE");
	gleswColorMask = (PFNGLCOLORMASKPROC)proc("glColorMask");
	gleswColorMaskiEXT = (PFNGLCOLORMASKIEXTPROC)proc("glColorMaskiEXT");
	gleswColorMaskiOES = (PFNGLCOLORMASKIOESPROC)proc("glColorMaskiOES");
	gleswCompileShader = (PFNGLCOMPILESHADERPROC)proc("glCompileShader");
	gleswCompressedTexImage2D = (PFNGLCOMPRESSEDTEXIMAGE2DPROC)proc("glCompressedTexImage2D");
	gleswCompressedTexImage3D = (PFNGLCOMPRESSEDTEXIMAGE3DPROC)proc("glCompressedTexImage3D");
	gleswCompressedTexImage3DOES = (PFNGLCOMPRESSEDTEXIMAGE3DOESPROC)proc("glCompressedTexImage3DOES");
	gleswCompressedTexSubImage2D = (PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC)proc("glCompressedTexSubImage2D");
	gleswCompressedTexSubImage3D = (PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC)proc("glCompressedTexSubImage3D");
	gleswCompressedTexSubImage3DOES = (PFNGLCOMPRESSEDTEXSUBIMAGE3DOESPROC)proc("glCompressedTexSubImage3DOES");
	gleswCopyBufferSubData = (PFNGLCOPYBUFFERSUBDATAPROC)proc("glCopyBufferSubData");
	gleswCopyBufferSubDataNV = (PFNGLCOPYBUFFERSUBDATANVPROC)proc("glCopyBufferSubDataNV");
	gleswCopyImageSubDataEXT = (PFNGLCOPYIMAGESUBDATAEXTPROC)proc("glCopyImageSubDataEXT");
	gleswCopyImageSubDataOES = (PFNGLCOPYIMAGESUBDATAOESPROC)proc("glCopyImageSubDataOES");
	gleswCopyPathNV = (PFNGLCOPYPATHNVPROC)proc("glCopyPathNV");
	gleswCopyTexImage2D = (PFNGLCOPYTEXIMAGE2DPROC)proc("glCopyTexImage2D");
	gleswCopyTexSubImage2D = (PFNGLCOPYTEXSUBIMAGE2DPROC)proc("glCopyTexSubImage2D");
	gleswCopyTexSubImage3D = (PFNGLCOPYTEXSUBIMAGE3DPROC)proc("glCopyTexSubImage3D");
	gleswCopyTexSubImage3DOES = (PFNGLCOPYTEXSUBIMAGE3DOESPROC)proc("glCopyTexSubImage3DOES");
	gleswCopyTextureLevelsAPPLE = (PFNGLCOPYTEXTURELEVELSAPPLEPROC)proc("glCopyTextureLevelsAPPLE");
	gleswCoverFillPathInstancedNV = (PFNGLCOVERFILLPATHINSTANCEDNVPROC)proc("glCoverFillPathInstancedNV");
	gleswCoverFillPathNV = (PFNGLCOVERFILLPATHNVPROC)proc("glCoverFillPathNV");
	gleswCoverStrokePathInstancedNV = (PFNGLCOVERSTROKEPATHINSTANCEDNVPROC)proc("glCoverStrokePathInstancedNV");
	gleswCoverStrokePathNV = (PFNGLCOVERSTROKEPATHNVPROC)proc("glCoverStrokePathNV");
	gleswCoverageMaskNV = (PFNGLCOVERAGEMASKNVPROC)proc("glCoverageMaskNV");
	gleswCoverageModulationNV = (PFNGLCOVERAGEMODULATIONNVPROC)proc("glCoverageModulationNV");
	gleswCoverageModulationTableNV = (PFNGLCOVERAGEMODULATIONTABLENVPROC)proc("glCoverageModulationTableNV");
	gleswCoverageOperationNV = (PFNGLCOVERAGEOPERATIONNVPROC)proc("glCoverageOperationNV");
	gleswCreatePerfQueryINTEL = (PFNGLCREATEPERFQUERYINTELPROC)proc("glCreatePerfQueryINTEL");
	gleswCreateProgram = (PFNGLCREATEPROGRAMPROC)proc("glCreateProgram");
	gleswCreateShader = (PFNGLCREATESHADERPROC)proc("glCreateShader");
	gleswCreateShaderProgramvEXT = (PFNGLCREATESHADERPROGRAMVEXTPROC)proc("glCreateShaderProgramvEXT");
	gleswCullFace = (PFNGLCULLFACEPROC)proc("glCullFace");
	gleswDebugMessageCallbackKHR = (PFNGLDEBUGMESSAGECALLBACKKHRPROC)proc("glDebugMessageCallbackKHR");
	gleswDebugMessageControlKHR = (PFNGLDEBUGMESSAGECONTROLKHRPROC)proc("glDebugMessageControlKHR");
	gleswDebugMessageInsertKHR = (PFNGLDEBUGMESSAGEINSERTKHRPROC)proc("glDebugMessageInsertKHR");
	gleswDeleteBuffers = (PFNGLDELETEBUFFERSPROC)proc("glDeleteBuffers");
	gleswDeleteFencesNV = (PFNGLDELETEFENCESNVPROC)proc("glDeleteFencesNV");
	gleswDeleteFramebuffers = (PFNGLDELETEFRAMEBUFFERSPROC)proc("glDeleteFramebuffers");
	gleswDeletePathsNV = (PFNGLDELETEPATHSNVPROC)proc("glDeletePathsNV");
	gleswDeletePerfMonitorsAMD = (PFNGLDELETEPERFMONITORSAMDPROC)proc("glDeletePerfMonitorsAMD");
	gleswDeletePerfQueryINTEL = (PFNGLDELETEPERFQUERYINTELPROC)proc("glDeletePerfQueryINTEL");
	gleswDeleteProgram = (PFNGLDELETEPROGRAMPROC)proc("glDeleteProgram");
	gleswDeleteProgramPipelinesEXT = (PFNGLDELETEPROGRAMPIPELINESEXTPROC)proc("glDeleteProgramPipelinesEXT");
	gleswDeleteQueries = (PFNGLDELETEQUERIESPROC)proc("glDeleteQueries");
	gleswDeleteQueriesEXT = (PFNGLDELETEQUERIESEXTPROC)proc("glDeleteQueriesEXT");
	gleswDeleteRenderbuffers = (PFNGLDELETERENDERBUFFERSPROC)proc("glDeleteRenderbuffers");
	gleswDeleteSamplers = (PFNGLDELETESAMPLERSPROC)proc("glDeleteSamplers");
	gleswDeleteShader = (PFNGLDELETESHADERPROC)proc("glDeleteShader");
	gleswDeleteSync = (PFNGLDELETESYNCPROC)proc("glDeleteSync");
	gleswDeleteSyncAPPLE = (PFNGLDELETESYNCAPPLEPROC)proc("glDeleteSyncAPPLE");
	gleswDeleteTextures = (PFNGLDELETETEXTURESPROC)proc("glDeleteTextures");
	gleswDeleteTransformFeedbacks = (PFNGLDELETETRANSFORMFEEDBACKSPROC)proc("glDeleteTransformFeedbacks");
	gleswDeleteVertexArrays = (PFNGLDELETEVERTEXARRAYSPROC)proc("glDeleteVertexArrays");
	gleswDeleteVertexArraysOES = (PFNGLDELETEVERTEXARRAYSOESPROC)proc("glDeleteVertexArraysOES");
	gleswDepthFunc = (PFNGLDEPTHFUNCPROC)proc("glDepthFunc");
	gleswDepthMask = (PFNGLDEPTHMASKPROC)proc("glDepthMask");
	gleswDepthRangeArrayfvNV = (PFNGLDEPTHRANGEARRAYFVNVPROC)proc("glDepthRangeArrayfvNV");
	gleswDepthRangeIndexedfNV = (PFNGLDEPTHRANGEINDEXEDFNVPROC)proc("glDepthRangeIndexedfNV");
	gleswDepthRangef = (PFNGLDEPTHRANGEFPROC)proc("glDepthRangef");
	gleswDetachShader = (PFNGLDETACHSHADERPROC)proc("glDetachShader");
	gleswDisable = (PFNGLDISABLEPROC)proc("glDisable");
	gleswDisableDriverControlQCOM = (PFNGLDISABLEDRIVERCONTROLQCOMPROC)proc("glDisableDriverControlQCOM");
	gleswDisableVertexAttribArray = (PFNGLDISABLEVERTEXATTRIBARRAYPROC)proc("glDisableVertexAttribArray");
	gleswDisableiEXT = (PFNGLDISABLEIEXTPROC)proc("glDisableiEXT");
	gleswDisableiNV = (PFNGLDISABLEINVPROC)proc("glDisableiNV");
	gleswDisableiOES = (PFNGLDISABLEIOESPROC)proc("glDisableiOES");
	gleswDiscardFramebufferEXT = (PFNGLDISCARDFRAMEBUFFEREXTPROC)proc("glDiscardFramebufferEXT");
	gleswDrawArrays = (PFNGLDRAWARRAYSPROC)proc("glDrawArrays");
	gleswDrawArraysInstanced = (PFNGLDRAWARRAYSINSTANCEDPROC)proc("glDrawArraysInstanced");
	gleswDrawArraysInstancedANGLE = (PFNGLDRAWARRAYSINSTANCEDANGLEPROC)proc("glDrawArraysInstancedANGLE");
	gleswDrawArraysInstancedBaseInstanceEXT = (PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEEXTPROC)proc("glDrawArraysInstancedBaseInstanceEXT");
	gleswDrawArraysInstancedEXT = (PFNGLDRAWARRAYSINSTANCEDEXTPROC)proc("glDrawArraysInstancedEXT");
	gleswDrawArraysInstancedNV = (PFNGLDRAWARRAYSINSTANCEDNVPROC)proc("glDrawArraysInstancedNV");
	gleswDrawBuffers = (PFNGLDRAWBUFFERSPROC)proc("glDrawBuffers");
	gleswDrawBuffersEXT = (PFNGLDRAWBUFFERSEXTPROC)proc("glDrawBuffersEXT");
	gleswDrawBuffersIndexedEXT = (PFNGLDRAWBUFFERSINDEXEDEXTPROC)proc("glDrawBuffersIndexedEXT");
	gleswDrawBuffersNV = (PFNGLDRAWBUFFERSNVPROC)proc("glDrawBuffersNV");
	gleswDrawElements = (PFNGLDRAWELEMENTSPROC)proc("glDrawElements");
	gleswDrawElementsBaseVertexEXT = (PFNGLDRAWELEMENTSBASEVERTEXEXTPROC)proc("glDrawElementsBaseVertexEXT");
	gleswDrawElementsBaseVertexOES = (PFNGLDRAWELEMENTSBASEVERTEXOESPROC)proc("glDrawElementsBaseVertexOES");
	gleswDrawElementsInstanced = (PFNGLDRAWELEMENTSINSTANCEDPROC)proc("glDrawElementsInstanced");
	gleswDrawElementsInstancedANGLE = (PFNGLDRAWELEMENTSINSTANCEDANGLEPROC)proc("glDrawElementsInstancedANGLE");
	gleswDrawElementsInstancedBaseInstanceEXT = (PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEEXTPROC)proc("glDrawElementsInstancedBaseInstanceEXT");
	gleswDrawElementsInstancedBaseVertexBaseInstanceEXT = (PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEEXTPROC)proc("glDrawElementsInstancedBaseVertexBaseInstanceEXT");
	gleswDrawElementsInstancedBaseVertexEXT = (PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXEXTPROC)proc("glDrawElementsInstancedBaseVertexEXT");
	gleswDrawElementsInstancedBaseVertexOES = (PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXOESPROC)proc("glDrawElementsInstancedBaseVertexOES");
	gleswDrawElementsInstancedEXT = (PFNGLDRAWELEMENTSINSTANCEDEXTPROC)proc("glDrawElementsInstancedEXT");
	gleswDrawElementsInstancedNV = (PFNGLDRAWELEMENTSINSTANCEDNVPROC)proc("glDrawElementsInstancedNV");
	gleswDrawRangeElements = (PFNGLDRAWRANGEELEMENTSPROC)proc("glDrawRangeElements");
	gleswDrawRangeElementsBaseVertexEXT = (PFNGLDRAWRANGEELEMENTSBASEVERTEXEXTPROC)proc("glDrawRangeElementsBaseVertexEXT");
	gleswDrawRangeElementsBaseVertexOES = (PFNGLDRAWRANGEELEMENTSBASEVERTEXOESPROC)proc("glDrawRangeElementsBaseVertexOES");
	gleswEGLImageTargetRenderbufferStorageOES = (PFNGLEGLIMAGETARGETRENDERBUFFERSTORAGEOESPROC)proc("glEGLImageTargetRenderbufferStorageOES");
	gleswEGLImageTargetTexture2DOES = (PFNGLEGLIMAGETARGETTEXTURE2DOESPROC)proc("glEGLImageTargetTexture2DOES");
	gleswEnable = (PFNGLENABLEPROC)proc("glEnable");
	gleswEnableDriverControlQCOM = (PFNGLENABLEDRIVERCONTROLQCOMPROC)proc("glEnableDriverControlQCOM");
	gleswEnableVertexAttribArray = (PFNGLENABLEVERTEXATTRIBARRAYPROC)proc("glEnableVertexAttribArray");
	gleswEnableiEXT = (PFNGLENABLEIEXTPROC)proc("glEnableiEXT");
	gleswEnableiNV = (PFNGLENABLEINVPROC)proc("glEnableiNV");
	gleswEnableiOES = (PFNGLENABLEIOESPROC)proc("glEnableiOES");
	gleswEndConditionalRenderNV = (PFNGLENDCONDITIONALRENDERNVPROC)proc("glEndConditionalRenderNV");
	gleswEndPerfMonitorAMD = (PFNGLENDPERFMONITORAMDPROC)proc("glEndPerfMonitorAMD");
	gleswEndPerfQueryINTEL = (PFNGLENDPERFQUERYINTELPROC)proc("glEndPerfQueryINTEL");
	gleswEndQuery = (PFNGLENDQUERYPROC)proc("glEndQuery");
	gleswEndQueryEXT = (PFNGLENDQUERYEXTPROC)proc("glEndQueryEXT");
	gleswEndTilingQCOM = (PFNGLENDTILINGQCOMPROC)proc("glEndTilingQCOM");
	gleswEndTransformFeedback = (PFNGLENDTRANSFORMFEEDBACKPROC)proc("glEndTransformFeedback");
	gleswExtGetBufferPointervQCOM = (PFNGLEXTGETBUFFERPOINTERVQCOMPROC)proc("glExtGetBufferPointervQCOM");
	gleswExtGetBuffersQCOM = (PFNGLEXTGETBUFFERSQCOMPROC)proc("glExtGetBuffersQCOM");
	gleswExtGetFramebuffersQCOM = (PFNGLEXTGETFRAMEBUFFERSQCOMPROC)proc("glExtGetFramebuffersQCOM");
	gleswExtGetProgramBinarySourceQCOM = (PFNGLEXTGETPROGRAMBINARYSOURCEQCOMPROC)proc("glExtGetProgramBinarySourceQCOM");
	gleswExtGetProgramsQCOM = (PFNGLEXTGETPROGRAMSQCOMPROC)proc("glExtGetProgramsQCOM");
	gleswExtGetRenderbuffersQCOM = (PFNGLEXTGETRENDERBUFFERSQCOMPROC)proc("glExtGetRenderbuffersQCOM");
	gleswExtGetShadersQCOM = (PFNGLEXTGETSHADERSQCOMPROC)proc("glExtGetShadersQCOM");
	gleswExtGetTexLevelParameterivQCOM = (PFNGLEXTGETTEXLEVELPARAMETERIVQCOMPROC)proc("glExtGetTexLevelParameterivQCOM");
	gleswExtGetTexSubImageQCOM = (PFNGLEXTGETTEXSUBIMAGEQCOMPROC)proc("glExtGetTexSubImageQCOM");
	gleswExtGetTexturesQCOM = (PFNGLEXTGETTEXTURESQCOMPROC)proc("glExtGetTexturesQCOM");
	gleswExtIsProgramBinaryQCOM = (PFNGLEXTISPROGRAMBINARYQCOMPROC)proc("glExtIsProgramBinaryQCOM");
	gleswExtTexObjectStateOverrideiQCOM = (PFNGLEXTTEXOBJECTSTATEOVERRIDEIQCOMPROC)proc("glExtTexObjectStateOverrideiQCOM");
	gleswFenceSync = (PFNGLFENCESYNCPROC)proc("glFenceSync");
	gleswFenceSyncAPPLE = (PFNGLFENCESYNCAPPLEPROC)proc("glFenceSyncAPPLE");
	gleswFinish = (PFNGLFINISHPROC)proc("glFinish");
	gleswFinishFenceNV = (PFNGLFINISHFENCENVPROC)proc("glFinishFenceNV");
	gleswFlush = (PFNGLFLUSHPROC)proc("glFlush");
	gleswFlushMappedBufferRange = (PFNGLFLUSHMAPPEDBUFFERRANGEPROC)proc("glFlushMappedBufferRange");
	gleswFlushMappedBufferRangeEXT = (PFNGLFLUSHMAPPEDBUFFERRANGEEXTPROC)proc("glFlushMappedBufferRangeEXT");
	gleswFragmentCoverageColorNV = (PFNGLFRAGMENTCOVERAGECOLORNVPROC)proc("glFragmentCoverageColorNV");
	gleswFramebufferPixelLocalStorageSizeEXT = (PFNGLFRAMEBUFFERPIXELLOCALSTORAGESIZEEXTPROC)proc("glFramebufferPixelLocalStorageSizeEXT");
	gleswFramebufferRenderbuffer = (PFNGLFRAMEBUFFERRENDERBUFFERPROC)proc("glFramebufferRenderbuffer");
	gleswFramebufferSampleLocationsfvNV = (PFNGLFRAMEBUFFERSAMPLELOCATIONSFVNVPROC)proc("glFramebufferSampleLocationsfvNV");
	gleswFramebufferTexture2D = (PFNGLFRAMEBUFFERTEXTURE2DPROC)proc("glFramebufferTexture2D");
	gleswFramebufferTexture2DDownsampleIMG = (PFNGLFRAMEBUFFERTEXTURE2DDOWNSAMPLEIMGPROC)proc("glFramebufferTexture2DDownsampleIMG");
	gleswFramebufferTexture2DMultisampleEXT = (PFNGLFRAMEBUFFERTEXTURE2DMULTISAMPLEEXTPROC)proc("glFramebufferTexture2DMultisampleEXT");
	gleswFramebufferTexture2DMultisampleIMG = (PFNGLFRAMEBUFFERTEXTURE2DMULTISAMPLEIMGPROC)proc("glFramebufferTexture2DMultisampleIMG");
	gleswFramebufferTexture3DOES = (PFNGLFRAMEBUFFERTEXTURE3DOESPROC)proc("glFramebufferTexture3DOES");
	gleswFramebufferTextureEXT = (PFNGLFRAMEBUFFERTEXTUREEXTPROC)proc("glFramebufferTextureEXT");
	gleswFramebufferTextureLayer = (PFNGLFRAMEBUFFERTEXTURELAYERPROC)proc("glFramebufferTextureLayer");
	gleswFramebufferTextureLayerDownsampleIMG = (PFNGLFRAMEBUFFERTEXTURELAYERDOWNSAMPLEIMGPROC)proc("glFramebufferTextureLayerDownsampleIMG");
	gleswFramebufferTextureMultisampleMultiviewOVR = (PFNGLFRAMEBUFFERTEXTUREMULTISAMPLEMULTIVIEWOVRPROC)proc("glFramebufferTextureMultisampleMultiviewOVR");
	gleswFramebufferTextureMultiviewOVR = (PFNGLFRAMEBUFFERTEXTUREMULTIVIEWOVRPROC)proc("glFramebufferTextureMultiviewOVR");
	gleswFramebufferTextureOES = (PFNGLFRAMEBUFFERTEXTUREOESPROC)proc("glFramebufferTextureOES");
	gleswFrontFace = (PFNGLFRONTFACEPROC)proc("glFrontFace");
	gleswGenBuffers = (PFNGLGENBUFFERSPROC)proc("glGenBuffers");
	gleswGenFencesNV = (PFNGLGENFENCESNVPROC)proc("glGenFencesNV");
	gleswGenFramebuffers = (PFNGLGENFRAMEBUFFERSPROC)proc("glGenFramebuffers");
	gleswGenPathsNV = (PFNGLGENPATHSNVPROC)proc("glGenPathsNV");
	gleswGenPerfMonitorsAMD = (PFNGLGENPERFMONITORSAMDPROC)proc("glGenPerfMonitorsAMD");
	gleswGenProgramPipelinesEXT = (PFNGLGENPROGRAMPIPELINESEXTPROC)proc("glGenProgramPipelinesEXT");
	gleswGenQueries = (PFNGLGENQUERIESPROC)proc("glGenQueries");
	gleswGenQueriesEXT = (PFNGLGENQUERIESEXTPROC)proc("glGenQueriesEXT");
	gleswGenRenderbuffers = (PFNGLGENRENDERBUFFERSPROC)proc("glGenRenderbuffers");
	gleswGenSamplers = (PFNGLGENSAMPLERSPROC)proc("glGenSamplers");
	gleswGenTextures = (PFNGLGENTEXTURESPROC)proc("glGenTextures");
	gleswGenTransformFeedbacks = (PFNGLGENTRANSFORMFEEDBACKSPROC)proc("glGenTransformFeedbacks");
	gleswGenVertexArrays = (PFNGLGENVERTEXARRAYSPROC)proc("glGenVertexArrays");
	gleswGenVertexArraysOES = (PFNGLGENVERTEXARRAYSOESPROC)proc("glGenVertexArraysOES");
	gleswGenerateMipmap = (PFNGLGENERATEMIPMAPPROC)proc("glGenerateMipmap");
	gleswGetActiveAttrib = (PFNGLGETACTIVEATTRIBPROC)proc("glGetActiveAttrib");
	gleswGetActiveUniform = (PFNGLGETACTIVEUNIFORMPROC)proc("glGetActiveUniform");
	gleswGetActiveUniformBlockName = (PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC)proc("glGetActiveUniformBlockName");
	gleswGetActiveUniformBlockiv = (PFNGLGETACTIVEUNIFORMBLOCKIVPROC)proc("glGetActiveUniformBlockiv");
	gleswGetActiveUniformsiv = (PFNGLGETACTIVEUNIFORMSIVPROC)proc("glGetActiveUniformsiv");
	gleswGetAttachedShaders = (PFNGLGETATTACHEDSHADERSPROC)proc("glGetAttachedShaders");
	gleswGetAttribLocation = (PFNGLGETATTRIBLOCATIONPROC)proc("glGetAttribLocation");
	gleswGetBooleanv = (PFNGLGETBOOLEANVPROC)proc("glGetBooleanv");
	gleswGetBufferParameteri64v = (PFNGLGETBUFFERPARAMETERI64VPROC)proc("glGetBufferParameteri64v");
	gleswGetBufferParameteriv = (PFNGLGETBUFFERPARAMETERIVPROC)proc("glGetBufferParameteriv");
	gleswGetBufferPointerv = (PFNGLGETBUFFERPOINTERVPROC)proc("glGetBufferPointerv");
	gleswGetBufferPointervOES = (PFNGLGETBUFFERPOINTERVOESPROC)proc("glGetBufferPointervOES");
	gleswGetCoverageModulationTableNV = (PFNGLGETCOVERAGEMODULATIONTABLENVPROC)proc("glGetCoverageModulationTableNV");
	gleswGetDebugMessageLogKHR = (PFNGLGETDEBUGMESSAGELOGKHRPROC)proc("glGetDebugMessageLogKHR");
	gleswGetDriverControlStringQCOM = (PFNGLGETDRIVERCONTROLSTRINGQCOMPROC)proc("glGetDriverControlStringQCOM");
	gleswGetDriverControlsQCOM = (PFNGLGETDRIVERCONTROLSQCOMPROC)proc("glGetDriverControlsQCOM");
	gleswGetError = (PFNGLGETERRORPROC)proc("glGetError");
	gleswGetFenceivNV = (PFNGLGETFENCEIVNVPROC)proc("glGetFenceivNV");
	gleswGetFirstPerfQueryIdINTEL = (PFNGLGETFIRSTPERFQUERYIDINTELPROC)proc("glGetFirstPerfQueryIdINTEL");
	gleswGetFloati_vNV = (PFNGLGETFLOATI_VNVPROC)proc("glGetFloati_vNV");
	gleswGetFloatv = (PFNGLGETFLOATVPROC)proc("glGetFloatv");
	gleswGetFragDataIndexEXT = (PFNGLGETFRAGDATAINDEXEXTPROC)proc("glGetFragDataIndexEXT");
	gleswGetFragDataLocation = (PFNGLGETFRAGDATALOCATIONPROC)proc("glGetFragDataLocation");
	gleswGetFramebufferAttachmentParameteriv = (PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC)proc("glGetFramebufferAttachmentParameteriv");
	gleswGetFramebufferPixelLocalStorageSizeEXT = (PFNGLGETFRAMEBUFFERPIXELLOCALSTORAGESIZEEXTPROC)proc("glGetFramebufferPixelLocalStorageSizeEXT");
	gleswGetGraphicsResetStatusEXT = (PFNGLGETGRAPHICSRESETSTATUSEXTPROC)proc("glGetGraphicsResetStatusEXT");
	gleswGetGraphicsResetStatusKHR = (PFNGLGETGRAPHICSRESETSTATUSKHRPROC)proc("glGetGraphicsResetStatusKHR");
	gleswGetImageHandleNV = (PFNGLGETIMAGEHANDLENVPROC)proc("glGetImageHandleNV");
	gleswGetInteger64i_v = (PFNGLGETINTEGER64I_VPROC)proc("glGetInteger64i_v");
	gleswGetInteger64v = (PFNGLGETINTEGER64VPROC)proc("glGetInteger64v");
	gleswGetInteger64vAPPLE = (PFNGLGETINTEGER64VAPPLEPROC)proc("glGetInteger64vAPPLE");
	gleswGetIntegeri_v = (PFNGLGETINTEGERI_VPROC)proc("glGetIntegeri_v");
	gleswGetIntegeri_vEXT = (PFNGLGETINTEGERI_VEXTPROC)proc("glGetIntegeri_vEXT");
	gleswGetIntegerv = (PFNGLGETINTEGERVPROC)proc("glGetIntegerv");
	gleswGetInternalformatSampleivNV = (PFNGLGETINTERNALFORMATSAMPLEIVNVPROC)proc("glGetInternalformatSampleivNV");
	gleswGetInternalformativ = (PFNGLGETINTERNALFORMATIVPROC)proc("glGetInternalformativ");
	gleswGetNextPerfQueryIdINTEL = (PFNGLGETNEXTPERFQUERYIDINTELPROC)proc("glGetNextPerfQueryIdINTEL");
	gleswGetObjectLabelEXT = (PFNGLGETOBJECTLABELEXTPROC)proc("glGetObjectLabelEXT");
	gleswGetObjectLabelKHR = (PFNGLGETOBJECTLABELKHRPROC)proc("glGetObjectLabelKHR");
	gleswGetObjectPtrLabelKHR = (PFNGLGETOBJECTPTRLABELKHRPROC)proc("glGetObjectPtrLabelKHR");
	gleswGetPathCommandsNV = (PFNGLGETPATHCOMMANDSNVPROC)proc("glGetPathCommandsNV");
	gleswGetPathCoordsNV = (PFNGLGETPATHCOORDSNVPROC)proc("glGetPathCoordsNV");
	gleswGetPathDashArrayNV = (PFNGLGETPATHDASHARRAYNVPROC)proc("glGetPathDashArrayNV");
	gleswGetPathLengthNV = (PFNGLGETPATHLENGTHNVPROC)proc("glGetPathLengthNV");
	gleswGetPathMetricRangeNV = (PFNGLGETPATHMETRICRANGENVPROC)proc("glGetPathMetricRangeNV");
	gleswGetPathMetricsNV = (PFNGLGETPATHMETRICSNVPROC)proc("glGetPathMetricsNV");
	gleswGetPathParameterfvNV = (PFNGLGETPATHPARAMETERFVNVPROC)proc("glGetPathParameterfvNV");
	gleswGetPathParameterivNV = (PFNGLGETPATHPARAMETERIVNVPROC)proc("glGetPathParameterivNV");
	gleswGetPathSpacingNV = (PFNGLGETPATHSPACINGNVPROC)proc("glGetPathSpacingNV");
	gleswGetPerfCounterInfoINTEL = (PFNGLGETPERFCOUNTERINFOINTELPROC)proc("glGetPerfCounterInfoINTEL");
	gleswGetPerfMonitorCounterDataAMD = (PFNGLGETPERFMONITORCOUNTERDATAAMDPROC)proc("glGetPerfMonitorCounterDataAMD");
	gleswGetPerfMonitorCounterInfoAMD = (PFNGLGETPERFMONITORCOUNTERINFOAMDPROC)proc("glGetPerfMonitorCounterInfoAMD");
	gleswGetPerfMonitorCounterStringAMD = (PFNGLGETPERFMONITORCOUNTERSTRINGAMDPROC)proc("glGetPerfMonitorCounterStringAMD");
	gleswGetPerfMonitorCountersAMD = (PFNGLGETPERFMONITORCOUNTERSAMDPROC)proc("glGetPerfMonitorCountersAMD");
	gleswGetPerfMonitorGroupStringAMD = (PFNGLGETPERFMONITORGROUPSTRINGAMDPROC)proc("glGetPerfMonitorGroupStringAMD");
	gleswGetPerfMonitorGroupsAMD = (PFNGLGETPERFMONITORGROUPSAMDPROC)proc("glGetPerfMonitorGroupsAMD");
	gleswGetPerfQueryDataINTEL = (PFNGLGETPERFQUERYDATAINTELPROC)proc("glGetPerfQueryDataINTEL");
	gleswGetPerfQueryIdByNameINTEL = (PFNGLGETPERFQUERYIDBYNAMEINTELPROC)proc("glGetPerfQueryIdByNameINTEL");
	gleswGetPerfQueryInfoINTEL = (PFNGLGETPERFQUERYINFOINTELPROC)proc("glGetPerfQueryInfoINTEL");
	gleswGetPointervKHR = (PFNGLGETPOINTERVKHRPROC)proc("glGetPointervKHR");
	gleswGetProgramBinary = (PFNGLGETPROGRAMBINARYPROC)proc("glGetProgramBinary");
	gleswGetProgramBinaryOES = (PFNGLGETPROGRAMBINARYOESPROC)proc("glGetProgramBinaryOES");
	gleswGetProgramInfoLog = (PFNGLGETPROGRAMINFOLOGPROC)proc("glGetProgramInfoLog");
	gleswGetProgramPipelineInfoLogEXT = (PFNGLGETPROGRAMPIPELINEINFOLOGEXTPROC)proc("glGetProgramPipelineInfoLogEXT");
	gleswGetProgramPipelineivEXT = (PFNGLGETPROGRAMPIPELINEIVEXTPROC)proc("glGetProgramPipelineivEXT");
	gleswGetProgramResourceLocationIndexEXT = (PFNGLGETPROGRAMRESOURCELOCATIONINDEXEXTPROC)proc("glGetProgramResourceLocationIndexEXT");
	gleswGetProgramResourcefvNV = (PFNGLGETPROGRAMRESOURCEFVNVPROC)proc("glGetProgramResourcefvNV");
	gleswGetProgramiv = (PFNGLGETPROGRAMIVPROC)proc("glGetProgramiv");
	gleswGetQueryObjecti64vEXT = (PFNGLGETQUERYOBJECTI64VEXTPROC)proc("glGetQueryObjecti64vEXT");
	gleswGetQueryObjectivEXT = (PFNGLGETQUERYOBJECTIVEXTPROC)proc("glGetQueryObjectivEXT");
	gleswGetQueryObjectui64vEXT = (PFNGLGETQUERYOBJECTUI64VEXTPROC)proc("glGetQueryObjectui64vEXT");
	gleswGetQueryObjectuiv = (PFNGLGETQUERYOBJECTUIVPROC)proc("glGetQueryObjectuiv");
	gleswGetQueryObjectuivEXT = (PFNGLGETQUERYOBJECTUIVEXTPROC)proc("glGetQueryObjectuivEXT");
	gleswGetQueryiv = (PFNGLGETQUERYIVPROC)proc("glGetQueryiv");
	gleswGetQueryivEXT = (PFNGLGETQUERYIVEXTPROC)proc("glGetQueryivEXT");
	gleswGetRenderbufferParameteriv = (PFNGLGETRENDERBUFFERPARAMETERIVPROC)proc("glGetRenderbufferParameteriv");
	gleswGetSamplerParameterIivEXT = (PFNGLGETSAMPLERPARAMETERIIVEXTPROC)proc("glGetSamplerParameterIivEXT");
	gleswGetSamplerParameterIivOES = (PFNGLGETSAMPLERPARAMETERIIVOESPROC)proc("glGetSamplerParameterIivOES");
	gleswGetSamplerParameterIuivEXT = (PFNGLGETSAMPLERPARAMETERIUIVEXTPROC)proc("glGetSamplerParameterIuivEXT");
	gleswGetSamplerParameterIuivOES = (PFNGLGETSAMPLERPARAMETERIUIVOESPROC)proc("glGetSamplerParameterIuivOES");
	gleswGetSamplerParameterfv = (PFNGLGETSAMPLERPARAMETERFVPROC)proc("glGetSamplerParameterfv");
	gleswGetSamplerParameteriv = (PFNGLGETSAMPLERPARAMETERIVPROC)proc("glGetSamplerParameteriv");
	gleswGetShaderInfoLog = (PFNGLGETSHADERINFOLOGPROC)proc("glGetShaderInfoLog");
	gleswGetShaderPrecisionFormat = (PFNGLGETSHADERPRECISIONFORMATPROC)proc("glGetShaderPrecisionFormat");
	gleswGetShaderSource = (PFNGLGETSHADERSOURCEPROC)proc("glGetShaderSource");
	gleswGetShaderiv = (PFNGLGETSHADERIVPROC)proc("glGetShaderiv");
	gleswGetString = (PFNGLGETSTRINGPROC)proc("glGetString");
	gleswGetStringi = (PFNGLGETSTRINGIPROC)proc("glGetStringi");
	gleswGetSynciv = (PFNGLGETSYNCIVPROC)proc("glGetSynciv");
	gleswGetSyncivAPPLE = (PFNGLGETSYNCIVAPPLEPROC)proc("glGetSyncivAPPLE");
	gleswGetTexParameterIivEXT = (PFNGLGETTEXPARAMETERIIVEXTPROC)proc("glGetTexParameterIivEXT");
	gleswGetTexParameterIivOES = (PFNGLGETTEXPARAMETERIIVOESPROC)proc("glGetTexParameterIivOES");
	gleswGetTexParameterIuivEXT = (PFNGLGETTEXPARAMETERIUIVEXTPROC)proc("glGetTexParameterIuivEXT");
	gleswGetTexParameterIuivOES = (PFNGLGETTEXPARAMETERIUIVOESPROC)proc("glGetTexParameterIuivOES");
	gleswGetTexParameterfv = (PFNGLGETTEXPARAMETERFVPROC)proc("glGetTexParameterfv");
	gleswGetTexParameteriv = (PFNGLGETTEXPARAMETERIVPROC)proc("glGetTexParameteriv");
	gleswGetTextureHandleNV = (PFNGLGETTEXTUREHANDLENVPROC)proc("glGetTextureHandleNV");
	gleswGetTextureSamplerHandleNV = (PFNGLGETTEXTURESAMPLERHANDLENVPROC)proc("glGetTextureSamplerHandleNV");
	gleswGetTransformFeedbackVarying = (PFNGLGETTRANSFORMFEEDBACKVARYINGPROC)proc("glGetTransformFeedbackVarying");
	gleswGetTranslatedShaderSourceANGLE = (PFNGLGETTRANSLATEDSHADERSOURCEANGLEPROC)proc("glGetTranslatedShaderSourceANGLE");
	gleswGetUniformBlockIndex = (PFNGLGETUNIFORMBLOCKINDEXPROC)proc("glGetUniformBlockIndex");
	gleswGetUniformIndices = (PFNGLGETUNIFORMINDICESPROC)proc("glGetUniformIndices");
	gleswGetUniformLocation = (PFNGLGETUNIFORMLOCATIONPROC)proc("glGetUniformLocation");
	gleswGetUniformfv = (PFNGLGETUNIFORMFVPROC)proc("glGetUniformfv");
	gleswGetUniformiv = (PFNGLGETUNIFORMIVPROC)proc("glGetUniformiv");
	gleswGetUniformuiv = (PFNGLGETUNIFORMUIVPROC)proc("glGetUniformuiv");
	gleswGetVertexAttribIiv = (PFNGLGETVERTEXATTRIBIIVPROC)proc("glGetVertexAttribIiv");
	gleswGetVertexAttribIuiv = (PFNGLGETVERTEXATTRIBIUIVPROC)proc("glGetVertexAttribIuiv");
	gleswGetVertexAttribPointerv = (PFNGLGETVERTEXATTRIBPOINTERVPROC)proc("glGetVertexAttribPointerv");
	gleswGetVertexAttribfv = (PFNGLGETVERTEXATTRIBFVPROC)proc("glGetVertexAttribfv");
	gleswGetVertexAttribiv = (PFNGLGETVERTEXATTRIBIVPROC)proc("glGetVertexAttribiv");
	gleswGetnUniformfvEXT = (PFNGLGETNUNIFORMFVEXTPROC)proc("glGetnUniformfvEXT");
	gleswGetnUniformfvKHR = (PFNGLGETNUNIFORMFVKHRPROC)proc("glGetnUniformfvKHR");
	gleswGetnUniformivEXT = (PFNGLGETNUNIFORMIVEXTPROC)proc("glGetnUniformivEXT");
	gleswGetnUniformivKHR = (PFNGLGETNUNIFORMIVKHRPROC)proc("glGetnUniformivKHR");
	gleswGetnUniformuivKHR = (PFNGLGETNUNIFORMUIVKHRPROC)proc("glGetnUniformuivKHR");
	gleswHint = (PFNGLHINTPROC)proc("glHint");
	gleswInsertEventMarkerEXT = (PFNGLINSERTEVENTMARKEREXTPROC)proc("glInsertEventMarkerEXT");
	gleswInterpolatePathsNV = (PFNGLINTERPOLATEPATHSNVPROC)proc("glInterpolatePathsNV");
	gleswInvalidateFramebuffer = (PFNGLINVALIDATEFRAMEBUFFERPROC)proc("glInvalidateFramebuffer");
	gleswInvalidateSubFramebuffer = (PFNGLINVALIDATESUBFRAMEBUFFERPROC)proc("glInvalidateSubFramebuffer");
	gleswIsBuffer = (PFNGLISBUFFERPROC)proc("glIsBuffer");
	gleswIsEnabled = (PFNGLISENABLEDPROC)proc("glIsEnabled");
	gleswIsEnablediEXT = (PFNGLISENABLEDIEXTPROC)proc("glIsEnablediEXT");
	gleswIsEnablediNV = (PFNGLISENABLEDINVPROC)proc("glIsEnablediNV");
	gleswIsEnablediOES = (PFNGLISENABLEDIOESPROC)proc("glIsEnablediOES");
	gleswIsFenceNV = (PFNGLISFENCENVPROC)proc("glIsFenceNV");
	gleswIsFramebuffer = (PFNGLISFRAMEBUFFERPROC)proc("glIsFramebuffer");
	gleswIsImageHandleResidentNV = (PFNGLISIMAGEHANDLERESIDENTNVPROC)proc("glIsImageHandleResidentNV");
	gleswIsPathNV = (PFNGLISPATHNVPROC)proc("glIsPathNV");
	gleswIsPointInFillPathNV = (PFNGLISPOINTINFILLPATHNVPROC)proc("glIsPointInFillPathNV");
	gleswIsPointInStrokePathNV = (PFNGLISPOINTINSTROKEPATHNVPROC)proc("glIsPointInStrokePathNV");
	gleswIsProgram = (PFNGLISPROGRAMPROC)proc("glIsProgram");
	gleswIsProgramPipelineEXT = (PFNGLISPROGRAMPIPELINEEXTPROC)proc("glIsProgramPipelineEXT");
	gleswIsQuery = (PFNGLISQUERYPROC)proc("glIsQuery");
	gleswIsQueryEXT = (PFNGLISQUERYEXTPROC)proc("glIsQueryEXT");
	gleswIsRenderbuffer = (PFNGLISRENDERBUFFERPROC)proc("glIsRenderbuffer");
	gleswIsSampler = (PFNGLISSAMPLERPROC)proc("glIsSampler");
	gleswIsShader = (PFNGLISSHADERPROC)proc("glIsShader");
	gleswIsSync = (PFNGLISSYNCPROC)proc("glIsSync");
	gleswIsSyncAPPLE = (PFNGLISSYNCAPPLEPROC)proc("glIsSyncAPPLE");
	gleswIsTexture = (PFNGLISTEXTUREPROC)proc("glIsTexture");
	gleswIsTextureHandleResidentNV = (PFNGLISTEXTUREHANDLERESIDENTNVPROC)proc("glIsTextureHandleResidentNV");
	gleswIsTransformFeedback = (PFNGLISTRANSFORMFEEDBACKPROC)proc("glIsTransformFeedback");
	gleswIsVertexArray = (PFNGLISVERTEXARRAYPROC)proc("glIsVertexArray");
	gleswIsVertexArrayOES = (PFNGLISVERTEXARRAYOESPROC)proc("glIsVertexArrayOES");
	gleswLabelObjectEXT = (PFNGLLABELOBJECTEXTPROC)proc("glLabelObjectEXT");
	gleswLineWidth = (PFNGLLINEWIDTHPROC)proc("glLineWidth");
	gleswLinkProgram = (PFNGLLINKPROGRAMPROC)proc("glLinkProgram");
	gleswMakeImageHandleNonResidentNV = (PFNGLMAKEIMAGEHANDLENONRESIDENTNVPROC)proc("glMakeImageHandleNonResidentNV");
	gleswMakeImageHandleResidentNV = (PFNGLMAKEIMAGEHANDLERESIDENTNVPROC)proc("glMakeImageHandleResidentNV");
	gleswMakeTextureHandleNonResidentNV = (PFNGLMAKETEXTUREHANDLENONRESIDENTNVPROC)proc("glMakeTextureHandleNonResidentNV");
	gleswMakeTextureHandleResidentNV = (PFNGLMAKETEXTUREHANDLERESIDENTNVPROC)proc("glMakeTextureHandleResidentNV");
	gleswMapBufferOES = (PFNGLMAPBUFFEROESPROC)proc("glMapBufferOES");
	gleswMapBufferRange = (PFNGLMAPBUFFERRANGEPROC)proc("glMapBufferRange");
	gleswMapBufferRangeEXT = (PFNGLMAPBUFFERRANGEEXTPROC)proc("glMapBufferRangeEXT");
	gleswMatrixLoad3x2fNV = (PFNGLMATRIXLOAD3X2FNVPROC)proc("glMatrixLoad3x2fNV");
	gleswMatrixLoad3x3fNV = (PFNGLMATRIXLOAD3X3FNVPROC)proc("glMatrixLoad3x3fNV");
	gleswMatrixLoadTranspose3x3fNV = (PFNGLMATRIXLOADTRANSPOSE3X3FNVPROC)proc("glMatrixLoadTranspose3x3fNV");
	gleswMatrixMult3x2fNV = (PFNGLMATRIXMULT3X2FNVPROC)proc("glMatrixMult3x2fNV");
	gleswMatrixMult3x3fNV = (PFNGLMATRIXMULT3X3FNVPROC)proc("glMatrixMult3x3fNV");
	gleswMatrixMultTranspose3x3fNV = (PFNGLMATRIXMULTTRANSPOSE3X3FNVPROC)proc("glMatrixMultTranspose3x3fNV");
	gleswMinSampleShadingOES = (PFNGLMINSAMPLESHADINGOESPROC)proc("glMinSampleShadingOES");
	gleswMultiDrawArraysEXT = (PFNGLMULTIDRAWARRAYSEXTPROC)proc("glMultiDrawArraysEXT");
	gleswMultiDrawArraysIndirectEXT = (PFNGLMULTIDRAWARRAYSINDIRECTEXTPROC)proc("glMultiDrawArraysIndirectEXT");
	gleswMultiDrawElementsBaseVertexEXT = (PFNGLMULTIDRAWELEMENTSBASEVERTEXEXTPROC)proc("glMultiDrawElementsBaseVertexEXT");
	gleswMultiDrawElementsBaseVertexOES = (PFNGLMULTIDRAWELEMENTSBASEVERTEXOESPROC)proc("glMultiDrawElementsBaseVertexOES");
	gleswMultiDrawElementsEXT = (PFNGLMULTIDRAWELEMENTSEXTPROC)proc("glMultiDrawElementsEXT");
	gleswMultiDrawElementsIndirectEXT = (PFNGLMULTIDRAWELEMENTSINDIRECTEXTPROC)proc("glMultiDrawElementsIndirectEXT");
	gleswNamedFramebufferSampleLocationsfvNV = (PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVNVPROC)proc("glNamedFramebufferSampleLocationsfvNV");
	gleswObjectLabelKHR = (PFNGLOBJECTLABELKHRPROC)proc("glObjectLabelKHR");
	gleswObjectPtrLabelKHR = (PFNGLOBJECTPTRLABELKHRPROC)proc("glObjectPtrLabelKHR");
	gleswPatchParameteriEXT = (PFNGLPATCHPARAMETERIEXTPROC)proc("glPatchParameteriEXT");
	gleswPatchParameteriOES = (PFNGLPATCHPARAMETERIOESPROC)proc("glPatchParameteriOES");
	gleswPathCommandsNV = (PFNGLPATHCOMMANDSNVPROC)proc("glPathCommandsNV");
	gleswPathCoordsNV = (PFNGLPATHCOORDSNVPROC)proc("glPathCoordsNV");
	gleswPathCoverDepthFuncNV = (PFNGLPATHCOVERDEPTHFUNCNVPROC)proc("glPathCoverDepthFuncNV");
	gleswPathDashArrayNV = (PFNGLPATHDASHARRAYNVPROC)proc("glPathDashArrayNV");
	gleswPathGlyphIndexArrayNV = (PFNGLPATHGLYPHINDEXARRAYNVPROC)proc("glPathGlyphIndexArrayNV");
	gleswPathGlyphIndexRangeNV = (PFNGLPATHGLYPHINDEXRANGENVPROC)proc("glPathGlyphIndexRangeNV");
	gleswPathGlyphRangeNV = (PFNGLPATHGLYPHRANGENVPROC)proc("glPathGlyphRangeNV");
	gleswPathGlyphsNV = (PFNGLPATHGLYPHSNVPROC)proc("glPathGlyphsNV");
	gleswPathMemoryGlyphIndexArrayNV = (PFNGLPATHMEMORYGLYPHINDEXARRAYNVPROC)proc("glPathMemoryGlyphIndexArrayNV");
	gleswPathParameterfNV = (PFNGLPATHPARAMETERFNVPROC)proc("glPathParameterfNV");
	gleswPathParameterfvNV = (PFNGLPATHPARAMETERFVNVPROC)proc("glPathParameterfvNV");
	gleswPathParameteriNV = (PFNGLPATHPARAMETERINVPROC)proc("glPathParameteriNV");
	gleswPathParameterivNV = (PFNGLPATHPARAMETERIVNVPROC)proc("glPathParameterivNV");
	gleswPathStencilDepthOffsetNV = (PFNGLPATHSTENCILDEPTHOFFSETNVPROC)proc("glPathStencilDepthOffsetNV");
	gleswPathStencilFuncNV = (PFNGLPATHSTENCILFUNCNVPROC)proc("glPathStencilFuncNV");
	gleswPathStringNV = (PFNGLPATHSTRINGNVPROC)proc("glPathStringNV");
	gleswPathSubCommandsNV = (PFNGLPATHSUBCOMMANDSNVPROC)proc("glPathSubCommandsNV");
	gleswPathSubCoordsNV = (PFNGLPATHSUBCOORDSNVPROC)proc("glPathSubCoordsNV");
	gleswPauseTransformFeedback = (PFNGLPAUSETRANSFORMFEEDBACKPROC)proc("glPauseTransformFeedback");
	gleswPixelStorei = (PFNGLPIXELSTOREIPROC)proc("glPixelStorei");
	gleswPointAlongPathNV = (PFNGLPOINTALONGPATHNVPROC)proc("glPointAlongPathNV");
	gleswPolygonModeNV = (PFNGLPOLYGONMODENVPROC)proc("glPolygonModeNV");
	gleswPolygonOffset = (PFNGLPOLYGONOFFSETPROC)proc("glPolygonOffset");
	gleswPolygonOffsetClampEXT = (PFNGLPOLYGONOFFSETCLAMPEXTPROC)proc("glPolygonOffsetClampEXT");
	gleswPopDebugGroupKHR = (PFNGLPOPDEBUGGROUPKHRPROC)proc("glPopDebugGroupKHR");
	gleswPopGroupMarkerEXT = (PFNGLPOPGROUPMARKEREXTPROC)proc("glPopGroupMarkerEXT");
	gleswPrimitiveBoundingBoxEXT = (PFNGLPRIMITIVEBOUNDINGBOXEXTPROC)proc("glPrimitiveBoundingBoxEXT");
	gleswPrimitiveBoundingBoxOES = (PFNGLPRIMITIVEBOUNDINGBOXOESPROC)proc("glPrimitiveBoundingBoxOES");
	gleswProgramBinary = (PFNGLPROGRAMBINARYPROC)proc("glProgramBinary");
	gleswProgramBinaryOES = (PFNGLPROGRAMBINARYOESPROC)proc("glProgramBinaryOES");
	gleswProgramParameteri = (PFNGLPROGRAMPARAMETERIPROC)proc("glProgramParameteri");
	gleswProgramParameteriEXT = (PFNGLPROGRAMPARAMETERIEXTPROC)proc("glProgramParameteriEXT");
	gleswProgramPathFragmentInputGenNV = (PFNGLPROGRAMPATHFRAGMENTINPUTGENNVPROC)proc("glProgramPathFragmentInputGenNV");
	gleswProgramUniform1fEXT = (PFNGLPROGRAMUNIFORM1FEXTPROC)proc("glProgramUniform1fEXT");
	gleswProgramUniform1fvEXT = (PFNGLPROGRAMUNIFORM1FVEXTPROC)proc("glProgramUniform1fvEXT");
	gleswProgramUniform1iEXT = (PFNGLPROGRAMUNIFORM1IEXTPROC)proc("glProgramUniform1iEXT");
	gleswProgramUniform1ivEXT = (PFNGLPROGRAMUNIFORM1IVEXTPROC)proc("glProgramUniform1ivEXT");
	gleswProgramUniform1uiEXT = (PFNGLPROGRAMUNIFORM1UIEXTPROC)proc("glProgramUniform1uiEXT");
	gleswProgramUniform1uivEXT = (PFNGLPROGRAMUNIFORM1UIVEXTPROC)proc("glProgramUniform1uivEXT");
	gleswProgramUniform2fEXT = (PFNGLPROGRAMUNIFORM2FEXTPROC)proc("glProgramUniform2fEXT");
	gleswProgramUniform2fvEXT = (PFNGLPROGRAMUNIFORM2FVEXTPROC)proc("glProgramUniform2fvEXT");
	gleswProgramUniform2iEXT = (PFNGLPROGRAMUNIFORM2IEXTPROC)proc("glProgramUniform2iEXT");
	gleswProgramUniform2ivEXT = (PFNGLPROGRAMUNIFORM2IVEXTPROC)proc("glProgramUniform2ivEXT");
	gleswProgramUniform2uiEXT = (PFNGLPROGRAMUNIFORM2UIEXTPROC)proc("glProgramUniform2uiEXT");
	gleswProgramUniform2uivEXT = (PFNGLPROGRAMUNIFORM2UIVEXTPROC)proc("glProgramUniform2uivEXT");
	gleswProgramUniform3fEXT = (PFNGLPROGRAMUNIFORM3FEXTPROC)proc("glProgramUniform3fEXT");
	gleswProgramUniform3fvEXT = (PFNGLPROGRAMUNIFORM3FVEXTPROC)proc("glProgramUniform3fvEXT");
	gleswProgramUniform3iEXT = (PFNGLPROGRAMUNIFORM3IEXTPROC)proc("glProgramUniform3iEXT");
	gleswProgramUniform3ivEXT = (PFNGLPROGRAMUNIFORM3IVEXTPROC)proc("glProgramUniform3ivEXT");
	gleswProgramUniform3uiEXT = (PFNGLPROGRAMUNIFORM3UIEXTPROC)proc("glProgramUniform3uiEXT");
	gleswProgramUniform3uivEXT = (PFNGLPROGRAMUNIFORM3UIVEXTPROC)proc("glProgramUniform3uivEXT");
	gleswProgramUniform4fEXT = (PFNGLPROGRAMUNIFORM4FEXTPROC)proc("glProgramUniform4fEXT");
	gleswProgramUniform4fvEXT = (PFNGLPROGRAMUNIFORM4FVEXTPROC)proc("glProgramUniform4fvEXT");
	gleswProgramUniform4iEXT = (PFNGLPROGRAMUNIFORM4IEXTPROC)proc("glProgramUniform4iEXT");
	gleswProgramUniform4ivEXT = (PFNGLPROGRAMUNIFORM4IVEXTPROC)proc("glProgramUniform4ivEXT");
	gleswProgramUniform4uiEXT = (PFNGLPROGRAMUNIFORM4UIEXTPROC)proc("glProgramUniform4uiEXT");
	gleswProgramUniform4uivEXT = (PFNGLPROGRAMUNIFORM4UIVEXTPROC)proc("glProgramUniform4uivEXT");
	gleswProgramUniformHandleui64NV = (PFNGLPROGRAMUNIFORMHANDLEUI64NVPROC)proc("glProgramUniformHandleui64NV");
	gleswProgramUniformHandleui64vNV = (PFNGLPROGRAMUNIFORMHANDLEUI64VNVPROC)proc("glProgramUniformHandleui64vNV");
	gleswProgramUniformMatrix2fvEXT = (PFNGLPROGRAMUNIFORMMATRIX2FVEXTPROC)proc("glProgramUniformMatrix2fvEXT");
	gleswProgramUniformMatrix2x3fvEXT = (PFNGLPROGRAMUNIFORMMATRIX2X3FVEXTPROC)proc("glProgramUniformMatrix2x3fvEXT");
	gleswProgramUniformMatrix2x4fvEXT = (PFNGLPROGRAMUNIFORMMATRIX2X4FVEXTPROC)proc("glProgramUniformMatrix2x4fvEXT");
	gleswProgramUniformMatrix3fvEXT = (PFNGLPROGRAMUNIFORMMATRIX3FVEXTPROC)proc("glProgramUniformMatrix3fvEXT");
	gleswProgramUniformMatrix3x2fvEXT = (PFNGLPROGRAMUNIFORMMATRIX3X2FVEXTPROC)proc("glProgramUniformMatrix3x2fvEXT");
	gleswProgramUniformMatrix3x4fvEXT = (PFNGLPROGRAMUNIFORMMATRIX3X4FVEXTPROC)proc("glProgramUniformMatrix3x4fvEXT");
	gleswProgramUniformMatrix4fvEXT = (PFNGLPROGRAMUNIFORMMATRIX4FVEXTPROC)proc("glProgramUniformMatrix4fvEXT");
	gleswProgramUniformMatrix4x2fvEXT = (PFNGLPROGRAMUNIFORMMATRIX4X2FVEXTPROC)proc("glProgramUniformMatrix4x2fvEXT");
	gleswProgramUniformMatrix4x3fvEXT = (PFNGLPROGRAMUNIFORMMATRIX4X3FVEXTPROC)proc("glProgramUniformMatrix4x3fvEXT");
	gleswPushDebugGroupKHR = (PFNGLPUSHDEBUGGROUPKHRPROC)proc("glPushDebugGroupKHR");
	gleswPushGroupMarkerEXT = (PFNGLPUSHGROUPMARKEREXTPROC)proc("glPushGroupMarkerEXT");
	gleswQueryCounterEXT = (PFNGLQUERYCOUNTEREXTPROC)proc("glQueryCounterEXT");
	gleswRasterSamplesEXT = (PFNGLRASTERSAMPLESEXTPROC)proc("glRasterSamplesEXT");
	gleswReadBuffer = (PFNGLREADBUFFERPROC)proc("glReadBuffer");
	gleswReadBufferIndexedEXT = (PFNGLREADBUFFERINDEXEDEXTPROC)proc("glReadBufferIndexedEXT");
	gleswReadBufferNV = (PFNGLREADBUFFERNVPROC)proc("glReadBufferNV");
	gleswReadPixels = (PFNGLREADPIXELSPROC)proc("glReadPixels");
	gleswReadnPixelsEXT = (PFNGLREADNPIXELSEXTPROC)proc("glReadnPixelsEXT");
	gleswReadnPixelsKHR = (PFNGLREADNPIXELSKHRPROC)proc("glReadnPixelsKHR");
	gleswReleaseShaderCompiler = (PFNGLRELEASESHADERCOMPILERPROC)proc("glReleaseShaderCompiler");
	gleswRenderbufferStorage = (PFNGLRENDERBUFFERSTORAGEPROC)proc("glRenderbufferStorage");
	gleswRenderbufferStorageMultisample = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC)proc("glRenderbufferStorageMultisample");
	gleswRenderbufferStorageMultisampleANGLE = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLEANGLEPROC)proc("glRenderbufferStorageMultisampleANGLE");
	gleswRenderbufferStorageMultisampleAPPLE = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLEAPPLEPROC)proc("glRenderbufferStorageMultisampleAPPLE");
	gleswRenderbufferStorageMultisampleEXT = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC)proc("glRenderbufferStorageMultisampleEXT");
	gleswRenderbufferStorageMultisampleIMG = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLEIMGPROC)proc("glRenderbufferStorageMultisampleIMG");
	gleswRenderbufferStorageMultisampleNV = (PFNGLRENDERBUFFERSTORAGEMULTISAMPLENVPROC)proc("glRenderbufferStorageMultisampleNV");
	gleswResolveDepthValuesNV = (PFNGLRESOLVEDEPTHVALUESNVPROC)proc("glResolveDepthValuesNV");
	gleswResolveMultisampleFramebufferAPPLE = (PFNGLRESOLVEMULTISAMPLEFRAMEBUFFERAPPLEPROC)proc("glResolveMultisampleFramebufferAPPLE");
	gleswResumeTransformFeedback = (PFNGLRESUMETRANSFORMFEEDBACKPROC)proc("glResumeTransformFeedback");
	gleswSampleCoverage = (PFNGLSAMPLECOVERAGEPROC)proc("glSampleCoverage");
	gleswSamplerParameterIivEXT = (PFNGLSAMPLERPARAMETERIIVEXTPROC)proc("glSamplerParameterIivEXT");
	gleswSamplerParameterIivOES = (PFNGLSAMPLERPARAMETERIIVOESPROC)proc("glSamplerParameterIivOES");
	gleswSamplerParameterIuivEXT = (PFNGLSAMPLERPARAMETERIUIVEXTPROC)proc("glSamplerParameterIuivEXT");
	gleswSamplerParameterIuivOES = (PFNGLSAMPLERPARAMETERIUIVOESPROC)proc("glSamplerParameterIuivOES");
	gleswSamplerParameterf = (PFNGLSAMPLERPARAMETERFPROC)proc("glSamplerParameterf");
	gleswSamplerParameterfv = (PFNGLSAMPLERPARAMETERFVPROC)proc("glSamplerParameterfv");
	gleswSamplerParameteri = (PFNGLSAMPLERPARAMETERIPROC)proc("glSamplerParameteri");
	gleswSamplerParameteriv = (PFNGLSAMPLERPARAMETERIVPROC)proc("glSamplerParameteriv");
	gleswScissor = (PFNGLSCISSORPROC)proc("glScissor");
	gleswScissorArrayvNV = (PFNGLSCISSORARRAYVNVPROC)proc("glScissorArrayvNV");
	gleswScissorIndexedNV = (PFNGLSCISSORINDEXEDNVPROC)proc("glScissorIndexedNV");
	gleswScissorIndexedvNV = (PFNGLSCISSORINDEXEDVNVPROC)proc("glScissorIndexedvNV");
	gleswSelectPerfMonitorCountersAMD = (PFNGLSELECTPERFMONITORCOUNTERSAMDPROC)proc("glSelectPerfMonitorCountersAMD");
	gleswSetFenceNV = (PFNGLSETFENCENVPROC)proc("glSetFenceNV");
	gleswShaderBinary = (PFNGLSHADERBINARYPROC)proc("glShaderBinary");
	gleswShaderSource = (PFNGLSHADERSOURCEPROC)proc("glShaderSource");
	gleswStartTilingQCOM = (PFNGLSTARTTILINGQCOMPROC)proc("glStartTilingQCOM");
	gleswStencilFillPathInstancedNV = (PFNGLSTENCILFILLPATHINSTANCEDNVPROC)proc("glStencilFillPathInstancedNV");
	gleswStencilFillPathNV = (PFNGLSTENCILFILLPATHNVPROC)proc("glStencilFillPathNV");
	gleswStencilFunc = (PFNGLSTENCILFUNCPROC)proc("glStencilFunc");
	gleswStencilFuncSeparate = (PFNGLSTENCILFUNCSEPARATEPROC)proc("glStencilFuncSeparate");
	gleswStencilMask = (PFNGLSTENCILMASKPROC)proc("glStencilMask");
	gleswStencilMaskSeparate = (PFNGLSTENCILMASKSEPARATEPROC)proc("glStencilMaskSeparate");
	gleswStencilOp = (PFNGLSTENCILOPPROC)proc("glStencilOp");
	gleswStencilOpSeparate = (PFNGLSTENCILOPSEPARATEPROC)proc("glStencilOpSeparate");
	gleswStencilStrokePathInstancedNV = (PFNGLSTENCILSTROKEPATHINSTANCEDNVPROC)proc("glStencilStrokePathInstancedNV");
	gleswStencilStrokePathNV = (PFNGLSTENCILSTROKEPATHNVPROC)proc("glStencilStrokePathNV");
	gleswStencilThenCoverFillPathInstancedNV = (PFNGLSTENCILTHENCOVERFILLPATHINSTANCEDNVPROC)proc("glStencilThenCoverFillPathInstancedNV");
	gleswStencilThenCoverFillPathNV = (PFNGLSTENCILTHENCOVERFILLPATHNVPROC)proc("glStencilThenCoverFillPathNV");
	gleswStencilThenCoverStrokePathInstancedNV = (PFNGLSTENCILTHENCOVERSTROKEPATHINSTANCEDNVPROC)proc("glStencilThenCoverStrokePathInstancedNV");
	gleswStencilThenCoverStrokePathNV = (PFNGLSTENCILTHENCOVERSTROKEPATHNVPROC)proc("glStencilThenCoverStrokePathNV");
	gleswSubpixelPrecisionBiasNV = (PFNGLSUBPIXELPRECISIONBIASNVPROC)proc("glSubpixelPrecisionBiasNV");
	gleswTestFenceNV = (PFNGLTESTFENCENVPROC)proc("glTestFenceNV");
	gleswTexBufferEXT = (PFNGLTEXBUFFEREXTPROC)proc("glTexBufferEXT");
	gleswTexBufferOES = (PFNGLTEXBUFFEROESPROC)proc("glTexBufferOES");
	gleswTexBufferRangeEXT = (PFNGLTEXBUFFERRANGEEXTPROC)proc("glTexBufferRangeEXT");
	gleswTexBufferRangeOES = (PFNGLTEXBUFFERRANGEOESPROC)proc("glTexBufferRangeOES");
	gleswTexImage2D = (PFNGLTEXIMAGE2DPROC)proc("glTexImage2D");
	gleswTexImage3D = (PFNGLTEXIMAGE3DPROC)proc("glTexImage3D");
	gleswTexImage3DOES = (PFNGLTEXIMAGE3DOESPROC)proc("glTexImage3DOES");
	gleswTexPageCommitmentEXT = (PFNGLTEXPAGECOMMITMENTEXTPROC)proc("glTexPageCommitmentEXT");
	gleswTexParameterIivEXT = (PFNGLTEXPARAMETERIIVEXTPROC)proc("glTexParameterIivEXT");
	gleswTexParameterIivOES = (PFNGLTEXPARAMETERIIVOESPROC)proc("glTexParameterIivOES");
	gleswTexParameterIuivEXT = (PFNGLTEXPARAMETERIUIVEXTPROC)proc("glTexParameterIuivEXT");
	gleswTexParameterIuivOES = (PFNGLTEXPARAMETERIUIVOESPROC)proc("glTexParameterIuivOES");
	gleswTexParameterf = (PFNGLTEXPARAMETERFPROC)proc("glTexParameterf");
	gleswTexParameterfv = (PFNGLTEXPARAMETERFVPROC)proc("glTexParameterfv");
	gleswTexParameteri = (PFNGLTEXPARAMETERIPROC)proc("glTexParameteri");
	gleswTexParameteriv = (PFNGLTEXPARAMETERIVPROC)proc("glTexParameteriv");
	gleswTexStorage1DEXT = (PFNGLTEXSTORAGE1DEXTPROC)proc("glTexStorage1DEXT");
	gleswTexStorage2D = (PFNGLTEXSTORAGE2DPROC)proc("glTexStorage2D");
	gleswTexStorage2DEXT = (PFNGLTEXSTORAGE2DEXTPROC)proc("glTexStorage2DEXT");
	gleswTexStorage3D = (PFNGLTEXSTORAGE3DPROC)proc("glTexStorage3D");
	gleswTexStorage3DEXT = (PFNGLTEXSTORAGE3DEXTPROC)proc("glTexStorage3DEXT");
	gleswTexStorage3DMultisampleOES = (PFNGLTEXSTORAGE3DMULTISAMPLEOESPROC)proc("glTexStorage3DMultisampleOES");
	gleswTexSubImage2D = (PFNGLTEXSUBIMAGE2DPROC)proc("glTexSubImage2D");
	gleswTexSubImage3D = (PFNGLTEXSUBIMAGE3DPROC)proc("glTexSubImage3D");
	gleswTexSubImage3DOES = (PFNGLTEXSUBIMAGE3DOESPROC)proc("glTexSubImage3DOES");
	gleswTextureStorage1DEXT = (PFNGLTEXTURESTORAGE1DEXTPROC)proc("glTextureStorage1DEXT");
	gleswTextureStorage2DEXT = (PFNGLTEXTURESTORAGE2DEXTPROC)proc("glTextureStorage2DEXT");
	gleswTextureStorage3DEXT = (PFNGLTEXTURESTORAGE3DEXTPROC)proc("glTextureStorage3DEXT");
	gleswTextureViewEXT = (PFNGLTEXTUREVIEWEXTPROC)proc("glTextureViewEXT");
	gleswTextureViewOES = (PFNGLTEXTUREVIEWOESPROC)proc("glTextureViewOES");
	gleswTransformFeedbackVaryings = (PFNGLTRANSFORMFEEDBACKVARYINGSPROC)proc("glTransformFeedbackVaryings");
	gleswTransformPathNV = (PFNGLTRANSFORMPATHNVPROC)proc("glTransformPathNV");
	gleswUniform1f = (PFNGLUNIFORM1FPROC)proc("glUniform1f");
	gleswUniform1fv = (PFNGLUNIFORM1FVPROC)proc("glUniform1fv");
	gleswUniform1i = (PFNGLUNIFORM1IPROC)proc("glUniform1i");
	gleswUniform1iv = (PFNGLUNIFORM1IVPROC)proc("glUniform1iv");
	gleswUniform1ui = (PFNGLUNIFORM1UIPROC)proc("glUniform1ui");
	gleswUniform1uiv = (PFNGLUNIFORM1UIVPROC)proc("glUniform1uiv");
	gleswUniform2f = (PFNGLUNIFORM2FPROC)proc("glUniform2f");
	gleswUniform2fv = (PFNGLUNIFORM2FVPROC)proc("glUniform2fv");
	gleswUniform2i = (PFNGLUNIFORM2IPROC)proc("glUniform2i");
	gleswUniform2iv = (PFNGLUNIFORM2IVPROC)proc("glUniform2iv");
	gleswUniform2ui = (PFNGLUNIFORM2UIPROC)proc("glUniform2ui");
	gleswUniform2uiv = (PFNGLUNIFORM2UIVPROC)proc("glUniform2uiv");
	gleswUniform3f = (PFNGLUNIFORM3FPROC)proc("glUniform3f");
	gleswUniform3fv = (PFNGLUNIFORM3FVPROC)proc("glUniform3fv");
	gleswUniform3i = (PFNGLUNIFORM3IPROC)proc("glUniform3i");
	gleswUniform3iv = (PFNGLUNIFORM3IVPROC)proc("glUniform3iv");
	gleswUniform3ui = (PFNGLUNIFORM3UIPROC)proc("glUniform3ui");
	gleswUniform3uiv = (PFNGLUNIFORM3UIVPROC)proc("glUniform3uiv");
	gleswUniform4f = (PFNGLUNIFORM4FPROC)proc("glUniform4f");
	gleswUniform4fv = (PFNGLUNIFORM4FVPROC)proc("glUniform4fv");
	gleswUniform4i = (PFNGLUNIFORM4IPROC)proc("glUniform4i");
	gleswUniform4iv = (PFNGLUNIFORM4IVPROC)proc("glUniform4iv");
	gleswUniform4ui = (PFNGLUNIFORM4UIPROC)proc("glUniform4ui");
	gleswUniform4uiv = (PFNGLUNIFORM4UIVPROC)proc("glUniform4uiv");
	gleswUniformBlockBinding = (PFNGLUNIFORMBLOCKBINDINGPROC)proc("glUniformBlockBinding");
	gleswUniformHandleui64NV = (PFNGLUNIFORMHANDLEUI64NVPROC)proc("glUniformHandleui64NV");
	gleswUniformHandleui64vNV = (PFNGLUNIFORMHANDLEUI64VNVPROC)proc("glUniformHandleui64vNV");
	gleswUniformMatrix2fv = (PFNGLUNIFORMMATRIX2FVPROC)proc("glUniformMatrix2fv");
	gleswUniformMatrix2x3fv = (PFNGLUNIFORMMATRIX2X3FVPROC)proc("glUniformMatrix2x3fv");
	gleswUniformMatrix2x3fvNV = (PFNGLUNIFORMMATRIX2X3FVNVPROC)proc("glUniformMatrix2x3fvNV");
	gleswUniformMatrix2x4fv = (PFNGLUNIFORMMATRIX2X4FVPROC)proc("glUniformMatrix2x4fv");
	gleswUniformMatrix2x4fvNV = (PFNGLUNIFORMMATRIX2X4FVNVPROC)proc("glUniformMatrix2x4fvNV");
	gleswUniformMatrix3fv = (PFNGLUNIFORMMATRIX3FVPROC)proc("glUniformMatrix3fv");
	gleswUniformMatrix3x2fv = (PFNGLUNIFORMMATRIX3X2FVPROC)proc("glUniformMatrix3x2fv");
	gleswUniformMatrix3x2fvNV = (PFNGLUNIFORMMATRIX3X2FVNVPROC)proc("glUniformMatrix3x2fvNV");
	gleswUniformMatrix3x4fv = (PFNGLUNIFORMMATRIX3X4FVPROC)proc("glUniformMatrix3x4fv");
	gleswUniformMatrix3x4fvNV = (PFNGLUNIFORMMATRIX3X4FVNVPROC)proc("glUniformMatrix3x4fvNV");
	gleswUniformMatrix4fv = (PFNGLUNIFORMMATRIX4FVPROC)proc("glUniformMatrix4fv");
	gleswUniformMatrix4x2fv = (PFNGLUNIFORMMATRIX4X2FVPROC)proc("glUniformMatrix4x2fv");
	gleswUniformMatrix4x2fvNV = (PFNGLUNIFORMMATRIX4X2FVNVPROC)proc("glUniformMatrix4x2fvNV");
	gleswUniformMatrix4x3fv = (PFNGLUNIFORMMATRIX4X3FVPROC)proc("glUniformMatrix4x3fv");
	gleswUniformMatrix4x3fvNV = (PFNGLUNIFORMMATRIX4X3FVNVPROC)proc("glUniformMatrix4x3fvNV");
	gleswUnmapBuffer = (PFNGLUNMAPBUFFERPROC)proc("glUnmapBuffer");
	gleswUnmapBufferOES = (PFNGLUNMAPBUFFEROESPROC)proc("glUnmapBufferOES");
	gleswUseProgram = (PFNGLUSEPROGRAMPROC)proc("glUseProgram");
	gleswUseProgramStagesEXT = (PFNGLUSEPROGRAMSTAGESEXTPROC)proc("glUseProgramStagesEXT");
	gleswValidateProgram = (PFNGLVALIDATEPROGRAMPROC)proc("glValidateProgram");
	gleswValidateProgramPipelineEXT = (PFNGLVALIDATEPROGRAMPIPELINEEXTPROC)proc("glValidateProgramPipelineEXT");
	gleswVertexAttrib1f = (PFNGLVERTEXATTRIB1FPROC)proc("glVertexAttrib1f");
	gleswVertexAttrib1fv = (PFNGLVERTEXATTRIB1FVPROC)proc("glVertexAttrib1fv");
	gleswVertexAttrib2f = (PFNGLVERTEXATTRIB2FPROC)proc("glVertexAttrib2f");
	gleswVertexAttrib2fv = (PFNGLVERTEXATTRIB2FVPROC)proc("glVertexAttrib2fv");
	gleswVertexAttrib3f = (PFNGLVERTEXATTRIB3FPROC)proc("glVertexAttrib3f");
	gleswVertexAttrib3fv = (PFNGLVERTEXATTRIB3FVPROC)proc("glVertexAttrib3fv");
	gleswVertexAttrib4f = (PFNGLVERTEXATTRIB4FPROC)proc("glVertexAttrib4f");
	gleswVertexAttrib4fv = (PFNGLVERTEXATTRIB4FVPROC)proc("glVertexAttrib4fv");
	gleswVertexAttribDivisor = (PFNGLVERTEXATTRIBDIVISORPROC)proc("glVertexAttribDivisor");
	gleswVertexAttribDivisorANGLE = (PFNGLVERTEXATTRIBDIVISORANGLEPROC)proc("glVertexAttribDivisorANGLE");
	gleswVertexAttribDivisorEXT = (PFNGLVERTEXATTRIBDIVISOREXTPROC)proc("glVertexAttribDivisorEXT");
	gleswVertexAttribDivisorNV = (PFNGLVERTEXATTRIBDIVISORNVPROC)proc("glVertexAttribDivisorNV");
	gleswVertexAttribI4i = (PFNGLVERTEXATTRIBI4IPROC)proc("glVertexAttribI4i");
	gleswVertexAttribI4iv = (PFNGLVERTEXATTRIBI4IVPROC)proc("glVertexAttribI4iv");
	gleswVertexAttribI4ui = (PFNGLVERTEXATTRIBI4UIPROC)proc("glVertexAttribI4ui");
	gleswVertexAttribI4uiv = (PFNGLVERTEXATTRIBI4UIVPROC)proc("glVertexAttribI4uiv");
	gleswVertexAttribIPointer = (PFNGLVERTEXATTRIBIPOINTERPROC)proc("glVertexAttribIPointer");
	gleswVertexAttribPointer = (PFNGLVERTEXATTRIBPOINTERPROC)proc("glVertexAttribPointer");
	gleswViewport = (PFNGLVIEWPORTPROC)proc("glViewport");
	gleswViewportArrayvNV = (PFNGLVIEWPORTARRAYVNVPROC)proc("glViewportArrayvNV");
	gleswViewportIndexedfNV = (PFNGLVIEWPORTINDEXEDFNVPROC)proc("glViewportIndexedfNV");
	gleswViewportIndexedfvNV = (PFNGLVIEWPORTINDEXEDFVNVPROC)proc("glViewportIndexedfvNV");
	gleswWaitSync = (PFNGLWAITSYNCPROC)proc("glWaitSync");
	gleswWaitSyncAPPLE = (PFNGLWAITSYNCAPPLEPROC)proc("glWaitSyncAPPLE");
	gleswWeightPathsNV = (PFNGLWEIGHTPATHSNVPROC)proc("glWeightPathsNV");
}
