/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLBlendFuncExtended.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

class JSWebGLBlendFuncExtendedPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLBlendFuncExtendedPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLBlendFuncExtendedPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLBlendFuncExtendedPrototype>(vm)) JSWebGLBlendFuncExtendedPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLBlendFuncExtendedPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLBlendFuncExtendedPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLBlendFuncExtendedPrototype, JSWebGLBlendFuncExtendedPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLBlendFuncExtendedPrototypeTableValues[] =
{
    { "SRC1_COLOR_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x88F9 } },
    { "SRC1_ALPHA_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8589 } },
    { "ONE_MINUS_SRC1_COLOR_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x88FA } },
    { "ONE_MINUS_SRC1_ALPHA_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x88FB } },
    { "MAX_DUAL_SOURCE_DRAW_BUFFERS_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x88FC } },
};

const ClassInfo JSWebGLBlendFuncExtendedPrototype::s_info = { "WebGLBlendFuncExtended"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLBlendFuncExtendedPrototype) };

void JSWebGLBlendFuncExtendedPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLBlendFuncExtended::info(), JSWebGLBlendFuncExtendedPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLBlendFuncExtended::s_info = { "WebGLBlendFuncExtended"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLBlendFuncExtended) };

JSWebGLBlendFuncExtended::JSWebGLBlendFuncExtended(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLBlendFuncExtended>&& impl)
    : JSDOMWrapper<WebGLBlendFuncExtended>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLBlendFuncExtended>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLBlendFuncExtended::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLBlendFuncExtendedPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLBlendFuncExtendedPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLBlendFuncExtended::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLBlendFuncExtended>(vm, globalObject);
}

void JSWebGLBlendFuncExtended::destroy(JSC::JSCell* cell)
{
    JSWebGLBlendFuncExtended* thisObject = static_cast<JSWebGLBlendFuncExtended*>(cell);
    thisObject->JSWebGLBlendFuncExtended::~JSWebGLBlendFuncExtended();
}

JSC::GCClient::IsoSubspace* JSWebGLBlendFuncExtended::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLBlendFuncExtended, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLBlendFuncExtended.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLBlendFuncExtended = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLBlendFuncExtended.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLBlendFuncExtended = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLBlendFuncExtended::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLBlendFuncExtended*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLBlendFuncExtendedOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsWebGLBlendFuncExtended = jsCast<JSWebGLBlendFuncExtended*>(handle.slot()->asCell());
    auto& owner = jsWebGLBlendFuncExtended->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsWebGLBlendFuncExtended"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLBlendFuncExtendedOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLBlendFuncExtended = static_cast<JSWebGLBlendFuncExtended*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLBlendFuncExtended->protectedWrapped().ptr(), jsWebGLBlendFuncExtended);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLBlendFuncExtended@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22WebGLBlendFuncExtendedE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, WebGLBlendFuncExtended>, void>> static inline void verifyVTable(WebGLBlendFuncExtended* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLBlendFuncExtended@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore22WebGLBlendFuncExtendedE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLBlendFuncExtended has subclasses. If WebGLBlendFuncExtended has subclasses that get passed
        // to toJS() we currently require WebGLBlendFuncExtended you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLBlendFuncExtended>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebGLBlendFuncExtended>(impl.ptr());
#endif
    return createWrapper<WebGLBlendFuncExtended>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLBlendFuncExtended& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLBlendFuncExtended* JSWebGLBlendFuncExtended::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLBlendFuncExtended*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
