/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(VIDEO)

#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "MediaControlsHost.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class JSMediaControlsHost : public JSDOMWrapper<MediaControlsHost> {
public:
    using Base = JSDOMWrapper<MediaControlsHost>;
    static JSMediaControlsHost* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<MediaControlsHost>&& impl)
    {
        auto& vm = globalObject->vm();
        JSMediaControlsHost* ptr = new (NotNull, JSC::allocateCell<JSMediaControlsHost>(vm)) JSMediaControlsHost(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(vm);
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static MediaControlsHost* toWrapped(JSC::VM&, JSC::JSValue);
    static void destroy(JSC::JSCell*);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info(), JSC::NonArray);
    }

    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
protected:
    JSMediaControlsHost(JSC::Structure*, JSDOMGlobalObject&, Ref<MediaControlsHost>&&);

    DECLARE_DEFAULT_FINISH_CREATION;
};

class JSMediaControlsHostOwner final : public JSC::WeakHandleOwner {
public:
    bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::AbstractSlotVisitor&, ASCIILiteral*) final;
    void finalize(JSC::Handle<JSC::Unknown>, void* context) final;
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, MediaControlsHost*)
{
    static NeverDestroyed<JSMediaControlsHostOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(MediaControlsHost* wrappableObject)
{
    return wrappableObject;
}

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, MediaControlsHost&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaControlsHost* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<MediaControlsHost>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<MediaControlsHost>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<MediaControlsHost> {
    using WrapperClass = JSMediaControlsHost;
    using ToWrappedReturnType = MediaControlsHost*;
};
String convertEnumerationToString(MediaControlsHost::DeviceType);
template<> JSC::JSString* convertEnumerationToJS(JSC::VM&, MediaControlsHost::DeviceType);

template<> std::optional<MediaControlsHost::DeviceType> parseEnumerationFromString<MediaControlsHost::DeviceType>(const String&);
template<> std::optional<MediaControlsHost::DeviceType> parseEnumeration<MediaControlsHost::DeviceType>(JSC::JSGlobalObject&, JSC::JSValue);
template<> ASCIILiteral expectedEnumerationValues<MediaControlsHost::DeviceType>();

#if ENABLE(MODERN_MEDIA_CONTROLS)

String convertEnumerationToString(MediaControlsHost::SourceType);
template<> JSC::JSString* convertEnumerationToJS(JSC::VM&, MediaControlsHost::SourceType);

template<> std::optional<MediaControlsHost::SourceType> parseEnumerationFromString<MediaControlsHost::SourceType>(const String&);
template<> std::optional<MediaControlsHost::SourceType> parseEnumeration<MediaControlsHost::SourceType>(JSC::JSGlobalObject&, JSC::JSValue);
template<> ASCIILiteral expectedEnumerationValues<MediaControlsHost::SourceType>();

#endif


} // namespace WebCore

#endif // ENABLE(VIDEO)
