/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGetHTMLOptions.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSShadowRoot.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GetHTMLOptions>> convertDictionary<GetHTMLOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GetHTMLOptions result;
    JSValue serializableShadowRootsValue;
    if (isNullOrUndefined)
        serializableShadowRootsValue = jsUndefined();
    else {
        serializableShadowRootsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "serializableShadowRoots"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto serializableShadowRootsConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, serializableShadowRootsValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(serializableShadowRootsConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.serializableShadowRoots = serializableShadowRootsConversionResult.releaseReturnValue();
    JSValue shadowRootsValue;
    if (isNullOrUndefined)
        shadowRootsValue = jsUndefined();
    else {
        shadowRootsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "shadowRoots"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto shadowRootsConversionResult = convertOptionalWithDefault<IDLSequence<IDLInterface<ShadowRoot>>>(lexicalGlobalObject, shadowRootsValue, [&]() -> ConversionResult<IDLSequence<IDLInterface<ShadowRoot>>> { return Converter<IDLSequence<IDLInterface<ShadowRoot>>>::ReturnType { }; });
    if (UNLIKELY(shadowRootsConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.shadowRoots = shadowRootsConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
