/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.sf.fmj.media.rtp.RTCPAPPPacket;
import net.sf.fmj.media.rtp.RTCPBYEPacket;
import net.sf.fmj.media.rtp.RTCPCompoundPacket;
import net.sf.fmj.media.rtp.RTCPPacket;
import net.sf.fmj.media.rtp.RTCPPacketParserListener;
import net.sf.fmj.media.rtp.RTCPRRPacket;
import net.sf.fmj.media.rtp.RTCPReportBlock;
import net.sf.fmj.media.rtp.RTCPSDES;
import net.sf.fmj.media.rtp.RTCPSDESItem;
import net.sf.fmj.media.rtp.RTCPSDESPacket;
import net.sf.fmj.media.rtp.RTCPSRPacket;
import net.sf.fmj.media.rtp.util.BadFormatException;
import net.sf.fmj.media.rtp.util.BadVersionException;
import net.sf.fmj.media.rtp.util.Packet;

public class RTCPPacketParser {
    private final List<RTCPPacketParserListener> listeners = new ArrayList<RTCPPacketParserListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRTCPPacketParserListener(RTCPPacketParserListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        List<RTCPPacketParserListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onEnterSenderReport() {
        List<RTCPPacketParserListener> list = this.listeners;
        synchronized (list) {
            for (RTCPPacketParserListener l : this.listeners) {
                l.enterSenderReport();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMalformedEndOfParticipation() {
        List<RTCPPacketParserListener> list = this.listeners;
        synchronized (list) {
            for (RTCPPacketParserListener l : this.listeners) {
                l.malformedEndOfParticipation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMalformedReceiverReport() {
        List<RTCPPacketParserListener> list = this.listeners;
        synchronized (list) {
            for (RTCPPacketParserListener l : this.listeners) {
                l.malformedReceiverReport();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMalformedSenderReport() {
        List<RTCPPacketParserListener> list = this.listeners;
        synchronized (list) {
            for (RTCPPacketParserListener l : this.listeners) {
                l.malformedSenderReport();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onMalformedSourceDescription() {
        List<RTCPPacketParserListener> list = this.listeners;
        synchronized (list) {
            for (RTCPPacketParserListener l : this.listeners) {
                l.malformedSourceDescription();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPayloadUknownType() {
        List<RTCPPacketParserListener> list = this.listeners;
        synchronized (list) {
            for (RTCPPacketParserListener l : this.listeners) {
                l.uknownPayloadType();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onVisitSenderReport(RTCPSRPacket rtcpSRPacket) {
        List<RTCPPacketParserListener> list = this.listeners;
        synchronized (list) {
            for (RTCPPacketParserListener l : this.listeners) {
                l.visitSendeReport(rtcpSRPacket);
            }
        }
    }

    public RTCPPacket parse(Packet packet) throws BadFormatException {
        RTCPCompoundPacket base = new RTCPCompoundPacket(packet);
        Vector<RTCPSDESPacket> subpackets = new Vector<RTCPSDESPacket>(2);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(base.data, base.offset, base.length));
        try {
            int length;
            for (int offset = 0; offset < base.length; offset += length) {
                RTCPPacket p;
                int firstbyte = in.readUnsignedByte();
                if ((firstbyte & 0xC0) != 128) {
                    throw new BadVersionException("version must be 2. (base.length " + base.length + ", base.offset " + base.offset + ", firstbyte 0x" + Integer.toHexString(firstbyte) + ", offset " + offset + ")");
                }
                int type = in.readUnsignedByte();
                length = in.readUnsignedShort();
                if (offset + (length = length + 1 << 2) > base.length) {
                    throw new BadFormatException("Packet length less than actual packet length");
                }
                int padlen = 0;
                if (offset + length == base.length) {
                    if ((firstbyte & 0x20) != 0 && (padlen = base.data[base.offset + base.length - 1] & 0xFF) == 0) {
                        throw new BadFormatException();
                    }
                } else if ((firstbyte & 0x20) != 0) {
                    throw new BadFormatException("No padding found.");
                }
                int inlength = length - padlen;
                firstbyte &= 0x1F;
                switch (type) {
                    case 200: {
                        this.onEnterSenderReport();
                        if (inlength != 28 + 24 * firstbyte) {
                            this.onMalformedSenderReport();
                            System.out.println("bad format.");
                            throw new BadFormatException("inlength != 28 + 24 * firstbyte");
                        }
                        RTCPSRPacket srp = new RTCPSRPacket(base);
                        p = srp;
                        srp.ssrc = in.readInt();
                        srp.ntptimestampmsw = (long)in.readInt() & 0xFFFFFFFFL;
                        srp.ntptimestamplsw = (long)in.readInt() & 0xFFFFFFFFL;
                        srp.rtptimestamp = (long)in.readInt() & 0xFFFFFFFFL;
                        srp.packetcount = (long)in.readInt() & 0xFFFFFFFFL;
                        srp.octetcount = (long)in.readInt() & 0xFFFFFFFFL;
                        srp.reports = new RTCPReportBlock[firstbyte];
                        this.onVisitSenderReport(srp);
                        this.readRTCPReportBlock(in, srp.reports);
                        break;
                    }
                    case 201: {
                        if (inlength != 8 + 24 * firstbyte) {
                            this.onMalformedReceiverReport();
                            throw new BadFormatException("inlength != 8 + 24 * firstbyte");
                        }
                        RTCPRRPacket rrp = new RTCPRRPacket(base);
                        p = rrp;
                        rrp.ssrc = in.readInt();
                        rrp.reports = new RTCPReportBlock[firstbyte];
                        this.readRTCPReportBlock(in, rrp.reports);
                        break;
                    }
                    case 202: {
                        RTCPSDESPacket sdesp;
                        p = sdesp = new RTCPSDESPacket(base);
                        sdesp.sdes = new RTCPSDES[firstbyte];
                        int sdesoff = 4;
                        for (int i = 0; i < sdesp.sdes.length; ++i) {
                            int j;
                            RTCPSDES chunk;
                            sdesp.sdes[i] = chunk = new RTCPSDES();
                            chunk.ssrc = in.readInt();
                            sdesoff += 5;
                            Vector<RTCPSDESItem> items = new Vector<RTCPSDESItem>();
                            boolean gotcname = false;
                            while ((j = in.readUnsignedByte()) != 0) {
                                if (j < 1 || j > 8) {
                                    this.onMalformedSourceDescription();
                                    throw new BadFormatException("j < 1 || j > 8");
                                }
                                if (j == 1) {
                                    gotcname = true;
                                }
                                RTCPSDESItem item = new RTCPSDESItem();
                                items.addElement(item);
                                item.type = j;
                                int sdeslen = in.readUnsignedByte();
                                item.data = new byte[sdeslen];
                                in.readFully(item.data);
                                sdesoff += 2 + sdeslen;
                            }
                            if (!gotcname) {
                                this.onMalformedSourceDescription();
                                throw new BadFormatException("!gotcname");
                            }
                            chunk.items = new RTCPSDESItem[items.size()];
                            items.copyInto(chunk.items);
                            if ((sdesoff & 3) == 0) continue;
                            in.skip(4 - (sdesoff & 3));
                            sdesoff = sdesoff + 3 & 0xFFFFFFFC;
                        }
                        if (inlength == sdesoff) break;
                        this.onMalformedSourceDescription();
                        throw new BadFormatException("inlength != sdesoff");
                    }
                    case 203: {
                        int reasonlen;
                        RTCPBYEPacket byep = new RTCPBYEPacket(base);
                        p = byep;
                        byep.ssrc = new int[firstbyte];
                        for (int i = 0; i < byep.ssrc.length; ++i) {
                            byep.ssrc[i] = in.readInt();
                        }
                        if (inlength > 4 + 4 * firstbyte) {
                            reasonlen = in.readUnsignedByte();
                            byep.reason = new byte[reasonlen];
                            ++reasonlen;
                        } else {
                            reasonlen = 0;
                            byep.reason = new byte[0];
                        }
                        reasonlen = reasonlen + 3 & 0xFFFFFFFC;
                        if (inlength != 4 + 4 * firstbyte + reasonlen) {
                            this.onMalformedEndOfParticipation();
                            throw new BadFormatException("inlength != 4 + 4 * firstbyte + reasonlen");
                        }
                        in.readFully(byep.reason);
                        in.skip(reasonlen - byep.reason.length);
                        break;
                    }
                    case 204: {
                        if (inlength < 12) {
                            throw new BadFormatException("inlength < 12");
                        }
                        RTCPAPPPacket appp = new RTCPAPPPacket(base);
                        p = appp;
                        appp.ssrc = in.readInt();
                        appp.name = in.readInt();
                        appp.subtype = firstbyte;
                        appp.data = new byte[inlength - 12];
                        in.readFully(appp.data);
                        in.skip(inlength - 12 - appp.data.length);
                        break;
                    }
                    default: {
                        p = this.parse(base, firstbyte, type, length, in);
                        if (p != null) break;
                        this.onPayloadUknownType();
                        throw new BadFormatException("p == null");
                    }
                }
                p.offset = offset;
                p.length = length;
                subpackets.addElement((RTCPSDESPacket)p);
                in.skipBytes(padlen);
            }
        }
        catch (EOFException e) {
            throw new BadFormatException("Unexpected end of RTCP packet");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Impossible Exception");
        }
        base.packets = new RTCPPacket[subpackets.size()];
        subpackets.copyInto(base.packets);
        return base;
    }

    protected RTCPPacket parse(RTCPCompoundPacket base, int firstbyte, int type, int length, DataInputStream in) throws BadFormatException, IOException {
        this.onPayloadUknownType();
        throw new BadFormatException("Uknown payload type");
    }

    private void readRTCPReportBlock(DataInputStream in, RTCPReportBlock[] reports) throws IOException {
        for (int i = 0; i < reports.length; ++i) {
            RTCPReportBlock report;
            reports[i] = report = new RTCPReportBlock();
            report.ssrc = in.readInt();
            long val = in.readInt();
            report.fractionlost = (int)((val &= 0xFFFFFFFFL) >> 24);
            report.packetslost = (int)(val & 0xFFFFFFL);
            report.lastseq = (long)in.readInt() & 0xFFFFFFFFL;
            report.jitter = in.readInt();
            report.lsr = (long)in.readInt() & 0xFFFFFFFFL;
            report.dlsr = (long)in.readInt() & 0xFFFFFFFFL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRTCPPacketParserListener(RTCPPacketParserListener listener) {
        if (listener != null) {
            List<RTCPPacketParserListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }
}

