/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.keybindingchooser.chooser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputAdapter;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.keybindingchooser.chooser.BindingEntry;

public abstract class BindingPanel
extends TransparentPanel {
    private static final long serialVersionUID = 0L;
    private ArrayList<BindingEntry> contents = new ArrayList();

    protected abstract void onUpdate(int var1, BindingEntry var2, boolean var3);

    protected abstract void onClick(MouseEvent var1, BindingEntry var2, BindingEntry.Field var3);

    public BindingPanel() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.addMouseListener(new MouseTracker());
    }

    public boolean putBinding(int keyCode, int modifier, String action) {
        return this.putBinding(KeyStroke.getKeyStroke(keyCode, modifier), action);
    }

    public boolean putBinding(KeyStroke shortcut, String action) {
        return this.putBinding(shortcut, action, this.getComponentCount());
    }

    public boolean putBinding(KeyStroke shortcut, String action, int index) {
        return this.putBinding(new BindingEntry(shortcut, action), index);
    }

    public boolean putBinding(BindingEntry newEntry, int index) {
        if (index < 0 || index > this.getBindingCount()) {
            String message = "Attempting to add to invalid index: " + index;
            throw new IndexOutOfBoundsException(message);
        }
        KeyStroke shortcut = newEntry.getShortcut();
        if (shortcut != BindingEntry.DISABLED) {
            for (BindingEntry entry : this.contents) {
                if (!shortcut.equals(entry.getShortcut())) continue;
                entry.setAction(newEntry.getAction());
                return false;
            }
        } else if (this.contents.contains((Object)newEntry)) {
            return false;
        }
        this.contents.add(index, newEntry);
        if (index > 0) {
            BindingEntry previous = this.getBinding(index - 1);
            for (int i = this.getComponentCount() - 1; i >= 0; --i) {
                if (this.getComponent(i).equals((Object)previous)) {
                    this.add((Component)((Object)newEntry), i + 1);
                    break;
                }
                assert (i != 0) : "Listing doesn't contain expected previous entry when adding to index " + index;
            }
        } else {
            this.add((Component)((Object)newEntry), 0);
        }
        this.onUpdate(index, newEntry, true);
        for (int i = index + 1; i < this.getBindingCount(); ++i) {
            BindingEntry shifted = this.getBinding(i);
            this.onUpdate(i, shifted, false);
        }
        return true;
    }

    public void putAllBindings(Map<KeyStroke, String> bindings) {
        for (KeyStroke action : bindings.keySet()) {
            this.putBinding(action, bindings.get(action));
        }
    }

    public boolean removeBinding(BindingEntry entry) {
        int index = this.getBindingIndex(entry);
        if (index != -1) {
            return this.removeBinding(index) != null;
        }
        return false;
    }

    public BindingEntry removeBinding(int index) {
        if (index < 0 || index > this.getBindingCount()) {
            String message = "Attempting to remove from invalid index: " + index;
            throw new IndexOutOfBoundsException(message);
        }
        BindingEntry entry = this.contents.remove(index);
        this.remove((Component)((Object)entry));
        for (int i = index; i < this.getBindingCount(); ++i) {
            BindingEntry shifted = this.getBinding(i);
            this.onUpdate(i, shifted, false);
        }
        return entry;
    }

    public void clearBindings() {
        while (this.getBindingCount() > 0) {
            this.removeBinding(0);
        }
    }

    public boolean contains(KeyStroke shortcut) {
        for (BindingEntry entry : this.contents) {
            if (!(shortcut == BindingEntry.DISABLED ? entry.isDisabled() : shortcut.equals(entry.getShortcut()))) continue;
            return true;
        }
        return false;
    }

    public int getBindingCount() {
        return this.contents.size();
    }

    public int getBindingIndex(BindingEntry entry) {
        return this.contents.indexOf((Object)entry);
    }

    public BindingEntry getBinding(int index) {
        return this.contents.get(index);
    }

    public ArrayList<BindingEntry> getBindings() {
        return new ArrayList<BindingEntry>(this.contents);
    }

    public LinkedHashMap<KeyStroke, String> getBindingMap() {
        LinkedHashMap<KeyStroke, String> mapping = new LinkedHashMap<KeyStroke, String>();
        for (BindingEntry entry : this.contents) {
            if (entry.isDisabled()) continue;
            mapping.put(entry.getShortcut(), entry.getAction());
        }
        return mapping;
    }

    public InputMap getBindingInputMap() {
        InputMap mapping = new InputMap();
        LinkedHashMap<KeyStroke, String> bindingMap = this.getBindingMap();
        for (KeyStroke keystroke : bindingMap.keySet()) {
            mapping.put(keystroke, bindingMap.get(keystroke));
        }
        return mapping;
    }

    private class MouseTracker
    extends MouseInputAdapter {
        private MouseTracker() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            Point loc = event.getPoint();
            Component comp = BindingPanel.this.getComponentAt(loc);
            if (comp instanceof BindingEntry) {
                BindingEntry entry = (BindingEntry)((Object)comp);
                int x = loc.x - entry.getLocation().x;
                int y = loc.y - entry.getLocation().y;
                Component label = entry.findComponentAt(x, y);
                if (entry.getField(BindingEntry.Field.INDENT).equals(label)) {
                    BindingPanel.this.onClick(event, entry, BindingEntry.Field.INDENT);
                } else if (entry.getField(BindingEntry.Field.ACTION).equals(label)) {
                    BindingPanel.this.onClick(event, entry, BindingEntry.Field.ACTION);
                } else if (entry.getField(BindingEntry.Field.SHORTCUT).equals(label)) {
                    BindingPanel.this.onClick(event, entry, BindingEntry.Field.SHORTCUT);
                } else {
                    BindingPanel.this.onClick(event, entry, null);
                }
            }
        }
    }
}

