/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.media;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.service.protocol.AbstractCall;
import net.java.sip.communicator.service.protocol.CallConference;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.CallPeerState;
import net.java.sip.communicator.service.protocol.CallState;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallChangeListener;
import net.java.sip.communicator.service.protocol.event.CallPeerChangeEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerListener;
import net.java.sip.communicator.service.protocol.event.DTMFListener;
import net.java.sip.communicator.service.protocol.event.DTMFReceivedEvent;
import net.java.sip.communicator.service.protocol.event.SoundLevelListener;
import net.java.sip.communicator.service.protocol.media.CallPeerMediaHandler;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallConference;
import net.java.sip.communicator.service.protocol.media.MediaAwareCallPeer;
import net.java.sip.communicator.service.protocol.media.ProtocolMediaActivator;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.service.neomedia.RTPTranslator;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.event.SimpleAudioLevelListener;
import org.jitsi.service.neomedia.recording.Recorder;

public abstract class MediaAwareCall<T extends MediaAwareCallPeer<?, ?, V>, U extends OperationSetBasicTelephony<V>, V extends ProtocolProviderService>
extends AbstractCall<T, V>
implements CallPeerListener,
PropertyChangeListener,
DTMFListener {
    public static final String DEFAULT_DEVICE = "defaultDevice";
    protected boolean localVideoAllowed = false;
    protected final U parentOpSet;
    private List<SoundLevelListener> localUserAudioLevelListeners;
    private final Object localUserAudioLevelListenersSyncRoot = new Object();
    private boolean mute = false;
    protected MediaUseCase mediaUseCase = MediaUseCase.ANY;
    private final SimpleAudioLevelListener localAudioLevelDelegator = new SimpleAudioLevelListener(){

        public void audioLevelChanged(int level) {
            MediaAwareCall.this.fireLocalUserAudioLevelChangeEvent(level);
        }
    };

    protected MediaAwareCall(U parentOpSet) {
        super(parentOpSet.getProtocolProvider());
        this.parentOpSet = parentOpSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCallPeer(T callPeer) {
        if (!this.doAddCallPeer((CallPeer)callPeer)) {
            return;
        }
        callPeer.addCallPeerListener((CallPeerListener)this);
        Object object = this.localUserAudioLevelListenersSyncRoot;
        synchronized (object) {
            List callPeers = this.getCallPeerList();
            if (callPeers.size() == 1 && ((Object)((Object)((MediaAwareCallPeer)((Object)callPeers.get(0))))).equals(callPeer)) {
                ((CallPeerMediaHandler)((Object)((MediaAwareCallPeer)((Object)callPeer)).getMediaHandler())).setLocalUserAudioLevelListener(this.localAudioLevelDelegator);
            }
        }
        this.fireCallPeerEvent((CallPeer)callPeer, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCallPeer(CallPeerChangeEvent evt) {
        MediaAwareCallPeer callPeer = (MediaAwareCallPeer)evt.getSourceCallPeer();
        if (!this.doRemoveCallPeer((CallPeer)callPeer)) {
            return;
        }
        callPeer.removeCallPeerListener(this);
        Object object = this.localUserAudioLevelListenersSyncRoot;
        synchronized (object) {
            ((CallPeerMediaHandler)((Object)callPeer.getMediaHandler())).setLocalUserAudioLevelListener(null);
            List callPeers = this.getCallPeerList();
            if (!callPeers.isEmpty()) {
                ((CallPeerMediaHandler)((Object)((MediaAwareCallPeer)((Object)callPeers.get(0))).getMediaHandler())).setLocalUserAudioLevelListener(this.localAudioLevelDelegator);
            }
        }
        try {
            this.fireCallPeerEvent((CallPeer)callPeer, 2, evt.getReasonString() != null);
        }
        finally {
            callPeer.setCall(null);
        }
        if (this.getCallPeerCount() == 0) {
            this.setCallState(CallState.CALL_ENDED, evt);
        }
    }

    public void peerImageChanged(CallPeerChangeEvent evt) {
    }

    public void peerAddressChanged(CallPeerChangeEvent evt) {
    }

    public void peerTransportAddressChanged(CallPeerChangeEvent evt) {
    }

    public void peerDisplayNameChanged(CallPeerChangeEvent evt) {
    }

    public void peerStateChanged(CallPeerChangeEvent evt) {
        Object newState = evt.getNewValue();
        if (CallPeerState.DISCONNECTED.equals(newState) || CallPeerState.FAILED.equals(newState)) {
            this.removeCallPeer(evt);
        } else if (CallPeerState.CONNECTED.equals(newState) || CallPeerState.CONNECTING_WITH_EARLY_MEDIA.equals(newState)) {
            this.setCallState(CallState.CALL_IN_PROGRESS);
        } else if (CallPeerState.REFERRED.equals(newState)) {
            this.setCallState(CallState.CALL_REFERRED);
        }
    }

    public U getParentOperationSet() {
        return this.parentOpSet;
    }

    public RTPTranslator getRTPTranslator(MediaType mediaType) {
        return this.getConference().getRTPTranslator(mediaType);
    }

    public boolean isConferenceFocus() {
        return this.getConference().isConferenceFocus();
    }

    public MediaDevice getDefaultDevice(MediaType mediaType) {
        return this.getConference().getDefaultDevice(mediaType, this.mediaUseCase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalUserSoundLevelListener(SoundLevelListener l) {
        Object object = this.localUserAudioLevelListenersSyncRoot;
        synchronized (object) {
            if (this.localUserAudioLevelListeners == null || this.localUserAudioLevelListeners.isEmpty()) {
                Iterator callPeerIter = this.getCallPeers();
                while (callPeerIter.hasNext()) {
                    ((CallPeerMediaHandler)((Object)((MediaAwareCallPeer)((Object)callPeerIter.next())).getMediaHandler())).setLocalUserAudioLevelListener(this.localAudioLevelDelegator);
                }
            }
            this.localUserAudioLevelListeners = this.localUserAudioLevelListeners == null ? new ArrayList<SoundLevelListener>() : new ArrayList<SoundLevelListener>(this.localUserAudioLevelListeners);
            this.localUserAudioLevelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalUserSoundLevelListener(SoundLevelListener l) {
        Object object = this.localUserAudioLevelListenersSyncRoot;
        synchronized (object) {
            if (this.localUserAudioLevelListeners != null) {
                this.localUserAudioLevelListeners = new ArrayList<SoundLevelListener>(this.localUserAudioLevelListeners);
                if (this.localUserAudioLevelListeners.remove(l) && this.localUserAudioLevelListeners.isEmpty()) {
                    this.localUserAudioLevelListeners = null;
                }
            }
            if (this.localUserAudioLevelListeners == null || this.localUserAudioLevelListeners.isEmpty()) {
                Iterator callPeerIter = this.getCallPeers();
                while (callPeerIter.hasNext()) {
                    ((CallPeerMediaHandler)((Object)((MediaAwareCallPeer)((Object)callPeerIter.next())).getMediaHandler())).setLocalUserAudioLevelListener(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireLocalUserAudioLevelChangeEvent(int newLevel) {
        List<SoundLevelListener> localUserAudioLevelListeners;
        Object object = this.localUserAudioLevelListenersSyncRoot;
        synchronized (object) {
            localUserAudioLevelListeners = this.localUserAudioLevelListeners;
        }
        if (localUserAudioLevelListeners != null) {
            int localUserAudioLevelListenerCount = localUserAudioLevelListeners.size();
            for (int i = 0; i < localUserAudioLevelListenerCount; ++i) {
                localUserAudioLevelListeners.get(i).soundLevelChanged((Object)this, newLevel);
            }
        }
    }

    public boolean isMute() {
        return this.mute;
    }

    public void setMute(boolean mute) {
        if (this.mute != mute) {
            this.mute = mute;
            Iterator peers = this.getCallPeers();
            while (peers.hasNext()) {
                ((MediaAwareCallPeer)((Object)peers.next())).setMute(this.mute);
            }
        }
    }

    public void setLocalVideoAllowed(boolean allowed, MediaUseCase useCase) throws OperationFailedException {
        if (this.mediaUseCase != useCase) {
            this.setVideoDevice(null, useCase);
        }
        this.localVideoAllowed = allowed;
        this.mediaUseCase = useCase;
        Iterator peers = this.getCallPeers();
        while (peers.hasNext()) {
            ((MediaAwareCallPeer)((Object)peers.next())).setLocalVideoAllowed(allowed);
        }
    }

    public MediaUseCase getMediaUseCase() {
        return this.mediaUseCase;
    }

    public boolean isLocalVideoAllowed(MediaUseCase useCase) {
        return this.mediaUseCase.equals((Object)useCase) && this.localVideoAllowed;
    }

    public boolean isLocalVideoStreaming() {
        Iterator peers = this.getCallPeers();
        while (peers.hasNext()) {
            if (!((MediaAwareCallPeer)((Object)peers.next())).isLocalVideoStreaming()) continue;
            return true;
        }
        return false;
    }

    public void addVideoPropertyChangeListener(PropertyChangeListener listener) {
        Iterator peers = this.getCallPeers();
        while (peers.hasNext()) {
            ((MediaAwareCallPeer)((Object)peers.next())).addVideoPropertyChangeListener(listener);
        }
    }

    public void removeVideoPropertyChangeListener(PropertyChangeListener listener) {
        Iterator peers = this.getCallPeers();
        while (peers.hasNext()) {
            ((MediaAwareCallPeer)((Object)peers.next())).removeVideoPropertyChangeListener(listener);
        }
    }

    public Recorder createRecorder() throws OperationFailedException {
        final Recorder recorder = ProtocolMediaActivator.getMediaService().createRecorder(this.getDefaultDevice(MediaType.AUDIO));
        if (recorder != null) {
            final PropertyChangeListener muteListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("Mute")) {
                        MediaAwareCall.this.updateRecorderMuteState(recorder);
                    }
                }
            };
            final CallChangeListener callChangeListener = new CallChangeListener(){

                public void callStateChanged(CallChangeEvent evt) {
                    if (!"CallState".equals(evt.getPropertyName())) {
                        return;
                    }
                    if (CallState.CALL_ENDED.equals(evt.getNewValue())) {
                        recorder.stop();
                    }
                }

                public void callPeerAdded(CallPeerEvent evt) {
                    MediaAwareCall.this.updateRecorderMuteState(recorder);
                    evt.getSourceCallPeer().addPropertyChangeListener(muteListener);
                }

                public void callPeerRemoved(CallPeerEvent evt) {
                    MediaAwareCall.this.updateRecorderMuteState(recorder);
                    evt.getSourceCallPeer().removePropertyChangeListener(muteListener);
                }
            };
            this.addCallChangeListener(callChangeListener);
            Iterator iterListeners = ProtocolMediaActivator.getMediaService().getRecorderListeners();
            while (iterListeners.hasNext()) {
                recorder.addListener((Recorder.Listener)iterListeners.next());
            }
            recorder.addListener(new Recorder.Listener(){

                public void recorderStopped(Recorder recorder) {
                    MediaAwareCall.this.removeCallChangeListener(callChangeListener);
                    Iterator iter = ProtocolMediaActivator.getMediaService().getRecorderListeners();
                    while (iter.hasNext()) {
                        recorder.removeListener((Recorder.Listener)iter.next());
                    }
                }
            });
            Iterator iter = this.getCallPeers();
            while (iter.hasNext()) {
                ((MediaAwareCallPeer)((Object)iter.next())).addPropertyChangeListener(muteListener);
            }
            this.updateRecorderMuteState(recorder);
        }
        return recorder;
    }

    private void updateRecorderMuteState(Recorder recorder) {
        Iterator iter = this.getCallPeers();
        while (iter.hasNext()) {
            if (((MediaAwareCallPeer)((Object)iter.next())).isMute()) continue;
            recorder.setMute(false);
            return;
        }
        recorder.setMute(true);
    }

    public void setAudioDevice(MediaDevice audioDevice) {
        this.getConference().setDevice(MediaType.AUDIO, audioDevice);
    }

    public void setVideoDevice(MediaDevice videoDevice, MediaUseCase useCase) {
        this.mediaUseCase = useCase;
        this.getConference().setDevice(MediaType.VIDEO, videoDevice);
    }

    protected void setCallState(CallState newState, CallPeerChangeEvent cause) {
        try {
            super.setCallState(newState, cause);
        }
        finally {
            if (CallState.CALL_ENDED.equals(this.getCallState())) {
                ProtocolMediaActivator.getMediaService().removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        if (ev.getSource() instanceof CallConference) {
            String propertyName = ev.getPropertyName();
            if ("conferenceFocus".equals(propertyName)) {
                this.conferenceFocusChanged((Boolean)ev.getOldValue(), (Boolean)ev.getNewValue());
            } else if (DEFAULT_DEVICE.equals(propertyName)) {
                this.firePropertyChange(DEFAULT_DEVICE, ev.getOldValue(), ev.getNewValue());
            }
        }
    }

    protected void conferenceFocusChanged(boolean oldValue, boolean newValue) {
        this.firePropertyChange("conferenceFocus", oldValue, newValue);
    }

    protected CallConference createConference() {
        return new MediaAwareCallConference(false, this.useTranslator);
    }

    public MediaAwareCallConference getConference() {
        return (MediaAwareCallConference)super.getConference();
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        if (oldValue != newValue && "conference".equals(property)) {
            if (oldValue != null) {
                ((CallConference)oldValue).removePropertyChangeListener((PropertyChangeListener)this);
            }
            if (newValue != null) {
                ((CallConference)newValue).addPropertyChangeListener((PropertyChangeListener)this);
            }
        }
        super.firePropertyChange(property, oldValue, newValue);
    }

    public void setConference(CallConference conference) {
        super.setConference(conference);
    }

    public void toneReceived(DTMFReceivedEvent evt) {
    }
}

