/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.contactinfo;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.java.sip.communicator.plugin.contactinfo.ContactInfoDialog;
import net.java.sip.communicator.plugin.contactinfo.Resources;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.Contact;

public class ContactInfoContactPanel
extends TransparentPanel {
    private static final long serialVersionUID = 0L;
    private JList contactList = new JList();
    private JScrollPane contactScrollPane = new JScrollPane();
    private DefaultListModel contactListModel = new DefaultListModel();
    private ContactInfoDialog contactInfoDialog;

    public ContactInfoContactPanel(Iterator<Contact> contacts, ContactInfoDialog dialog) {
        super((LayoutManager)new BorderLayout());
        this.contactInfoDialog = dialog;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Resources.getString("service.gui.CONTACTS")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.contactList.setOpaque(false);
        this.contactList.setModel(this.contactListModel);
        this.contactList.setCellRenderer(new ContactPanelCellRenderer());
        this.contactList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JList list = (JList)e.getSource();
                    Contact selectedContact = (Contact)list.getSelectedValue();
                    ContactInfoContactPanel.this.contactInfoDialog.loadContactDetails(selectedContact);
                }
            }
        });
        boolean isFirstIter = true;
        while (contacts.hasNext()) {
            Contact contact = contacts.next();
            this.contactListModel.addElement(contact);
            if (!isFirstIter) continue;
            isFirstIter = false;
            this.contactInfoDialog.loadContactDetails(contact);
            this.contactList.setSelectedIndex(0);
        }
        this.contactScrollPane.setPreferredSize(new Dimension(100, 200));
        this.contactScrollPane.getViewport().add(this.contactList);
        this.add(this.contactScrollPane);
    }

    private static class ContactPanelCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 0L;
        private boolean isSelected;
        private Color blueGreyBorderColor = new Color(131, 149, 178);
        private Color selectedColor = new Color(209, 212, 225);

        public ContactPanelCellRenderer() {
            this.setOpaque(false);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.isSelected = isSelected;
            Contact contact = (Contact)value;
            this.setIcon(new ImageIcon(contact.getProtocolProvider().getProtocolIcon().getIcon("IconSize16x16")));
            this.setText(((Contact)value).getDisplayName());
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            if (this.isSelected) {
                Graphics2D g2 = (Graphics2D)g.create();
                try {
                    AntialiasingManager.activateAntialiasing((Graphics)g2);
                    int width = this.getWidth();
                    int height = this.getHeight();
                    g2.setColor(this.selectedColor);
                    g2.fillRoundRect(1, 0, width, height, 7, 7);
                    g2.setColor(this.blueGreyBorderColor);
                    g2.setStroke(new BasicStroke(1.5f));
                    g2.drawRoundRect(1, 0, width - 2, height - 1, 7, 7);
                }
                finally {
                    g2.dispose();
                }
            }
            super.paintComponent(g);
        }
    }
}

