/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.login;

import javax.swing.ImageIcon;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.plugin.desktoputil.AuthenticationWindow;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.SecurityAuthority;
import net.java.sip.communicator.service.protocol.UserCredentials;

public class DefaultSecurityAuthority
implements SecurityAuthority {
    private ProtocolProviderService protocolProvider;
    private boolean isUserNameEditable = false;

    public DefaultSecurityAuthority(ProtocolProviderService protocolProvider) {
        this.protocolProvider = protocolProvider;
    }

    public UserCredentials obtainCredentials(String realm, UserCredentials userCredentials, int reasonCode) {
        String errorMessage = null;
        if (reasonCode == 1 || reasonCode == 2) {
            errorMessage = GuiActivator.getResources().getI18NString("service.gui.AUTHENTICATION_FAILED", new String[]{realm});
        }
        AuthenticationWindow loginWindow = null;
        String userName = userCredentials.getUserName();
        char[] password = userCredentials.getPassword();
        ImageIcon icon = AuthenticationWindow.getAuthenticationWindowIcon((ProtocolProviderService)this.protocolProvider);
        loginWindow = errorMessage == null ? new AuthenticationWindow(userName, password, realm, this.isUserNameEditable, icon) : new AuthenticationWindow(userName, password, realm, this.isUserNameEditable, icon, errorMessage);
        loginWindow.setVisible(true);
        if (!loginWindow.isCanceled()) {
            userCredentials.setUserName(loginWindow.getUserName());
            userCredentials.setPassword(loginWindow.getPassword());
            userCredentials.setPasswordPersistent(loginWindow.isRememberPassword());
        } else {
            userCredentials.setUserName(null);
            userCredentials = null;
        }
        return userCredentials;
    }

    public UserCredentials obtainCredentials(String realm, UserCredentials userCredentials) {
        return this.obtainCredentials(realm, userCredentials, 0);
    }

    public void setUserNameEditable(boolean isUserNameEditable) {
        this.isUserNameEditable = isUserNameEditable;
    }

    public boolean isUserNameEditable() {
        return this.isUserNameEditable;
    }
}

