/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.replacers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.sip.communicator.impl.gui.main.chat.Replacer;
import org.apache.commons.lang3.StringEscapeUtils;

public class URLReplacer
implements Replacer {
    private final Pattern pattern;

    public URLReplacer(Pattern urlPattern) {
        if (urlPattern == null) {
            throw new IllegalArgumentException("urlPattern cannot be null");
        }
        this.pattern = urlPattern;
    }

    @Override
    public boolean expectsPlainText() {
        return true;
    }

    @Override
    public void replace(StringBuilder target, String piece) {
        Matcher m = this.pattern.matcher(piece);
        int prevEnd = 0;
        while (m.find()) {
            target.append(StringEscapeUtils.escapeHtml4((String)piece.substring(prevEnd, m.start())));
            prevEnd = m.end();
            String url = m.group().trim();
            target.append("<A href=\"");
            if (url.startsWith("www")) {
                target.append("http://");
            }
            target.append(url);
            target.append("\">");
            target.append(StringEscapeUtils.escapeHtml4((String)url));
            target.append("</A>");
        }
        target.append(StringEscapeUtils.escapeHtml4((String)piece.substring(prevEnd)));
    }
}

