/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.im.InputContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.ChatTransport;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactNode;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaUIContact;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.ExtendedTransferHandler;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.util.Logger;

public class ChatTransferHandler
extends ExtendedTransferHandler {
    protected static final DataFlavor uiContactDataFlavor = new DataFlavor(UIContact.class, "UIContact");
    private static final Logger logger = Logger.getLogger(ChatTransferHandler.class);
    private static DataFlavor uriListFlavor;
    private final ChatPanel chatPanel;

    public ChatTransferHandler(ChatPanel chatPanel) {
        this.chatPanel = chatPanel;
    }

    public boolean canImport(JComponent comp, DataFlavor[] flavor) {
        for (DataFlavor f : flavor) {
            if (!f.equals(uiContactDataFlavor) && !f.equals(uriListFlavor)) continue;
            return true;
        }
        return super.canImport(comp, flavor);
    }

    public boolean importData(JComponent comp, Transferable t) {
        block32: {
            Object o;
            block30: {
                block29: {
                    if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        try {
                            o = t.getTransferData(DataFlavor.javaFileListFlavor);
                            if (o instanceof Collection) {
                                Collection files = (Collection)o;
                                for (File file : files) {
                                    this.chatPanel.sendFile(file);
                                }
                                return true;
                            }
                        }
                        catch (UnsupportedFlavorException e) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)"Failed to drop files.", (Throwable)e);
                            }
                        }
                        catch (IOException e) {
                            if (!logger.isDebugEnabled()) break block29;
                            logger.debug((Object)"Failed to drop files.", (Throwable)e);
                        }
                    }
                }
                if (t.isDataFlavorSupported(uriListFlavor)) {
                    try {
                        o = t.getTransferData(uriListFlavor);
                        boolean dataProcessed = false;
                        StringTokenizer tokens = new StringTokenizer((String)o);
                        while (tokens.hasMoreTokens()) {
                            String urlString = tokens.nextToken();
                            URL url = new URL(urlString);
                            File file = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
                            this.chatPanel.sendFile(file);
                            dataProcessed = true;
                        }
                        return dataProcessed;
                    }
                    catch (UnsupportedFlavorException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Failed to drop files.", (Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block30;
                        logger.debug((Object)"Failed to drop files.", (Throwable)e);
                    }
                }
            }
            if (t.isDataFlavorSupported(uiContactDataFlavor)) {
                block31: {
                    o = null;
                    try {
                        o = t.getTransferData(uiContactDataFlavor);
                    }
                    catch (UnsupportedFlavorException e) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Failed to drop meta contact.", (Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        if (!logger.isDebugEnabled()) break block31;
                        logger.debug((Object)"Failed to drop meta contact.", (Throwable)e);
                    }
                }
                if (o instanceof ContactNode) {
                    UIContactImpl uiContact = ((ContactNode)o).getContactDescriptor();
                    if (!(uiContact instanceof MetaUIContact)) {
                        return false;
                    }
                    ChatTransport currentChatTransport = this.chatPanel.getChatSession().getCurrentChatTransport();
                    Iterator contacts = ((MetaContact)uiContact.getDescriptor()).getContactsForProvider(currentChatTransport.getProtocolProvider());
                    String contact = null;
                    if (contacts.hasNext()) {
                        contact = ((Contact)contacts.next()).getAddress();
                    }
                    if (contact != null) {
                        ArrayList<String> inviteList = new ArrayList<String>();
                        inviteList.add(contact);
                        this.chatPanel.inviteContacts(currentChatTransport, inviteList, null);
                        return true;
                    }
                    new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.ERROR"), GuiActivator.getResources().getI18NString("service.gui.CONTACT_NOT_SUPPORTING_CHAT_CONF", new String[]{uiContact.getDisplayName()})).showDialog();
                }
            }
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                InputContext inputContext = comp.getInputContext();
                if (inputContext != null) {
                    inputContext.endComposition();
                }
                try {
                    BufferedReader reader = new BufferedReader(DataFlavor.stringFlavor.getReaderForText(t));
                    StringBuilder buffToPaste = new StringBuilder();
                    String line = reader.readLine();
                    while (line != null) {
                        buffToPaste.append(line);
                        line = reader.readLine();
                        if (line == null) continue;
                        buffToPaste.append("\n");
                    }
                    ((JTextComponent)comp).replaceSelection(buffToPaste.toString());
                    return true;
                }
                catch (UnsupportedFlavorException ufe) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Failed to drop string.", (Throwable)ufe);
                    }
                }
                catch (IOException ioe) {
                    if (!logger.isDebugEnabled()) break block32;
                    logger.debug((Object)"Failed to drop string.", (Throwable)ioe);
                }
            }
        }
        return false;
    }

    static {
        try {
            uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)"", (Throwable)e);
        }
    }
}

