/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.widgets;

import com.explodingpixels.util.PlatformUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class WindowUtils {
    private static final String FRAME_ACTIVE_PROPERTY = "Frame.active";

    public static void makeWindowNonOpaque(Window window) {
        window.setBackground(new Color(0, 0, 0, 0));
        if (!PlatformUtils.isMac()) {
            WindowUtils.quietlyTryToMakeWindowNonOqaque(window);
        }
    }

    private static void quietlyTryToMakeWindowNonOqaque(Window window) {
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
            method.invoke(clazz, window, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static WindowFocusListener createAndInstallRepaintWindowFocusListener(Window window) {
        WindowFocusListener windowFocusListener = new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent e) {
                e.getWindow().repaint();
            }

            public void windowLostFocus(WindowEvent e) {
                e.getWindow().repaint();
            }
        };
        window.addWindowFocusListener(windowFocusListener);
        return windowFocusListener;
    }

    public static boolean isParentWindowFocused(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        return window != null && window.isFocused();
    }

    public static void installWindowFocusListener(WindowFocusListener focusListener, JComponent component) {
        component.addPropertyChangeListener(FRAME_ACTIVE_PROPERTY, WindowUtils.createFrameFocusPropertyChangeListener(focusListener, component));
    }

    public static void installJComponentRepainterOnWindowFocusChanged(JComponent component) {
        component.addAncestorListener(WindowUtils.createAncestorListener(component, WindowUtils.createWindowListener(component)));
    }

    private static AncestorListener createAncestorListener(final JComponent component, final WindowListener windowListener) {
        return new AncestorListener(){

            public void ancestorAdded(AncestorEvent event) {
                Window window = SwingUtilities.getWindowAncestor(component);
                if (window != null) {
                    window.removeWindowListener(windowListener);
                    window.addWindowListener(windowListener);
                }
            }

            public void ancestorRemoved(AncestorEvent event) {
            }

            public void ancestorMoved(AncestorEvent event) {
            }
        };
    }

    private static WindowListener createWindowListener(final JComponent component) {
        return new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                component.repaint();
            }

            public void windowDeactivated(WindowEvent e) {
                component.repaint();
            }
        };
    }

    private static PropertyChangeListener createFrameFocusPropertyChangeListener(final WindowFocusListener focusListener, final JComponent component) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Window window = SwingUtilities.getWindowAncestor(component);
                boolean hasFocus = (Boolean)component.getClientProperty(WindowUtils.FRAME_ACTIVE_PROPERTY);
                if (hasFocus) {
                    focusListener.windowGainedFocus(new WindowEvent(window, 207));
                } else {
                    focusListener.windowLostFocus(new WindowEvent(window, 208));
                }
            }
        };
    }
}

