/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.widgets;

import com.explodingpixels.widgets.StripedViewportBorder;
import com.explodingpixels.widgets.TableHeaderUtils;
import java.awt.Color;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;

public class TableUtils {
    private TableUtils() {
    }

    public static void makeStriped(JTable table, Color stipeColor) {
        table.addPropertyChangeListener("ancestor", TableUtils.createAncestorPropertyChangeListener(table, stipeColor));
        for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
            table.getColumnModel().getColumn(i).addPropertyChangeListener(TableUtils.createAncestorPropertyChangeListener(table, stipeColor));
        }
    }

    private static PropertyChangeListener createAncestorPropertyChangeListener(final JTable table, final Color stipeColor) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                TableUtils.parentDidChange(table, stipeColor);
            }
        };
    }

    private static void parentDidChange(JTable table, Color stipeColor) {
        if (table.getParent() instanceof JViewport && table.getParent().getParent() instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)table.getParent().getParent();
            scrollPane.setViewportBorder(new StripedViewportBorder(scrollPane.getViewport(), table, stipeColor));
            scrollPane.getViewport().setOpaque(false);
            scrollPane.setCorner("UPPER_RIGHT_CORNER", TableHeaderUtils.createCornerComponent(table));
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public static void makeSortable(JTable table, SortDelegate sortDelegate) {
        TableUtils.validateSortDelegate(sortDelegate);
        MouseListener mouseListener = TableHeaderUtils.createColumnHeaderSortHandler(table, sortDelegate);
        table.getTableHeader().addMouseListener(mouseListener);
    }

    private static void validateSortDelegate(SortDelegate sortDelegate) {
        if (sortDelegate == null) {
            throw new IllegalArgumentException("The given SortDelegate cannot be null.");
        }
    }

    public static interface SortDelegate {
        public void sort(int var1, SortDirection var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortDirection {
        NONE(""),
        ASCENDING("ascending"),
        DESCENDING("descending");

        private final String fValue;

        private SortDirection(String value) {
            this.fValue = value;
        }

        String getValue() {
            return this.fValue;
        }

        static SortDirection find(String value) {
            for (SortDirection sortDirection : SortDirection.values()) {
                if (!sortDirection.getValue().equals(value)) continue;
                return sortDirection;
            }
            throw new IllegalArgumentException("No sort direction found for " + value);
        }
    }
}

