/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.callhistory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.impl.callhistory.CallHistoryActivator;
import net.java.sip.communicator.impl.callhistory.CallHistorySourceContact;
import net.java.sip.communicator.service.callhistory.CallHistoryQuery;
import net.java.sip.communicator.service.callhistory.CallRecord;
import net.java.sip.communicator.service.callhistory.event.CallHistoryQueryListener;
import net.java.sip.communicator.service.callhistory.event.CallHistoryQueryStatusEvent;
import net.java.sip.communicator.service.callhistory.event.CallRecordEvent;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactQueryListener;
import net.java.sip.communicator.service.contactsource.ContactQueryStatusEvent;
import net.java.sip.communicator.service.contactsource.ContactReceivedEvent;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.SourceContact;

public class CallHistoryContactSource
implements ContactSourceService {
    public String getDisplayName() {
        return CallHistoryActivator.getResources().getI18NString("service.gui.CALL_HISTORY_GROUP_NAME");
    }

    public ContactQuery createContactQuery(String queryString) {
        return this.createContactQuery(queryString, 50);
    }

    public ContactQuery createContactQuery(String queryString, int contactCount) {
        if (queryString != null && queryString.length() > 0) {
            return new CallHistoryContactQuery(CallHistoryActivator.getCallHistoryService().findByPeer(queryString, contactCount));
        }
        return new CallHistoryContactQuery(CallHistoryActivator.getCallHistoryService().findLast(contactCount));
    }

    public int getType() {
        return 2;
    }

    public int getIndex() {
        return -1;
    }

    private class CallHistoryContactQuery
    implements ContactQuery {
        private final List<ContactQueryListener> queryListeners = new LinkedList<ContactQueryListener>();
        private final List<SourceContact> sourceContacts = new LinkedList<SourceContact>();
        private CallHistoryQuery callHistoryQuery;
        private int status = 3;
        Iterator<CallRecord> recordsIter = null;
        private boolean showMoreLabelAllowed = true;

        public CallHistoryContactQuery(Collection<CallRecord> callRecords) {
            this.recordsIter = callRecords.iterator();
            Iterator<CallRecord> recordsIter = callRecords.iterator();
            while (recordsIter.hasNext() && this.status != 1) {
                this.sourceContacts.add(new CallHistorySourceContact(CallHistoryContactSource.this, recordsIter.next()));
            }
            this.showMoreLabelAllowed = false;
        }

        public void start() {
            if (this.callHistoryQuery != null) {
                this.callHistoryQuery.addQueryListener(new CallHistoryQueryListener(){

                    @Override
                    public void callRecordReceived(CallRecordEvent event) {
                        if (CallHistoryContactQuery.this.getStatus() == 1) {
                            return;
                        }
                        CallHistorySourceContact contact = new CallHistorySourceContact(CallHistoryContactSource.this, event.getCallRecord());
                        CallHistoryContactQuery.this.sourceContacts.add(contact);
                        CallHistoryContactQuery.this.fireQueryEvent(contact);
                    }

                    @Override
                    public void queryStatusChanged(CallHistoryQueryStatusEvent event) {
                        CallHistoryContactQuery.this.status = event.getEventType();
                        CallHistoryContactQuery.this.fireQueryStatusEvent(CallHistoryContactQuery.this.status);
                    }
                });
                this.recordsIter = this.callHistoryQuery.getCallRecords().iterator();
            }
            while (this.recordsIter.hasNext()) {
                CallHistorySourceContact contact = new CallHistorySourceContact(CallHistoryContactSource.this, this.recordsIter.next());
                this.sourceContacts.add(contact);
                this.fireQueryEvent(contact);
            }
            if (this.status != 1) {
                this.status = 0;
                if (this.callHistoryQuery == null) {
                    this.fireQueryStatusEvent(this.status);
                }
            }
        }

        public CallHistoryContactQuery(CallHistoryQuery callHistoryQuery) {
            this.callHistoryQuery = callHistoryQuery;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addContactQueryListener(ContactQueryListener l) {
            List<ContactQueryListener> list = this.queryListeners;
            synchronized (list) {
                this.queryListeners.add(l);
            }
        }

        public void cancel() {
            this.status = 1;
            if (this.callHistoryQuery != null) {
                this.callHistoryQuery.cancel();
            }
        }

        public int getStatus() {
            return this.status;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeContactQueryListener(ContactQueryListener l) {
            List<ContactQueryListener> list = this.queryListeners;
            synchronized (list) {
                this.queryListeners.remove(l);
            }
        }

        public List<SourceContact> getQueryResults() {
            return this.sourceContacts;
        }

        public ContactSourceService getContactSource() {
            return CallHistoryContactSource.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireQueryEvent(SourceContact contact) {
            ArrayList<ContactQueryListener> listeners;
            ContactReceivedEvent event = new ContactReceivedEvent((ContactQuery)this, contact, this.showMoreLabelAllowed);
            List<ContactQueryListener> list = this.queryListeners;
            synchronized (list) {
                listeners = new ArrayList<ContactQueryListener>(this.queryListeners);
            }
            for (ContactQueryListener l : listeners) {
                l.contactReceived(event);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireQueryStatusEvent(int newStatus) {
            ArrayList<ContactQueryListener> listeners;
            ContactQueryStatusEvent event = new ContactQueryStatusEvent((ContactQuery)this, newStatus);
            List<ContactQueryListener> list = this.queryListeners;
            synchronized (list) {
                listeners = new ArrayList<ContactQueryListener>(this.queryListeners);
            }
            for (ContactQueryListener l : listeners) {
                l.queryStatusChanged(event);
            }
        }

        public String getQueryString() {
            return this.callHistoryQuery.getQueryString();
        }
    }
}

