/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.swingnotification;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.java.sip.communicator.impl.swingnotification.SwingNotificationActivator;
import net.java.sip.communicator.plugin.desktoputil.ComponentUtils;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.PopupNotificationPanel;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.systray.AbstractPopupMessageHandler;
import net.java.sip.communicator.service.systray.PopupMessage;
import net.java.sip.communicator.service.systray.event.SystrayPopupMessageEvent;
import net.java.sip.communicator.util.Html2Text;
import net.java.sip.communicator.util.Logger;

public class PopupMessageHandlerSwingImpl
extends AbstractPopupMessageHandler {
    private static final Logger logger = Logger.getLogger(PopupMessageHandlerSwingImpl.class);

    public void showPopupMessage(final PopupMessage popupMessage) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PopupMessageHandlerSwingImpl.this.showPopupMessage(popupMessage);
                }
            });
            return;
        }
        GraphicsConfiguration graphicsConf = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        final JWindow notificationWindow = new JWindow(graphicsConf);
        final Timer popupTimer = new Timer(10000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (notificationWindow.isVisible()) {
                    new Thread(new PopupDiscarder(notificationWindow)).start();
                }
            }
        });
        popupTimer.setRepeats(false);
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                popupTimer.stop();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                popupTimer.start();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Container container = notificationWindow.getContentPane();
                PopupNotificationPanel notif = (PopupNotificationPanel)container.getComponent(0);
                PopupMessageHandlerSwingImpl.this.firePopupMessageClicked(new SystrayPopupMessageEvent((Object)e, notif.getTag()));
                notificationWindow.dispose();
            }
        };
        notificationWindow.addMouseListener(adapter);
        JComponent content = popupMessage.getComponent();
        if (content == null) {
            content = this.createPopup(popupMessage.getMessageTitle(), popupMessage.getMessage(), popupMessage.getIcon(), popupMessage.getTag());
        }
        this.registerMouseListener(content, adapter);
        notificationWindow.add(content);
        notificationWindow.setAlwaysOnTop(true);
        notificationWindow.pack();
        new Thread(new PopupLauncher(notificationWindow, graphicsConf)).start();
        popupTimer.start();
    }

    private void registerMouseListener(Component content, MouseAdapter adapter) {
        content.addMouseListener(adapter);
        if (content instanceof JComponent) {
            for (Component c : ((JComponent)content).getComponents()) {
                this.registerMouseListener(c, adapter);
            }
        }
    }

    private JComponent createPopup(String titleString, String message, byte[] imageBytes, Object tag) {
        JLabel msgIcon = null;
        if (imageBytes != null) {
            ImageIcon imageIcon = ImageUtils.getScaledRoundedIcon((byte[])imageBytes, (int)45, (int)45);
            msgIcon = new JLabel(imageIcon);
        }
        String plainMessage = Html2Text.extractText((String)("<pre>" + message + "</pre>"));
        JTextArea msgContent = new JTextArea(plainMessage);
        msgContent.setLineWrap(true);
        msgContent.setWrapStyleWord(true);
        msgContent.setOpaque(false);
        msgContent.setAlignmentX(0.0f);
        int msgContentHeight = this.getPopupMessageAreaHeight(msgContent, plainMessage);
        msgContent.setPreferredSize(new Dimension(250, msgContentHeight));
        TransparentPanel notificationBody = new TransparentPanel();
        notificationBody.setLayout((LayoutManager)new BoxLayout((Container)notificationBody, 1));
        notificationBody.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        notificationBody.add((Component)msgContent);
        TransparentPanel notificationContent = new TransparentPanel();
        notificationContent.setLayout((LayoutManager)new BorderLayout(5, 0));
        notificationContent.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        if (msgIcon != null) {
            notificationContent.add((Component)msgIcon, (Object)"West");
        }
        notificationContent.add((Component)notificationBody, (Object)"Center");
        return new PopupNotificationPanel(titleString, (JPanel)notificationContent, tag);
    }

    public String toString() {
        String applicationName = SwingNotificationActivator.getResources().getSettingsString("service.gui.APPLICATION_NAME");
        return SwingNotificationActivator.getResources().getI18NString("impl.swingnotification.POPUP_MESSAGE_HANDLER", new String[]{applicationName});
    }

    private int getPopupMessageAreaHeight(Component c, String message) {
        int stringWidth = ComponentUtils.getStringWidth((Component)c, (String)message);
        int numberOfRows = 0;
        numberOfRows = stringWidth / 230 > 5 ? 5 : stringWidth / 230 + 1;
        FontMetrics fontMetrics = c.getFontMetrics(c.getFont());
        return fontMetrics.getHeight() * Math.max(numberOfRows, 3) + 5;
    }

    public int getPreferenceIndex() {
        return 3;
    }

    private static class PopupLauncher
    implements Runnable {
        private final JWindow notificationWindow;
        private final int x;
        private final int y;

        PopupLauncher(JWindow notificationWindow, GraphicsConfiguration graphicsConf) {
            this.notificationWindow = notificationWindow;
            Rectangle rec = graphicsConf.getBounds();
            Insets ins = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConf);
            this.x = rec.width + rec.x - ins.right - notificationWindow.getWidth() - 1;
            this.y = rec.height + rec.y - ins.bottom - notificationWindow.getHeight() - 1;
            notificationWindow.setLocation(this.x, rec.height);
            notificationWindow.setVisible(true);
        }

        @Override
        public void run() {
            int height = this.y - this.notificationWindow.getY();
            do {
                this.notificationWindow.setLocation(this.x, this.notificationWindow.getY() - 2);
                try {
                    Thread.sleep(10L);
                    height += 2;
                }
                catch (InterruptedException ex) {
                    logger.warn((Object)"exception while showing popup notification window :", (Throwable)ex);
                }
            } while (height < 0);
        }
    }

    private static class PopupDiscarder
    implements Runnable {
        private final JWindow notificationWindow;

        PopupDiscarder(JWindow notificationWindow) {
            this.notificationWindow = notificationWindow;
        }

        @Override
        public void run() {
            int height = this.notificationWindow.getY();
            int x = this.notificationWindow.getX();
            do {
                this.notificationWindow.setLocation(x, this.notificationWindow.getY() + 2);
                try {
                    Thread.sleep(10L);
                    height -= 2;
                }
                catch (InterruptedException ex) {
                    logger.warn((Object)"exception while discarding popup notification window :", (Throwable)ex);
                }
            } while (height > 0);
            this.notificationWindow.dispose();
        }
    }
}

