/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.irccommands.command;

import junit.framework.Assert;
import junit.framework.TestCase;
import net.java.sip.communicator.impl.protocol.irc.IdentityManager;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;
import net.java.sip.communicator.plugin.irccommands.command.Nick;
import org.easymock.EasyMock;

public class NickTest
extends TestCase {
    public NickTest(String testName) {
        super(testName);
    }

    public void testNullProviderInit() {
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{connection});
        new Nick(null, connection);
    }

    public void testNullConnectionInit() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class);
        EasyMock.replay((Object[])new Object[]{provider});
        try {
            new Nick(provider, null);
            Assert.fail((String)"Should not reach this as we expected an IAE for null connection.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEmptyNickCommand() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class);
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{provider, connection});
        Nick nick = new Nick(provider, connection);
        try {
            nick.execute("#test", "/nick");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEmptyNickCommandWithSpace() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class);
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{provider, connection});
        Nick nick = new Nick(provider, connection);
        try {
            nick.execute("#test", "/nick ");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testEmptyNickCommandWithDoubleSpace() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class);
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        EasyMock.replay((Object[])new Object[]{provider, connection});
        Nick nick = new Nick(provider, connection);
        nick.execute("#test", "/nick  ");
    }

    public void testNickCommandWithNickAndSpace() {
        ProtocolProviderServiceIrcImpl provider = (ProtocolProviderServiceIrcImpl)EasyMock.createMock(ProtocolProviderServiceIrcImpl.class);
        IrcConnection connection = (IrcConnection)EasyMock.createMock(IrcConnection.class);
        IdentityManager idmgr = (IdentityManager)EasyMock.createMock(IdentityManager.class);
        EasyMock.expect((Object)connection.getIdentityManager()).andReturn((Object)idmgr);
        idmgr.setNick((String)EasyMock.eq((Object)"myNewN1ck"));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{provider, connection, idmgr});
        Nick nick = new Nick(provider, connection);
        nick.execute("#test", "/nick myNewN1ck ");
    }
}

