/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.irccommands.command;

import net.java.sip.communicator.impl.protocol.irc.Command;
import net.java.sip.communicator.impl.protocol.irc.IrcConnection;
import net.java.sip.communicator.impl.protocol.irc.ProtocolProviderServiceIrcImpl;

public class Me
implements Command {
    private static final int END_OF_ME_COMMAND_PREFIX = 4;
    private final IrcConnection connection;

    public Me(ProtocolProviderServiceIrcImpl provider, IrcConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        this.connection = connection;
    }

    public void execute(String source, String line) {
        if (line.length() < 4) {
            throw new IllegalArgumentException("The message is missing.");
        }
        String message = line.substring(4);
        if (message.isEmpty()) {
            throw new IllegalArgumentException("Invalid /me command: message cannot be empty.");
        }
        this.connection.getClient().act(source, message);
    }

    public String help() {
        return "Usage: /me <message>";
    }
}

