/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.sysactivity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.impl.sysactivity.SystemActivityEventDispatcher;
import net.java.sip.communicator.impl.sysactivity.SystemActivityManager;
import net.java.sip.communicator.impl.sysactivity.SystemActivityNotifications;
import net.java.sip.communicator.service.sysactivity.SystemActivityChangeListener;
import net.java.sip.communicator.service.sysactivity.SystemActivityNotificationsService;
import net.java.sip.communicator.service.sysactivity.event.SystemActivityEvent;
import net.java.sip.communicator.util.Logger;
import org.jitsi.util.OSUtils;

public class SystemActivityNotificationsServiceImpl
implements SystemActivityNotifications.NotificationsDelegate,
SystemActivityNotificationsService,
Runnable {
    private final Logger logger = Logger.getLogger(SystemActivityNotificationsServiceImpl.class);
    private final SystemActivityEventDispatcher eventDispatcher = new SystemActivityEventDispatcher();
    private final Map<SystemActivityChangeListener, Long> idleChangeListeners = new HashMap<SystemActivityChangeListener, Long>();
    private final List<SystemActivityChangeListener> listenersInIdleState = new ArrayList<SystemActivityChangeListener>();
    private static final int CHECK_FOR_IDLE_DEFAULT = 30000;
    private static final int CHECK_FOR_IDLE_WHEN_IDLE = 1000;
    private static int idleStateCheckDelay = 30000;
    private boolean running = false;
    private long lastNetworkChange = -1L;
    private static final long NETWORK_EVENT_SILENT_TIME = 10000L;
    private Boolean networkIsConnected = null;
    private static final String SYSTEM_ACTIVITY_MANAGER_LINUX_CLASS = "net.java.sip.communicator.impl.sysactivity.NetworkManagerListenerImpl";
    private static final String SYSTEM_ACTIVITY_MANAGER_ANDROID_CLASS = "net.java.sip.communicator.impl.sysactivity.ConnectivityManagerListenerImpl";
    private SystemActivityManager currentRunningManager = null;

    public void start() {
        this.running = true;
        Thread notifystartThread = new Thread(new Runnable(){

            @Override
            public void run() {
                SystemActivityNotifications.setDelegate(SystemActivityNotificationsServiceImpl.this);
                SystemActivityNotifications.start();
            }
        }, "SystemActivityNotificationsServiceImpl");
        notifystartThread.setDaemon(true);
        notifystartThread.start();
        if (this.isSupported(10)) {
            Thread idleNotifyThread = new Thread((Runnable)this, "SystemActivityNotificationsServiceImpl.IdleNotifyThread");
            idleNotifyThread.setDaemon(true);
            idleNotifyThread.start();
        }
        if (this.getCurrentRunningManager() != null) {
            this.getCurrentRunningManager().start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        SystemActivityNotifications.stop();
        if (this.getCurrentRunningManager() != null) {
            this.getCurrentRunningManager().stop();
        }
        this.eventDispatcher.stop();
        this.running = false;
        SystemActivityNotificationsServiceImpl systemActivityNotificationsServiceImpl = this;
        synchronized (systemActivityNotificationsServiceImpl) {
            this.notifyAll();
        }
    }

    @Override
    public void addSystemActivityChangeListener(SystemActivityChangeListener listener) {
        this.eventDispatcher.addSystemActivityChangeListener(listener);
    }

    @Override
    public void removeSystemActivityChangeListener(SystemActivityChangeListener listener) {
        this.eventDispatcher.removeSystemActivityChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIdleSystemChangeListener(long idleTime, SystemActivityChangeListener listener) {
        Map<SystemActivityChangeListener, Long> map = this.idleChangeListeners;
        synchronized (map) {
            if (idleTime > 0L && !this.idleChangeListeners.containsKey(listener)) {
                this.idleChangeListeners.put(listener, idleTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIdleSystemChangeListener(SystemActivityChangeListener listener) {
        Map<SystemActivityChangeListener, Long> map = this.idleChangeListeners;
        synchronized (map) {
            this.idleChangeListeners.remove(listener);
        }
    }

    @Override
    public long getTimeSinceLastInput() {
        if (SystemActivityNotifications.isLoaded()) {
            return SystemActivityNotifications.getLastInput();
        }
        return -1L;
    }

    @Override
    public void notify(int type) {
        SystemActivityEvent evt = null;
        switch (type) {
            case 0: {
                evt = new SystemActivityEvent(this, 0);
                break;
            }
            case 1: {
                evt = new SystemActivityEvent(this, 1);
                break;
            }
            case 2: {
                evt = new SystemActivityEvent(this, 2);
                break;
            }
            case 3: {
                evt = new SystemActivityEvent(this, 3);
                break;
            }
            case 4: {
                evt = new SystemActivityEvent(this, 4);
                break;
            }
            case 5: {
                evt = new SystemActivityEvent(this, 5);
                break;
            }
            case 6: {
                evt = new SystemActivityEvent(this, 6);
                break;
            }
            case 7: {
                evt = new SystemActivityEvent(this, 7);
                break;
            }
            case 8: {
                evt = new SystemActivityEvent(this, 8);
                break;
            }
            case 9: {
                evt = new SystemActivityEvent(this, 9);
                break;
            }
            case 10: {
                evt = new SystemActivityEvent(this, 12);
                break;
            }
            case 11: {
                evt = new SystemActivityEvent(this, 13);
                this.eventDispatcher.fireSystemActivityEventCurrentThread(evt);
                return;
            }
            case 12: {
                evt = new SystemActivityEvent(this, 14);
                this.eventDispatcher.fireSystemActivityEventCurrentThread(evt);
                return;
            }
        }
        if (evt != null) {
            this.fireSystemActivityEvent(evt);
        }
    }

    @Override
    public void notifyNetworkChange(int family, long luidIndex, String name, long type, boolean connected) {
        long current = System.currentTimeMillis();
        if (current - this.lastNetworkChange <= 10000L && this.networkIsConnected != null && this.networkIsConnected.equals(connected)) {
            this.networkIsConnected = connected;
            return;
        }
        this.lastNetworkChange = current;
        this.networkIsConnected = connected;
        SystemActivityEvent evt = new SystemActivityEvent(this, 9);
        this.fireSystemActivityEvent(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            try {
                long idleTime = 0L;
                if (this.idleChangeListeners.size() > 0) {
                    idleTime = SystemActivityNotifications.getLastInput();
                    if (idleTime < (long)idleStateCheckDelay && this.listenersInIdleState.size() > 0) {
                        for (SystemActivityChangeListener systemActivityChangeListener : this.listenersInIdleState) {
                            this.fireSystemIdleEndEvent(systemActivityChangeListener);
                        }
                        this.listenersInIdleState.clear();
                    }
                    for (Map.Entry entry : this.idleChangeListeners.entrySet()) {
                        SystemActivityChangeListener listener = (SystemActivityChangeListener)entry.getKey();
                        if (this.listenersInIdleState.contains(listener) || (Long)entry.getValue() > idleTime) continue;
                        this.fireSystemIdleEvent(listener);
                        this.listenersInIdleState.add(listener);
                    }
                }
                if (this.listenersInIdleState.size() > 0) {
                    idleStateCheckDelay = 1000;
                } else if (idleTime != 0L) {
                    int newSetting;
                    long minIdleSetting = 30000L;
                    if (!this.idleChangeListeners.isEmpty()) {
                        minIdleSetting = Collections.min(this.idleChangeListeners.values());
                    }
                    idleStateCheckDelay = (newSetting = (int)(minIdleSetting - idleTime) + 1000) > 0 ? newSetting : 30000;
                } else {
                    idleStateCheckDelay = 30000;
                }
                Iterator<SystemActivityChangeListener> iterator = this;
                synchronized (iterator) {
                    this.wait(idleStateCheckDelay);
                }
            }
            catch (UnsatisfiedLinkError t) {
                this.logger.error((Object)"Missing native impl", (Throwable)t);
                return;
            }
            catch (Throwable t) {
                this.logger.error((Object)"Error checking for idle", t);
            }
        }
    }

    protected void fireSystemActivityEvent(SystemActivityEvent evt) {
        int eventID = evt.getEventID();
        if (this.logger.isInfoEnabled() && (eventID == 9 || eventID == 12)) {
            this.logger.info((Object)("Received system activity event: " + evt));
        }
        if (eventID == 9) {
            this.eventDispatcher.fireSystemActivityEvent(evt, 500);
        } else {
            this.eventDispatcher.fireSystemActivityEvent(evt);
        }
    }

    protected void fireSystemIdleEvent(SystemActivityChangeListener listener) {
        SystemActivityEvent evt = new SystemActivityEvent(this, 10);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Dispatching SystemActivityEvent evt=" + evt));
        }
        try {
            listener.activityChanged(evt);
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            this.logger.error((Object)"Error delivering event", t);
        }
    }

    protected void fireSystemIdleEndEvent(SystemActivityChangeListener listener) {
        SystemActivityEvent evt = new SystemActivityEvent(this, 11);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Dispatching SystemActivityEvent evt=" + evt));
        }
        try {
            listener.activityChanged(evt);
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            this.logger.error((Object)"Error delivering event", t);
        }
    }

    @Override
    public boolean isSupported(int eventID) {
        if (OSUtils.IS_WINDOWS) {
            switch (eventID) {
                case 0: 
                case 1: 
                case 9: 
                case 10: 
                case 11: {
                    return SystemActivityNotifications.isLoaded();
                }
            }
            return false;
        }
        if (OSUtils.IS_MAC) {
            return SystemActivityNotifications.isLoaded();
        }
        if (OSUtils.IS_LINUX) {
            switch (eventID) {
                case 0: 
                case 9: {
                    SystemActivityManager currentRunningManager = this.getCurrentRunningManager();
                    return currentRunningManager == null ? false : currentRunningManager.isConnected();
                }
                case 10: 
                case 11: {
                    return SystemActivityNotifications.isLoaded();
                }
            }
            return false;
        }
        if (OSUtils.IS_ANDROID) {
            return eventID == 9;
        }
        return false;
    }

    private SystemActivityManager getCurrentRunningManager() {
        if (this.currentRunningManager == null) {
            try {
                String className = null;
                if (OSUtils.IS_LINUX) {
                    className = SYSTEM_ACTIVITY_MANAGER_LINUX_CLASS;
                } else if (OSUtils.IS_ANDROID) {
                    className = SYSTEM_ACTIVITY_MANAGER_ANDROID_CLASS;
                }
                if (className != null) {
                    this.currentRunningManager = (SystemActivityManager)Class.forName(className).newInstance();
                }
            }
            catch (Throwable t) {
                this.logger.error((Object)"Error creating manager", t);
            }
        }
        return this.currentRunningManager;
    }
}

