/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSVideoPlaybackQuality.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsVideoPlaybackQuality_creationTime);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoPlaybackQuality_totalVideoFrames);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoPlaybackQuality_droppedVideoFrames);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoPlaybackQuality_corruptedVideoFrames);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoPlaybackQuality_displayCompositedVideoFrames);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoPlaybackQuality_totalFrameDelay);

class JSVideoPlaybackQualityPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSVideoPlaybackQualityPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVideoPlaybackQualityPrototype* ptr = new (NotNull, JSC::allocateCell<JSVideoPlaybackQualityPrototype>(vm)) JSVideoPlaybackQualityPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVideoPlaybackQualityPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSVideoPlaybackQualityPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVideoPlaybackQualityPrototype, JSVideoPlaybackQualityPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSVideoPlaybackQualityPrototypeTableValues[] =
{
    { "creationTime"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoPlaybackQuality_creationTime, 0 } },
    { "totalVideoFrames"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoPlaybackQuality_totalVideoFrames, 0 } },
    { "droppedVideoFrames"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoPlaybackQuality_droppedVideoFrames, 0 } },
    { "corruptedVideoFrames"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoPlaybackQuality_corruptedVideoFrames, 0 } },
    { "displayCompositedVideoFrames"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoPlaybackQuality_displayCompositedVideoFrames, 0 } },
    { "totalFrameDelay"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoPlaybackQuality_totalFrameDelay, 0 } },
};

const ClassInfo JSVideoPlaybackQualityPrototype::s_info = { "VideoPlaybackQuality"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoPlaybackQualityPrototype) };

void JSVideoPlaybackQualityPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSVideoPlaybackQuality::info(), JSVideoPlaybackQualityPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext()->settingsValues().videoQualityIncludesDisplayCompositingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "displayCompositedVideoFrames"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSVideoPlaybackQuality::s_info = { "VideoPlaybackQuality"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoPlaybackQuality) };

JSVideoPlaybackQuality::JSVideoPlaybackQuality(Structure* structure, JSDOMGlobalObject& globalObject, Ref<VideoPlaybackQuality>&& impl)
    : JSDOMWrapper<VideoPlaybackQuality>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, VideoPlaybackQuality>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSVideoPlaybackQuality::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSVideoPlaybackQualityPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSVideoPlaybackQualityPrototype::create(vm, &globalObject, structure);
}

JSObject* JSVideoPlaybackQuality::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSVideoPlaybackQuality>(vm, globalObject);
}

void JSVideoPlaybackQuality::destroy(JSC::JSCell* cell)
{
    JSVideoPlaybackQuality* thisObject = static_cast<JSVideoPlaybackQuality*>(cell);
    thisObject->JSVideoPlaybackQuality::~JSVideoPlaybackQuality();
}

static inline JSValue jsVideoPlaybackQuality_creationTimeGetter(JSGlobalObject& lexicalGlobalObject, JSVideoPlaybackQuality& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.creationTime())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoPlaybackQuality_creationTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoPlaybackQuality>::get<jsVideoPlaybackQuality_creationTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoPlaybackQuality_totalVideoFramesGetter(JSGlobalObject& lexicalGlobalObject, JSVideoPlaybackQuality& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.totalVideoFrames())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoPlaybackQuality_totalVideoFrames, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoPlaybackQuality>::get<jsVideoPlaybackQuality_totalVideoFramesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoPlaybackQuality_droppedVideoFramesGetter(JSGlobalObject& lexicalGlobalObject, JSVideoPlaybackQuality& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.droppedVideoFrames())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoPlaybackQuality_droppedVideoFrames, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoPlaybackQuality>::get<jsVideoPlaybackQuality_droppedVideoFramesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoPlaybackQuality_corruptedVideoFramesGetter(JSGlobalObject& lexicalGlobalObject, JSVideoPlaybackQuality& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.corruptedVideoFrames())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoPlaybackQuality_corruptedVideoFrames, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoPlaybackQuality>::get<jsVideoPlaybackQuality_corruptedVideoFramesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoPlaybackQuality_displayCompositedVideoFramesGetter(JSGlobalObject& lexicalGlobalObject, JSVideoPlaybackQuality& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.displayCompositedVideoFrames())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoPlaybackQuality_displayCompositedVideoFrames, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoPlaybackQuality>::get<jsVideoPlaybackQuality_displayCompositedVideoFramesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoPlaybackQuality_totalFrameDelayGetter(JSGlobalObject& lexicalGlobalObject, JSVideoPlaybackQuality& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.totalFrameDelay())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoPlaybackQuality_totalFrameDelay, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoPlaybackQuality>::get<jsVideoPlaybackQuality_totalFrameDelayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSVideoPlaybackQuality::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSVideoPlaybackQuality, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForVideoPlaybackQuality.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForVideoPlaybackQuality = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForVideoPlaybackQuality.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForVideoPlaybackQuality = std::forward<decltype(space)>(space); }
    );
}

void JSVideoPlaybackQuality::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSVideoPlaybackQuality*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSVideoPlaybackQualityOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSVideoPlaybackQualityOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsVideoPlaybackQuality = static_cast<JSVideoPlaybackQuality*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsVideoPlaybackQuality->wrapped(), jsVideoPlaybackQuality);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7VideoPlaybackQuality@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20VideoPlaybackQualityE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<VideoPlaybackQuality>&& impl)
{

    if constexpr (std::is_polymorphic_v<VideoPlaybackQuality>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7VideoPlaybackQuality@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore20VideoPlaybackQualityE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // VideoPlaybackQuality has subclasses. If VideoPlaybackQuality has subclasses that get passed
        // to toJS() we currently require VideoPlaybackQuality you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<VideoPlaybackQuality>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, VideoPlaybackQuality& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

VideoPlaybackQuality* JSVideoPlaybackQuality::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSVideoPlaybackQuality*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
