/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSQLResultSet.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSSQLResultSetRowList.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSQLResultSetConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSQLResultSet_rows);
static JSC_DECLARE_CUSTOM_GETTER(jsSQLResultSet_insertId);
static JSC_DECLARE_CUSTOM_GETTER(jsSQLResultSet_rowsAffected);

class JSSQLResultSetPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSQLResultSetPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSQLResultSetPrototype* ptr = new (NotNull, JSC::allocateCell<JSSQLResultSetPrototype>(vm)) JSSQLResultSetPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSQLResultSetPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSQLResultSetPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSQLResultSetPrototype, JSSQLResultSetPrototype::Base);

using JSSQLResultSetDOMConstructor = JSDOMConstructorNotConstructable<JSSQLResultSet>;

template<> const ClassInfo JSSQLResultSetDOMConstructor::s_info = { "SQLResultSet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLResultSetDOMConstructor) };

template<> JSValue JSSQLResultSetDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSQLResultSetDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SQLResultSet"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSQLResultSet::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSSQLResultSetPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSQLResultSetConstructor, 0 } },
    { "rows"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSQLResultSet_rows, 0 } },
    { "insertId"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSQLResultSet_insertId, 0 } },
    { "rowsAffected"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSQLResultSet_rowsAffected, 0 } },
};

const ClassInfo JSSQLResultSetPrototype::s_info = { "SQLResultSet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLResultSetPrototype) };

void JSSQLResultSetPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSQLResultSet::info(), JSSQLResultSetPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSQLResultSet::s_info = { "SQLResultSet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSQLResultSet) };

JSSQLResultSet::JSSQLResultSet(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SQLResultSet>&& impl)
    : JSDOMWrapper<SQLResultSet>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, SQLResultSet>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSQLResultSet::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSQLResultSetPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSQLResultSetPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSQLResultSet::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSQLResultSet>(vm, globalObject);
}

JSValue JSSQLResultSet::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSQLResultSetDOMConstructor, DOMConstructorID::SQLResultSet>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSQLResultSet::destroy(JSC::JSCell* cell)
{
    JSSQLResultSet* thisObject = static_cast<JSSQLResultSet*>(cell);
    thisObject->JSSQLResultSet::~JSSQLResultSet();
}

JSC_DEFINE_CUSTOM_GETTER(jsSQLResultSetConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSQLResultSetPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSQLResultSet::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsSQLResultSet_rowsGetter(JSGlobalObject& lexicalGlobalObject, JSSQLResultSet& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<SQLResultSetRowList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.rows())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSQLResultSet_rows, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSQLResultSet>::get<jsSQLResultSet_rowsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSQLResultSet_insertIdGetter(JSGlobalObject& lexicalGlobalObject, JSSQLResultSet& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLongLong>(lexicalGlobalObject, throwScope, impl.insertId())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSQLResultSet_insertId, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSQLResultSet>::get<jsSQLResultSet_insertIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSQLResultSet_rowsAffectedGetter(JSGlobalObject& lexicalGlobalObject, JSSQLResultSet& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.rowsAffected())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSQLResultSet_rowsAffected, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSQLResultSet>::get<jsSQLResultSet_rowsAffectedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSQLResultSet::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSQLResultSet, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSQLResultSet.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSQLResultSet = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSQLResultSet.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSQLResultSet = std::forward<decltype(space)>(space); }
    );
}

void JSSQLResultSet::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSQLResultSet*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSQLResultSetOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSQLResultSetOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSQLResultSet = static_cast<JSSQLResultSet*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSQLResultSet->wrapped(), jsSQLResultSet);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SQLResultSet@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12SQLResultSetE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SQLResultSet>&& impl)
{

    if constexpr (std::is_polymorphic_v<SQLResultSet>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7SQLResultSet@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12SQLResultSetE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // SQLResultSet has subclasses. If SQLResultSet has subclasses that get passed
        // to toJS() we currently require SQLResultSet you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<SQLResultSet>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SQLResultSet& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SQLResultSet* JSSQLResultSet::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSQLResultSet*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
