/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUMultisampleState.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> GPUMultisampleState convertDictionary<GPUMultisampleState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUMultisampleState result;
    JSValue alphaToCoverageEnabledValue;
    if (isNullOrUndefined)
        alphaToCoverageEnabledValue = jsUndefined();
    else {
        alphaToCoverageEnabledValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "alphaToCoverageEnabled"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!alphaToCoverageEnabledValue.isUndefined()) {
        result.alphaToCoverageEnabled = convert<IDLBoolean>(lexicalGlobalObject, alphaToCoverageEnabledValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.alphaToCoverageEnabled = false;
    JSValue countValue;
    if (isNullOrUndefined)
        countValue = jsUndefined();
    else {
        countValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "count"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!countValue.isUndefined()) {
        result.count = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, countValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.count = 1;
    JSValue maskValue;
    if (isNullOrUndefined)
        maskValue = jsUndefined();
    else {
        maskValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mask"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!maskValue.isUndefined()) {
        result.mask = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, maskValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.mask = 0xFFFFFFFF;
    return result;
}

} // namespace WebCore
