/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMMatrix2DInit.h"

#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> DOMMatrix2DInit convertDictionary<DOMMatrix2DInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    DOMMatrix2DInit result;
    JSValue aValue;
    if (isNullOrUndefined)
        aValue = jsUndefined();
    else {
        aValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "a"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!aValue.isUndefined()) {
        result.a = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, aValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue bValue;
    if (isNullOrUndefined)
        bValue = jsUndefined();
    else {
        bValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "b"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bValue.isUndefined()) {
        result.b = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, bValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue cValue;
    if (isNullOrUndefined)
        cValue = jsUndefined();
    else {
        cValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "c"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cValue.isUndefined()) {
        result.c = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, cValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue dValue;
    if (isNullOrUndefined)
        dValue = jsUndefined();
    else {
        dValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "d"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dValue.isUndefined()) {
        result.d = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, dValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue eValue;
    if (isNullOrUndefined)
        eValue = jsUndefined();
    else {
        eValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "e"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!eValue.isUndefined()) {
        result.e = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, eValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue fValue;
    if (isNullOrUndefined)
        fValue = jsUndefined();
    else {
        fValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "f"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!fValue.isUndefined()) {
        result.f = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, fValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue m11Value;
    if (isNullOrUndefined)
        m11Value = jsUndefined();
    else {
        m11Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m11"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!m11Value.isUndefined()) {
        result.m11 = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m11Value);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue m12Value;
    if (isNullOrUndefined)
        m12Value = jsUndefined();
    else {
        m12Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m12"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!m12Value.isUndefined()) {
        result.m12 = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m12Value);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue m21Value;
    if (isNullOrUndefined)
        m21Value = jsUndefined();
    else {
        m21Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m21"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!m21Value.isUndefined()) {
        result.m21 = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m21Value);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue m22Value;
    if (isNullOrUndefined)
        m22Value = jsUndefined();
    else {
        m22Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m22"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!m22Value.isUndefined()) {
        result.m22 = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m22Value);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue m41Value;
    if (isNullOrUndefined)
        m41Value = jsUndefined();
    else {
        m41Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m41"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!m41Value.isUndefined()) {
        result.m41 = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m41Value);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue m42Value;
    if (isNullOrUndefined)
        m42Value = jsUndefined();
    else {
        m42Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m42"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!m42Value.isUndefined()) {
        result.m42 = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m42Value);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

} // namespace WebCore
