/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCOEPInheritenceViolationReportBody.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCOEPInheritenceViolationReportBodyPrototypeFunction_toJSON);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCOEPInheritenceViolationReportBody_disposition);
static JSC_DECLARE_CUSTOM_GETTER(jsCOEPInheritenceViolationReportBody_type);
static JSC_DECLARE_CUSTOM_GETTER(jsCOEPInheritenceViolationReportBody_blockedURL);

class JSCOEPInheritenceViolationReportBodyPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCOEPInheritenceViolationReportBodyPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCOEPInheritenceViolationReportBodyPrototype* ptr = new (NotNull, JSC::allocateCell<JSCOEPInheritenceViolationReportBodyPrototype>(vm)) JSCOEPInheritenceViolationReportBodyPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCOEPInheritenceViolationReportBodyPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCOEPInheritenceViolationReportBodyPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCOEPInheritenceViolationReportBodyPrototype, JSCOEPInheritenceViolationReportBodyPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSCOEPInheritenceViolationReportBodyPrototypeTableValues[] =
{
    { "disposition"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCOEPInheritenceViolationReportBody_disposition, 0 } },
    { "type"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCOEPInheritenceViolationReportBody_type, 0 } },
    { "blockedURL"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCOEPInheritenceViolationReportBody_blockedURL, 0 } },
    { "toJSON"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCOEPInheritenceViolationReportBodyPrototypeFunction_toJSON, 0 } },
};

const ClassInfo JSCOEPInheritenceViolationReportBodyPrototype::s_info = { "COEPInheritenceViolationReportBody"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCOEPInheritenceViolationReportBodyPrototype) };

void JSCOEPInheritenceViolationReportBodyPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCOEPInheritenceViolationReportBody::info(), JSCOEPInheritenceViolationReportBodyPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCOEPInheritenceViolationReportBody::s_info = { "COEPInheritenceViolationReportBody"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCOEPInheritenceViolationReportBody) };

JSCOEPInheritenceViolationReportBody::JSCOEPInheritenceViolationReportBody(Structure* structure, JSDOMGlobalObject& globalObject, Ref<COEPInheritenceViolationReportBody>&& impl)
    : JSReportBody(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, COEPInheritenceViolationReportBody>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCOEPInheritenceViolationReportBody::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCOEPInheritenceViolationReportBodyPrototype::createStructure(vm, &globalObject, JSReportBody::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCOEPInheritenceViolationReportBodyPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCOEPInheritenceViolationReportBody::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCOEPInheritenceViolationReportBody>(vm, globalObject);
}

static inline JSValue jsCOEPInheritenceViolationReportBody_dispositionGetter(JSGlobalObject& lexicalGlobalObject, JSCOEPInheritenceViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.disposition())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCOEPInheritenceViolationReportBody_disposition, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCOEPInheritenceViolationReportBody>::get<jsCOEPInheritenceViolationReportBody_dispositionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCOEPInheritenceViolationReportBody_typeGetter(JSGlobalObject& lexicalGlobalObject, JSCOEPInheritenceViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.type())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCOEPInheritenceViolationReportBody_type, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCOEPInheritenceViolationReportBody>::get<jsCOEPInheritenceViolationReportBody_typeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCOEPInheritenceViolationReportBody_blockedURLGetter(JSGlobalObject& lexicalGlobalObject, JSCOEPInheritenceViolationReportBody& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.blockedURL())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCOEPInheritenceViolationReportBody_blockedURL, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCOEPInheritenceViolationReportBody>::get<jsCOEPInheritenceViolationReportBody_blockedURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline EncodedJSValue jsCOEPInheritenceViolationReportBodyPrototypeFunction_toJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSCOEPInheritenceViolationReportBody* castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* result = constructEmptyObject(lexicalGlobalObject);
    auto dispositionValue = toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.disposition());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "disposition"_s), dispositionValue);
    auto typeValue = toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.type());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "type"_s), typeValue);
    auto blockedURLValue = toJS<IDLUSVString>(*lexicalGlobalObject, throwScope, impl.blockedURL());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "blockedURL"_s), blockedURLValue);
    return JSValue::encode(result);
}

JSC_DEFINE_HOST_FUNCTION(jsCOEPInheritenceViolationReportBodyPrototypeFunction_toJSON, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCOEPInheritenceViolationReportBody>::call<jsCOEPInheritenceViolationReportBodyPrototypeFunction_toJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

JSC::GCClient::IsoSubspace* JSCOEPInheritenceViolationReportBody::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCOEPInheritenceViolationReportBody, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCOEPInheritenceViolationReportBody.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCOEPInheritenceViolationReportBody = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCOEPInheritenceViolationReportBody.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCOEPInheritenceViolationReportBody = std::forward<decltype(space)>(space); }
    );
}

void JSCOEPInheritenceViolationReportBody::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCOEPInheritenceViolationReportBody*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
