/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSAudioParamDescriptor.h"

#include "JSAutomationRate.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> AudioParamDescriptor convertDictionary<AudioParamDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    AudioParamDescriptor result;
    JSValue automationRateValue;
    if (isNullOrUndefined)
        automationRateValue = jsUndefined();
    else {
        automationRateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "automationRate"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!automationRateValue.isUndefined()) {
        result.automationRate = convert<IDLEnumeration<AutomationRate>>(lexicalGlobalObject, automationRateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.automationRate = AutomationRate::ARate;
    JSValue defaultValueValue;
    if (isNullOrUndefined)
        defaultValueValue = jsUndefined();
    else {
        defaultValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "defaultValue"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!defaultValueValue.isUndefined()) {
        result.defaultValue = convert<IDLFloat>(lexicalGlobalObject, defaultValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.defaultValue = 0;
    JSValue maxValueValue;
    if (isNullOrUndefined)
        maxValueValue = jsUndefined();
    else {
        maxValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "maxValue"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!maxValueValue.isUndefined()) {
        result.maxValue = convert<IDLFloat>(lexicalGlobalObject, maxValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.maxValue = 3.4028235e38;
    JSValue minValueValue;
    if (isNullOrUndefined)
        minValueValue = jsUndefined();
    else {
        minValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "minValue"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!minValueValue.isUndefined()) {
        result.minValue = convert<IDLFloat>(lexicalGlobalObject, minValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.minValue = -3.4028235e38;
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nameValue.isUndefined()) {
        result.name = convert<IDLDOMString>(lexicalGlobalObject, nameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "name", "AudioParamDescriptor", "DOMString");
        return { };
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
