/* Generated by nsgenbind
 *
 * nsgenbind is published under the MIT Licence.
 * nsgenbind is similar to a compiler is a purely transformative tool which
 * explicitly makes no copyright claim on this generated output
 */

/* DukTape JavaScript bindings for NetSurf browser
 *
 * Copyright 2015 Vincent Sanders <vince@netsurf-browser.org>
 * This file is part of NetSurf, http://www.netsurf-browser.org/
 * Released under the terms of the MIT License,
 *        http://www.opensource.org/licenses/mit-license
 */

#include <dom/dom.h>

#include "utils/log.h"
#include "utils/nsurl.h"

#include "javascript/duktape/duktape.h"

struct browser_window;
struct html_content;
struct dom_node;
struct dom_element;
struct dom_document;
struct dom_html_element;
struct dom_node_character_data;
struct dom_node_text;
struct dom_node_list;
struct dom_node_comment;
struct dom_html_collection;
struct dom_html_br_element;


#include "build/Linux-gtk3/duktape/binding.h"
#include "build/Linux-gtk3/duktape/private.h"
#include "build/Linux-gtk3/duktape/prototype.h"

#include "javascript/duktape/dukky.h"



void dukky_node___init(duk_context *ctx, node_private_t *priv, struct dom_node *node)
{
	dukky_event_target___init(ctx, &priv->parent);
#line 19 "Node.bnd"

	priv->node = node;
	dom_node_ref(node);
	priv->parent.is_node = true;
#line 54 "node.c"
}

void dukky_node___fini(duk_context *ctx, node_private_t *priv)
{

	dom_node_unref(priv->node);
	dukky_event_target___fini(ctx, &priv->parent);
}

static duk_ret_t dukky_node___constructor(duk_context *ctx)
{
	/* create private data and attach to instance */
	node_private_t *priv = calloc(1, sizeof(*priv));
	if (priv == NULL) return 0;
	duk_push_pointer(ctx, priv);
	duk_put_prop_string(ctx, 0, dukky_magic_string_private);

	dukky_node___init(ctx, priv, duk_get_pointer(ctx, 1));
	duk_set_top(ctx, 1);
	return 1;
}

static duk_ret_t dukky_node___destructor(duk_context *ctx)
{
	node_private_t *priv;
	duk_get_prop_string(ctx, 0, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop(ctx);
	if (priv == NULL) return 0;

	dukky_node___fini(ctx, priv);
	free(priv);
	return 0;
}

static duk_ret_t dukky_node_hasChildNodes(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 103 "Node.bnd"

	dom_exception exc;
	bool res;
	exc = dom_node_has_child_nodes(priv->node, &res);
	if (exc != DOM_NO_ERR) return 0;
	duk_push_boolean(ctx, res);
	return 1;
#line 118 "node.c"
}

static duk_ret_t dukky_node_normalize(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc > 0) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 0);
	}

	/* check types of passed arguments are correct */
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 260 "Node.bnd"

	dom_exception exc;
	exc = dom_node_normalize(priv->node);
	if (exc != DOM_NO_ERR) return 0;
	return 0;
#line 147 "node.c"
}

static duk_ret_t dukky_node_cloneNode(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc == 0) {
		/* 1 optional arguments need adding */
		duk_push_boolean(ctx, 0);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_boolean(ctx, 0)) {
			if (duk_is_number(ctx, 0)) {
				duk_to_boolean(ctx, 0);
			} else {
				return duk_error(ctx, DUK_ERR_ERROR, dukky_error_fmt_bool_type, 0, "deep");
			}
		}
	}
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 268 "Node.bnd"

	dom_exception exc;
	bool deep;
	dom_node *clone;

	deep = duk_to_boolean(ctx, 0);

	exc = dom_node_clone_node(priv->node, deep, &clone);
	if (exc != DOM_NO_ERR) return 0;
	duk_set_top(ctx, 0);
	dukky_push_node(ctx, clone);
	dom_node_unref(clone);
	return 1;
#line 196 "node.c"
}

static duk_ret_t dukky_node_isEqualNode(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		/* unhandled type check */
	}
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 284 "Node.bnd"

	dom_exception exc;
	bool result;

	if (!dukky_instanceof(ctx, 0, PROTO_NAME(NODE))) return 0;

	duk_get_prop_string(ctx, 0, PRIVATE_MAGIC);
	node_private_t *other = duk_get_pointer(ctx, -1);
	duk_pop(ctx);

	exc = dom_node_is_equal(priv->node, other->node, &result);
	if (exc != DOM_NO_ERR) return 0;
	duk_push_boolean(ctx, result);
	return 1;
#line 240 "node.c"
}

static duk_ret_t dukky_node_compareDocumentPosition(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		/* unhandled type check */
	}
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 301 "Node.bnd"

	dom_exception exc;
	uint16_t ret;

	if (!dukky_instanceof(ctx, 0, PROTO_NAME(NODE))) return 0;

	duk_get_prop_string(ctx, 0, PRIVATE_MAGIC);
	node_private_t *other = duk_get_pointer(ctx, -1);
	duk_pop(ctx);

	exc = dom_node_compare_document_position(priv->node, other->node,
			&ret);

	if (exc != DOM_NO_ERR) return 0;

	duk_push_uint(ctx, ret);

	return 1;
#line 288 "node.c"
}

static duk_ret_t dukky_node_contains(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		/* unhandled type check */
	}
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 322 "Node.bnd"

	dom_exception exc;
	uint16_t ret;

	if (!dukky_instanceof(ctx, 0, PROTO_NAME(NODE))) return 0;

	duk_get_prop_string(ctx, 0, PRIVATE_MAGIC);
	node_private_t *other = duk_get_pointer(ctx, -1);
	duk_pop(ctx);

	/* Note that inclusive descendant says *IS* or *CONTAINED_BY* */
	if (priv->node == other->node) {
		duk_push_boolean(ctx, true);
		return 1;
	}

	exc = dom_node_compare_document_position(priv->node, other->node,
			&ret);

	if (exc != DOM_NO_ERR) return 0;

	duk_push_boolean(ctx, ret == DOM_DOCUMENT_POSITION_CONTAINED_BY);

	return 1;
#line 342 "node.c"
}

static duk_ret_t dukky_node_lookupPrefix(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 349 "Node.bnd"

	dom_exception exc;
	dom_string *ns, *pfx;
	duk_size_t size;
	const char *s = duk_safe_to_lstring(ctx, 0, &size);
	exc = dom_string_create((const uint8_t *)s, size, &ns);
	if (exc != DOM_NO_ERR) return 0;
	exc = dom_node_lookup_prefix(priv->node, ns, &pfx);
	dom_string_unref(ns);
	if (exc != DOM_NO_ERR) return 0;
	if (pfx == NULL) return 0;
	duk_push_lstring(ctx, dom_string_data(pfx), dom_string_length(pfx));
	dom_string_unref(pfx);
	return 0;
#line 388 "node.c"
}

static duk_ret_t dukky_node_lookupNamespaceURI(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 366 "Node.bnd"

	dom_exception exc;
	dom_string *ns, *pfx;
	duk_size_t size;
	const char *s = duk_safe_to_lstring(ctx, 0, &size);
	exc = dom_string_create((const uint8_t *)s, size, &pfx);
	if (exc != DOM_NO_ERR) return 0;
	exc = dom_node_lookup_namespace(priv->node, pfx, &ns);
	dom_string_unref(pfx);
	if (exc != DOM_NO_ERR) return 0;
	if (ns == NULL) return 0;
	duk_push_lstring(ctx, dom_string_data(ns), dom_string_length(ns));
	dom_string_unref(ns);
	return 0;
#line 434 "node.c"
}

static duk_ret_t dukky_node_isDefaultNamespace(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		if (!duk_is_string(ctx, 0)) {
			duk_to_string(ctx, 0);
		}
	}
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 384 "Node.bnd"

	dom_exception exc;
	dom_string *ns;
	duk_size_t size;
	const char *s = duk_safe_to_lstring(ctx, 0, &size);
	bool ret;
	exc = dom_string_create((const uint8_t *)s, size, &ns);
	if (exc != DOM_NO_ERR) return 0;
	exc = dom_node_is_default_namespace(priv->node, ns, &ret);
	dom_string_unref(ns);
	if (exc != DOM_NO_ERR) return 0;
	duk_push_boolean(ctx, ret);
	return 1;
#line 479 "node.c"
}

static duk_ret_t dukky_node_insertBefore(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 2) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 2, dukky_argc);
	} else if (dukky_argc > 2) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 2);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		/* unhandled type check */
	}
	if (dukky_argc > 1) {
		/* unhandled type check */
	}
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 400 "Node.bnd"

	if (!dukky_instanceof(ctx, 0, PROTO_NAME(NODE))) return 0;

	duk_get_prop_string(ctx, 0, PRIVATE_MAGIC);
	node_private_t *other = duk_get_pointer(ctx, -1);
	duk_pop(ctx);

	dom_node *before = NULL;

	if (duk_get_top(ctx) == 2) {
		if (!dukky_instanceof(ctx, 1, PROTO_NAME(NODE))) return 0;
		duk_get_prop_string(ctx, 1, PRIVATE_MAGIC);
		node_private_t *another = duk_get_pointer(ctx, -1);
		before = another->node;
		duk_pop(ctx);
	}

	dom_exception err;
	dom_node *spare;

	err = dom_node_insert_before(priv->node, other->node, before, &spare);
	if (err != DOM_NO_ERR) return 0;
	dukky_push_node(ctx, spare);
	dom_node_unref(spare);

	return 1;
#line 538 "node.c"
}

static duk_ret_t dukky_node_appendChild(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		/* unhandled type check */
	}
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 429 "Node.bnd"

	if (!dukky_instanceof(ctx, 0, PROTO_NAME(NODE))) return 0;

	duk_get_prop_string(ctx, 0, PRIVATE_MAGIC);
	node_private_t *other = duk_get_pointer(ctx, -1);
	duk_pop(ctx);

	dom_exception err;
	dom_node *spare;

	NSLOG(dukky, DEEPDEBUG, "About to append %p to %p", other->node, priv->node);
	err = dom_node_append_child(priv->node, other->node, &spare);
	if (err != DOM_NO_ERR) return 0;
	dukky_push_node(ctx, spare);
	dom_node_unref(spare);

	return 1;
#line 585 "node.c"
}

static duk_ret_t dukky_node_replaceChild(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 2) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 2, dukky_argc);
	} else if (dukky_argc > 2) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 2);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		/* unhandled type check */
	}
	if (dukky_argc > 1) {
		/* unhandled type check */
	}
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 449 "Node.bnd"

	if (!dukky_instanceof(ctx, 0, PROTO_NAME(NODE))) return 0;

	duk_get_prop_string(ctx, 0, PRIVATE_MAGIC);
	node_private_t *other = duk_get_pointer(ctx, -1);
	duk_pop(ctx);

	if (!dukky_instanceof(ctx, 1, PROTO_NAME(NODE))) return 0;

	duk_get_prop_string(ctx, 1, PRIVATE_MAGIC);
	node_private_t *old = duk_get_pointer(ctx, -1);
	duk_pop(ctx);

	dom_exception err;
	dom_node *spare;

	err = dom_node_replace_child(priv->node, other->node, old->node, &spare);
	if (err != DOM_NO_ERR) return 0;
	dukky_push_node(ctx, spare);
	dom_node_unref(spare);

	return 1;
#line 640 "node.c"
}

static duk_ret_t dukky_node_removeChild(duk_context *ctx)
{
	/* ensure the parameters are present */
	duk_idx_t dukky_argc = duk_get_top(ctx);
	if (dukky_argc < 1) {
		/* not enough arguments */
		return duk_error(ctx, DUK_RET_TYPE_ERROR, dukky_error_fmt_argument, 1, dukky_argc);
	} else if (dukky_argc > 1) {
		/* remove extraneous parameters */
		duk_set_top(ctx, 1);
	}

	/* check types of passed arguments are correct */
	if (dukky_argc > 0) {
		/* unhandled type check */
	}
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 474 "Node.bnd"

	if (!dukky_instanceof(ctx, 0, PROTO_NAME(NODE))) return 0;

	duk_get_prop_string(ctx, 0, PRIVATE_MAGIC);
	node_private_t *other = duk_get_pointer(ctx, -1);
	duk_pop(ctx);

	dom_exception err;
	dom_node *spare;

	err = dom_node_remove_child(priv->node, other->node, &spare);
	if (err != DOM_NO_ERR) return 0;
	dukky_push_node(ctx, spare);
	dom_node_unref(spare);

	return 1;
#line 686 "node.c"
}

static duk_ret_t dukky_node_nodeType_getter(duk_context *ctx)
{
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 31 "Node.bnd"

	dom_exception exc;
	dom_node_type ntype;
	exc = dom_node_get_node_type(priv->node, &ntype);
	if (exc != DOM_NO_ERR) return 0;
	duk_push_uint(ctx, (duk_uint_t)ntype);
	return 1;
#line 709 "node.c"
}

static duk_ret_t dukky_node_nodeName_getter(duk_context *ctx)
{
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 41 "Node.bnd"

	dom_exception exc;
	dom_string *str = NULL;
	exc = dom_node_get_node_name(priv->node, &str);
	if (exc != DOM_NO_ERR) return 0;
	duk_push_lstring(ctx, dom_string_data(str), dom_string_length(str));
	dom_string_unref(str);
	return 1;
#line 733 "node.c"
}

static duk_ret_t dukky_node_baseURI_getter(duk_context *ctx)
{
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 52 "Node.bnd"

	dom_exception exc;
	dom_string *base = NULL;
	exc = dom_node_get_base(priv->node, &base);
	if (exc != DOM_NO_ERR) return 0;
	assert(base != NULL);
	duk_push_lstring(ctx, dom_string_data(base), dom_string_length(base));
	dom_string_unref(base);
	return 1;
#line 758 "node.c"
}

static duk_ret_t dukky_node_ownerDocument_getter(duk_context *ctx)
{
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 64 "Node.bnd"

	dom_exception exc;
	dom_node *doc;
	exc = dom_node_get_owner_document(priv->node, &doc);
	if (exc != DOM_NO_ERR) return 0;
	if (doc == NULL) return 0;
	dukky_push_node(ctx, doc);
	dom_node_unref(doc);
	return 1;
#line 783 "node.c"
}

static duk_ret_t dukky_node_parentNode_getter(duk_context *ctx)
{
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 76 "Node.bnd"

	dom_exception exc;
	dom_node *pnode = NULL;
	exc = dom_node_get_parent_node(priv->node, &pnode);
	if (exc != DOM_NO_ERR) return 0;
	dukky_push_node(ctx, pnode);
	dom_node_unref(pnode);
	return 1;
#line 807 "node.c"
}

static duk_ret_t dukky_node_parentElement_getter(duk_context *ctx)
{
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 87 "Node.bnd"

	dom_exception exc;
	dom_node *pnode = NULL;
	dom_node_type ntype = DOM_NODE_TYPE_COUNT + 1;
	exc = dom_node_get_parent_node(priv->node, &pnode);
	if (exc != DOM_NO_ERR) return 0;
	if (pnode != NULL) {
		exc = dom_node_get_node_type(pnode, &ntype);
		if (exc != DOM_NO_ERR) { dom_node_unref(pnode); return 0; }
	}
	dukky_push_node(ctx, (ntype == DOM_ELEMENT_NODE) ? pnode : NULL);
	dom_node_unref(pnode);
	return 1;
#line 836 "node.c"
}

static duk_ret_t dukky_node_childNodes_getter(duk_context *ctx)
{
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 113 "Node.bnd"

	dom_exception exc;
	dom_nodelist *nlist = NULL;
	duk_set_top(ctx, 0);
	duk_push_this(ctx);
	duk_get_prop_string(ctx, 0, MAGIC(childNodes));
	if (duk_is_undefined(ctx, -1)) {
		duk_pop(ctx);
		exc = dom_node_get_child_nodes(priv->node, &nlist);
		if (exc != DOM_NO_ERR) return 0;
		dukky_push_generics(ctx, "makeListProxy");
		duk_push_pointer(ctx, nlist);
		if (dukky_create_object(ctx, PROTO_NAME(NODELIST), 1) != DUK_EXEC_SUCCESS) {
			dom_nodelist_unref(nlist);
			return 0;
		}
		dom_nodelist_unref(nlist);
		if (dukky_pcall(ctx, 1, false) != 0) {
			NSLOG(dukky, DEBUG, "Unable to construct nodelist?");
			return 0; /* coerced to undefined */
		}
		duk_dup(ctx, -1);
		duk_put_prop_string(ctx, 0, MAGIC(childNodes));
	}
	return 1;
#line 877 "node.c"
}

static duk_ret_t dukky_node_firstChild_getter(duk_context *ctx)
{
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 141 "Node.bnd"

	dom_exception exc;
	dom_node *n;
	exc = dom_node_get_first_child(priv->node, &n);
	if (exc != DOM_NO_ERR) return 0;
	if (dukky_push_node(ctx, n) == false) {
		dom_node_unref(n);
		return 0;
	}
	dom_node_unref(n);
	return 1;
#line 904 "node.c"
}

static duk_ret_t dukky_node_lastChild_getter(duk_context *ctx)
{
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 155 "Node.bnd"

	dom_exception exc;
	dom_node *n;
	exc = dom_node_get_last_child(priv->node, &n);
	if (exc != DOM_NO_ERR) return 0;
	if (dukky_push_node(ctx, n) == false) {
		dom_node_unref(n);
		return 0;
	}
	dom_node_unref(n);
	return 1;
#line 931 "node.c"
}

static duk_ret_t dukky_node_previousSibling_getter(duk_context *ctx)
{
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 169 "Node.bnd"

	dom_exception exc;
	dom_node *n;
	exc = dom_node_get_previous_sibling(priv->node, &n);
	if (exc != DOM_NO_ERR) return 0;
	if (dukky_push_node(ctx, n) == false) {
		dom_node_unref(n);
		return 0;
	}
	dom_node_unref(n);
	return 1;
#line 958 "node.c"
}

static duk_ret_t dukky_node_nextSibling_getter(duk_context *ctx)
{
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 183 "Node.bnd"

	dom_exception exc;
	dom_node *n;
	exc = dom_node_get_next_sibling(priv->node, &n);
	if (exc != DOM_NO_ERR) return 0;
	if (dukky_push_node(ctx, n) == false) {
		dom_node_unref(n);
		return 0;
	}
	dom_node_unref(n);
	return 1;
#line 985 "node.c"
}

static duk_ret_t dukky_node_nodeValue_getter(duk_context *ctx)
{
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 197 "Node.bnd"

	dom_exception exc;
	dom_string *content;

	exc = dom_node_get_node_value(priv->node, &content);
	if (exc != DOM_NO_ERR) {
		return 0;
	}

	if (content != NULL) {
		duk_push_lstring(ctx, dom_string_data(content), dom_string_length(content));
		dom_string_unref(content);
		return 1;
	}
	return 0;
#line 1016 "node.c"
}

static duk_ret_t dukky_node_nodeValue_setter(duk_context *ctx)
{
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 215 "Node.bnd"

	dom_exception exc;
	dom_string *content;
	duk_size_t slen;
	const char *s = duk_safe_to_lstring(ctx, 0, &slen);
	exc = dom_string_create((const uint8_t *)s, slen, &content);
	if (exc != DOM_NO_ERR) return 0;
	exc = dom_node_set_node_value(priv->node, content);
	dom_string_unref(content);
	if (exc != DOM_NO_ERR) return 0;
	return 1;
#line 1043 "node.c"
}

static duk_ret_t dukky_node_textContent_getter(duk_context *ctx)
{
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 229 "Node.bnd"

	dom_exception exc;
	dom_string *content;

	exc = dom_node_get_text_content(priv->node, &content);
	if (exc != DOM_NO_ERR) {
		return 0;
	}

	if (content != NULL) {
		duk_push_lstring(ctx, dom_string_data(content), dom_string_length(content));
		dom_string_unref(content);
		return 1;
	}
	return 0;
#line 1074 "node.c"
}

static duk_ret_t dukky_node_textContent_setter(duk_context *ctx)
{
	/* Get private data for method */
	node_private_t *priv = NULL;
	duk_push_this(ctx);
	duk_get_prop_string(ctx, -1, dukky_magic_string_private);
	priv = duk_get_pointer(ctx, -1);
	duk_pop_2(ctx);
	if (priv == NULL) {
		return 0; /* can do? No can do. */
	}

#line 247 "Node.bnd"

	dom_exception exc;
	dom_string *content;
	duk_size_t slen;
	const char *s = duk_safe_to_lstring(ctx, 0, &slen);
	exc = dom_string_create((const uint8_t *)s, slen, &content);
	if (exc != DOM_NO_ERR) return 0;
	exc = dom_node_set_text_content(priv->node, content);
	dom_string_unref(content);
	return 0;
#line 1100 "node.c"
}

duk_ret_t dukky_node___proto(duk_context *ctx, void *udata)
{
	/* Set this prototype's prototype (left-parent) */
	/* get prototype */
	duk_get_global_string(ctx, dukky_magic_string_prototypes);
	duk_get_prop_string(ctx, -1, "\xFF\xFFNETSURF_DUKTAPE_PROTOTYPE_EVENTTARGET");
	duk_replace(ctx, -2);
	duk_set_prototype(ctx, 0);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "hasChildNodes");
	duk_push_c_function(ctx, dukky_node_hasChildNodes, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "normalize");
	duk_push_c_function(ctx, dukky_node_normalize, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "cloneNode");
	duk_push_c_function(ctx, dukky_node_cloneNode, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "isEqualNode");
	duk_push_c_function(ctx, dukky_node_isEqualNode, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "compareDocumentPosition");
	duk_push_c_function(ctx, dukky_node_compareDocumentPosition, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "contains");
	duk_push_c_function(ctx, dukky_node_contains, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "lookupPrefix");
	duk_push_c_function(ctx, dukky_node_lookupPrefix, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "lookupNamespaceURI");
	duk_push_c_function(ctx, dukky_node_lookupNamespaceURI, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "isDefaultNamespace");
	duk_push_c_function(ctx, dukky_node_isDefaultNamespace, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "insertBefore");
	duk_push_c_function(ctx, dukky_node_insertBefore, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "appendChild");
	duk_push_c_function(ctx, dukky_node_appendChild, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "replaceChild");
	duk_push_c_function(ctx, dukky_node_replaceChild, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add a method */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "removeChild");
	duk_push_c_function(ctx, dukky_node_removeChild, DUK_VARARGS);
	duk_def_prop(ctx, -3,
		     DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "nodeType");
	duk_push_c_function(ctx, dukky_node_nodeType_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "nodeName");
	duk_push_c_function(ctx, dukky_node_nodeName_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "baseURI");
	duk_push_c_function(ctx, dukky_node_baseURI_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "ownerDocument");
	duk_push_c_function(ctx, dukky_node_ownerDocument_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "parentNode");
	duk_push_c_function(ctx, dukky_node_parentNode_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "parentElement");
	duk_push_c_function(ctx, dukky_node_parentElement_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "childNodes");
	duk_push_c_function(ctx, dukky_node_childNodes_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "firstChild");
	duk_push_c_function(ctx, dukky_node_firstChild_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "lastChild");
	duk_push_c_function(ctx, dukky_node_lastChild_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "previousSibling");
	duk_push_c_function(ctx, dukky_node_previousSibling_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add readonly property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "nextSibling");
	duk_push_c_function(ctx, dukky_node_nextSibling_getter, 0);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "nodeValue");
	duk_push_c_function(ctx, dukky_node_nodeValue_getter, 0);
	duk_push_c_function(ctx, dukky_node_nodeValue_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Add read/write property */
	duk_dup(ctx, 0);
	duk_push_string(ctx, "textContent");
	duk_push_c_function(ctx, dukky_node_textContent_getter, 0);
	duk_push_c_function(ctx, dukky_node_textContent_setter, 1);
	duk_def_prop(ctx, -4, DUK_DEFPROP_HAVE_GETTER |
		DUK_DEFPROP_HAVE_SETTER |
		DUK_DEFPROP_HAVE_ENUMERABLE | DUK_DEFPROP_ENUMERABLE |
		DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "ELEMENT_NODE");
	duk_push_int(ctx, 1);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "ATTRIBUTE_NODE");
	duk_push_int(ctx, 2);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "TEXT_NODE");
	duk_push_int(ctx, 3);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "CDATA_SECTION_NODE");
	duk_push_int(ctx, 4);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "ENTITY_REFERENCE_NODE");
	duk_push_int(ctx, 5);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "ENTITY_NODE");
	duk_push_int(ctx, 6);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "PROCESSING_INSTRUCTION_NODE");
	duk_push_int(ctx, 7);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "COMMENT_NODE");
	duk_push_int(ctx, 8);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "DOCUMENT_NODE");
	duk_push_int(ctx, 9);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "DOCUMENT_TYPE_NODE");
	duk_push_int(ctx, 10);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "DOCUMENT_FRAGMENT_NODE");
	duk_push_int(ctx, 11);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "NOTATION_NODE");
	duk_push_int(ctx, 12);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "DOCUMENT_POSITION_DISCONNECTED");
	duk_push_int(ctx, 1);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "DOCUMENT_POSITION_PRECEDING");
	duk_push_int(ctx, 2);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "DOCUMENT_POSITION_FOLLOWING");
	duk_push_int(ctx, 4);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "DOCUMENT_POSITION_CONTAINS");
	duk_push_int(ctx, 8);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "DOCUMENT_POSITION_CONTAINED_BY");
	duk_push_int(ctx, 16);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	duk_dup(ctx, 0);
	duk_push_string(ctx, "DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC");
	duk_push_int(ctx, 32);
	duk_def_prop(ctx, -3, DUK_DEFPROP_HAVE_VALUE |
		     DUK_DEFPROP_HAVE_WRITABLE |
		     DUK_DEFPROP_HAVE_ENUMERABLE |
		     DUK_DEFPROP_ENUMERABLE |
		     DUK_DEFPROP_HAVE_CONFIGURABLE);
	duk_pop(ctx);

	/* Set the destructor */
	duk_dup(ctx, 0);
	duk_push_c_function(ctx, dukky_node___destructor, 1);
	duk_set_finalizer(ctx, -2);
	duk_pop(ctx);

	/* Set the constructor */
	duk_dup(ctx, 0);
	duk_push_c_function(ctx, dukky_node___constructor, 2);
	duk_put_prop_string(ctx, -2, "\xFF\xFFNETSURF_DUKTAPE_INIT");
	duk_pop(ctx);

	return 1; /* The prototype object */
}


