/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.UIServiceImpl;
import net.java.sip.communicator.impl.gui.event.PluginComponentEvent;
import net.java.sip.communicator.impl.gui.event.PluginComponentListener;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.authorization.RequestAuthorizationDialog;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.history.HistoryWindow;
import net.java.sip.communicator.impl.gui.main.chat.history.HistoryWindowManager;
import net.java.sip.communicator.impl.gui.main.contactlist.AddContactDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.MetaContactListManager;
import net.java.sip.communicator.impl.gui.main.contactlist.MoveSubcontactMessageDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.RenameContactDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.TreeContactList;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaContactListSource;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaUIContact;
import net.java.sip.communicator.impl.gui.main.contactlist.contactsource.MetaUIGroup;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.GenericFileDialog;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommMenu;
import net.java.sip.communicator.plugin.desktoputil.SIPCommPopupMenu;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileChooser;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.gui.Container;
import net.java.sip.communicator.service.gui.PluginComponent;
import net.java.sip.communicator.service.gui.PluginComponentFactory;
import net.java.sip.communicator.service.gui.UIContact;
import net.java.sip.communicator.service.gui.UIGroup;
import net.java.sip.communicator.service.gui.event.ContactListEvent;
import net.java.sip.communicator.service.gui.event.ContactListListener;
import net.java.sip.communicator.service.protocol.AuthorizationRequest;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetBasicInstantMessaging;
import net.java.sip.communicator.service.protocol.OperationSetExtendedAuthorizations;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresencePermissions;
import net.java.sip.communicator.service.protocol.OperationSetSmsMessaging;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ConfigurationUtils;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.call.MetaContactPhoneUtil;
import net.java.sip.communicator.util.skin.Skinnable;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class MetaContactRightButtonMenu
extends SIPCommPopupMenu
implements ActionListener,
PluginComponentListener,
ContactListListener,
Skinnable {
    private static final long serialVersionUID = 3033031652970285857L;
    private final Logger logger = Logger.getLogger(MetaContactRightButtonMenu.class);
    private static final String allContactsString = GuiActivator.getResources().getI18NString("service.gui.ALL_CONTACTS");
    private static final String callString = GuiActivator.getResources().getI18NString("service.gui.CALL");
    private static final String removeString = GuiActivator.getResources().getI18NString("service.gui.REMOVE_CONTACT");
    private final SIPCommMenu moveToMenu = new SIPCommMenu(GuiActivator.getResources().getI18NString("service.gui.MOVE_TO_GROUP"));
    private final SIPCommMenu moveSubcontactMenu = new SIPCommMenu(GuiActivator.getResources().getI18NString("service.gui.MOVE_SUBCONTACT"));
    private final SIPCommMenu removeContactMenu = new SIPCommMenu(removeString);
    private final SIPCommMenu callContactMenu = new SIPCommMenu(callString);
    private final JMenuItem addContactItem = new JMenuItem();
    private final JMenuItem callItem = new JMenuItem(callString);
    private final JMenuItem videoCallItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.VIDEO_CALL"));
    private final SIPCommMenu videoCallMenu = new SIPCommMenu(GuiActivator.getResources().getI18NString("service.gui.VIDEO_CALL"));
    private final JMenuItem fullShareMenuItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.SHARE_FULL_SCREEN"));
    private final JMenuItem regionShareMenuItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.SHARE_REGION"));
    private final SIPCommMenu multiContactFullShareMenu = new SIPCommMenu(GuiActivator.getResources().getI18NString("service.gui.SHARE_FULL_SCREEN"));
    private final SIPCommMenu multiContactRegionShareMenu = new SIPCommMenu(GuiActivator.getResources().getI18NString("service.gui.SHARE_REGION"));
    private final JMenuItem sendMessageItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.SEND_MESSAGE"));
    private final JMenuItem sendFileItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.SEND_FILE"));
    private final JMenuItem sendSmsItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.SEND_SMS"));
    private final JMenuItem renameContactItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.RENAME_CONTACT"));
    private final JMenuItem viewHistoryItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.VIEW_HISTORY"));
    private final SIPCommMenu multiContactRequestAuthMenu = new SIPCommMenu(GuiActivator.getResources().getI18NString("service.gui.RE_REQUEST_AUTHORIZATION"));
    private final JMenuItem requestAuthMenuItem = new JMenuItem(GuiActivator.getResources().getI18NString("service.gui.RE_REQUEST_AUTHORIZATION"));
    private final MetaContact metaContact;
    private static final String moveToPrefix = "moveTo:";
    private static final String removeContactPrefix = "removeContact:";
    private static final String moveSubcontactPrefix = "moveSubcontact:";
    private static final String callContactPrefix = "callContact:";
    private static final String callPhonePrefix = "callPhone:";
    private static final String videoCallPrefix = "videoCall:";
    private static final String fullDesktopSharingPrefix = "shareFullScreen:";
    private static final String regionDesktopSharingPrefix = "shareRegionScreen:";
    private static final String requestAuthPrefix = "requestAuth:";
    private Contact contactToMove;
    private boolean moveAllContacts = false;
    private MoveSubcontactMessageDialog moveDialog;
    private final MainFrame mainFrame = GuiActivator.getUIService().getMainFrame();
    private final TreeContactList contactList = GuiActivator.getContactList();
    private Contact firstUnsubscribedContact = null;
    private MetaContactPhoneUtil contactPhoneUtil;
    private boolean separator = false;

    public MetaContactRightButtonMenu(MetaContact metaContact) {
        this.metaContact = metaContact;
        this.setLocation(this.getLocation());
        this.init();
        this.initMnemonics();
        this.loadSkin();
    }

    private void init() {
        JMenuItem item;
        this.addContactItem.setText(GuiActivator.getResources().getI18NString("service.gui.ADD_CONTACT_TO") + " " + this.metaContact.getDisplayName());
        Iterator groups = GuiActivator.getContactListService().getRoot().getSubgroups();
        if (groups.hasNext()) {
            JLabel infoLabel = new JLabel(GuiActivator.getResources().getI18NString("service.gui.SELECT_GROUP"));
            infoLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            infoLabel.setFont(infoLabel.getFont().deriveFont(1));
            this.moveToMenu.add((Component)infoLabel);
            this.moveToMenu.addSeparator();
        }
        if (GuiActivator.getContactList().getRootUIGroup() != null) {
            JMenuItem menuItem = new JMenuItem(GuiActivator.getContactList().getRootUIGroup().getDisplayName());
            menuItem.setName(moveToPrefix + GuiActivator.getContactListService().getRoot().getMetaUID());
            menuItem.addActionListener(this);
            this.moveToMenu.add(menuItem);
        }
        while (groups.hasNext()) {
            MetaContactGroup group = (MetaContactGroup)groups.next();
            if (!group.isPersistent()) continue;
            JMenuItem menuItem = new JMenuItem(group.getGroupName());
            menuItem.setName(moveToPrefix + group.getMetaUID());
            menuItem.addActionListener(this);
            this.moveToMenu.add(menuItem);
        }
        boolean hasOnlyReadonlyContacts = true;
        boolean hasAnyReadonlyContact = false;
        Iterator iter = this.metaContact.getContacts();
        while (iter.hasNext()) {
            Contact c = (Contact)iter.next();
            OperationSetPersistentPresencePermissions opsetPermissions = (OperationSetPersistentPresencePermissions)c.getProtocolProvider().getOperationSet(OperationSetPersistentPresencePermissions.class);
            if (opsetPermissions == null || !opsetPermissions.isReadOnly(c)) {
                hasOnlyReadonlyContacts = false;
            }
            if (opsetPermissions == null || !opsetPermissions.isReadOnly(c)) continue;
            hasAnyReadonlyContact = true;
        }
        Iterator contacts = this.metaContact.getContacts();
        if (this.metaContact.getContactCount() > 1) {
            ImageIcon deleteIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.DELETE_16x16_ICON));
            JMenuItem allItem = this.createMenuItem(allContactsString, "removeContact:allContacts", deleteIcon);
            JMenuItem allItem1 = new JMenuItem(allContactsString);
            allItem1.addActionListener(this);
            allItem1.setName("moveSubcontact:allContacts");
            if (!hasAnyReadonlyContact) {
                this.removeContactMenu.add(allItem);
                this.moveSubcontactMenu.add(allItem1);
                this.removeContactMenu.addSeparator();
                this.moveSubcontactMenu.addSeparator();
            }
        }
        this.contactPhoneUtil = MetaContactPhoneUtil.getPhoneUtil((MetaContact)this.metaContact);
        boolean hasPersistableAddress = false;
        while (contacts.hasNext()) {
            Contact contact = (Contact)contacts.next();
            ProtocolProviderService protocolProvider = contact.getProtocolProvider();
            String contactPersistableAddress = contact.getPersistableAddress();
            String contactAddress = contact.getAddress();
            ImageIcon protocolIcon = new ImageIcon(this.createContactStatusImage(contact));
            boolean isContactReadonly = false;
            OperationSetPersistentPresencePermissions opsetPermissions = (OperationSetPersistentPresencePermissions)protocolProvider.getOperationSet(OperationSetPersistentPresencePermissions.class);
            if (opsetPermissions != null && opsetPermissions.isReadOnly(contact)) {
                isContactReadonly = true;
            }
            if (!isContactReadonly) {
                this.removeContactMenu.add((JMenuItem)new ContactMenuItem(contact, contactAddress, removeContactPrefix, protocolIcon));
            }
            if (contactPersistableAddress != null) {
                hasPersistableAddress = true;
                if (!isContactReadonly) {
                    this.moveSubcontactMenu.add((JMenuItem)new ContactMenuItem(contact, contactPersistableAddress, moveSubcontactPrefix, protocolIcon));
                }
            }
            List phones = this.contactPhoneUtil.getPhones(contact);
            if (this.metaContact.getContactCount() > 1 || phones.size() > 0) {
                if (this.contactPhoneUtil.isCallEnabled(contact)) {
                    this.addCallMenuContact(contact, protocolIcon);
                    this.separator = true;
                }
                if (this.contactPhoneUtil.isVideoCallEnabled(contact)) {
                    this.videoCallMenu.add((JMenuItem)new ContactMenuItem(contact, contactAddress, videoCallPrefix, protocolIcon));
                }
                if (this.contactPhoneUtil.isDesktopSharingEnabled(contact)) {
                    this.multiContactFullShareMenu.add((JMenuItem)new ContactMenuItem(contact, contactAddress, fullDesktopSharingPrefix, protocolIcon));
                    this.multiContactRegionShareMenu.add((JMenuItem)new ContactMenuItem(contact, contactAddress, regionDesktopSharingPrefix, protocolIcon));
                }
                OperationSetExtendedAuthorizations authOpSet = (OperationSetExtendedAuthorizations)protocolProvider.getOperationSet(OperationSetExtendedAuthorizations.class);
                OperationSetMultiUserChat opSetMUC = (OperationSetMultiUserChat)protocolProvider.getOperationSet(OperationSetMultiUserChat.class);
                if (!(authOpSet == null || authOpSet.getSubscriptionStatus(contact) == null || authOpSet.getSubscriptionStatus(contact).equals((Object)OperationSetExtendedAuthorizations.SubscriptionStatus.Subscribed) || opSetMUC != null && opSetMUC.isPrivateMessagingContact(contactAddress))) {
                    if (this.firstUnsubscribedContact == null) {
                        this.firstUnsubscribedContact = contact;
                    }
                    this.multiContactRequestAuthMenu.add((JMenuItem)new ContactMenuItem(contact, contactAddress, requestAuthPrefix, protocolIcon));
                }
            }
            this.addCallMenuPhones(phones);
            this.addVideoMenuPhones(contact);
            if (!this.separator || !contacts.hasNext()) continue;
            this.callContactMenu.addSeparator();
            this.separator = false;
        }
        Component c = null;
        if (this.callContactMenu.getMenuComponentCount() > 0) {
            c = this.callContactMenu.getMenuComponent(this.callContactMenu.getMenuComponentCount() - 1);
        }
        if (c != null && c instanceof JSeparator) {
            this.callContactMenu.remove(c);
        }
        this.add(this.sendMessageItem);
        if (this.metaContact.getDefaultContact(OperationSetSmsMessaging.class) != null) {
            this.add(this.sendSmsItem);
            this.sendSmsItem.addActionListener(this);
            this.sendSmsItem.setName("sendSms");
        }
        if (this.callContactMenu.getItemCount() > 1) {
            this.add((JMenuItem)this.callContactMenu);
        } else {
            if (this.callContactMenu.getItemCount() > 0) {
                item = this.callContactMenu.getItem(0);
                this.callItem.setName(item.getName());
            } else {
                this.callItem.setName("call");
            }
            this.callItem.addActionListener(this);
            this.add(this.callItem);
        }
        if (this.videoCallMenu.getItemCount() > 1) {
            this.add((JMenuItem)this.videoCallMenu);
        } else {
            if (this.videoCallMenu.getItemCount() > 0) {
                item = this.videoCallMenu.getItem(0);
                this.videoCallItem.setName(item.getName());
            } else {
                this.videoCallItem.setName("videoCall");
            }
            this.videoCallItem.addActionListener(this);
            this.add(this.videoCallItem);
        }
        if (this.multiContactFullShareMenu.getItemCount() > 1) {
            this.add((JMenuItem)this.multiContactFullShareMenu);
            this.add((JMenuItem)this.multiContactRegionShareMenu);
        } else {
            if (this.multiContactFullShareMenu.getItemCount() > 0) {
                item = this.multiContactFullShareMenu.getItem(0);
                this.fullShareMenuItem.setName(item.getName());
                JMenuItem ritem = this.multiContactRegionShareMenu.getItem(0);
                this.regionShareMenuItem.setName(ritem.getName());
            } else {
                this.fullShareMenuItem.setName("shareFullScreen");
                this.regionShareMenuItem.setName("shareRegion");
            }
            this.fullShareMenuItem.addActionListener(this);
            this.regionShareMenuItem.addActionListener(this);
            this.add(this.fullShareMenuItem);
            this.add(this.regionShareMenuItem);
        }
        this.add(this.sendFileItem);
        this.addSeparator();
        if (!ConfigurationUtils.isContactMoveDisabled() && !ConfigurationUtils.isCreateGroupDisabled() && hasPersistableAddress) {
            boolean addSeparator = false;
            if (!hasAnyReadonlyContact) {
                this.add((JMenuItem)this.moveToMenu);
                addSeparator = true;
            }
            if (this.moveSubcontactMenu.getItemCount() > 0) {
                this.add((JMenuItem)this.moveSubcontactMenu);
                addSeparator = true;
            }
            if (addSeparator) {
                this.addSeparator();
            }
        }
        if (!(ConfigurationUtils.isAddContactDisabled() || ConfigurationUtils.isMergeContactDisabled() || hasAnyReadonlyContact)) {
            this.add(this.addContactItem);
            this.addSeparator();
        }
        this.separator = false;
        if (!ConfigurationUtils.isRemoveContactDisabled()) {
            if (this.metaContact.getContactCount() > 1) {
                this.add((JMenuItem)this.removeContactMenu);
                this.separator = true;
            } else if (!hasOnlyReadonlyContacts) {
                ImageIcon deleteIcon = new ImageIcon(ImageLoader.getImage(ImageLoader.DELETE_16x16_ICON));
                JMenuItem removeContactItem = this.createMenuItem(removeString, "removeContact:allContacts", deleteIcon);
                this.add(removeContactItem);
                this.separator = true;
            }
        }
        if (!ConfigurationUtils.isContactRenameDisabled()) {
            this.add(this.renameContactItem);
            this.separator = true;
        }
        if (this.separator) {
            this.addSeparator();
        }
        this.add(this.viewHistoryItem);
        this.addSeparator();
        Contact defaultContact = this.metaContact.getDefaultContact();
        int authRequestItemCount = this.multiContactRequestAuthMenu.getItemCount();
        OperationSetMultiUserChat opSetMUC = (OperationSetMultiUserChat)defaultContact.getProtocolProvider().getOperationSet(OperationSetMultiUserChat.class);
        if (authRequestItemCount > 1) {
            this.add((JMenuItem)this.multiContactRequestAuthMenu);
        } else if (authRequestItemCount == 1 || this.metaContact.getContactCount() == 1 && defaultContact.getProtocolProvider().getOperationSet(OperationSetExtendedAuthorizations.class) != null && (opSetMUC == null || !opSetMUC.isPrivateMessagingContact(defaultContact.getAddress())) && !OperationSetExtendedAuthorizations.SubscriptionStatus.Subscribed.equals((Object)((OperationSetExtendedAuthorizations)defaultContact.getProtocolProvider().getOperationSet(OperationSetExtendedAuthorizations.class)).getSubscriptionStatus(defaultContact))) {
            this.add(this.requestAuthMenuItem);
            this.requestAuthMenuItem.setName("requestAuth");
            this.requestAuthMenuItem.addActionListener(this);
        }
        this.initPluginComponents();
        this.sendMessageItem.setName("sendMessage");
        this.sendFileItem.setName("sendFile");
        this.moveToMenu.setName("moveToGroup");
        this.addContactItem.setName("addContact");
        this.renameContactItem.setName("renameContact");
        this.viewHistoryItem.setName("viewHistory");
        this.sendMessageItem.addActionListener(this);
        this.sendFileItem.addActionListener(this);
        this.renameContactItem.addActionListener(this);
        this.viewHistoryItem.addActionListener(this);
        this.addContactItem.addActionListener(this);
        if (this.metaContact.getDefaultContact(OperationSetFileTransfer.class) == null) {
            this.sendFileItem.setEnabled(false);
        }
        if (!this.contactPhoneUtil.isCallEnabled()) {
            this.callItem.setEnabled(false);
        }
        if (!this.contactPhoneUtil.isVideoCallEnabled()) {
            this.videoCallItem.setEnabled(false);
        }
        if (!this.contactPhoneUtil.isDesktopSharingEnabled()) {
            this.fullShareMenuItem.setEnabled(false);
            this.regionShareMenuItem.setEnabled(false);
        }
        if (this.metaContact.getDefaultContact(OperationSetBasicInstantMessaging.class) == null) {
            this.sendMessageItem.setEnabled(false);
        }
    }

    private void addCallMenuPhones(List<String> phones) {
        List<ProtocolProviderService> providers = CallManager.getTelephonyProviders();
        for (String phone : phones) {
            String p = phone.substring(0, phone.lastIndexOf("(") - 1);
            if (providers.size() <= 0) continue;
            JMenuItem menuItem = this.createMenuItem(phone, callPhonePrefix + p, GuiActivator.getResources().getImage("service.gui.icons.EXTERNAL_PHONE"));
            menuItem.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            this.callContactMenu.add(menuItem);
            this.separator = true;
        }
    }

    private void addCallMenuContact(Contact contact, Icon protocolIcon) {
        if (!contact.supportResources()) {
            return;
        }
        Collection resources = contact.getResources();
        if (resources == null) {
            return;
        }
        String contactAddress = contact.getAddress();
        if (contact.getResources().size() > 1) {
            this.callContactMenu.add((JMenuItem)new ContactMenuItem(contact, null, contactAddress, callContactPrefix, protocolIcon, true));
        }
        for (ContactResource resource : contact.getResources()) {
            ImageIcon resourceIcon;
            String resourceName;
            boolean isBold = false;
            if (contact.getResources().size() > 1) {
                resourceName = resource.getResourceName();
                resourceIcon = ImageLoader.getIndexedProtocolIcon(ImageUtils.getBytesInImage((byte[])resource.getPresenceStatus().getStatusIcon()), contact.getProtocolProvider());
            } else {
                resourceName = contact.getAddress() + " " + resource.getResourceName();
                resourceIcon = ImageLoader.getIndexedProtocolIcon(ImageUtils.getBytesInImage((byte[])contact.getPresenceStatus().getStatusIcon()), contact.getProtocolProvider());
                resource = null;
                isBold = true;
            }
            ContactMenuItem menuItem = new ContactMenuItem(contact, resource, resourceName, callContactPrefix, resourceIcon, isBold);
            if (contact.getResources().size() > 1) {
                menuItem.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            }
            this.callContactMenu.add((JMenuItem)menuItem);
        }
    }

    private void addVideoMenuPhones(Contact contact) {
        List<ProtocolProviderService> providers = CallManager.getTelephonyProviders();
        List videoPhones = this.contactPhoneUtil.getVideoPhones(contact, null);
        for (String vphone : videoPhones) {
            String p = vphone.substring(0, vphone.lastIndexOf("(") - 1);
            if (providers.size() <= 0) continue;
            JMenuItem vmenu = this.createMenuItem(vphone, videoCallPrefix + p, null);
            this.videoCallMenu.add(vmenu);
            JMenuItem shdmenu = this.createMenuItem(vphone, fullDesktopSharingPrefix + p, null);
            this.multiContactFullShareMenu.add(shdmenu);
            JMenuItem rshdmenu = this.createMenuItem(vphone, regionDesktopSharingPrefix + p, null);
            this.multiContactRegionShareMenu.add(rshdmenu);
            this.separator = true;
        }
    }

    private JMenuItem createMenuItem(String displayName, String name, Icon icon) {
        JMenuItem menuItem = new JMenuItem(displayName);
        menuItem.setIcon(icon);
        menuItem.setName(name);
        menuItem.addActionListener(this);
        return menuItem;
    }

    private void initPluginComponents() {
        ServiceReference[] serRefs = null;
        String osgiFilter = "(CONTAINER_ID=" + Container.CONTAINER_CONTACT_RIGHT_BUTTON_MENU.getID() + ")";
        try {
            serRefs = GuiActivator.bundleContext.getServiceReferences(PluginComponentFactory.class.getName(), osgiFilter);
        }
        catch (InvalidSyntaxException exc) {
            this.logger.error((Object)"Could not obtain plugin reference.", (Throwable)exc);
        }
        if (serRefs != null) {
            for (int i = 0; i < serRefs.length; ++i) {
                PluginComponentFactory factory = (PluginComponentFactory)GuiActivator.bundleContext.getService(serRefs[i]);
                PluginComponent component = factory.getPluginComponentInstance((Object)this);
                component.setCurrentContact(this.metaContact);
                if (component.getComponent() == null) continue;
                if (factory.getPositionIndex() != -1) {
                    this.add((Component)component.getComponent(), factory.getPositionIndex());
                    continue;
                }
                this.add((Component)component.getComponent());
            }
        }
        GuiActivator.getUIService().addPluginComponentListener(this);
    }

    private void initMnemonics() {
        this.sendMessageItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.SEND_MESSAGE"));
        char callMnemonic = GuiActivator.getResources().getI18nMnemonic("service.gui.CALL");
        if (this.callContactMenu.getItemCount() > 1) {
            this.callContactMenu.setMnemonic(callMnemonic);
        } else {
            this.callItem.setMnemonic(callMnemonic);
        }
        char videoCallMnemonic = GuiActivator.getResources().getI18nMnemonic("service.gui.VIDEO_CALL");
        if (this.videoCallMenu.getItemCount() > 1) {
            this.videoCallMenu.setMnemonic(videoCallMnemonic);
        } else {
            this.videoCallItem.setMnemonic(videoCallMnemonic);
        }
        this.sendSmsItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.SEND_SMS"));
        this.sendFileItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.SEND_FILE"));
        this.moveToMenu.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.MOVE_TO_GROUP"));
        this.addContactItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.ADD_CONTACT"));
        this.removeContactMenu.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.REMOVE_CONTACT"));
        this.renameContactItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.RENAME_CONTACT"));
        this.viewHistoryItem.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.VIEW_HISTORY"));
        this.moveSubcontactMenu.setMnemonic(GuiActivator.getResources().getI18nMnemonic("service.gui.MOVE_SUBCONTACT"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem menuItem = (JMenuItem)e.getSource();
        String itemName = menuItem.getName();
        if (itemName.equals(this.addContactItem.getName())) {
            AddContactDialog dialog = new AddContactDialog((Frame)((Object)this.mainFrame), this.metaContact);
            ProtocolProviderService protocolProvider = GuiActivator.getPreferredAccount();
            if (protocolProvider != null) {
                dialog.setSelectedAccount(protocolProvider);
            }
            dialog.setVisible(true);
        } else if (itemName.equalsIgnoreCase("sendMessage")) {
            GuiActivator.getUIService().getChatWindowManager().startChat(this.metaContact);
        } else if (itemName.equalsIgnoreCase("sendSms")) {
            Contact defaultSmsContact = this.metaContact.getDefaultContact(OperationSetSmsMessaging.class);
            GuiActivator.getUIService().getChatWindowManager().startChat(this.metaContact, defaultSmsContact, true);
        } else if (itemName.equals("call")) {
            this.call(false, false, false, null);
        } else if (itemName.equals("videoCall")) {
            this.call(true, false, false, null);
        } else if (itemName.equals("shareFullScreen")) {
            this.call(true, true, false, null);
        } else if (itemName.equals("shareRegion")) {
            this.call(true, true, true, null);
        } else if (itemName.equals("sendFile")) {
            SipCommFileChooser scfc = GenericFileDialog.create(null, (String)"Send file...", (int)0, (String)ConfigurationUtils.getSendFileLastDir());
            File selectedFile = scfc.getFileFromDialog();
            if (selectedFile != null) {
                ConfigurationUtils.setSendFileLastDir((String)selectedFile.getParent());
                ChatPanel chatPanel = GuiActivator.getUIService().getChatWindowManager().getContactChat(this.metaContact, true);
                chatPanel.sendFile(selectedFile);
                GuiActivator.getUIService().getChatWindowManager().openChat(chatPanel, true);
            }
            GuiActivator.getUIService().getChatWindowManager().startChat(this.metaContact);
        } else if (itemName.equals("renameContact")) {
            RenameContactDialog dialog = new RenameContactDialog(this.mainFrame, this.metaContact);
            dialog.setVisible(true);
            dialog.requestFocusInFiled();
        } else if (itemName.equals("viewHistory")) {
            HistoryWindowManager historyWindowManager = GuiActivator.getUIService().getHistoryWindowManager();
            if (historyWindowManager.containsHistoryWindowForContact(this.metaContact)) {
                HistoryWindow history = historyWindowManager.getHistoryWindowForContact(this.metaContact);
                if (history.getState() == 1) {
                    history.setState(0);
                }
                history.toFront();
            } else {
                HistoryWindow history = new HistoryWindow(this.metaContact);
                historyWindowManager.addHistoryWindowForContact(this.metaContact, history);
                history.setVisible(true);
            }
        } else if (itemName.equals("requestAuth")) {
            Contact contact = this.firstUnsubscribedContact != null ? this.firstUnsubscribedContact : this.metaContact.getDefaultContact();
            this.requestAuthorization(contact);
        } else if (itemName.startsWith(moveToPrefix)) {
            MetaContactListManager.moveMetaContactToGroup(this.metaContact, itemName.substring(moveToPrefix.length()));
        } else if (itemName.startsWith(removeContactPrefix)) {
            if (menuItem instanceof ContactMenuItem) {
                MetaContactListManager.removeContact(((ContactMenuItem)menuItem).getContact());
            } else {
                MetaContactListManager.removeMetaContact(this.metaContact);
            }
        } else if (itemName.startsWith(moveSubcontactPrefix)) {
            this.contactList.addContactListListener(this);
            this.contactList.setGroupClickConsumed(true);
            this.moveDialog = new MoveSubcontactMessageDialog(this.mainFrame, this);
            this.moveDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    MetaContactRightButtonMenu.this.contactList.setGroupClickConsumed(false);
                }
            });
            this.moveDialog.setVisible(true);
            if (menuItem instanceof ContactMenuItem) {
                this.contactToMove = ((ContactMenuItem)menuItem).getContact();
            } else {
                this.moveAllContacts = true;
            }
        } else if (itemName.startsWith(callContactPrefix)) {
            if (menuItem instanceof ContactMenuItem) {
                ContactMenuItem contactItem = (ContactMenuItem)menuItem;
                this.call(false, false, false, contactItem.getContact(), contactItem.getContactResource());
            } else {
                this.call(false, false, false, itemName.substring(callContactPrefix.length()));
            }
        } else if (itemName.startsWith(videoCallPrefix)) {
            if (menuItem instanceof ContactMenuItem) {
                ContactMenuItem contactItem = (ContactMenuItem)menuItem;
                this.call(true, false, false, contactItem.getContact(), contactItem.getContactResource());
            } else {
                this.call(true, false, false, itemName.substring(videoCallPrefix.length()));
            }
        } else if (itemName.startsWith(fullDesktopSharingPrefix)) {
            if (menuItem instanceof ContactMenuItem) {
                ContactMenuItem contactItem = (ContactMenuItem)menuItem;
                this.call(true, true, false, contactItem.getContact(), contactItem.getContactResource());
            } else {
                this.call(true, true, false, itemName.substring(fullDesktopSharingPrefix.length()));
            }
        } else if (itemName.startsWith(regionDesktopSharingPrefix)) {
            if (menuItem instanceof ContactMenuItem) {
                ContactMenuItem contactItem = (ContactMenuItem)menuItem;
                this.call(true, true, true, contactItem.getContact(), contactItem.getContactResource());
            } else {
                this.call(true, true, true, itemName.substring(regionDesktopSharingPrefix.length()));
            }
        } else if (itemName.startsWith(requestAuthPrefix)) {
            Contact contact = menuItem instanceof ContactMenuItem ? ((ContactMenuItem)menuItem).getContact() : this.getContactFromMetaContact(itemName.substring(requestAuthPrefix.length()));
            this.requestAuthorization(contact);
        } else if (itemName.startsWith(callPhonePrefix)) {
            String phone = itemName.substring(callPhonePrefix.length());
            this.call(false, false, false, phone);
        }
    }

    private Contact getContactFromMetaContact(String itemID) {
        Iterator i = this.metaContact.getContacts();
        while (i.hasNext()) {
            Contact contact = (Contact)i.next();
            String id = contact.getAddress() + contact.getProtocolProvider().getProtocolName();
            if (!itemID.equals(id)) continue;
            return contact;
        }
        return null;
    }

    public void groupClicked(ContactListEvent evt) {
        this.moveDialog.dispose();
        UIGroup sourceGroup = evt.getSourceGroup();
        if (!(sourceGroup instanceof MetaUIGroup)) {
            return;
        }
        MetaContactGroup metaGroup = (MetaContactGroup)sourceGroup.getDescriptor();
        this.contactList.removeContactListListener(this);
        if (this.moveAllContacts) {
            MetaContactListManager.moveMetaContactToGroup(this.metaContact, metaGroup);
        } else if (this.contactToMove != null) {
            MetaContactListManager.moveContactToGroup(this.contactToMove, metaGroup);
        }
        this.contactList.setGroupClickConsumed(false);
    }

    public void contactClicked(ContactListEvent evt) {
        UIContact descriptor = evt.getSourceContact();
        if (!(descriptor instanceof MetaUIContact)) {
            return;
        }
        this.moveContact((MetaContact)descriptor.getDescriptor());
    }

    public void groupSelected(ContactListEvent evt) {
    }

    public void contactSelected(ContactListEvent evt) {
    }

    private void moveContact(MetaContact toMetaContact) {
        this.moveDialog.dispose();
        if (toMetaContact.equals(this.metaContact)) {
            new ErrorDialog((Frame)((Object)this.mainFrame), GuiActivator.getResources().getI18NString("service.gui.MOVE_SUBCONTACT"), GuiActivator.getResources().getI18NString("service.gui.MOVE_SUBCONTACT_FAILED"), 1).showDialog();
        } else {
            this.contactList.removeContactListListener(this);
            if (this.moveAllContacts) {
                MetaContactListManager.moveMetaContactToMetaContact(this.metaContact, toMetaContact);
            } else if (this.contactToMove != null) {
                MetaContactListManager.moveContactToMetaContact(this.contactToMove, toMetaContact);
            }
        }
    }

    @Override
    public void pluginComponentAdded(PluginComponentEvent event) {
        PluginComponentFactory factory = event.getPluginComponentFactory();
        if (!factory.getContainer().equals((Object)Container.CONTAINER_CONTACT_RIGHT_BUTTON_MENU)) {
            return;
        }
        Object constraints = UIServiceImpl.getBorderLayoutConstraintsFromContainer(factory.getConstraints());
        PluginComponent c = factory.getPluginComponentInstance((Object)this);
        if (c.getComponent() == null) {
            return;
        }
        int ix = factory.getPositionIndex();
        if (constraints == null) {
            if (ix != -1) {
                this.add((Component)c.getComponent(), ix);
            } else {
                this.add((Component)c.getComponent());
            }
        } else if (ix != -1) {
            this.add((Component)c.getComponent(), constraints, ix);
        } else {
            this.add((Component)c.getComponent(), constraints);
        }
        c.setCurrentContact(this.metaContact);
        this.repaint();
    }

    @Override
    public void pluginComponentRemoved(PluginComponentEvent event) {
        PluginComponentFactory factory = event.getPluginComponentFactory();
        if (factory.getContainer().equals((Object)Container.CONTAINER_CONTACT_RIGHT_BUTTON_MENU)) {
            this.remove((Component)factory.getPluginComponentInstance((Object)this).getComponent());
        }
    }

    public Image createContactStatusImage(Contact protoContact) {
        return ImageLoader.getIndexedProtocolImage(ImageUtils.getBytesInImage((byte[])protoContact.getPresenceStatus().getStatusIcon()), protoContact.getProtocolProvider());
    }

    public void loadSkin() {
        this.callItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.CALL_16x16_ICON)));
        this.videoCallItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.VIDEO_CALL)));
        this.videoCallMenu.setIcon((Icon)new ImageIcon(ImageLoader.getImage(ImageLoader.VIDEO_CALL)));
        this.fullShareMenuItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.DESKTOP_SHARING)));
        this.regionShareMenuItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.REGION_DESKTOP_SHARING)));
        this.multiContactFullShareMenu.setIcon((Icon)new ImageIcon(ImageLoader.getImage(ImageLoader.DESKTOP_SHARING)));
        this.multiContactRegionShareMenu.setIcon((Icon)new ImageIcon(ImageLoader.getImage(ImageLoader.REGION_DESKTOP_SHARING)));
        this.sendMessageItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.SEND_MESSAGE_16x16_ICON)));
        this.sendFileItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.SEND_FILE_16x16_ICON)));
        this.sendSmsItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.SEND_MESSAGE_16x16_ICON)));
        this.renameContactItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.RENAME_16x16_ICON)));
        this.viewHistoryItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.HISTORY_16x16_ICON)));
        this.moveToMenu.setIcon((Icon)new ImageIcon(ImageLoader.getImage(ImageLoader.MOVE_TO_GROUP_16x16_ICON)));
        this.addContactItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.ADD_CONTACT_16x16_ICON)));
        this.removeContactMenu.setIcon((Icon)new ImageIcon(ImageLoader.getImage(ImageLoader.DELETE_16x16_ICON)));
        this.moveSubcontactMenu.setIcon((Icon)new ImageIcon(ImageLoader.getImage(ImageLoader.MOVE_CONTACT_ICON)));
        this.callContactMenu.setIcon((Icon)new ImageIcon(ImageLoader.getImage(ImageLoader.CALL_16x16_ICON)));
        this.requestAuthMenuItem.setIcon(new ImageIcon(ImageLoader.getImage(ImageLoader.UNAUTHORIZED_CONTACT_16x16)));
        this.multiContactRequestAuthMenu.setIcon((Icon)new ImageIcon(ImageLoader.getImage(ImageLoader.UNAUTHORIZED_CONTACT_16x16)));
    }

    private void requestAuthorization(final Contact contact) {
        final OperationSetExtendedAuthorizations authOpSet = (OperationSetExtendedAuthorizations)contact.getProtocolProvider().getOperationSet(OperationSetExtendedAuthorizations.class);
        if (authOpSet == null) {
            return;
        }
        final AuthorizationRequest request = new AuthorizationRequest();
        final RequestAuthorizationDialog dialog = new RequestAuthorizationDialog(this.mainFrame, contact, request);
        dialog.showDialog();
        new Thread(){

            @Override
            public void run() {
                int returnCode = dialog.getReturnCode();
                if (returnCode == 1) {
                    request.setReason(dialog.getRequestReason());
                    try {
                        authOpSet.reRequestAuthorization(request, contact);
                    }
                    catch (OperationFailedException e) {
                        new ErrorDialog((Frame)((Object)MetaContactRightButtonMenu.this.mainFrame), GuiActivator.getResources().getI18NString("service.gui.RE_REQUEST_AUTHORIZATION"), e.getMessage(), 1).showDialog();
                    }
                }
            }
        }.start();
    }

    private void call(boolean isVideo, boolean isDesktopSharing, boolean shareRegion, Contact contact, ContactResource contactResource) {
        if (contactResource != null) {
            CallManager.call(contact, contactResource, isVideo, isDesktopSharing, shareRegion);
        } else {
            CallManager.call(contact, isVideo, isDesktopSharing, shareRegion);
        }
    }

    private void call(boolean isVideo, boolean isDesktopSharing, boolean shareRegion, String contactName) {
        if (contactName != null) {
            Contact contact = this.getContactFromMetaContact(contactName);
            if (contact != null) {
                this.call(isVideo, isDesktopSharing, shareRegion, contact, null);
                return;
            }
            CallManager.call(contactName, MetaContactListSource.getUIContact(this.metaContact), isVideo, isDesktopSharing, shareRegion);
            return;
        }
        CallManager.call(this.metaContact, isVideo, isDesktopSharing, shareRegion);
    }

    private class ContactMenuItem
    extends JMenuItem {
        private final Contact contact;
        private ContactResource contactResource;

        public ContactMenuItem(Contact contact, String displayName, String menuName, Icon icon) {
            this(contact, null, displayName, menuName, icon, false);
        }

        public ContactMenuItem(Contact contact, ContactResource contactResource, String displayName, String menuName, Icon icon, boolean isBold) {
            super(displayName);
            this.contact = contact;
            this.contactResource = contactResource;
            this.setIcon(icon);
            this.setName(menuName);
            if (isBold) {
                this.setFont(this.getFont().deriveFont(1));
            }
            this.addActionListener(MetaContactRightButtonMenu.this);
        }

        Contact getContact() {
            return this.contact;
        }

        ContactResource getContactResource() {
            return this.contactResource;
        }
    }
}

