/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallManager;
import net.java.sip.communicator.impl.gui.main.contactlist.UIContactImpl;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.ComponentMover;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.plugin.desktoputil.transparent.TransparentFrame;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.OperationSetBasicTelephony;
import net.java.sip.communicator.service.protocol.OperationSetDesktopStreaming;
import net.java.sip.communicator.service.protocol.OperationSetVideoTelephony;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.CallEvent;
import net.java.sip.communicator.service.protocol.event.CallListener;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.util.OSUtils;

public class DesktopSharingFrame {
    private static final Logger logger = Logger.getLogger(DesktopSharingFrame.class);
    private static final ImageIcon resizeIcon = GuiActivator.getResources().getImage("service.gui.icons.WINDOW_RESIZE_ICON");
    private static int SHARING_REGION_INDENT = 2;
    private static int initialFrameX = -1;
    private static int initialFrameY = -1;
    private static int sharingRegionWidth = -1;
    private static int sharingRegionHeight = -1;
    private static final Map<Call, JFrame> callDesktopFrames = new Hashtable<Call, JFrame>();

    public static TransparentFrame createTransparentFrame(ProtocolProviderService protocolProvider, String contactAddress, UIContactImpl uiContact, boolean initialFrame) {
        TransparentFrame frame = TransparentFrame.createTransparentFrame();
        DesktopSharingFrame.initContentPane((JFrame)frame, initialFrame);
        JComponent sharingRegion = DesktopSharingFrame.createSharingRegion(initialFrame);
        frame.getContentPane().add((Component)sharingRegion, "North");
        JPanel buttonPanel = DesktopSharingFrame.initButtons((JFrame)frame, sharingRegion, initialFrame, null, protocolProvider, contactAddress, uiContact);
        frame.getContentPane().add((Component)buttonPanel, "South");
        frame.pack();
        return frame;
    }

    public static TransparentFrame createTransparentFrame(Call call, boolean initialFrame) {
        TransparentFrame frame = TransparentFrame.createTransparentFrame();
        DesktopSharingFrame.initContentPane((JFrame)frame, initialFrame);
        JComponent sharingRegion = DesktopSharingFrame.createSharingRegion(initialFrame);
        frame.getContentPane().add((Component)sharingRegion, "North");
        JPanel buttonPanel = DesktopSharingFrame.initButtons((JFrame)frame, sharingRegion, initialFrame, call, null, null, null);
        frame.getContentPane().add((Component)buttonPanel, "South");
        if (!initialFrame) {
            callDesktopFrames.put(call, (JFrame)frame);
            DesktopSharingFrame.addCallListener(call, (JFrame)frame);
            DesktopSharingFrame.addFrameListener(call, (JFrame)frame, sharingRegion);
            DesktopSharingFrame.addDesktopSharingListener(call, (JFrame)frame);
            logger.info((Object)("The sharing region width: " + sharingRegionWidth));
            if (sharingRegionWidth > -1 && sharingRegionHeight > -1) {
                sharingRegion.setPreferredSize(new Dimension(sharingRegionWidth, sharingRegionHeight));
            }
            frame.pack();
            if (initialFrameX != -1 || initialFrameY != -1) {
                frame.setLocation(initialFrameX, initialFrameY);
            } else {
                frame.setLocationRelativeTo(null);
            }
        } else {
            frame.pack();
            frame.setLocationRelativeTo(null);
        }
        return frame;
    }

    public static JFrame getFrameForCall(Call call) {
        return callDesktopFrames.get(call);
    }

    private static void addCallListener(Call call, JFrame frame) {
        OperationSetBasicTelephony basicTelephony = (OperationSetBasicTelephony)call.getProtocolProvider().getOperationSet(OperationSetBasicTelephony.class);
        if (basicTelephony != null) {
            basicTelephony.addCallListener(new CallListener(){

                public void callEnded(CallEvent ev) {
                    Call call = ev.getSourceCall();
                    JFrame desktopFrame = (JFrame)callDesktopFrames.get(call);
                    if (desktopFrame != null) {
                        desktopFrame.dispose();
                        callDesktopFrames.remove(call);
                    }
                }

                public void incomingCallReceived(CallEvent ev) {
                }

                public void outgoingCallCreated(CallEvent ev) {
                }
            });
        }
    }

    private static void addDesktopSharingListener(final Call call, JFrame frame) {
        OperationSetVideoTelephony videoTelephony = (OperationSetVideoTelephony)call.getProtocolProvider().getOperationSet(OperationSetVideoTelephony.class);
        videoTelephony.addPropertyChangeListener(call, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                JFrame desktopFrame;
                if ("LOCAL_VIDEO_STREAMING".equals(ev.getPropertyName()) && MediaDirection.RECVONLY.equals(ev.getNewValue()) && (desktopFrame = (JFrame)callDesktopFrames.get(call)) != null) {
                    desktopFrame.dispose();
                    callDesktopFrames.remove(call);
                }
            }
        });
    }

    private static void initContentPane(JFrame frame, boolean initialFrame) {
        JPanel contentPane = new JPanel(){
            public static final long serialVersionUID = 0L;

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g = g.create();
                try {
                    AntialiasingManager.activateAntialiasing((Graphics)g);
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setStroke(new BasicStroke(4.0f));
                    if (TransparentFrame.isTranslucencySupported) {
                        g2d.setColor(new Color(Color.DARK_GRAY.getRed(), Color.DARK_GRAY.getGreen(), Color.DARK_GRAY.getBlue(), 180));
                        g2d.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 20, 20);
                    } else {
                        g.setColor(Color.DARK_GRAY);
                        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                    }
                }
                finally {
                    g.dispose();
                }
            }
        };
        contentPane.setOpaque(false);
        contentPane.setDoubleBuffered(false);
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(SHARING_REGION_INDENT, SHARING_REGION_INDENT, SHARING_REGION_INDENT, SHARING_REGION_INDENT));
        frame.setContentPane(contentPane);
        ComponentMover.registerComponent((Component)frame);
        if (TransparentFrame.isTranslucencySupported && !OSUtils.IS_LINUX) {
            frame.setAlwaysOnTop(true);
        }
    }

    private static JComponent createSharingRegion(boolean initialFrame) {
        TransparentPanel sharingRegion = new TransparentPanel((LayoutManager)new BorderLayout());
        if (OSUtils.IS_MAC) {
            sharingRegion.setPreferredSize(new Dimension(592, 400));
        } else {
            sharingRegion.setPreferredSize(new Dimension(600, 400));
        }
        sharingRegion.setDoubleBuffered(false);
        if (!TransparentFrame.isTranslucencySupported && !initialFrame) {
            JLabel label = new JLabel(GuiActivator.getResources().getI18NString("service.gui.DRAG_FOR_SHARING"), 0);
            label.setForeground(Color.GRAY);
            sharingRegion.add(label);
        }
        return sharingRegion;
    }

    private static JPanel initButtons(final JFrame frame, final JComponent sharingRegion, boolean initialFrame, final Call call, final ProtocolProviderService protocolProvider, final String contact, final UIContactImpl uiContact) {
        JPanel buttonPanel = new JPanel(new GridBagLayout()){
            public static final long serialVersionUID = 0L;

            @Override
            public void paintComponent(Graphics g) {
                if (!TransparentFrame.isTranslucencySupported || OSUtils.IS_LINUX) {
                    super.paintComponent(g);
                    return;
                }
                Graphics2D g2d = (Graphics2D)g.create();
                AntialiasingManager.activateAntialiasing((Graphics)g2d);
                g2d.setColor(new Color(Color.DARK_GRAY.getRed(), Color.DARK_GRAY.getGreen(), Color.DARK_GRAY.getBlue(), 180));
                GeneralPath shape = new GeneralPath();
                int x = -SHARING_REGION_INDENT + 2;
                boolean y = false;
                int width = this.getWidth() + SHARING_REGION_INDENT * 2 - 4;
                int height = this.getHeight() + SHARING_REGION_INDENT * 2 - 2;
                shape.moveTo(x, (float)y);
                shape.lineTo(width, (float)y);
                shape.lineTo(width, height - 12);
                shape.curveTo(width, height - 12, width, height, width - 12, height);
                shape.lineTo(12.0f, height);
                shape.curveTo(12.0f, height, x, height, x, height - 12);
                shape.lineTo(x, (float)y);
                shape.closePath();
                g2d.fill(shape);
                g2d.setColor(this.getBackground());
            }
        };
        GridBagConstraints constraints = new GridBagConstraints();
        if (TransparentFrame.isTranslucencySupported && !OSUtils.IS_LINUX) {
            buttonPanel.setOpaque(false);
        } else {
            buttonPanel.setBackground(Color.DARK_GRAY);
        }
        buttonPanel.setCursor(Cursor.getPredefinedCursor(12));
        buttonPanel.setPreferredSize(new Dimension(sharingRegion.getWidth(), 30));
        if (initialFrame) {
            JButton startButton = DesktopSharingFrame.createButton(GuiActivator.getResources().getI18NString("service.gui.START_SHARING"));
            JButton cancelButton = DesktopSharingFrame.createButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            constraints.insets = new Insets(0, 0, 0, 5);
            constraints.anchor = 13;
            buttonPanel.add((Component)cancelButton, constraints);
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            constraints.anchor = 17;
            buttonPanel.add((Component)startButton, constraints);
            constraints.gridx = 3;
            constraints.gridy = 0;
            constraints.weightx = 0.0;
            constraints.insets = new Insets(0, 0, 0, 0);
            constraints.anchor = 16;
            buttonPanel.add((Component)DesktopSharingFrame.createResizeLabel(frame, sharingRegion, buttonPanel), constraints);
            startButton.setCursor(Cursor.getDefaultCursor());
            cancelButton.setCursor(Cursor.getDefaultCursor());
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    frame.dispose();
                }
            });
            startButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Point location = sharingRegion.getLocationOnScreen();
                    sharingRegionWidth = sharingRegion.getWidth();
                    sharingRegionHeight = sharingRegion.getHeight();
                    initialFrameX = frame.getX();
                    initialFrameY = frame.getY();
                    frame.dispose();
                    if (call != null) {
                        CallManager.enableRegionDesktopSharing(call, location.x, location.y, sharingRegionWidth, sharingRegionHeight);
                    } else {
                        CallManager.createRegionDesktopSharing(protocolProvider, contact, uiContact, location.x, location.y, sharingRegionWidth, sharingRegionHeight);
                    }
                }
            });
        } else {
            JButton stopButton = DesktopSharingFrame.createButton(GuiActivator.getResources().getI18NString("service.gui.STOP_SHARING"));
            buttonPanel.add(stopButton);
            stopButton.setCursor(Cursor.getDefaultCursor());
            stopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (call != null) {
                        CallManager.enableDesktopSharing(call, false);
                    }
                    frame.dispose();
                }
            });
        }
        return buttonPanel;
    }

    private static JButton createButton(String text) {
        JButton button = new JButton(text);
        button.setOpaque(false);
        return button;
    }

    private static JLabel createResizeLabel(final JFrame frame, final JComponent sharingRegion, final JComponent buttonPanel) {
        final JLabel resizeLabel = new JLabel(resizeIcon);
        resizeLabel.setCursor(Cursor.getPredefinedCursor(5));
        resizeLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point p = e.getPoint();
                SwingUtilities.convertPointToScreen(p, resizeLabel);
                Point regionLocation = sharingRegion.getLocationOnScreen();
                int sharingWidth = (int)(p.getX() - regionLocation.getX() - (double)(2 * SHARING_REGION_INDENT));
                int newSharingHeight = (int)(p.getY() - (double)frame.getY() - (double)buttonPanel.getHeight() - (double)(2 * SHARING_REGION_INDENT));
                if (OSUtils.IS_MAC && sharingWidth % 16 > 0) {
                    sharingWidth = Math.round((float)sharingWidth / 16.0f) * 16;
                } else if (sharingWidth % 2 > 0) {
                    sharingWidth = Math.round((float)sharingWidth / 2.0f) * 2;
                }
                sharingRegion.setPreferredSize(new Dimension(sharingWidth, newSharingHeight));
                frame.validate();
                int height = (int)(p.getY() - (double)frame.getY());
                frame.setSize(sharingWidth + 2 * SHARING_REGION_INDENT, height);
            }
        });
        return resizeLabel;
    }

    private static void addFrameListener(final Call call, final JFrame frame, final Component sharingRegion) {
        frame.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                OperationSetDesktopStreaming desktopOpSet = (OperationSetDesktopStreaming)call.getProtocolProvider().getOperationSet(OperationSetDesktopStreaming.class);
                if (desktopOpSet == null) {
                    return;
                }
                Point location = new Point(sharingRegion.getX(), sharingRegion.getY());
                SwingUtilities.convertPointToScreen(location, frame.getContentPane());
                desktopOpSet.movePartialDesktopStreaming(call, location.x, location.y);
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }
        });
    }
}

