/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets.plaf;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class HudPaintingUtils {
    public static final float FONT_SIZE = 11.0f;
    public static final Color FONT_COLOR = Color.WHITE;
    public static final Color PRESSED_MARK_COLOR = new Color(0, 0, 0, 225);
    private static final Color TOP_COLOR = new Color(170, 170, 170, 50);
    private static final Color BOTTOM_COLOR = new Color(17, 17, 17, 50);
    private static final Color TOP_PRESSED_COLOR = new Color(249, 249, 249, 153);
    private static final Color BOTTOM_PRESSED_COLOR = new Color(176, 176, 176, 153);
    public static final Color BORDER_COLOR = new Color(12961999);
    private static final int BORDER_WIDTH = 1;
    private static final Color LIGHT_SHADOW_COLOR = new Color(0, 0, 0, 145);
    private static final Color DARK_SHADOW_COLOR = new Color(0, 0, 0, 50);

    private HudPaintingUtils() {
    }

    public static void initHudComponent(JComponent component) {
        component.setFont(HudPaintingUtils.getHudFont());
        component.setForeground(FONT_COLOR);
        component.setOpaque(false);
    }

    public static Font getHudFont() {
        return UIManager.getFont("Button.font").deriveFont(1, 11.0f);
    }

    public static int getHudControlShadowSize(AbstractButton button) {
        return 2;
    }

    public static void paintHudControlBackground(Graphics2D graphics, AbstractButton button, int width, int height, Roundedness roundedness) {
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(LIGHT_SHADOW_COLOR);
        int arcDiameter = roundedness.getRoundedDiameter(height);
        graphics.drawRoundRect(0, 0, width - 1, height, arcDiameter, arcDiameter);
        graphics.setColor(DARK_SHADOW_COLOR);
        int smallerShadowArcDiameter = height - 1;
        graphics.drawRoundRect(0, 0, width - 1, height + 1, smallerShadowArcDiameter, smallerShadowArcDiameter);
        graphics.setPaint(HudPaintingUtils.createButtonPaint(button, 1));
        graphics.fillRoundRect(0, 1, width, height - 1, arcDiameter, arcDiameter);
        graphics.setColor(BORDER_COLOR);
        graphics.drawRoundRect(0, 0, width - 1, height - 1, arcDiameter, arcDiameter);
    }

    private static Paint createButtonPaint(AbstractButton button, int lineBorderWidth) {
        boolean isPressed = button.getModel().isPressed();
        Color topColor = isPressed ? TOP_PRESSED_COLOR : TOP_COLOR;
        Color bottomColor = isPressed ? BOTTOM_PRESSED_COLOR : BOTTOM_COLOR;
        int bottomY = button.getHeight() - lineBorderWidth * 2;
        return new GradientPaint(0.0f, lineBorderWidth, topColor, 0.0f, bottomY, bottomColor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Roundedness {
        ROUNDED_BUTTON(0.95),
        COMBO_BUTTON(0.45),
        CHECK_BOX(0.4),
        RADIO(1.0);

        private final double fRoundedPercentage;

        private Roundedness(double roundedPercentage) {
            this.fRoundedPercentage = roundedPercentage;
        }

        private int getRoundedDiameter(int controlHeight) {
            int roundedDiameter = (int)((double)controlHeight * this.fRoundedPercentage);
            int makeItEven = roundedDiameter % 2;
            return roundedDiameter - makeItEven;
        }
    }
}

