/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.vp8;

import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.VideoFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.video.vp8.DePacketizer;
import org.jitsi.util.Logger;

public class Packetizer
extends AbstractCodec2 {
    private static final Logger logger = Logger.getLogger(Packetizer.class);
    private static final int MAX_SIZE = 1350;
    private boolean firstPacket = true;

    public Packetizer() {
        super("VP8 Packetizer", VideoFormat.class, (Format[])new VideoFormat[]{new VideoFormat("VP8/rtp")});
        this.inputFormats = new VideoFormat[]{new VideoFormat("VP8")};
    }

    @Override
    protected void doClose() {
    }

    @Override
    protected void doOpen() {
        if (logger.isTraceEnabled()) {
            logger.trace("Opened VP8 packetizer");
        }
    }

    @Override
    protected int doProcess(Buffer inputBuffer, Buffer outputBuffer) {
        int inLen;
        if (inputBuffer.isDiscard() || (inLen = inputBuffer.getLength()) == 0) {
            outputBuffer.setDiscard(true);
            return 0;
        }
        int pdMaxLen = 6;
        int inOff = inputBuffer.getOffset();
        int len = inLen <= 1350 ? inLen : 1350;
        int offset = pdMaxLen;
        byte[] output = Packetizer.validateByteArraySize(outputBuffer, offset + len, true);
        System.arraycopy(inputBuffer.getData(), inOff, output, offset, len);
        byte[] pd = DePacketizer.VP8PayloadDescriptor.create(this.firstPacket);
        System.arraycopy(pd, 0, output, offset - pd.length, pd.length);
        outputBuffer.setFormat((Format)new VideoFormat("VP8/rtp"));
        outputBuffer.setOffset(offset -= pd.length);
        outputBuffer.setLength(len + pd.length);
        if (inLen <= 1350) {
            this.firstPacket = true;
            outputBuffer.setFlags(outputBuffer.getFlags() | 0x800);
            return 0;
        }
        this.firstPacket = false;
        inputBuffer.setLength(inLen - 1350);
        inputBuffer.setOffset(inOff + 1350);
        return 2;
    }
}

