/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.irc;

import net.java.sip.communicator.impl.protocol.irc.ChatRoomMemberIrcImpl;
import net.java.sip.communicator.impl.protocol.irc.Utils;
import net.java.sip.communicator.service.protocol.AbstractMessage;
import net.java.sip.communicator.service.protocol.Contact;

public class MessageIrcImpl
extends AbstractMessage {
    public static final String DEFAULT_MIME_ENCODING = "UTF-8";
    public static final String DEFAULT_MIME_TYPE = "text/plain";
    public static final String HTML_MIME_TYPE = "text/html";

    public static MessageIrcImpl newMessageFromIRC(String message) {
        String text = Utils.parseIrcMessage(message);
        text = Utils.styleAsMessage(text);
        return new MessageIrcImpl(text, HTML_MIME_TYPE, DEFAULT_MIME_ENCODING, null);
    }

    public static MessageIrcImpl newNoticeFromIRC(ChatRoomMemberIrcImpl user, String message) {
        return MessageIrcImpl.newNoticeFromIRC(user.getContactAddress(), message);
    }

    public static MessageIrcImpl newNoticeFromIRC(Contact user, String message) {
        return MessageIrcImpl.newNoticeFromIRC(user.getAddress(), message);
    }

    private static MessageIrcImpl newNoticeFromIRC(String user, String message) {
        String text = Utils.parseIrcMessage(message);
        text = Utils.styleAsNotice(text, user);
        return new MessageIrcImpl(text, HTML_MIME_TYPE, DEFAULT_MIME_ENCODING, null);
    }

    public static MessageIrcImpl newActionFromIRC(String message) {
        String text = Utils.parseIrcMessage(message);
        return new MessageIrcImpl("/me " + text, HTML_MIME_TYPE, DEFAULT_MIME_ENCODING, null);
    }

    public static MessageIrcImpl newAwayMessageFromIRC(String message) {
        String text = Utils.parseIrcMessage(message);
        text = Utils.styleAsAwayMessage(text);
        return new MessageIrcImpl(text, HTML_MIME_TYPE, DEFAULT_MIME_ENCODING, null);
    }

    public MessageIrcImpl(String content, String contentType, String contentEncoding, String subject) {
        super(content, contentType, contentEncoding, subject);
    }

    public boolean isCommand() {
        return this.getContent().startsWith("/");
    }

    public boolean isAction() {
        return this.getContent().startsWith("/me ");
    }

    protected void setContent(String messageContent) {
        super.setContent(messageContent);
    }
}

