/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip.net;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipAccountIDImpl;
import net.java.sip.communicator.impl.protocol.sip.net.AutoProxyConnection;
import net.java.sip.communicator.impl.protocol.sip.net.ManualProxyConnection;
import net.java.sip.communicator.service.dns.DnssecException;

public abstract class ProxyConnection {
    private List<String> returnedAddresses = new LinkedList<String>();
    protected String transport;
    protected InetSocketAddress socketAddress;
    protected final SipAccountIDImpl account;

    protected ProxyConnection(SipAccountIDImpl account) {
        this.account = account;
    }

    public final InetSocketAddress getAddress() {
        return this.socketAddress;
    }

    public final String getTransport() {
        return this.transport;
    }

    public final String getOutboundProxyString() {
        if (this.socketAddress == null) {
            return null;
        }
        InetAddress proxyAddress = this.socketAddress.getAddress();
        StringBuilder proxyStringBuffer = new StringBuilder(proxyAddress.getHostAddress());
        if (proxyAddress instanceof Inet6Address) {
            proxyStringBuffer.insert(0, '[');
            proxyStringBuffer.append(']');
        }
        proxyStringBuffer.append(':');
        proxyStringBuffer.append(this.socketAddress.getPort());
        proxyStringBuffer.append('/');
        proxyStringBuffer.append(this.transport);
        return proxyStringBuffer.toString();
    }

    public final boolean isSameInetAddress(InetAddress addressToTest) {
        if (this.socketAddress == null) {
            return false;
        }
        return addressToTest == this.socketAddress.getAddress();
    }

    public final boolean getNextAddress() throws DnssecException {
        boolean result;
        String key = null;
        do {
            if (!(result = this.getNextAddressFromDns()) || this.socketAddress == null || this.returnedAddresses.contains(key = this.getOutboundProxyString())) continue;
            this.returnedAddresses.add(key);
            break;
        } while (result && this.returnedAddresses.contains(key));
        return result;
    }

    protected abstract boolean getNextAddressFromDns() throws DnssecException;

    public void reset() {
        this.returnedAddresses.clear();
    }

    public static ProxyConnection create(ProtocolProviderServiceSipImpl pps) {
        if (pps.getAccountID().getAccountPropertyBoolean((Object)"PROXY_AUTO_CONFIG", true)) {
            return new AutoProxyConnection((SipAccountIDImpl)pps.getAccountID(), pps.getDefaultTransport());
        }
        return new ManualProxyConnection((SipAccountIDImpl)pps.getAccountID());
    }
}

