/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.javax.sip.address.AddressFactoryEx;
import gov.nist.javax.sip.header.SIPHeader;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.sdp.MediaDescription;
import javax.sdp.SessionDescription;
import javax.sip.ServerTransaction;
import javax.sip.Transaction;
import javax.sip.header.ContactHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.sip.communicator.impl.protocol.sip.CallPeerSipImpl;
import net.java.sip.communicator.impl.protocol.sip.OperationSetBasicTelephonySipImpl;
import net.java.sip.communicator.impl.protocol.sip.ProtocolProviderServiceSipImpl;
import net.java.sip.communicator.impl.protocol.sip.SipActivator;
import net.java.sip.communicator.impl.protocol.sip.sdp.SdpUtils;
import net.java.sip.communicator.service.protocol.AbstractOperationSetBasicAutoAnswer;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.CallPeer;
import net.java.sip.communicator.service.protocol.OperationSetAdvancedAutoAnswer;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.util.StringUtils;

public class OperationSetAutoAnswerSipImpl
extends AbstractOperationSetBasicAutoAnswer
implements OperationSetAdvancedAutoAnswer {
    private static final Logger logger = Logger.getLogger(OperationSetBasicTelephonySipImpl.class);
    private boolean answerConditional = false;
    private String headerName = null;
    private String headerValue = null;
    private String callFwdTo = null;

    public OperationSetAutoAnswerSipImpl(ProtocolProviderServiceSipImpl protocolProvider) {
        super((ProtocolProviderService)protocolProvider);
        this.load();
    }

    protected void load() {
        super.load();
        AccountID acc = this.protocolProvider.getAccountID();
        this.headerName = acc.getAccountPropertyString((Object)"AUTO_ANSWER_CONDITIONAL_NAME");
        this.headerValue = acc.getAccountPropertyString((Object)"AUTO_ANSWER_CONDITIONAL_VALUE");
        if (!StringUtils.isNullOrEmpty((String)this.headerName)) {
            this.answerConditional = true;
        }
        this.callFwdTo = acc.getAccountPropertyString((Object)"AUTO_ANSWER_FWD_NUM");
    }

    protected void save() {
        AccountID acc = this.protocolProvider.getAccountID();
        Map accProps = acc.getAccountProperties();
        accProps.put("AUTO_ANSWER_UNCONDITIONAL", null);
        accProps.put("AUTO_ANSWER_CONDITIONAL_NAME", null);
        accProps.put("AUTO_ANSWER_CONDITIONAL_VALUE", null);
        accProps.put("AUTO_ANSWER_FWD_NUM", null);
        if (this.answerUnconditional) {
            accProps.put("AUTO_ANSWER_UNCONDITIONAL", Boolean.TRUE.toString());
        } else if (this.answerConditional) {
            accProps.put("AUTO_ANSWER_CONDITIONAL_NAME", this.headerName);
            if (!StringUtils.isNullOrEmpty((String)this.headerValue)) {
                accProps.put("AUTO_ANSWER_CONDITIONAL_VALUE", this.headerValue);
            }
        } else if (!StringUtils.isNullOrEmpty((String)this.callFwdTo)) {
            accProps.put("AUTO_ANSWER_FWD_NUM", this.callFwdTo);
        }
        accProps.put("AUTO_ANSWER_WITH_VIDEO", Boolean.toString(this.answerWithVideo));
        acc.setAccountProperties(accProps);
        SipActivator.getProtocolProviderFactory().storeAccount(acc);
    }

    public void setAutoAnswerCondition(String headerName, String value) {
        this.clearLocal();
        this.answerConditional = true;
        this.headerName = headerName;
        this.headerValue = value;
        this.save();
    }

    public boolean isAutoAnswerConditionSet() {
        return this.answerConditional;
    }

    public void setCallForward(String numberTo) {
        this.clearLocal();
        this.callFwdTo = numberTo;
        this.save();
    }

    public String getCallForward() {
        return this.callFwdTo;
    }

    protected void clearLocal() {
        super.clearLocal();
        this.answerConditional = false;
        this.headerName = null;
        this.headerValue = null;
        this.callFwdTo = null;
    }

    public String getAutoAnswerHeaderName() {
        return this.headerName;
    }

    public String getAutoAnswerHeaderValue() {
        return this.headerValue;
    }

    public boolean forwardCall(Request invite, ServerTransaction serverTransaction) {
        if (StringUtils.isNullOrEmpty((String)this.callFwdTo)) {
            return false;
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"will send moved temporally response: ");
            }
            Response response = ((ProtocolProviderServiceSipImpl)this.protocolProvider).getMessageFactory().createResponse(302, invite);
            ContactHeader contactHeader = (ContactHeader)response.getHeader("Contact");
            AddressFactoryEx addressFactory = ((ProtocolProviderServiceSipImpl)this.protocolProvider).getAddressFactory();
            String destination = this.getCallForward();
            if (!destination.startsWith("sip")) {
                destination = "sip:" + destination;
            }
            contactHeader.setAddress(addressFactory.createAddress(addressFactory.createURI(destination)));
            serverTransaction.sendResponse(response);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("sent a moved temporally response: " + response));
            }
        }
        catch (Throwable ex) {
            logger.error((Object)"Error while trying to send a request", ex);
            return false;
        }
        return true;
    }

    protected boolean satisfyAutoAnswerConditions(Call call) {
        Iterator peers = call.getCallPeers();
        if (call.isAutoAnswer()) {
            return true;
        }
        if (this.answerConditional) {
            while (peers.hasNext()) {
                String value;
                Request invite;
                SIPHeader callAnswerHeader;
                CallPeer peer = (CallPeer)peers.next();
                Transaction transaction = ((CallPeerSipImpl)peer).getLatestInviteTransaction();
                if (transaction == null || (callAnswerHeader = (SIPHeader)(invite = transaction.getRequest()).getHeader(this.headerName)) == null || StringUtils.isNullOrEmpty((String)this.headerValue) || (value = callAnswerHeader.getHeaderValue()) == null || !this.headerValue.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean autoAnswer(Call call) {
        if (this.answerUnconditional || this.satisfyAutoAnswerConditions(call)) {
            boolean isVideoCall = this.doesRequestContainsActiveVideoMediaType(call);
            this.answerCall(call, isVideoCall);
            return true;
        }
        return false;
    }

    private boolean doesRequestContainsActiveVideoMediaType(Call call) {
        Iterator peers = call.getCallPeers();
        while (peers.hasNext()) {
            Request inviteReq;
            Transaction transaction = ((CallPeerSipImpl)((Object)peers.next())).getLatestInviteTransaction();
            if (transaction == null || (inviteReq = transaction.getRequest()) == null || inviteReq.getRawContent() == null) continue;
            String sdpStr = SdpUtils.getContentAsString((Message)inviteReq);
            SessionDescription sesDescr = SdpUtils.parseSdpString(sdpStr);
            Vector<MediaDescription> remoteDescriptions = SdpUtils.extractMediaDescriptions(sesDescr);
            for (MediaDescription mediaDescription : remoteDescriptions) {
                if (SdpUtils.getMediaType(mediaDescription) != MediaType.VIDEO || SdpUtils.getDirection(mediaDescription) != MediaDirection.SENDRECV) continue;
                return true;
            }
        }
        return false;
    }
}

