/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.jabber;

import junit.framework.TestCase;
import net.java.sip.communicator.service.protocol.AccountManagerUtils;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.slick.protocol.jabber.JabberSlickFixture;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class TestAccountUninstallationPersistence
extends TestCase {
    public TestAccountUninstallationPersistence(String testName) {
        super(testName);
    }

    public void testAccountUninstallationPersistence() throws Exception {
        Bundle providerBundle = JabberSlickFixture.providerBundle;
        providerBundle.stop();
        TestAccountUninstallationPersistence.assertTrue((String)("Couldn't stop the protocol provider bundle. State was " + providerBundle.getState()), (32 != providerBundle.getState() && 16 != providerBundle.getState() ? 1 : 0) != 0);
        providerBundle.uninstall();
        TestAccountUninstallationPersistence.assertEquals((String)"Couldn't stop the protocol provider bundle.", (int)1, (int)providerBundle.getState());
        providerBundle = JabberSlickFixture.bc.installBundle(providerBundle.getLocation());
        TestAccountUninstallationPersistence.assertEquals((String)"Couldn't re-install protocol provider bundle.", (int)2, (int)providerBundle.getState());
        AccountManagerUtils.startBundleAndWaitStoredAccountsLoaded((BundleContext)JabberSlickFixture.bc, (Bundle)providerBundle, (String)"Jabber");
        TestAccountUninstallationPersistence.assertEquals((String)"Couldn't re-start protocol provider bundle.", (int)32, (int)providerBundle.getState());
        ServiceReference[] jabberProviderRefs = null;
        try {
            jabberProviderRefs = JabberSlickFixture.bc.getServiceReferences(ProtocolProviderService.class.getName(), "(PROTOCOL_NAME=Jabber)");
        }
        catch (InvalidSyntaxException ex) {
            TestAccountUninstallationPersistence.fail((String)("We apparently got our filter wrong " + ex.getMessage()));
        }
        TestAccountUninstallationPersistence.assertTrue((String)"A Jabber Protocol Provider Service was still regged as an osgi service after it was explicitly uninstalled", (jabberProviderRefs == null || jabberProviderRefs.length == 0 ? 1 : 0) != 0);
        ServiceReference confReference = JabberSlickFixture.bc.getServiceReference(ConfigurationService.class.getName());
        ConfigurationService configurationService = (ConfigurationService)JabberSlickFixture.bc.getService(confReference);
        configurationService.purgeStoredConfiguration();
    }
}

