/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.notification;

import net.java.sip.communicator.impl.notification.CommandNotificationHandlerImpl;
import net.java.sip.communicator.impl.notification.LogMessageNotificationHandlerImpl;
import net.java.sip.communicator.impl.notification.PopupMessageNotificationHandlerImpl;
import net.java.sip.communicator.impl.notification.SoundNotificationHandlerImpl;
import net.java.sip.communicator.service.gui.UIService;
import net.java.sip.communicator.service.notification.CommandNotificationHandler;
import net.java.sip.communicator.service.notification.LogMessageNotificationHandler;
import net.java.sip.communicator.service.notification.NotificationHandler;
import net.java.sip.communicator.service.notification.NotificationService;
import net.java.sip.communicator.service.notification.PopupMessageNotificationHandler;
import net.java.sip.communicator.service.notification.SoundNotificationHandler;
import net.java.sip.communicator.service.systray.SystrayService;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.audionotifier.AudioNotifierService;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class NotificationActivator
implements BundleActivator {
    private final Logger logger = Logger.getLogger(NotificationActivator.class);
    protected static BundleContext bundleContext;
    private static AudioNotifierService audioNotifierService;
    private static SystrayService systrayService;
    private static NotificationService notificationService;
    private static UIService uiService;
    private CommandNotificationHandler commandHandler;
    private LogMessageNotificationHandler logMessageHandler;
    private PopupMessageNotificationHandler popupMessageHandler;
    private SoundNotificationHandler soundHandler;
    private static ConfigurationService configurationService;

    public void start(BundleContext bc) throws Exception {
        bundleContext = bc;
        try {
            this.logger.logEntry();
            this.logger.info((Object)"Notification handler Service...[  STARTED ]");
            ServiceReference notifReference = bundleContext.getServiceReference(NotificationService.class.getName());
            notificationService = (NotificationService)bundleContext.getService(notifReference);
            this.commandHandler = new CommandNotificationHandlerImpl();
            this.logMessageHandler = new LogMessageNotificationHandlerImpl();
            this.popupMessageHandler = new PopupMessageNotificationHandlerImpl();
            this.soundHandler = new SoundNotificationHandlerImpl();
            notificationService.addActionHandler((NotificationHandler)this.commandHandler);
            notificationService.addActionHandler((NotificationHandler)this.logMessageHandler);
            notificationService.addActionHandler((NotificationHandler)this.popupMessageHandler);
            notificationService.addActionHandler((NotificationHandler)this.soundHandler);
            this.logger.info((Object)"Notification handler Service ...[REGISTERED]");
        }
        finally {
            this.logger.logExit();
        }
    }

    public void stop(BundleContext bc) throws Exception {
        notificationService.removeActionHandler(this.commandHandler.getActionType());
        notificationService.removeActionHandler(this.logMessageHandler.getActionType());
        notificationService.removeActionHandler(this.popupMessageHandler.getActionType());
        notificationService.removeActionHandler(this.soundHandler.getActionType());
        this.logger.info((Object)"Notification handler Service ...[STOPPED]");
    }

    public static AudioNotifierService getAudioNotifier() {
        ServiceReference serviceReference;
        if (audioNotifierService == null && (serviceReference = bundleContext.getServiceReference(AudioNotifierService.class.getName())) != null) {
            audioNotifierService = (AudioNotifierService)bundleContext.getService(serviceReference);
        }
        return audioNotifierService;
    }

    public static SystrayService getSystray() {
        if (systrayService == null) {
            systrayService = (SystrayService)ServiceUtils.getService((BundleContext)bundleContext, SystrayService.class);
        }
        return systrayService;
    }

    public static UIService getUIService() {
        if (uiService == null) {
            uiService = (UIService)ServiceUtils.getService((BundleContext)bundleContext, UIService.class);
        }
        return uiService;
    }

    public static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            configurationService = (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
        }
        return configurationService;
    }

    static {
        uiService = null;
    }
}

