/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.spellcheck;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.spellcheck.ChatAttachments;
import net.java.sip.communicator.plugin.spellcheck.Parameters;
import net.java.sip.communicator.plugin.spellcheck.SpellCheckActivator;
import net.java.sip.communicator.service.gui.Chat;
import net.java.sip.communicator.service.gui.event.ChatListener;
import net.java.sip.communicator.util.Logger;
import org.dts.spell.dictionary.OpenOfficeSpellDictionary;
import org.dts.spell.dictionary.SpellDictionary;
import org.jitsi.service.fileaccess.FileAccessService;
import org.jitsi.service.fileaccess.FileCategory;
import org.jitsi.util.OSUtils;
import org.osgi.framework.BundleContext;

class SpellChecker
implements ChatListener {
    private static final Logger logger = Logger.getLogger(SpellChecker.class);
    private static final String LOCALE_CONFIG_PARAM = "net.java.sip.communicator.plugin.spellchecker.LOCALE";
    private static final String DEFAULT_DICT_PATH = "/resources/config/spellcheck/";
    private static final String DICT_DIR = "spellingDictionaries/";
    private static final String PERSONAL_DICT_NAME = "custom.per";
    private static final String SYSTEM_HUNSPELL_DIR = "net.java.sip.communicator.plugin.spellcheck.SYSTEM_HUNSPELL_DIR";
    private File personalDictLocation;
    private File dictLocation;
    private SpellDictionary dict;
    private Parameters.Locale locale;
    private ArrayList<ChatAttachments> attachedChats = new ArrayList();
    private boolean enabled = true;
    static final String LOCALE_CHANGED_PROP = "LocaleChanged";
    private final List<WeakReference<PropertyChangeListener>> propertyListeners = new ArrayList<WeakReference<PropertyChangeListener>>();

    SpellChecker() {
    }

    synchronized void start(BundleContext bc) throws Exception {
        String localeIso;
        this.enabled = SpellCheckActivator.getConfigService().getBoolean("plugin.spellcheck.ENABLE", true);
        FileAccessService faService = SpellCheckActivator.getFileAccessService();
        File dictionaryDir = faService.getPrivatePersistentFile(DICT_DIR, FileCategory.CACHE);
        if (!dictionaryDir.exists()) {
            dictionaryDir.mkdir();
        }
        this.personalDictLocation = faService.getPrivatePersistentFile("spellingDictionaries/custom.per", FileCategory.PROFILE);
        if (!this.personalDictLocation.exists()) {
            this.personalDictLocation.createNewFile();
        }
        if ((localeIso = SpellCheckActivator.getConfigService().getString(LOCALE_CONFIG_PARAM)) == null && (localeIso = Parameters.getDefault(Parameters.Default.LOCALE)) == null) {
            throw new Exception("No default locale provided for spell checker");
        }
        Parameters.Locale tmp = Parameters.getLocale(localeIso);
        if (tmp == null) {
            throw new Exception("No dictionary resources defined for locale: " + localeIso);
        }
        this.locale = tmp;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SpellCheckActivator.getUIService().addChatListener((ChatListener)SpellChecker.this);
                for (Chat chat : SpellCheckActivator.getUIService().getAllChats()) {
                    SpellChecker.this.chatCreated(chat);
                }
            }
        });
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Spell Checker loaded.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void stop() {
        ArrayList<ChatAttachments> arrayList = this.attachedChats;
        synchronized (arrayList) {
            for (ChatAttachments chat : this.attachedChats) {
                chat.detachListeners();
            }
            this.attachedChats.clear();
            SpellCheckActivator.getUIService().removeChatListener((ChatListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chatClosed(Chat chat) {
        ArrayList<ChatAttachments> arrayList = this.attachedChats;
        synchronized (arrayList) {
            ChatAttachments wrapper = this.getChatAttachments(chat);
            if (wrapper != null) {
                this.attachedChats.remove(wrapper);
                wrapper.detachListeners();
            }
            if (this.attachedChats.size() == 0) {
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chatCreated(Chat chat) {
        ArrayList<ChatAttachments> arrayList = this.attachedChats;
        synchronized (arrayList) {
            if (this.getChatAttachments(chat) == null && this.dict != null) {
                ChatAttachments wrapper = new ChatAttachments(chat, this.dict);
                if (this.attachedChats.contains(wrapper)) {
                    return;
                }
                wrapper.setEnabled(this.enabled);
                wrapper.attachListeners();
                this.attachedChats.add(wrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChatAttachments getChatAttachments(Chat chat) {
        ArrayList<ChatAttachments> arrayList = this.attachedChats;
        synchronized (arrayList) {
            for (ChatAttachments chatAttachments : this.attachedChats) {
                if (!chatAttachments.chat.equals(chat)) continue;
                return chatAttachments;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getPersonalWords() {
        ArrayList<String> personalWords = new ArrayList<String>();
        File file = this.personalDictLocation;
        synchronized (file) {
            try (Scanner personalDictScanner = new Scanner(this.personalDictLocation);){
                while (personalDictScanner.hasNextLine()) {
                    personalWords.add(personalDictScanner.nextLine());
                }
            }
            catch (FileNotFoundException exc) {
                logger.error((Object)"Unable to read custom dictionary", (Throwable)exc);
            }
        }
        return personalWords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPersonalWords(List<String> words) {
        File file = this.personalDictLocation;
        synchronized (file) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(this.personalDictLocation));
                for (String customWord : words) {
                    writer.append(customWord);
                    writer.newLine();
                }
                writer.flush();
                writer.close();
                ArrayList<ChatAttachments> arrayList = this.attachedChats;
                synchronized (arrayList) {
                    FileInputStream dictInput = new FileInputStream(this.dictLocation);
                    this.dict = new OpenOfficeSpellDictionary((InputStream)dictInput, this.personalDictLocation);
                    for (ChatAttachments chat : this.attachedChats) {
                        chat.setDictionary(this.dict);
                    }
                }
            }
            catch (IOException exc) {
                logger.error((Object)"Unable to access personal spelling dictionary", (Throwable)exc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Parameters.Locale getLocale() {
        Parameters.Locale locale = this.locale;
        synchronized (locale) {
            return this.locale;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLocale(Parameters.Locale locale) throws Exception {
        Parameters.Locale locale2 = this.locale;
        synchronized (locale2) {
            String sysDir;
            File systemDict;
            if (this.locale.equals(locale) && this.dict != null) {
                return;
            }
            File dictLocation = this.getLocalDictForLocale(locale);
            InputStream dictInput = null;
            FileInputStream affInput = null;
            if (OSUtils.IS_LINUX && !dictLocation.exists() && (systemDict = new File(sysDir = SpellCheckActivator.getConfigService().getString(SYSTEM_HUNSPELL_DIR), locale.getIcuLocale() + ".dic")).exists()) {
                dictInput = new FileInputStream(systemDict);
                affInput = new FileInputStream(new File(sysDir, locale.getIcuLocale() + ".aff"));
            }
            if (!dictLocation.exists() && dictInput == null) {
                boolean dictFound = false;
                Enumeration dictUrls = SpellCheckActivator.bundleContext.getBundle().findEntries(DEFAULT_DICT_PATH, "*.zip", false);
                if (dictUrls != null) {
                    while (dictUrls.hasMoreElements()) {
                        URL dictUrl = (URL)dictUrls.nextElement();
                        if (!new File(dictUrl.getFile()).getName().equals(new File(locale.getDictUrl().getFile()).getName())) continue;
                        dictInput = dictUrl.openStream();
                        dictFound = true;
                        break;
                    }
                }
                if (!dictFound) {
                    this.copyDictionary(locale.getDictUrl().openStream(), dictLocation);
                }
            }
            if (dictInput == null) {
                dictInput = new FileInputStream(dictLocation);
            }
            ArrayList<ChatAttachments> arrayList = this.attachedChats;
            synchronized (arrayList) {
                OpenOfficeSpellDictionary dict = affInput == null ? new OpenOfficeSpellDictionary(dictInput, this.personalDictLocation) : new OpenOfficeSpellDictionary(affInput, dictInput, this.personalDictLocation, true);
                this.dict = dict;
                this.dictLocation = dictLocation;
                Parameters.Locale oldLocale = this.locale;
                this.locale = locale;
                SpellCheckActivator.getConfigService().setProperty(LOCALE_CONFIG_PARAM, (Object)locale.getIsoCode());
                for (ChatAttachments chat : this.attachedChats) {
                    chat.setDictionary(this.dict);
                }
                this.firePropertyChangedEvent(LOCALE_CHANGED_PROP, oldLocale, this.locale);
            }
        }
    }

    File getLocalDictForLocale(Parameters.Locale locale) throws Exception {
        String path = locale.getDictUrl().getFile();
        int filenameStart = path.lastIndexOf(47) + 1;
        String filename = path.substring(filenameStart);
        File dictLocation = SpellCheckActivator.getFileAccessService().getPrivatePersistentFile(DICT_DIR + filename, FileCategory.CACHE);
        return dictLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLocale(Parameters.Locale locale) throws Exception {
        Parameters.Locale locale2 = this.locale;
        synchronized (locale2) {
            String path = locale.getDictUrl().getFile();
            int filenameStart = path.lastIndexOf(47) + 1;
            String filename = path.substring(filenameStart);
            File dictLocation = SpellCheckActivator.getFileAccessService().getPrivatePersistentFile(DICT_DIR + filename, FileCategory.CACHE);
            if (dictLocation.exists()) {
                dictLocation.delete();
            }
            String localeIso = Parameters.getDefault(Parameters.Default.LOCALE);
            Parameters.Locale loc = Parameters.getLocale(localeIso);
            this.setLocale(loc);
        }
    }

    boolean isLocaleAvailable(Parameters.Locale locale) {
        try {
            if (this.getLocalDictForLocale(locale).exists()) {
                return true;
            }
            Enumeration dictUrls = SpellCheckActivator.bundleContext.getBundle().findEntries(DEFAULT_DICT_PATH, "*.zip", false);
            if (dictUrls != null) {
                while (dictUrls.hasMoreElements()) {
                    URL dictUrl = (URL)dictUrls.nextElement();
                    if (!new File(dictUrl.getFile()).getName().equals(new File(locale.getDictUrl().getFile()).getName())) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception exc) {
            return false;
        }
    }

    boolean isUserLocale(Parameters.Locale locale) {
        try {
            return this.getLocalDictForLocale(locale).exists();
        }
        catch (Exception exc) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isEnabled() {
        ArrayList<ChatAttachments> arrayList = this.attachedChats;
        synchronized (arrayList) {
            return this.enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            ArrayList<ChatAttachments> arrayList = this.attachedChats;
            synchronized (arrayList) {
                this.enabled = enabled;
                for (ChatAttachments chatAttachment : this.attachedChats) {
                    chatAttachment.setEnabled(this.enabled);
                }
            }
        }
    }

    private void copyDictionary(InputStream input, File dest) throws IOException, FileNotFoundException {
        int len;
        byte[] buf = new byte[1024];
        FileOutputStream output = new FileOutputStream(dest);
        while ((len = input.read(buf)) > 0) {
            output.write(buf, 0, len);
        }
        input.close();
        output.close();
    }

    private boolean isDictionaryValid(SpellDictionary dict) {
        try {
            dict.isCorrect("foo");
            return true;
        }
        catch (Exception exc) {
            logger.error((Object)"Dictionary validation failed", (Throwable)exc);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        List<WeakReference<PropertyChangeListener>> list = this.propertyListeners;
        synchronized (list) {
            Iterator<WeakReference<PropertyChangeListener>> i = this.propertyListeners.iterator();
            boolean contains = false;
            while (i.hasNext()) {
                PropertyChangeListener l = (PropertyChangeListener)i.next().get();
                if (l == null) {
                    i.remove();
                    continue;
                }
                if (!l.equals(listener)) continue;
                contains = true;
            }
            if (!contains) {
                this.propertyListeners.add(new WeakReference<PropertyChangeListener>(listener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        List<WeakReference<PropertyChangeListener>> list = this.propertyListeners;
        synchronized (list) {
            Iterator<WeakReference<PropertyChangeListener>> i = this.propertyListeners.iterator();
            while (i.hasNext()) {
                PropertyChangeListener l = (PropertyChangeListener)i.next().get();
                if (l != null && !l.equals(listener)) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChangedEvent(String property, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, property, oldValue, newValue);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Will dispatch the following plugin component event: " + evt));
        }
        List<WeakReference<PropertyChangeListener>> list = this.propertyListeners;
        synchronized (list) {
            Iterator<WeakReference<PropertyChangeListener>> i = this.propertyListeners.iterator();
            while (i.hasNext()) {
                PropertyChangeListener l = (PropertyChangeListener)i.next().get();
                if (l == null) {
                    i.remove();
                    continue;
                }
                l.propertyChange(evt);
            }
        }
    }
}

