/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.negotiators.capabilities;

import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import com.ircclouds.irc.api.listeners.VariousMessageListenerAdapter;
import com.ircclouds.irc.api.negotiators.CompositeNegotiator;
import com.ircclouds.irc.api.negotiators.SaslContext;
import com.ircclouds.irc.api.negotiators.api.Relay;
import com.ircclouds.irc.api.om.ServerMessageBuilder;
import com.ircclouds.irc.api.utils.RawMessageUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslCapability
extends VariousMessageListenerAdapter
implements CompositeNegotiator.Capability {
    private static final Logger LOG = LoggerFactory.getLogger(SaslCapability.class);
    private static final String CAP_ID = "sasl";
    private static final Pattern AUTHENTICATE_CONFIRMATION = Pattern.compile("AUTHENTICATE\\s+(\\+)\\s*$", 0);
    private static final int RPL_LOGGEDIN = 900;
    private static final int RPL_LOGGEDOUT = 901;
    private static final int ERR_NICKLOCKED = 902;
    private static final int RPL_SASLSUCCESS = 903;
    private static final int ERR_SASLFAIL = 904;
    private static final int ERR_SASLTOOLONG = 905;
    private static final int ERR_SASLABORTED = 906;
    private static final int ERR_SASLALREADY = 907;
    private static final int RPL_SASLMECHS = 908;
    private static final ServerMessageBuilder SERVER_MSG_BUILDER = new ServerMessageBuilder();
    private final boolean enable;
    private final String authzId;
    private final String user;
    private final String pass;
    private SaslContext state;

    public SaslCapability(boolean enable, String authzid, String user, String pass) {
        this.enable = enable;
        this.authzId = authzid;
        if (this.enable && user == null) {
            throw new NullPointerException("user");
        }
        this.user = user;
        if (this.enable && pass == null) {
            throw new NullPointerException("pass");
        }
        this.pass = pass;
    }

    @Override
    public String getId() {
        return CAP_ID;
    }

    @Override
    public boolean enable() {
        return this.enable;
    }

    @Override
    public boolean converse(Relay relay, String msg) {
        if (!this.enable) {
            return false;
        }
        if (msg == null) {
            this.state = new SaslContext(relay);
            this.state.init();
            return true;
        }
        Matcher confirmation = AUTHENTICATE_CONFIRMATION.matcher(msg);
        if (confirmation.find()) {
            this.state.confirm(confirmation.group(1), this.authzId, this.user, this.pass);
            return true;
        }
        if (RawMessageUtils.isServerNumericMessage(msg)) {
            ServerNumericMessage numMsg = SERVER_MSG_BUILDER.build(msg);
            switch (numMsg.getNumericCode()) {
                case 900: {
                    this.state.loggedIn();
                    return true;
                }
                case 903: {
                    this.state.success();
                    return false;
                }
                case 904: {
                    this.state.fail();
                    return true;
                }
                case 902: {
                    LOG.error("SASL account locked. Failing authentication procedure.");
                    this.state.fail();
                    return true;
                }
                case 906: 
                case 907: {
                    return false;
                }
                case 905: {
                    LOG.error("We have sent a bad message. Message was longer than 400 chars. This is a bug in the SASL capability implementation. Aborting SASL authentication.");
                    this.state.abort();
                    return true;
                }
            }
            LOG.warn("Unsupported numeric message. Aborting SASL authentication. ({})", (Object)msg);
            return false;
        }
        LOG.warn("Unknown message, not handling: " + msg);
        return true;
    }
}

