/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.actions;

import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.actions.XCopyValueAction;
import com.intellij.xdebugger.impl.ui.tree.actions.XFetchValueActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.debugger.PyCopyValueEvaluationCallback;
import com.jetbrains.python.debugger.PyDebugUtilsKt;
import com.jetbrains.python.debugger.QuotingPolicy;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u00060\u000bR\u00020\fH\u0014\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/debugger/actions/PyXCopyValueAction;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XCopyValueAction;", "<init>", "()V", "addToCollector", "", "paths", "", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "valueNode", "valueCollector", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$ValueCollector;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase;", "intellij.python.community.impl"})
public final class PyXCopyValueAction
extends XCopyValueAction {
    protected void addToCollector(@NotNull List<XValueNodeImpl> paths, @NotNull XValueNodeImpl valueNode, @NotNull XFetchValueActionBase.ValueCollector valueCollector) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Intrinsics.checkNotNullParameter((Object)valueNode, (String)"valueNode");
        Intrinsics.checkNotNullParameter((Object)valueCollector, (String)"valueCollector");
        XDebuggerTree xDebuggerTree = valueCollector.getTree();
        if (!((xDebuggerTree != null && (xDebuggerTree = xDebuggerTree.getEditorsProvider()) != null ? xDebuggerTree.getFileType() : null) instanceof PythonFileType)) {
            super.addToCollector(paths, valueNode, valueCollector);
            return;
        }
        if (paths.size() > 1) {
            valueCollector.add(valueNode.getText().toString(), valueNode.getPath().getPathCount());
        } else {
            XFullValueEvaluator fullValueEvaluator = valueNode.getFullValueEvaluator();
            QuotingPolicy quotingPolicy = PyDebuggerSettings.getInstance().getQuotingPolicy();
            if (fullValueEvaluator != null) {
                Intrinsics.checkNotNull((Object)quotingPolicy);
                new PyCopyValueEvaluationCallback(valueNode, valueCollector, quotingPolicy).startFetchingValue(fullValueEvaluator);
            } else {
                Intrinsics.checkNotNull((Object)quotingPolicy);
                String string = DebuggerUIUtil.getNodeRawValue((XValueNodeImpl)valueNode);
                if (string == null) {
                    string = "";
                }
                valueCollector.add(PyDebugUtilsKt.getQuotingString((QuotingPolicy)quotingPolicy, (String)string));
            }
        }
    }
}

