/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.remotestore.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.action.admin.cluster.remotestore.stats.RemoteStoreStats;
import org.opensearch.action.admin.cluster.remotestore.stats.RemoteStoreStatsRequest;
import org.opensearch.action.admin.cluster.remotestore.stats.RemoteStoreStatsResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.PlainShardsIterator;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.index.IndexService;
import org.opensearch.index.remote.RemoteSegmentTransferTracker;
import org.opensearch.index.remote.RemoteStoreStatsTrackerFactory;
import org.opensearch.index.remote.RemoteTranslogTransferTracker;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardNotFoundException;
import org.opensearch.indices.IndicesService;
import org.opensearch.transport.TransportService;

public class TransportRemoteStoreStatsAction
extends TransportBroadcastByNodeAction<RemoteStoreStatsRequest, RemoteStoreStatsResponse, RemoteStoreStats> {
    private final IndicesService indicesService;
    private final RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory;

    @Inject
    public TransportRemoteStoreStatsAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, RemoteStoreStatsTrackerFactory remoteStoreStatsTrackerFactory) {
        super("cluster:monitor/_remotestore/stats", clusterService, transportService, actionFilters, indexNameExpressionResolver, RemoteStoreStatsRequest::new, "management");
        this.indicesService = indicesService;
        this.remoteStoreStatsTrackerFactory = remoteStoreStatsTrackerFactory;
    }

    @Override
    protected ShardsIterator shards(ClusterState clusterState, RemoteStoreStatsRequest request, String[] concreteIndices) {
        ArrayList<ShardRouting> newShardRoutings = new ArrayList<ShardRouting>();
        if (request.shards().length > 0) {
            clusterState.routingTable().allShards(concreteIndices).getShardRoutings().forEach(shardRouting -> {
                if (Arrays.asList(request.shards()).contains(Integer.toString(shardRouting.shardId().id()))) {
                    newShardRoutings.add((ShardRouting)shardRouting);
                }
            });
        } else {
            newShardRoutings.addAll(clusterState.routingTable().allShards(concreteIndices).getShardRoutings());
        }
        return new PlainShardsIterator(newShardRoutings.stream().filter(shardRouting -> !request.local() || shardRouting.currentNodeId() == null || shardRouting.currentNodeId().equals(clusterState.getNodes().getLocalNodeId())).filter(shardRouting -> Boolean.parseBoolean(clusterState.getMetadata().index(shardRouting.index()).getSettings().get("index.remote_store.enabled"))).collect(Collectors.toList()));
    }

    @Override
    protected ClusterBlockException checkGlobalBlock(ClusterState state, RemoteStoreStatsRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected ClusterBlockException checkRequestBlock(ClusterState state, RemoteStoreStatsRequest request, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, concreteIndices);
    }

    @Override
    protected RemoteStoreStats readShardResult(StreamInput in) throws IOException {
        return new RemoteStoreStats(in);
    }

    @Override
    protected RemoteStoreStatsResponse newResponse(RemoteStoreStatsRequest request, int totalShards, int successfulShards, int failedShards, List<RemoteStoreStats> responses, List<DefaultShardOperationFailedException> shardFailures, ClusterState clusterState) {
        return new RemoteStoreStatsResponse(responses.toArray(new RemoteStoreStats[0]), totalShards, successfulShards, failedShards, shardFailures);
    }

    @Override
    protected RemoteStoreStatsRequest readRequestFrom(StreamInput in) throws IOException {
        return new RemoteStoreStatsRequest(in);
    }

    @Override
    protected RemoteStoreStats shardOperation(RemoteStoreStatsRequest request, ShardRouting shardRouting) {
        IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(shardRouting.shardId().id());
        if (indexShard.routingEntry() == null) {
            throw new ShardNotFoundException(indexShard.shardId());
        }
        RemoteSegmentTransferTracker remoteSegmentTransferTracker = this.remoteStoreStatsTrackerFactory.getRemoteSegmentTransferTracker(indexShard.shardId());
        assert (Objects.nonNull(remoteSegmentTransferTracker));
        RemoteTranslogTransferTracker remoteTranslogTransferTracker = this.remoteStoreStatsTrackerFactory.getRemoteTranslogTransferTracker(indexShard.shardId());
        assert (Objects.nonNull(remoteTranslogTransferTracker));
        return new RemoteStoreStats(remoteSegmentTransferTracker.stats(), remoteTranslogTransferTracker.stats(), indexShard.routingEntry());
    }
}

