/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.client.hotspot;

import io.prometheus.client.Collector;
import io.prometheus.client.CounterMetricFamily;
import io.prometheus.client.GaugeMetricFamily;
import io.prometheus.client.Predicate;
import io.prometheus.client.SampleNameFilter;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;

public class ClassLoadingExports
extends Collector {
    private static final String JVM_CLASSES_CURRENTLY_LOADED = "jvm_classes_currently_loaded";
    private static final String JVM_CLASSES_LOADED_TOTAL = "jvm_classes_loaded_total";
    private static final String JVM_CLASSES_UNLOADED_TOTAL = "jvm_classes_unloaded_total";
    private final ClassLoadingMXBean clBean;

    public ClassLoadingExports() {
        this(ManagementFactory.getClassLoadingMXBean());
    }

    public ClassLoadingExports(ClassLoadingMXBean clBean) {
        this.clBean = clBean;
    }

    void addClassLoadingMetrics(List<Collector.MetricFamilySamples> sampleFamilies, Predicate<String> nameFilter) {
        if (nameFilter.test((Object)JVM_CLASSES_CURRENTLY_LOADED)) {
            sampleFamilies.add((Collector.MetricFamilySamples)new GaugeMetricFamily(JVM_CLASSES_CURRENTLY_LOADED, "The number of classes that are currently loaded in the JVM", (double)this.clBean.getLoadedClassCount()));
        }
        if (nameFilter.test((Object)JVM_CLASSES_LOADED_TOTAL)) {
            sampleFamilies.add((Collector.MetricFamilySamples)new CounterMetricFamily(JVM_CLASSES_LOADED_TOTAL, "The total number of classes that have been loaded since the JVM has started execution", (double)this.clBean.getTotalLoadedClassCount()));
        }
        if (nameFilter.test((Object)JVM_CLASSES_UNLOADED_TOTAL)) {
            sampleFamilies.add((Collector.MetricFamilySamples)new CounterMetricFamily(JVM_CLASSES_UNLOADED_TOTAL, "The total number of classes that have been unloaded since the JVM has started execution", (double)this.clBean.getUnloadedClassCount()));
        }
    }

    public List<Collector.MetricFamilySamples> collect() {
        return this.collect(null);
    }

    public List<Collector.MetricFamilySamples> collect(Predicate<String> nameFilter) {
        ArrayList<Collector.MetricFamilySamples> mfs = new ArrayList<Collector.MetricFamilySamples>();
        this.addClassLoadingMetrics(mfs, nameFilter == null ? SampleNameFilter.ALLOW_ALL : nameFilter);
        return mfs;
    }
}

