/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership.cloud;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.membership.cloud.CertificateStreamProvider;
import org.apache.catalina.tribes.membership.cloud.CloudMembershipProvider;
import org.apache.catalina.tribes.membership.cloud.CloudMembershipService;
import org.apache.catalina.tribes.membership.cloud.TokenStreamProvider;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.json.JSONParser;

public class KubernetesMembershipProvider
extends CloudMembershipProvider {
    private static final Log log = LogFactory.getLog(KubernetesMembershipProvider.class);

    @Override
    public void start(int n) throws Exception {
        Object object;
        String string;
        if ((n & 4) == 0) {
            return;
        }
        super.start(n);
        String string2 = this.getNamespace();
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("cloudMembershipProvider.start", string2));
        }
        String string3 = KubernetesMembershipProvider.getEnv("OPENSHIFT_KUBE_PING_MASTER_PROTOCOL", "KUBERNETES_MASTER_PROTOCOL");
        String string4 = KubernetesMembershipProvider.getEnv("OPENSHIFT_KUBE_PING_MASTER_HOST", "KUBERNETES_SERVICE_HOST");
        String string5 = KubernetesMembershipProvider.getEnv("OPENSHIFT_KUBE_PING_MASTER_PORT", "KUBERNETES_SERVICE_PORT");
        String string6 = KubernetesMembershipProvider.getEnv("OPENSHIFT_KUBE_PING_CLIENT_CERT_FILE", "KUBERNETES_CLIENT_CERTIFICATE_FILE");
        String string7 = KubernetesMembershipProvider.getEnv("OPENSHIFT_KUBE_PING_CA_CERT_FILE", "KUBERNETES_CA_CERTIFICATE_FILE");
        if (string7 == null) {
            string7 = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
        }
        if (string6 == null) {
            if (string3 == null) {
                string3 = "https";
            }
            if ((string = KubernetesMembershipProvider.getEnv("OPENSHIFT_KUBE_PING_SA_TOKEN_FILE", "SA_TOKEN_FILE")) == null) {
                string = "/var/run/secrets/kubernetes.io/serviceaccount/token";
            }
            try {
                object = Files.readAllBytes(FileSystems.getDefault().getPath(string, new String[0]));
                this.streamProvider = new TokenStreamProvider(new String((byte[])object, StandardCharsets.US_ASCII), string7);
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("kubernetesMembershipProvider.streamError"), (Throwable)iOException);
            }
        } else {
            if (string3 == null) {
                string3 = "http";
            }
            if ((string = KubernetesMembershipProvider.getEnv("KUBERNETES_CLIENT_KEY_FILE")) == null) {
                log.error((Object)sm.getString("kubernetesMembershipProvider.noKey"));
                return;
            }
            object = KubernetesMembershipProvider.getEnv("KUBERNETES_CLIENT_KEY_PASSWORD");
            String string8 = KubernetesMembershipProvider.getEnv("KUBERNETES_CLIENT_KEY_ALGO");
            if (string8 == null) {
                string8 = "RSA";
            }
            this.streamProvider = new CertificateStreamProvider(string6, string, (String)object, string8, string7);
        }
        if ((string = KubernetesMembershipProvider.getEnv("OPENSHIFT_KUBE_PING_API_VERSION", "KUBERNETES_API_VERSION")) == null) {
            string = "v1";
        }
        object = KubernetesMembershipProvider.getEnv("OPENSHIFT_KUBE_PING_LABELS", "KUBERNETES_LABELS");
        string2 = URLEncoder.encode(string2, "UTF-8");
        object = object == null ? null : URLEncoder.encode((String)object, "UTF-8");
        this.url = String.format("%s://%s:%s/api/%s/namespaces/%s/pods", string3, string4, string5, string, string2);
        if (object != null && ((String)object).length() > 0) {
            this.url = this.url + "?labelSelector=" + (String)object;
        }
        this.heartbeat();
    }

    @Override
    public boolean stop(int n) throws Exception {
        try {
            boolean bl = super.stop(n);
            return bl;
        }
        finally {
            this.streamProvider = null;
        }
    }

    @Override
    protected Member[] fetchMembers() {
        if (this.streamProvider == null) {
            return new Member[0];
        }
        ArrayList<MemberImpl> arrayList = new ArrayList<MemberImpl>();
        try (InputStream inputStream = this.streamProvider.openStream(this.url, this.headers, this.connectionTimeout, this.readTimeout);
             InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");){
            this.parsePods(inputStreamReader, arrayList);
        }
        catch (IOException iOException) {
            log.error((Object)sm.getString("kubernetesMembershipProvider.streamError"), (Throwable)iOException);
        }
        return arrayList.toArray(new Member[0]);
    }

    protected void parsePods(Reader reader, List<MemberImpl> list) {
        JSONParser jSONParser = new JSONParser(reader);
        try {
            LinkedHashMap linkedHashMap = jSONParser.object();
            Object v = linkedHashMap.get("items");
            if (!(v instanceof List)) {
                log.error((Object)sm.getString("kubernetesMembershipProvider.invalidPodsList", "no items"));
                return;
            }
            List list2 = (List)v;
            for (Object e : list2) {
                String string;
                if (!(e instanceof LinkedHashMap)) {
                    log.warn((Object)sm.getString("kubernetesMembershipProvider.invalidPod", "item"));
                    continue;
                }
                LinkedHashMap linkedHashMap2 = (LinkedHashMap)e;
                Object v2 = linkedHashMap2.get("kind");
                if (v2 != null && !"Pod".equals(v2)) continue;
                Object v3 = linkedHashMap2.get("metadata");
                if (!(v3 instanceof LinkedHashMap)) {
                    log.warn((Object)sm.getString("kubernetesMembershipProvider.invalidPod", "metadata"));
                    continue;
                }
                LinkedHashMap linkedHashMap3 = (LinkedHashMap)v3;
                Object v4 = linkedHashMap3.get("name");
                if (v4 == null) {
                    log.warn((Object)sm.getString("kubernetesMembershipProvider.invalidPod", "name"));
                    continue;
                }
                Object v5 = linkedHashMap3.get("uid");
                Object v6 = linkedHashMap3.get("creationTimestamp");
                if (v6 == null) {
                    log.warn((Object)sm.getString("kubernetesMembershipProvider.invalidPod", "uid"));
                    continue;
                }
                Object v7 = linkedHashMap2.get("status");
                if (!(v7 instanceof LinkedHashMap)) {
                    log.warn((Object)sm.getString("kubernetesMembershipProvider.invalidPod", "status"));
                    continue;
                }
                LinkedHashMap linkedHashMap4 = (LinkedHashMap)v7;
                if (!"Running".equals(linkedHashMap4.get("phase"))) continue;
                Object v8 = linkedHashMap4.get("podIP");
                if (v8 == null) {
                    log.warn((Object)sm.getString("kubernetesMembershipProvider.invalidPod", "podIP"));
                    continue;
                }
                String string2 = v8.toString();
                String string3 = string = v5 == null ? string2 : v5.toString();
                if (string2.equals(this.localIp)) {
                    Member member = this.service.getLocalMember(false);
                    if (member.getUniqueId() != CloudMembershipService.INITIAL_ID || !(member instanceof MemberImpl)) continue;
                    byte[] byArray = this.md5.digest(string.getBytes(StandardCharsets.US_ASCII));
                    ((MemberImpl)member).setUniqueId(byArray);
                    continue;
                }
                long l = Duration.between(Instant.parse(v6.toString()), this.startTime).toMillis();
                MemberImpl memberImpl = null;
                try {
                    memberImpl = new MemberImpl(string2, this.port, l);
                }
                catch (IOException iOException) {
                    log.error((Object)sm.getString("kubernetesMembershipProvider.memberError"), (Throwable)iOException);
                    continue;
                }
                byte[] byArray = this.md5.digest(string.getBytes(StandardCharsets.US_ASCII));
                memberImpl.setUniqueId(byArray);
                list.add(memberImpl);
            }
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("kubernetesMembershipProvider.jsonError"), (Throwable)exception);
        }
    }
}

