/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.CachedResource;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class Cache {
    private static final Log log = LogFactory.getLog(Cache.class);
    protected static final StringManager sm = StringManager.getManager(Cache.class);
    private static final long TARGET_FREE_PERCENT_GET = 5L;
    private static final long TARGET_FREE_PERCENT_BACKGROUND = 10L;
    private static final int OBJECT_MAX_SIZE_FACTOR = 20;
    private final StandardRoot root;
    private final AtomicLong size = new AtomicLong(0L);
    private long ttl = 5000L;
    private long maxSize = 0xA00000L;
    private int objectMaxSize = (int)this.maxSize / 20;
    private WebResourceRoot.CacheStrategy cacheStrategy;
    private LongAdder lookupCount = new LongAdder();
    private LongAdder hitCount = new LongAdder();
    private final ConcurrentMap<String, CachedResource> resourceCache = new ConcurrentHashMap<String, CachedResource>();

    public Cache(StandardRoot standardRoot) {
        this.root = standardRoot;
    }

    protected WebResource getResource(String string, boolean bl) {
        if (this.noCache(string)) {
            return this.root.getResourceInternal(string, bl);
        }
        WebResourceRoot.CacheStrategy cacheStrategy = this.getCacheStrategy();
        if (cacheStrategy != null && cacheStrategy.noCache(string)) {
            return this.root.getResourceInternal(string, bl);
        }
        this.lookupCount.increment();
        CachedResource cachedResource = (CachedResource)this.resourceCache.get(string);
        if (cachedResource != null && !cachedResource.validateResource(bl)) {
            this.removeCacheEntry(string);
            cachedResource = null;
        }
        if (cachedResource == null) {
            int n = this.getObjectMaxSizeBytes();
            CachedResource cachedResource2 = new CachedResource(this, this.root, string, this.getTtl(), n, bl);
            cachedResource = this.resourceCache.putIfAbsent(string, cachedResource2);
            if (cachedResource == null) {
                long l;
                long l2;
                cachedResource = cachedResource2;
                cachedResource.validateResource(bl);
                long l3 = cachedResource.getSize();
                this.size.addAndGet(l3);
                if (this.size.get() > this.maxSize && (l2 = this.evict(l = this.maxSize * 95L / 100L, this.resourceCache.values().iterator())) > this.maxSize) {
                    this.removeCacheEntry(string);
                    log.warn((Object)sm.getString("cache.addFail", new Object[]{string, this.root.getContext().getName()}));
                }
            } else {
                if (cachedResource.usesClassLoaderResources() != bl) {
                    cachedResource = cachedResource2;
                }
                cachedResource.validateResource(bl);
            }
        } else {
            this.hitCount.increment();
        }
        return cachedResource;
    }

    protected WebResource[] getResources(String string, boolean bl) {
        this.lookupCount.increment();
        CachedResource cachedResource = (CachedResource)this.resourceCache.get(string);
        if (cachedResource != null && !cachedResource.validateResources(bl)) {
            this.removeCacheEntry(string);
            cachedResource = null;
        }
        if (cachedResource == null) {
            int n = this.getObjectMaxSizeBytes();
            CachedResource cachedResource2 = new CachedResource(this, this.root, string, this.getTtl(), n, bl);
            cachedResource = this.resourceCache.putIfAbsent(string, cachedResource2);
            if (cachedResource == null) {
                long l;
                long l2;
                cachedResource = cachedResource2;
                cachedResource.validateResources(bl);
                long l3 = cachedResource.getSize();
                this.size.addAndGet(l3);
                if (this.size.get() > this.maxSize && (l2 = this.evict(l = this.maxSize * 95L / 100L, this.resourceCache.values().iterator())) > this.maxSize) {
                    this.removeCacheEntry(string);
                    log.warn((Object)sm.getString("cache.addFail", new Object[]{string}));
                }
            } else {
                cachedResource.validateResources(bl);
            }
        } else {
            this.hitCount.increment();
        }
        return cachedResource.getWebResources();
    }

    protected void backgroundProcess() {
        TreeSet<CachedResource> treeSet = new TreeSet<CachedResource>(Comparator.comparingLong(CachedResource::getNextCheck));
        treeSet.addAll(this.resourceCache.values());
        Iterator<CachedResource> iterator = treeSet.iterator();
        long l = this.maxSize * 90L / 100L;
        long l2 = this.evict(l, iterator);
        if (l2 > l) {
            log.info((Object)sm.getString("cache.backgroundEvictFail", new Object[]{10L, this.root.getContext().getName(), l2 / 1024L}));
        }
    }

    private boolean noCache(String string) {
        return string.endsWith(".class") && (string.startsWith("/WEB-INF/classes/") || string.startsWith("/WEB-INF/lib/")) || string.startsWith("/WEB-INF/lib/") && string.endsWith(".jar");
    }

    private long evict(long l, Iterator<CachedResource> iterator) {
        long l2 = System.currentTimeMillis();
        long l3 = this.size.get();
        while (l3 > l && iterator.hasNext()) {
            CachedResource cachedResource = iterator.next();
            if (cachedResource.getNextCheck() > l2) continue;
            this.removeCacheEntry(cachedResource.getWebappPath());
            l3 = this.size.get();
        }
        return l3;
    }

    void removeCacheEntry(String string) {
        CachedResource cachedResource = (CachedResource)this.resourceCache.remove(string);
        if (cachedResource != null) {
            long l = cachedResource.getSize();
            this.size.addAndGet(-l);
        }
    }

    public WebResourceRoot.CacheStrategy getCacheStrategy() {
        return this.cacheStrategy;
    }

    public void setCacheStrategy(WebResourceRoot.CacheStrategy cacheStrategy) {
        this.cacheStrategy = cacheStrategy;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long l) {
        this.ttl = l;
    }

    public long getMaxSize() {
        return this.maxSize / 1024L;
    }

    public void setMaxSize(long l) {
        this.maxSize = l * 1024L;
    }

    public long getLookupCount() {
        return this.lookupCount.sum();
    }

    public long getHitCount() {
        return this.hitCount.sum();
    }

    public void setObjectMaxSize(int n) {
        if ((long)n * 1024L > Integer.MAX_VALUE) {
            log.warn((Object)sm.getString("cache.objectMaxSizeTooBigBytes", new Object[]{n}));
            this.objectMaxSize = Integer.MAX_VALUE;
        }
        this.objectMaxSize = n * 1024;
    }

    public int getObjectMaxSize() {
        return this.objectMaxSize / 1024;
    }

    public int getObjectMaxSizeBytes() {
        return this.objectMaxSize;
    }

    void enforceObjectMaxSizeLimit() {
        long l = this.maxSize / 20L;
        if (l > Integer.MAX_VALUE) {
            return;
        }
        if ((long)this.objectMaxSize > l) {
            log.warn((Object)sm.getString("cache.objectMaxSizeTooBig", new Object[]{this.objectMaxSize / 1024, (int)l / 1024}));
            this.objectMaxSize = (int)l;
        }
    }

    public void clear() {
        this.resourceCache.clear();
        this.size.set(0L);
    }

    public long getSize() {
        return this.size.get() / 1024L;
    }
}

