/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.session;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.StoreManager;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class PersistentManagerBase
extends ManagerBase
implements StoreManager {
    private final Log log = LogFactory.getLog(PersistentManagerBase.class);
    private static final String name = "PersistentManagerBase";
    private static final String PERSISTED_LAST_ACCESSED_TIME = "org.apache.catalina.session.PersistentManagerBase.persistedLastAccessedTime";
    protected Store store = null;
    protected boolean saveOnRestart = true;
    protected int maxIdleBackup = -1;
    protected int minIdleSwap = -1;
    protected int maxIdleSwap = -1;
    private final Map<String, Object> sessionSwapInLocks = new HashMap<String, Object>();
    private final ThreadLocal<Session> sessionToSwapIn = new ThreadLocal();

    public int getMaxIdleBackup() {
        return this.maxIdleBackup;
    }

    public void setMaxIdleBackup(int n) {
        if (n == this.maxIdleBackup) {
            return;
        }
        int n2 = this.maxIdleBackup;
        this.maxIdleBackup = n;
        this.support.firePropertyChange("maxIdleBackup", (Object)n2, (Object)this.maxIdleBackup);
    }

    public int getMaxIdleSwap() {
        return this.maxIdleSwap;
    }

    public void setMaxIdleSwap(int n) {
        if (n == this.maxIdleSwap) {
            return;
        }
        int n2 = this.maxIdleSwap;
        this.maxIdleSwap = n;
        this.support.firePropertyChange("maxIdleSwap", (Object)n2, (Object)this.maxIdleSwap);
    }

    public int getMinIdleSwap() {
        return this.minIdleSwap;
    }

    public void setMinIdleSwap(int n) {
        if (this.minIdleSwap == n) {
            return;
        }
        int n2 = this.minIdleSwap;
        this.minIdleSwap = n;
        this.support.firePropertyChange("minIdleSwap", (Object)n2, (Object)this.minIdleSwap);
    }

    public boolean isLoaded(String string) {
        try {
            if (super.findSession(string) != null) {
                return true;
            }
        }
        catch (IOException iOException) {
            this.log.error((Object)sm.getString("persistentManager.isLoadedError", new Object[]{string}), (Throwable)iOException);
        }
        return false;
    }

    @Override
    public String getName() {
        return name;
    }

    public void setStore(Store store) {
        this.store = store;
        store.setManager(this);
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    public boolean getSaveOnRestart() {
        return this.saveOnRestart;
    }

    public void setSaveOnRestart(boolean bl) {
        if (bl == this.saveOnRestart) {
            return;
        }
        boolean bl2 = this.saveOnRestart;
        this.saveOnRestart = bl;
        this.support.firePropertyChange("saveOnRestart", (Object)bl2, (Object)this.saveOnRestart);
    }

    public void clearStore() {
        if (this.store == null) {
            return;
        }
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreClear());
                }
                catch (PrivilegedActionException privilegedActionException) {
                    this.log.error((Object)sm.getString("persistentManager.storeClearError"), (Throwable)privilegedActionException.getException());
                }
            } else {
                this.store.clear();
            }
        }
        catch (IOException iOException) {
            this.log.error((Object)sm.getString("persistentManager.storeClearError"), (Throwable)iOException);
        }
    }

    @Override
    public void processExpires() {
        long l = System.currentTimeMillis();
        Session[] sessionArray = this.findSessions();
        int n = 0;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Start expire sessions " + this.getName() + " at " + l + " sessioncount " + sessionArray.length));
        }
        for (Session session : sessionArray) {
            if (session.isValid()) continue;
            this.expiredSessions.incrementAndGet();
            ++n;
        }
        this.processPersistenceChecks();
        if (this.getStore() instanceof StoreBase) {
            ((StoreBase)this.getStore()).processExpires();
        }
        long l2 = System.currentTimeMillis();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("End expire sessions " + this.getName() + " processingTime " + (l2 - l) + " expired sessions: " + n));
        }
        this.processingTime += l2 - l;
    }

    public void processPersistenceChecks() {
        this.processMaxIdleSwaps();
        this.processMaxActiveSwaps();
        this.processMaxIdleBackups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session findSession(String string) throws IOException {
        Session session = super.findSession(string);
        if (session != null) {
            Session session2 = session;
            synchronized (session2) {
                session = super.findSession(session.getIdInternal());
                if (session != null) {
                    session.access();
                    session.endAccess();
                }
            }
        }
        if (session != null) {
            return session;
        }
        session = this.swapIn(string);
        return session;
    }

    @Override
    public void removeSuper(Session session) {
        super.remove(session, false);
    }

    @Override
    public void load() {
        String[] stringArray;
        block11: {
            this.sessions.clear();
            if (this.store == null) {
                return;
            }
            stringArray = null;
            try {
                if (SecurityUtil.isPackageProtectionEnabled()) {
                    try {
                        stringArray = AccessController.doPrivileged(new PrivilegedStoreKeys());
                        break block11;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        this.log.error((Object)sm.getString("persistentManager.storeLoadKeysError"), (Throwable)privilegedActionException.getException());
                        return;
                    }
                }
                stringArray = this.store.keys();
            }
            catch (IOException iOException) {
                this.log.error((Object)sm.getString("persistentManager.storeLoadKeysError"), (Throwable)iOException);
                return;
            }
        }
        int n = stringArray.length;
        if (n == 0) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("persistentManager.loading", new Object[]{String.valueOf(n)}));
        }
        for (String string : stringArray) {
            try {
                this.swapIn(string);
            }
            catch (IOException iOException) {
                this.log.error((Object)sm.getString("persistentManager.storeLoadError"), (Throwable)iOException);
            }
        }
    }

    @Override
    public void remove(Session session, boolean bl) {
        super.remove(session, bl);
        if (this.store != null) {
            this.removeSession(session.getIdInternal());
        }
    }

    protected void removeSession(String string) {
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreRemove(string));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    this.log.error((Object)sm.getString("persistentManager.removeError"), (Throwable)privilegedActionException.getException());
                }
            } else {
                this.store.remove(string);
            }
        }
        catch (IOException iOException) {
            this.log.error((Object)sm.getString("persistentManager.removeError"), (Throwable)iOException);
        }
    }

    @Override
    public void unload() {
        if (this.store == null) {
            return;
        }
        Session[] sessionArray = this.findSessions();
        int n = sessionArray.length;
        if (n == 0) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("persistentManager.unloading", new Object[]{String.valueOf(n)}));
        }
        for (Session session : sessionArray) {
            try {
                this.swapOut(session);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getActiveSessionsFull() {
        int n = this.getActiveSessions();
        try {
            n += this.getStore().getSize();
        }
        catch (IOException iOException) {
            this.log.warn((Object)sm.getString("persistentManager.storeSizeException"));
        }
        return n;
    }

    @Override
    public Set<String> getSessionIdsFull() {
        HashSet<String> hashSet = new HashSet<String>(this.sessions.keySet());
        try {
            hashSet.addAll(Arrays.asList(this.getStore().keys()));
        }
        catch (IOException iOException) {
            this.log.warn((Object)sm.getString("persistentManager.storeKeysException"));
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session swapIn(String string2) throws IOException {
        if (this.store == null) {
            return null;
        }
        Object object = null;
        Object object2 = this;
        synchronized (object2) {
            object = this.sessionSwapInLocks.computeIfAbsent(string2, string -> new Object());
        }
        object2 = null;
        Object object3 = object;
        synchronized (object3) {
            object2 = (Session)this.sessions.get(string2);
            if (object2 == null) {
                Session session = this.sessionToSwapIn.get();
                try {
                    if (session == null || !string2.equals(session.getId())) {
                        object2 = this.loadSessionFromStore(string2);
                        this.sessionToSwapIn.set((Session)object2);
                        if (object2 != null && !object2.isValid()) {
                            this.log.error((Object)sm.getString("persistentManager.swapInInvalid", new Object[]{string2}));
                            object2.expire();
                            this.removeSession(string2);
                            object2 = null;
                        }
                        if (object2 != null) {
                            this.reactivateLoadedSession(string2, (Session)object2);
                        }
                    }
                }
                finally {
                    this.sessionToSwapIn.remove();
                }
            }
        }
        object3 = this;
        synchronized (object3) {
            this.sessionSwapInLocks.remove(string2);
        }
        return object2;
    }

    private void reactivateLoadedSession(String string, Session session) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)sm.getString("persistentManager.swapIn", new Object[]{string}));
        }
        session.setManager(this);
        ((StandardSession)session).tellNew();
        this.add(session);
        ((StandardSession)session).activate();
        session.access();
        session.endAccess();
    }

    private Session loadSessionFromStore(String string) throws IOException {
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                return this.securedStoreLoad(string);
            }
            return this.store.load(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = sm.getString("persistentManager.deserializeError", new Object[]{string});
            this.log.error((Object)string2, (Throwable)classNotFoundException);
            throw new IllegalStateException(string2, classNotFoundException);
        }
    }

    private Session securedStoreLoad(String string) throws IOException, ClassNotFoundException {
        try {
            return AccessController.doPrivileged(new PrivilegedStoreLoad(string));
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            this.log.error((Object)sm.getString("persistentManager.swapInException", new Object[]{string}), (Throwable)exception);
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)exception;
            }
            return null;
        }
    }

    protected void swapOut(Session session) throws IOException {
        if (this.store == null || !session.isValid()) {
            return;
        }
        ((StandardSession)session).passivate();
        this.writeSession(session);
        super.remove(session, true);
        session.recycle();
    }

    protected void writeSession(Session session) throws IOException {
        if (this.store == null || !session.isValid()) {
            return;
        }
        try {
            if (SecurityUtil.isPackageProtectionEnabled()) {
                try {
                    AccessController.doPrivileged(new PrivilegedStoreSave(session));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (exception instanceof IOException) {
                        throw (IOException)exception;
                    }
                    this.log.error((Object)sm.getString("persistentManager.serializeError", new Object[]{session.getIdInternal(), exception}));
                }
            } else {
                this.store.save(session);
            }
        }
        catch (IOException iOException) {
            this.log.error((Object)sm.getString("persistentManager.serializeError", new Object[]{session.getIdInternal(), iOException}));
            throw iOException;
        }
    }

    @Override
    protected void startInternal() throws LifecycleException {
        super.startInternal();
        if (this.store == null) {
            this.log.error((Object)sm.getString("persistentManager.noStore"));
        } else if (this.store instanceof Lifecycle) {
            ((Lifecycle)((Object)this.store)).start();
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"Stopping");
        }
        this.setState(LifecycleState.STOPPING);
        if (this.getStore() != null && this.saveOnRestart) {
            this.unload();
        } else {
            Session[] sessionArray;
            for (Session session : sessionArray = this.findSessions()) {
                StandardSession standardSession = (StandardSession)session;
                if (!standardSession.isValid()) continue;
                standardSession.expire();
            }
        }
        if (this.getStore() instanceof Lifecycle) {
            ((Lifecycle)((Object)this.getStore())).stop();
        }
        super.stopInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMaxIdleSwaps() {
        if (!this.getState().isAvailable() || this.maxIdleSwap < 0) {
            return;
        }
        Session[] sessionArray = this.findSessions();
        if (this.maxIdleSwap >= 0) {
            for (Session session : sessionArray) {
                StandardSession standardSession;
                StandardSession standardSession2 = standardSession = (StandardSession)session;
                synchronized (standardSession2) {
                    if (!standardSession.isValid()) {
                        continue;
                    }
                    int n = (int)(standardSession.getIdleTimeInternal() / 1000L);
                    if (n >= this.maxIdleSwap && n >= this.minIdleSwap) {
                        if (standardSession.accessCount != null && standardSession.accessCount.get() > 0) {
                            continue;
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)sm.getString("persistentManager.swapMaxIdle", new Object[]{standardSession.getIdInternal(), n}));
                        }
                        try {
                            this.swapOut(standardSession);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMaxActiveSwaps() {
        if (!this.getState().isAvailable() || this.minIdleSwap < 0 || this.getMaxActiveSessions() < 0) {
            return;
        }
        Session[] sessionArray = this.findSessions();
        int n = (int)((double)this.getMaxActiveSessions() * 0.9);
        if (n >= sessionArray.length) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)sm.getString("persistentManager.tooManyActive", new Object[]{sessionArray.length}));
        }
        int n2 = sessionArray.length - n;
        for (int i = 0; i < sessionArray.length && n2 > 0; ++i) {
            StandardSession standardSession;
            StandardSession standardSession2 = standardSession = (StandardSession)sessionArray[i];
            synchronized (standardSession2) {
                int n3 = (int)(standardSession.getIdleTimeInternal() / 1000L);
                if (n3 >= this.minIdleSwap) {
                    if (standardSession.accessCount != null && standardSession.accessCount.get() > 0) {
                        continue;
                    }
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)sm.getString("persistentManager.swapTooManyActive", new Object[]{standardSession.getIdInternal(), n3}));
                    }
                    try {
                        this.swapOut(standardSession);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    --n2;
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMaxIdleBackups() {
        if (!this.getState().isAvailable() || this.maxIdleBackup < 0) {
            return;
        }
        Session[] sessionArray = this.findSessions();
        if (this.maxIdleBackup >= 0) {
            for (Session session : sessionArray) {
                StandardSession standardSession;
                StandardSession standardSession2 = standardSession = (StandardSession)session;
                synchronized (standardSession2) {
                    if (!standardSession.isValid()) {
                        continue;
                    }
                    long l = standardSession.getLastAccessedTimeInternal();
                    Long l2 = (Long)standardSession.getNote(PERSISTED_LAST_ACCESSED_TIME);
                    if (l2 != null && l == l2) {
                        continue;
                    }
                    int n = (int)(standardSession.getIdleTimeInternal() / 1000L);
                    if (n >= this.maxIdleBackup) {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)sm.getString("persistentManager.backupMaxIdle", new Object[]{standardSession.getIdInternal(), n}));
                        }
                        try {
                            this.writeSession(standardSession);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        standardSession.setNote(PERSISTED_LAST_ACCESSED_TIME, l);
                    }
                }
            }
        }
    }

    private class PrivilegedStoreClear
    implements PrivilegedExceptionAction<Void> {
        PrivilegedStoreClear() {
        }

        @Override
        public Void run() throws Exception {
            PersistentManagerBase.this.store.clear();
            return null;
        }
    }

    private class PrivilegedStoreKeys
    implements PrivilegedExceptionAction<String[]> {
        PrivilegedStoreKeys() {
        }

        @Override
        public String[] run() throws Exception {
            return PersistentManagerBase.this.store.keys();
        }
    }

    private class PrivilegedStoreRemove
    implements PrivilegedExceptionAction<Void> {
        private String id;

        PrivilegedStoreRemove(String string) {
            this.id = string;
        }

        @Override
        public Void run() throws Exception {
            PersistentManagerBase.this.store.remove(this.id);
            return null;
        }
    }

    private class PrivilegedStoreLoad
    implements PrivilegedExceptionAction<Session> {
        private String id;

        PrivilegedStoreLoad(String string) {
            this.id = string;
        }

        @Override
        public Session run() throws Exception {
            return PersistentManagerBase.this.store.load(this.id);
        }
    }

    private class PrivilegedStoreSave
    implements PrivilegedExceptionAction<Void> {
        private Session session;

        PrivilegedStoreSave(Session session) {
            this.session = session;
        }

        @Override
        public Void run() throws Exception {
            PersistentManagerBase.this.store.save(this.session);
            return null;
        }
    }
}

