"use strict";(self.webpackChunkdeck=self.webpackChunkdeck||[]).push([["node_modules_css-loader_dist_runtime_getUrl_js-src_CardSelector_vue-data_image_svg_xml_3c_21--4079df"],{75724:(t,e,n)=>{n.d(e,{A:()=>l});var o=n(71354),a=n.n(o),r=n(76314),s=n.n(r)()(a());s.push([t.id,"\n#modal-inner[data-v-59cf91b8] {\n\twidth: 90vw;\n\tmax-width: 400px;\n\tpadding: 20px;\n\theight: 200px;\n}\n.multiselect[data-v-59cf91b8] {\n\twidth: 100%;\n\tmargin-bottom: 10px;\n}\nul[data-v-59cf91b8] {\n\tmin-height: 100px;\n}\nli[data-v-59cf91b8] {\n\tpadding: 6px;\n\tborder: 1px solid transparent;\n}\nli[data-v-59cf91b8]:hover, li[data-v-59cf91b8]:focus {\n\tbackground-color: var(--color-background-dark);\n}\n.board-bullet[data-v-59cf91b8] {\n\tdisplay: inline-block;\n\twidth: 12px;\n\theight: 12px;\n\tborder: none;\n\tborder-radius: 50%;\n\tcursor: pointer;\n}\nbutton[data-v-59cf91b8] {\n\tfloat: right;\n}\n.card-selector[data-v-59cf91b8] .modal-container {\n\toverflow: visible !important;\n}\n","",{version:3,sources:["webpack://./src/CardSelector.vue"],names:[],mappings:";AA+JA;CACA,WAAA;CACA,gBAAA;CACA,aAAA;CACA,aAAA;AACA;AAEA;CACA,WAAA;CACA,mBAAA;AACA;AAEA;CACA,iBAAA;AACA;AAEA;CACA,YAAA;CACA,6BAAA;AACA;AAEA;CACA,8CAAA;AACA;AAEA;CACA,qBAAA;CACA,WAAA;CACA,YAAA;CACA,YAAA;CACA,kBAAA;CACA,eAAA;AACA;AAEA;CACA,YAAA;AACA;AAEA;CACA,4BAAA;AACA",sourcesContent:["\x3c!--\n  - SPDX-FileCopyrightText: 2019 Nextcloud GmbH and Nextcloud contributors\n  - SPDX-License-Identifier: AGPL-3.0-or-later\n--\x3e\n\n<template>\n\t<NcModal class=\"card-selector\" @close=\"close\">\n\t\t<div id=\"modal-inner\" :class=\"{ 'icon-loading': loading }\">\n\t\t\t<h3>{{ title }}</h3>\n\t\t\t<NcSelect v-model=\"selectedBoard\"\n\t\t\t\t:placeholder=\"t('deck', 'Select a board')\"\n\t\t\t\t:options=\"boards\"\n\t\t\t\t:disabled=\"loading\"\n\t\t\t\tlabel=\"title\"\n\t\t\t\t@option:selected=\"fetchCardsFromBoard\">\n\t\t\t\t<template #selected-option=\"props\">\n\t\t\t\t\t<span>\n\t\t\t\t\t\t<span :style=\"{ 'backgroundColor': '#' + props.color }\" class=\"board-bullet\" />\n\t\t\t\t\t\t<span>{{ props.title }}</span>\n\t\t\t\t\t</span>\n\t\t\t\t</template>\n\t\t\t\t<template #option=\"props\">\n\t\t\t\t\t<span>\n\t\t\t\t\t\t<span :style=\"{ 'backgroundColor': '#' + props.color }\" class=\"board-bullet\" />\n\t\t\t\t\t\t<span>{{ props.title }}</span>\n\t\t\t\t\t</span>\n\t\t\t\t</template>\n\t\t\t</NcSelect>\n\n\t\t\t<NcSelect v-model=\"selectedCard\"\n\t\t\t\t:placeholder=\"t('deck', 'Select a card')\"\n\t\t\t\t:options=\"cardsFromBoard\"\n\t\t\t\t:disabled=\"loading || selectedBoard === ''\"\n\t\t\t\tlabel=\"title\" />\n\n\t\t\t<button :disabled=\"!isBoardAndStackChoosen\" class=\"primary\" @click=\"select\">\n\t\t\t\t{{ action }}\n\t\t\t</button>\n\t\t\t<button @click=\"close\">\n\t\t\t\t{{ t('deck', 'Cancel') }}\n\t\t\t</button>\n\t\t</div>\n\t</NcModal>\n</template>\n\n<script>\nimport { generateUrl } from '@nextcloud/router'\nimport { NcModal, NcSelect } from '@nextcloud/vue'\nimport axios from '@nextcloud/axios'\n\nexport default {\n\tname: 'CardSelector',\n\tcomponents: {\n\t\tNcModal,\n\t\tNcSelect,\n\t},\n\tprops: {\n\t\ttitle: {\n\t\t\ttype: String,\n\t\t\tdefault: t('deck', 'Select the card to link to a project'),\n\t\t},\n\t\taction: {\n\t\t\ttype: String,\n\t\t\tdefault: t('deck', 'Link to card'),\n\t\t},\n\t},\n\tdata() {\n\t\treturn {\n\t\t\tboards: [],\n\t\t\tselectedBoard: '',\n\t\t\tcardsFromBoard: [],\n\t\t\tselectedCard: '',\n\t\t\tloading: true,\n\t\t}\n\t},\n\tcomputed: {\n\t\tisBoardAndStackChoosen() {\n\t\t\treturn !(this.selectedBoard === '' || this.selectedCard === '')\n\t\t},\n\t},\n\tbeforeMount() {\n\t\tthis.fetchBoards()\n\t},\n\tmethods: {\n\t\tfetchBoards() {\n\t\t\taxios.get(generateUrl('/apps/deck/boards')).then((response) => {\n\t\t\t\tthis.boards = response.data\n\t\t\t\tthis.loading = false\n\t\t\t})\n\t\t},\n\t\tasync fetchCardsFromBoard(board) {\n\t\t\ttry {\n\t\t\t\tthis.cardsFromBoard = []\n\t\t\t\tconst url = generateUrl('/apps/deck/stacks/' + board.id)\n\t\t\t\tconst response = await axios.get(url)\n\t\t\t\tresponse.data.forEach(stack => {\n\t\t\t\t\tthis.cardsFromBoard.push(...stack.cards)\n\t\t\t\t})\n\t\t\t} catch (err) {\n\t\t\t\treturn err\n\t\t\t}\n\n\t\t},\n\t\tclose() {\n\t\t\tthis.$root.$emit('close')\n\t\t},\n\t\tselect() {\n\t\t\tthis.$root.$emit('select', this.selectedCard.id)\n\n\t\t},\n\t},\n\n}\n<\/script>\n\n<style scoped>\n\t#modal-inner {\n\t\twidth: 90vw;\n\t\tmax-width: 400px;\n\t\tpadding: 20px;\n\t\theight: 200px;\n\t}\n\n\t.multiselect {\n\t\twidth: 100%;\n\t\tmargin-bottom: 10px;\n\t}\n\n\tul {\n\t\tmin-height: 100px;\n\t}\n\n\tli {\n\t\tpadding: 6px;\n\t\tborder: 1px solid transparent;\n\t}\n\n\tli:hover, li:focus {\n\t\tbackground-color: var(--color-background-dark);\n\t}\n\n\t.board-bullet {\n\t\tdisplay: inline-block;\n\t\twidth: 12px;\n\t\theight: 12px;\n\t\tborder: none;\n\t\tborder-radius: 50%;\n\t\tcursor: pointer;\n\t}\n\n\tbutton {\n\t\tfloat: right;\n\t}\n\n\t.card-selector:deep(.modal-container) {\n\t\toverflow: visible !important;\n\t}\n</style>\n"],sourceRoot:""}]);const l=s},4417:t=>{t.exports=function(t,e){return e||(e={}),t?(t=String(t.__esModule?t.default:t),/^['"].*['"]$/.test(t)&&(t=t.slice(1,-1)),e.hash&&(t+=e.hash),/["'() \t\n]|(%20)/.test(t)||e.needQuotes?'"'.concat(t.replace(/"/g,'\\"').replace(/\n/g,"\\n"),'"'):t):t}},96562:(e,n,o)=>{o.r(n),o.d(n,{default:()=>x});var a=o(63814),r=o(76333),s=o(70715);const l={name:"CardSelector",components:{NcModal:r.FH,NcSelect:r.EQ},props:{title:{type:String,default:t("deck","Select the card to link to a project")},action:{type:String,default:t("deck","Link to card")}},data:()=>({boards:[],selectedBoard:"",cardsFromBoard:[],selectedCard:"",loading:!0}),computed:{isBoardAndStackChoosen(){return!(""===this.selectedBoard||""===this.selectedCard)}},beforeMount(){this.fetchBoards()},methods:{fetchBoards(){s.Ay.get((0,a.Jv)("/apps/deck/boards")).then((t=>{this.boards=t.data,this.loading=!1}))},async fetchCardsFromBoard(t){try{this.cardsFromBoard=[];const e=(0,a.Jv)("/apps/deck/stacks/"+t.id);(await s.Ay.get(e)).data.forEach((t=>{this.cardsFromBoard.push(...t.cards)}))}catch(t){return t}},close(){this.$root.$emit("close")},select(){this.$root.$emit("select",this.selectedCard.id)}}};var d=o(85072),c=o.n(d),i=o(97825),A=o.n(i),p=o(77659),h=o.n(p),g=o(55056),u=o.n(g),m=o(10540),b=o.n(m),C=o(41113),N=o.n(C),v=o(75724),f={};f.styleTagTransform=N(),f.setAttributes=u(),f.insert=h().bind(null,"head"),f.domAPI=A(),f.insertStyleElement=b();c()(v.A,f);v.A&&v.A.locals&&v.A.locals;const x=(0,o(14486).A)(l,(function(){var t=this,e=t._self._c;return e("NcModal",{staticClass:"card-selector",on:{close:t.close}},[e("div",{class:{"icon-loading":t.loading},attrs:{id:"modal-inner"}},[e("h3",[t._v(t._s(t.title))]),t._v(" "),e("NcSelect",{attrs:{placeholder:t.t("deck","Select a board"),options:t.boards,disabled:t.loading,label:"title"},on:{"option:selected":t.fetchCardsFromBoard},scopedSlots:t._u([{key:"selected-option",fn:function(n){return[e("span",[e("span",{staticClass:"board-bullet",style:{backgroundColor:"#"+n.color}}),t._v(" "),e("span",[t._v(t._s(n.title))])])]}},{key:"option",fn:function(n){return[e("span",[e("span",{staticClass:"board-bullet",style:{backgroundColor:"#"+n.color}}),t._v(" "),e("span",[t._v(t._s(n.title))])])]}}]),model:{value:t.selectedBoard,callback:function(e){t.selectedBoard=e},expression:"selectedBoard"}}),t._v(" "),e("NcSelect",{attrs:{placeholder:t.t("deck","Select a card"),options:t.cardsFromBoard,disabled:t.loading||""===t.selectedBoard,label:"title"},model:{value:t.selectedCard,callback:function(e){t.selectedCard=e},expression:"selectedCard"}}),t._v(" "),e("button",{staticClass:"primary",attrs:{disabled:!t.isBoardAndStackChoosen},on:{click:t.select}},[t._v("\n\t\t\t"+t._s(t.action)+"\n\t\t")]),t._v(" "),e("button",{on:{click:t.close}},[t._v("\n\t\t\t"+t._s(t.t("deck","Cancel"))+"\n\t\t")])],1)])}),[],!1,null,"59cf91b8",null).exports},27518:t=>{t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M15.4%2016.6L10.8%2012l4.6-4.6L14%206l-6%206%206%206%201.4-1.4z%27/%3e%3c/svg%3e"},27514:t=>{t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M18.4%207.4L17%206l-6%206%206%206%201.4-1.4-4.6-4.6%204.6-4.6m-6%200L11%206l-6%206%206%206%201.4-1.4L7.8%2012l4.6-4.6z%27/%3e%3c/svg%3e"},79722:t=>{t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M5.6%207.4L7%206l6%206-6%206-1.4-1.4%204.6-4.6-4.6-4.6m6%200L13%206l6%206-6%206-1.4-1.4%204.6-4.6-4.6-4.6z%27/%3e%3c/svg%3e"},86886:t=>{t.exports="data:image/svg+xml,%3c%21--%20-%20SPDX-FileCopyrightText:%202020%20Google%20Inc.%20-%20SPDX-License-Identifier:%20Apache-2.0%20--%3e%3csvg%20xmlns=%27http://www.w3.org/2000/svg%27%20width=%2724%27%20height=%2724%27%20fill=%27%23222%27%3e%3cpath%20d=%27M8.6%2016.6l4.6-4.6-4.6-4.6L10%206l6%206-6%206-1.4-1.4z%27/%3e%3c/svg%3e"},76333:(t,e,n)=>{n.d(e,{AO:()=>T.N,Az:()=>l.N,B6:()=>A.N,Bx:()=>E.N,EQ:()=>ut.N,FH:()=>st.A,K1:()=>et.N,Ki:()=>d.A,Ko:()=>o.A,Qz:()=>I.N,R1:()=>P.N,c:()=>H.A,i$:()=>J.N,lT:()=>Y.N,ne:()=>rt.A,v:()=>mt.N,x1:()=>D.A,yI:()=>q.A,z:()=>p.A});n(18911);var o=n(89257),a=n(92090),r=n(30567),s=n(1790),l=n(7225),d=n(73267),c=n(17452),i=n(93806),A=n(26325),p=n(80114),h=n(32831),g=n(98060),u=n(59224),m=n(47611),b=n(10363),C=n(97313),N=n(17465),v=n(20377),f=n(54656),x=n(80329),k=n(62720),S=n(24777),B=n(24302),w=n(94851),_=n(66687),y=n(2318),F=n(85948),L=n(12146),M=n(46503),E=n(26455),P=n(36562),I=n(32421),D=n(18740),T=n(12620),X=n(63657),$=n(85641),z=n(46747),G=n(21558),Q=n(74900),U=n(57201),Y=n(87638),j=n(81212),H=n(31126),J=n(76358),K=n(74358),W=n(68296),R=n(7834),q=n(34196),O=n(78298),V=n(57758),Z=n(9508),tt=n(26517),et=n(96338),nt=n(63407),ot=n(59500),at=n(64990),rt=n(84237),st=n(27180),lt=n(80910),dt=n(66154),ct=n(17622),it=n(79742),At=n(14825),pt=n(51681),ht=n(69126),gt=n(4570),ut=(n(40708),n(18230),n(70715),n(21777),n(40699)),mt=n(60666),bt=(n(61338),n(94632)),Ct=n(63447),Nt=n(63527),vt=n(89775),ft=n(65217),xt=n(42740),kt=n(35702),St=n(76057),Bt=n(87136),wt=n(23610),_t=(n(23020),n(53429),n(94205),n(9050),n(684),n(42892)),yt=n(65842),Ft=(n(18300),n(75105),n(92471),n(16406),n(33884));o.A,a.N,r.A,s.A,l.N,d.A,c.A,i.A,p.A,h.A,g.A,A.N,u.N,m.A,b.A,C.N,N.N,v.A,f.N,x.A,k.A,S.N,B.N,w.N,_.A,y.N,F.A,L.N,M.A,ht.N,E.N,P.N,I.N,D.A,T.N,X.N,$.N,z.N,G.N,Q.N,U.N,Y.N,j.A,H.A,J.N,K.N,W.A,R.N,q.A,O.A,V.A,Z.N,tt.N,et.N,nt.A,ot.N,at.N,rt.A,pt.N,st.A,lt.A,dt.N,ct.N,it.N,At.N,ht.a,gt.N,bt.N,ut.N,Ct.N,Nt.N,vt.N,ft.N,xt.A,mt.N,kt.N,St.N,Bt.N,wt.A,Symbol.toStringTag,_t.u,yt.u,Ft.yw,Symbol.toStringTag}}]);
//# sourceMappingURL=deck-node_modules_css-loader_dist_runtime_getUrl_js-src_CardSelector_vue-data_image_svg_xml_3c_21--4079df.js.map?v=d44ba319545d2f2b4f01